/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.assumptions;

import com.intellij.util.system.OS;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\bJ\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/assumptions/SystemAssumption;", "", "myOSTypeSupplier", "Lkotlin/Function0;", "Lcom/intellij/util/system/OS;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "isWindows", "", "isLinux", "isMac", "isNotWindows", "isNotLinux", "isNotMac", "isUnix", "isNotUnix", "isOs", "os", "isNotOs", "Companion", "intellij.cidr.common.testFramework.core.nolang"})
public final class SystemAssumption {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<OS> myOSTypeSupplier;
    @NotNull
    private static final SystemAssumption LOCAL_INSTANCE = new SystemAssumption((Function0<? extends OS>)((Function0)SystemAssumption::LOCAL_INSTANCE$lambda$0));

    private SystemAssumption(Function0<? extends OS> myOSTypeSupplier) {
        this.myOSTypeSupplier = myOSTypeSupplier;
    }

    public final void isWindows() {
        this.isOs(OS.Windows);
    }

    public final void isLinux() {
        this.isOs(OS.Linux);
    }

    public final void isMac() {
        this.isOs(OS.macOS);
    }

    public final void isNotWindows() {
        this.isNotOs(OS.Windows);
    }

    public final void isNotLinux() {
        this.isNotOs(OS.Linux);
    }

    public final void isNotMac() {
        this.isNotOs(OS.macOS);
    }

    public final void isUnix() {
        Assume.assumeTrue((String)"Unix host only", (this.myOSTypeSupplier.invoke() != OS.Windows ? 1 : 0) != 0);
    }

    public final void isNotUnix() {
        Assume.assumeFalse((String)"not for Unix host", (this.myOSTypeSupplier.invoke() != OS.Windows ? 1 : 0) != 0);
    }

    public final void isOs(@NotNull OS os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Assume.assumeTrue((String)(os + " host only"), (this.myOSTypeSupplier.invoke() == os ? 1 : 0) != 0);
    }

    public final void isNotOs(@NotNull OS os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Assume.assumeFalse((String)("not for " + os + " host"), (this.myOSTypeSupplier.invoke() == os ? 1 : 0) != 0);
    }

    private static final OS LOCAL_INSTANCE$lambda$0() {
        OS oS = OS.CURRENT;
        Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"CURRENT");
        return oS;
    }

    @JvmStatic
    @NotNull
    public static final SystemAssumption assumeLocalSystem() {
        return Companion.assumeLocalSystem();
    }

    @JvmStatic
    @NotNull
    public static final SystemAssumption assumeSystem(@NotNull Function0<? extends OS> osSupplier) {
        return Companion.assumeSystem(osSupplier);
    }

    public /* synthetic */ SystemAssumption(Function0 myOSTypeSupplier, DefaultConstructorMarker $constructor_marker) {
        this((Function0<? extends OS>)myOSTypeSupplier);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\u0007\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/assumptions/SystemAssumption$Companion;", "", "<init>", "()V", "LOCAL_INSTANCE", "Lcom/jetbrains/cidr/assumptions/SystemAssumption;", "assumeLocalSystem", "assumeSystem", "osSupplier", "Lkotlin/Function0;", "Lcom/intellij/util/system/OS;", "intellij.cidr.common.testFramework.core.nolang"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SystemAssumption assumeLocalSystem() {
            return LOCAL_INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final SystemAssumption assumeSystem(@NotNull Function0<? extends OS> osSupplier) {
            Intrinsics.checkNotNullParameter(osSupplier, (String)"osSupplier");
            return new SystemAssumption(osSupplier, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

