/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.assumptions;

import com.jetbrains.cidr.ArchitectureType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/assumptions/ArchitectureAssumption;", "", "myArchSupplier", "Lkotlin/Function0;", "Lcom/jetbrains/cidr/ArchitectureType;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "isX86orX64", "", "isX86", "isX64", "isAarch64", "intellij.cidr.common.testFramework.core.nolang"})
public final class ArchitectureAssumption {
    @NotNull
    private final Function0<ArchitectureType> myArchSupplier;

    public ArchitectureAssumption(@NotNull Function0<? extends ArchitectureType> myArchSupplier) {
        Intrinsics.checkNotNullParameter(myArchSupplier, (String)"myArchSupplier");
        this.myArchSupplier = myArchSupplier;
    }

    public final void isX86orX64() {
        ArchitectureType arch = (ArchitectureType)this.myArchSupplier.invoke();
        Assume.assumeTrue((String)"x86 or x86_64 host only", (arch == ArchitectureType.X86_64 || arch == ArchitectureType.I386 ? 1 : 0) != 0);
    }

    public final void isX86() {
        Assume.assumeTrue((String)"x86 host only", (this.myArchSupplier.invoke() == ArchitectureType.I386 ? 1 : 0) != 0);
    }

    public final void isX64() {
        Assume.assumeTrue((String)"x86_64 host only", (this.myArchSupplier.invoke() == ArchitectureType.X86_64 ? 1 : 0) != 0);
    }

    public final void isAarch64() {
        Assume.assumeTrue((String)"Aarch64 host only", (this.myArchSupplier.invoke() == ArchitectureType.ARM64 ? 1 : 0) != 0);
    }
}

