/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.IndexingTestUtil;
import com.jetbrains.cidr.CidrProjectDependentFixture;
import com.jetbrains.cidr.CidrProjectDependentFixtureBase;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrProjectFixtureCustomizer;
import com.jetbrains.cidr.WaitUtilKt;
import com.jetbrains.cidr.lang.modulemap.AllowedModules;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityExecutionService;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.workspace.OCGeneratedSourcesFilter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 02\u00020\u0001:\u00010B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J*\u0010\u0018\u001a\u00020\u000f2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\b\u0010!\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010#\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0007H\u0016J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u000fH\u0016J\b\u0010-\u001a\u00020\u0007H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lcom/jetbrains/cidr/OCSymbolsProjectFixtureCustomizer;", "Lcom/jetbrains/cidr/CidrProjectFixtureCustomizer;", "fixture", "Lcom/jetbrains/cidr/CidrProjectFixture;", "<init>", "(Lcom/jetbrains/cidr/CidrProjectFixture;)V", "isLoadSymbols", "", "isSaveSymbols", "_buildSymbolTables", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$SymbolsProperties$SymbolsKind;", "buildSymbolTables", "getBuildSymbolTables", "()Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$SymbolsProperties$SymbolsKind;", "setBuildSymbolTables", "", "setupSerialization", "loadSymbols", "saveSymbols", "preSetUp", "preTearDown", "waitForSymbols", "project", "Lcom/intellij/openapi/project/Project;", "assertScopeExt", "m", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mask", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "setShouldBuildTablesInTests", "rebuildSymbolsIfNeeded", "resetSymbols", "psiFile", "Lcom/intellij/psi/PsiFile;", "hasMacro", "logStats", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getDescription", "", "beforeInitializing", "shouldReinitialize", "getProject", "()Lcom/intellij/openapi/project/Project;", "Companion", "intellij.cidr.common.testFramework.core"})
public final class OCSymbolsProjectFixtureCustomizer
implements CidrProjectFixtureCustomizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CidrProjectFixture<?> fixture;
    private boolean isLoadSymbols;
    private boolean isSaveSymbols;
    @Nullable
    private FileSymbolTablesCache.SymbolsProperties.SymbolsKind _buildSymbolTables;
    @Nullable
    private static volatile FileSymbolTablesCache.SymbolsProperties.SymbolsKind prevBuildSymbolTables;

    public OCSymbolsProjectFixtureCustomizer(@NotNull CidrProjectFixture<?> fixture) {
        Intrinsics.checkNotNullParameter(fixture, (String)"fixture");
        this.fixture = fixture;
        this.isLoadSymbols = true;
        this.isSaveSymbols = true;
    }

    private final FileSymbolTablesCache.SymbolsProperties.SymbolsKind getBuildSymbolTables() {
        if (this._buildSymbolTables == null) {
            FileSymbolTablesCache.SymbolsProperties.SymbolsKind result = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.NO_SYMBOLS;
            for (CidrProjectDependentFixtureBase each : this.fixture.getDependentFixture()) {
                FileSymbolTablesCache.SymbolsProperties.SymbolsKind eachResult;
                if (!(each instanceof CidrProjectDependentFixture)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)((CidrProjectDependentFixture)each).shouldBuildSymbolTables(), (String)"shouldBuildSymbolTables(...)");
                if (result.compareTo((Enum)eachResult) >= 0) continue;
                result = eachResult;
            }
            this._buildSymbolTables = result;
        }
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = this._buildSymbolTables;
        Intrinsics.checkNotNull((Object)symbolsKind);
        return symbolsKind;
    }

    public final void setBuildSymbolTables(@NotNull FileSymbolTablesCache.SymbolsProperties.SymbolsKind buildSymbolTables) {
        Intrinsics.checkNotNullParameter((Object)buildSymbolTables, (String)"buildSymbolTables");
        this._buildSymbolTables = buildSymbolTables;
    }

    public final void setupSerialization(boolean loadSymbols, boolean saveSymbols) {
        this.isLoadSymbols = loadSymbols;
        this.isSaveSymbols = saveSymbols;
    }

    @Override
    public void preSetUp() {
        FileSymbolTablesCache.setShouldBuildTablesInTests(null);
    }

    @Override
    public void preTearDown() {
        FileSymbolTablesCache.setShouldBuildTablesInTests(null);
    }

    @Override
    public void waitForSymbols(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            return;
        }
        OCSymbolTablesBuildingActivity symbolTablesBuildingActivity = OCSymbolTablesBuildingActivity.getInstance((Project)project);
        WaitUtilKt.waitForEvent((Function0<Boolean>)((Function0)() -> OCSymbolsProjectFixtureCustomizer.waitForSymbols$lambda$0(symbolTablesBuildingActivity)), (Function0<String>)((Function0)OCSymbolsProjectFixtureCustomizer::waitForSymbols$lambda$1), TimeUnit.MINUTES.toMillis(10L));
        IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, project, null, 2, null);
    }

    @Override
    public void assertScopeExt(@NotNull StringBuilder m, int mask, @NotNull List<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        GlobalSearchScope globalSearchScope = OCSearchScope.getProjectSourcesScope((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getProjectSourcesScope(...)");
        GlobalSearchScope sourcesScope = globalSearchScope;
        OCGeneratedSourcesFilter.GeneratedSourcesScope generatedSourcesScope = new OCGeneratedSourcesFilter.GeneratedSourcesScope(this.getProject(), sourcesScope);
        m.append(CidrProjectFixture.assertScope(sourcesScope, "content sources", (mask & 4) != 0, files));
        m.append(CidrProjectFixture.assertScope((GlobalSearchScope)generatedSourcesScope, "content generated sources", (mask & 0x10) != 0, files));
    }

    @Override
    public void setShouldBuildTablesInTests() {
        FileSymbolTablesCache.setShouldBuildTablesInTests((FileSymbolTablesCache.SymbolsProperties)new FileSymbolTablesCache.SymbolsProperties(this.getBuildSymbolTables(), this.isLoadSymbols, this.isSaveSymbols));
    }

    @Override
    public void rebuildSymbolsIfNeeded(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (AllowedModules.Companion.isRebuildRequired()) {
            OCSymbolTablesBuildingActivity.getInstance((Project)project).rebuildSymbols();
            IndexingTestUtil.Companion.waitUntilIndexesAreReady$default(IndexingTestUtil.Companion, project, null, 2, null);
        }
    }

    @Override
    public void resetSymbols(@NotNull Project project, @NotNull PsiFile psiFile, boolean hasMacro) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        ActionsKt.runWriteAction(() -> OCSymbolsProjectFixtureCustomizer.resetSymbols$lambda$0(project, psiFile));
        FileSymbolTablesCache.getInstance((Project)project).ensurePendingFilesProcessed();
    }

    @Override
    public void logStats(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        OCBuildingActivityProgressIndicator.logStats((Logger)logger);
    }

    @Override
    @NotNull
    public String getDescription() {
        return ", " + this.getBuildSymbolTables();
    }

    @Override
    public void beforeInitializing() {
        prevBuildSymbolTables = this.getBuildSymbolTables();
    }

    @Override
    public boolean shouldReinitialize() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = prevBuildSymbolTables;
        Intrinsics.checkNotNull((Object)symbolsKind);
        return symbolsKind.compareTo((Enum)this.getBuildSymbolTables()) < 0;
    }

    private final Project getProject() {
        Project project = this.fixture.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    private static final boolean waitForSymbols$lambda$0(OCSymbolTablesBuildingActivity $symbolTablesBuildingActivity) {
        return !$symbolTablesBuildingActivity.isBuilding();
    }

    private static final String waitForSymbols$lambda$1() {
        int cpuCount = Runtime.getRuntime().availableProcessors();
        int symbolBuildingThreadCount = OCBuildingActivityExecutionService.Companion.getInstance().getThreadCount();
        String string = "Aborting. waiting shouldn't take so much time.\ncpuCount: %d\nThread count in building pool: %d\n";
        Object[] objectArray = new Object[]{cpuCount, symbolBuildingThreadCount};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final Unit resetSymbols$lambda$0(Project $project, PsiFile $psiFile) {
        FileSymbolTablesCache.getInstance((Project)$project).handleOutOfCodeBlockChange($psiFile, true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/OCSymbolsProjectFixtureCustomizer$Companion;", "", "<init>", "()V", "prevBuildSymbolTables", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$SymbolsProperties$SymbolsKind;", "intellij.cidr.common.testFramework.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

