/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.task.ProjectTaskManager;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.common.DumpKt;
import com.intellij.testFramework.common.TimeoutKt;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrRunnerBundle;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizerListener;
import java.lang.management.ThreadInfo;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a9\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u0007\"\b\b\u0001\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\r\u00a2\u0006\u0002\u0010\u000e\u001aP\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001d\u0018\u00010\u001c\u001aH\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001d\u0018\u00010\u001c\u001a>\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u000b2\u001a\u0010\"\u001a\u0016\u0012\u0004\u0012\u00020$\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u001c0#\u001a\u0016\u0010&\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u000b\u001a\b\u0010'\u001a\u00020\u0017H\u0007\u001a\b\u0010(\u001a\u00020\u0017H\u0007\u00a8\u0006)"}, d2={"publishThreadDump", "Ljava/nio/file/Path;", "fileNamePrefix", "", "trimMargin", "text", "waitForRootsUpdated", "T", "E", "", "disposable", "Lcom/intellij/openapi/Disposable;", "block", "Lcom/intellij/openapi/util/ThrowableComputable;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "createRunConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "name", "type", "Lcom/intellij/execution/configurations/ConfigurationTypeBase;", "buildTargetAndConfigurationData", "Lcom/jetbrains/cidr/execution/BuildTargetAndConfigurationData;", "temporary", "", "shared", "project", "Lcom/intellij/openapi/project/Project;", "configurator", "Ljava/util/function/Consumer;", "Lcom/jetbrains/cidr/execution/CidrRunConfiguration;", "settings", "executeProjectTask", "Lcom/intellij/openapi/util/Pair;", "projectDisposable", "taskExecutor", "Ljava/util/function/BiConsumer;", "Lcom/intellij/task/ProjectTaskManager;", "Lcom/intellij/task/ProjectTaskManager$Result;", "disposeBuildToolWindow", "hasRadler", "hasKMP", "intellij.cidr.common.testFramework.core.nolang"})
@JvmName(name="CidrTestUtils")
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncom/jetbrains/cidr/CidrTestUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class CidrTestUtils {
    @NotNull
    public static final Path publishThreadDump(@NotNull String fileNamePrefix) {
        Intrinsics.checkNotNullParameter((Object)fileNamePrefix, (String)"fileNamePrefix");
        Path dumpPath = DumpKt.publishArtifact(fileNamePrefix, "txt", (Function1<? super Path, Unit>)((Function1)CidrTestUtils::publishThreadDump$lambda$0));
        System.out.println((Object)("Thread dump is published to " + dumpPath));
        return dumpPath;
    }

    @NotNull
    public static final String trimMargin(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return StringsKt.trimMargin$default((String)text2, null, (int)1, null);
    }

    @Nullable
    public static final <T, E extends Throwable> T waitForRootsUpdated(@NotNull Disposable disposable, @NotNull ThrowableComputable<T, E> block) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        CompletableFuture<Void> rootsUpdated = new CompletableFuture<Void>();
        ApplicationKt.getApplication().getMessageBus().connect(disposable).subscribe(OCRootsSynchronizerListener.TOPIC, (Object)new OCRootsSynchronizerListener(rootsUpdated){
            final /* synthetic */ CompletableFuture<Void> $rootsUpdated;
            {
                this.$rootsUpdated = $rootsUpdated;
            }

            public void afterRootsUpdated(CidrWorkspace workspace) {
                Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
                this.$rootsUpdated.complete(null);
            }
        });
        Object result = block.compute();
        rootsUpdated.get(Duration.getInWholeMilliseconds-impl((long)Duration.times-UwyO8pc((long)TimeoutKt.getDEFAULT_TEST_TIMEOUT(), (int)3)), TimeUnit.MILLISECONDS);
        return (T)result;
    }

    @NotNull
    public static final RunnerAndConfigurationSettings createRunConfiguration(@NotNull String name, @NotNull ConfigurationTypeBase type, @Nullable BuildTargetAndConfigurationData buildTargetAndConfigurationData, boolean temporary, boolean shared, @NotNull Project project, @Nullable Consumer<CidrRunConfiguration<?, ?>> configurator) throws Exception {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)EdtTestUtilKt.runInEdtAndGet(() -> CidrTestUtils.createRunConfiguration$lambda$0(project, name, type));
        return CidrTestUtils.createRunConfiguration(settings, buildTargetAndConfigurationData, temporary, shared, project, configurator);
    }

    @NotNull
    public static final RunnerAndConfigurationSettings createRunConfiguration(@NotNull RunnerAndConfigurationSettings settings, @Nullable BuildTargetAndConfigurationData buildTargetAndConfigurationData, boolean temporary, boolean shared, @NotNull Project project, @Nullable Consumer<CidrRunConfiguration<?, ?>> configurator) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        settings.setTemporary(temporary);
        RunConfiguration runConfiguration = settings.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.CidrRunConfiguration<*, *>");
        CidrRunConfiguration config = (CidrRunConfiguration)runConfiguration;
        config.setTargetAndConfigurationData(buildTargetAndConfigurationData);
        if (config instanceof CidrExecutableDataHolder) {
            ExecutableData executableData;
            if (buildTargetAndConfigurationData != null && buildTargetAndConfigurationData.target != null) {
                BuildTargetData buildTargetData = buildTargetAndConfigurationData.target;
                Intrinsics.checkNotNull((Object)buildTargetData);
                executableData = new ExecutableData(buildTargetData);
            } else {
                executableData = null;
            }
            ExecutableData data = executableData;
            ((CidrExecutableDataHolder)config).setExecutableData(data);
        }
        Consumer<CidrRunConfiguration<?, ?>> consumer = configurator;
        if (consumer != null) {
            consumer.accept(config);
        }
        EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)() -> CidrTestUtils.createRunConfiguration$lambda$1(project, shared, settings)));
        return settings;
    }

    @NotNull
    public static final Pair<Boolean, String> executeProjectTask(@NotNull Project project, @NotNull Disposable projectDisposable, @NotNull BiConsumer<ProjectTaskManager, Consumer<ProjectTaskManager.Result>> taskExecutor) throws Exception {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDisposable, (String)"projectDisposable");
        Intrinsics.checkNotNullParameter(taskExecutor, (String)"taskExecutor");
        CompletableFuture success = new CompletableFuture();
        taskExecutor.accept(ProjectTaskManager.getInstance((Project)project), arg_0 -> CidrTestUtils.executeProjectTask$lambda$0(success, arg_0));
        Ref finished = new Ref((Object)false);
        CidrProjectFixture.measureTiming("Build", () -> CidrTestUtils.executeProjectTask$lambda$1(success, finished));
        Object object = finished.get();
        Intrinsics.checkNotNull((Object)object);
        Assertions.assertTrue((boolean)((Boolean)object), (String)"timeout");
        Object t = success.get();
        Intrinsics.checkNotNull(t);
        boolean result = (Boolean)t;
        String output = CidrTestUtils.disposeBuildToolWindow(project, projectDisposable);
        return new Pair((Object)result, (Object)output);
    }

    @NotNull
    public static final String disposeBuildToolWindow(@NotNull Project project, @NotNull Disposable projectDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDisposable, (String)"projectDisposable");
        Content content = (Content)UIUtil.invokeAndWaitIfNeeded(() -> CidrTestUtils.disposeBuildToolWindow$lambda$0(project));
        String output = "";
        if (content != null) {
            JComponent jComponent = content.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            JComponent console = jComponent;
            if (console instanceof ConsoleViewImpl) {
                UIUtil.invokeAndWaitIfNeeded(() -> CidrTestUtils.disposeBuildToolWindow$lambda$1(console));
                output = ((ConsoleViewImpl)console).getText();
            }
            Disposer.register((Disposable)projectDisposable, (Disposable)((Disposable)content));
        }
        return output;
    }

    @ApiStatus.Obsolete
    public static final boolean hasRadler() {
        return PluginManager.getInstance().findEnabledPlugin(PluginId.Companion.getId("org.jetbrains.plugins.clion.radler")) != null;
    }

    @ApiStatus.Obsolete
    public static final boolean hasKMP() {
        return PluginManager.getInstance().findEnabledPlugin(PluginId.Companion.getId("com.jetbrains.kmm")) != null;
    }

    private static final Unit publishThreadDump$lambda$0(Path dumpPath) {
        Intrinsics.checkNotNullParameter((Object)dumpPath, (String)"dumpPath");
        String string = ThreadDumper.getThreadDumpInfo((ThreadInfo[])ThreadDumper.getThreadInfos(), (boolean)true).getRawDump();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRawDump(...)");
        String threadDump = string;
        Files.writeString(dumpPath, (CharSequence)threadDump, new OpenOption[0]);
        return Unit.INSTANCE;
    }

    private static final RunnerAndConfigurationSettings createRunConfiguration$lambda$0(Project $project, String $name, ConfigurationTypeBase $type) {
        RunManager runManager = RunManager.Companion.getInstance($project);
        runManager.removeConfiguration(runManager.findConfigurationByName($name));
        return runManager.createConfiguration($name, $type.getConfigurationFactories()[0]);
    }

    private static final Unit createRunConfiguration$lambda$1(Project $project, boolean $shared, RunnerAndConfigurationSettings $settings) {
        RunManagerImpl runManager = RunManagerImpl.Companion.getInstanceImpl($project);
        runManager.fireBeginUpdate();
        if ($shared) {
            $settings.storeInDotIdeaFolder();
        } else {
            $settings.storeInLocalWorkspace();
        }
        runManager.addConfiguration($settings);
        runManager.setSelectedConfiguration($settings);
        runManager.fireEndUpdate();
        return Unit.INSTANCE;
    }

    private static final void executeProjectTask$lambda$0(CompletableFuture $success, ProjectTaskManager.Result result) {
        $success.complete(result != null && !result.isAborted() && !result.hasErrors());
    }

    private static final void executeProjectTask$lambda$1(CompletableFuture $success, Ref $finished) {
        try {
            $success.get(1L, TimeUnit.MINUTES);
            $finished.set((Object)true);
        }
        catch (TimeoutException timeoutException) {
            $finished.set((Object)false);
        }
    }

    private static final Content disposeBuildToolWindow$lambda$0(Project $project) {
        Object object;
        block2: {
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance($project).getToolWindow("Messages");
            if (toolWindow == null) {
                return null;
            }
            ContentManager contentManager = toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
            ContentManager contentManager2 = contentManager;
            Content[] contentArray = contentManager2.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            for (Object object2 : (Object[])contentArray) {
                Content content1 = (Content)object2;
                boolean bl = false;
                Content content = content1;
                Intrinsics.checkNotNull((Object)content);
                if (!Intrinsics.areEqual((Object)content.getDisplayName(), (Object)CidrRunnerBundle.message((String)"build.logToolWindowName", (Object[])new Object[0]))) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        return (Content)object;
    }

    private static final void disposeBuildToolWindow$lambda$1(JComponent $console) {
        WriteIntentReadAction.run(() -> CidrTestUtils.disposeBuildToolWindow$lambda$1$0($console));
    }

    private static final void disposeBuildToolWindow$lambda$1$0(JComponent $console) {
        UIUtil.dispatchAllInvocationEvents();
        ((ConsoleViewImpl)$console).flushDeferredText();
        ((ConsoleViewImpl)$console).waitAllRequests();
    }
}

