/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.IoTestUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.cidr.CidrPathManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestDataFixture {
    public static final String REAL_PROJECT_DIR_SUFFIX = "-real";
    private final Set<File> myTempFiles = new HashSet<File>();
    protected boolean myCreateSymLinkedProject;
    private final File myTestDataDir;
    public static final Pattern IDEA_DIR_NAME_PATTERN = Pattern.compile("^" + Pattern.quote(".idea") + "$");

    public CidrTestDataFixture(File testDataDir) {
        this(testDataDir, false);
    }

    public CidrTestDataFixture(File testDataDir, boolean createSymlinkedProject) {
        this.myTestDataDir = testDataDir;
        this.myCreateSymLinkedProject = createSymlinkedProject;
    }

    @NotNull
    public static Path getRegressionTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("regression-testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(0);
        }
        return path;
    }

    @NotNull
    public static Path getAsmTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("cidr-asm/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(1);
        }
        return path;
    }

    @NotNull
    public static Path getCustomCompilerTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("cidr-custom-compiler/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(2);
        }
        return path;
    }

    @NotNull
    public static Path getCMakeTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-cmake/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(3);
        }
        return path;
    }

    @NotNull
    public static Path getMakefileTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-makefile/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(4);
        }
        return path;
    }

    @NotNull
    public static Path getDoxygenTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("doxygen/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(5);
        }
        return path;
    }

    @NotNull
    public static Path getCMakePsiTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-cmake/psi/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(6);
        }
        return path;
    }

    @NotNull
    public static Path getCMakePsiLegacyTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-cmake/psi/tests-legacy/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(7);
        }
        return path;
    }

    @NotNull
    public static Path getCppDiagnosticsTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().getParent().resolve("contrib/cpp-diagnostics/cmake/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(8);
        }
        return path;
    }

    @NotNull
    public static Path getLangTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("cidr-lang/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(9);
        }
        return path;
    }

    @NotNull
    public static Path getTranslateCodeTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("cidr-translateCode/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(10);
        }
        return path;
    }

    @NotNull
    public static Path getDfaTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-dfa/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(11);
        }
        return path;
    }

    public static Path getRunFileTestData() {
        return CidrPathManager.getCidrSourcesRoot().resolve("clion-runFile/tests/testData");
    }

    @NotNull
    public static Path getDebuggerTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("cidr-debugger/core/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(12);
        }
        return path;
    }

    @NotNull
    public static Path getCoverageTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("cidr-coverage/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(13);
        }
        return path;
    }

    @NotNull
    public static Path getCLionTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion/main/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(14);
        }
        return path;
    }

    @NotNull
    public static Path getProjectStatusTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-projectStatus/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(15);
        }
        return path;
    }

    @NotNull
    public static Path getWestTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-west/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(16);
        }
        return path;
    }

    @NotNull
    public static Path getToolchainsTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-toolchains/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(17);
        }
        return path;
    }

    @NotNull
    public static Path getEmbeddedTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-embedded/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(18);
        }
        return path;
    }

    @NotNull
    public static Path getOpenFolderTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-openfolder/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(19);
        }
        return path;
    }

    @NotNull
    public static Path getProjectModelTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("cidr-projectModel/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(20);
        }
        return path;
    }

    @NotNull
    public static Path getCompDBTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-compdb/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(21);
        }
        return path;
    }

    @NotNull
    public static Path getProfilingTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-profiling/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(22);
        }
        return path;
    }

    @NotNull
    public static Path getPackageManagerTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-packageManager/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(23);
        }
        return path;
    }

    @NotNull
    public static Path getAppCodeTestData() {
        Path path = PathManager.getHomeDir().resolve("CIDR-appcode/appcode/main/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(24);
        }
        return path;
    }

    @NotNull
    public static Path getSwiftTestData() {
        Path path = PathManager.getHomeDir().resolve("CIDR-appcode/swift-core-tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(25);
        }
        return path;
    }

    @NotNull
    public static Path getSwiftPackageManagerTestData() {
        Path path = PathManager.getHomeDir().resolve("CIDR-appcode/swift-package-manager/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(26);
        }
        return path;
    }

    @NotNull
    public static Path getMesonTestData() {
        Path path = CidrPathManager.getCidrSourcesRoot().resolve("clion-meson/tests/testData");
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(27);
        }
        return path;
    }

    public void enableSymlinkedProjectCreation() {
        this.myCreateSymLinkedProject = true;
    }

    public boolean isSymlinked() {
        return this.myCreateSymLinkedProject;
    }

    @NotNull
    public File getTestDataDir() {
        if (this.myTestDataDir == null) {
            throw new UnsupportedOperationException("No test data. Please override CidrTestCase.createTestDataFixture");
        }
        File file = this.myTestDataDir;
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(28);
        }
        return file;
    }

    @NotNull
    public Path getTestDataPath() {
        Path path = this.getTestDataDir().toPath();
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(29);
        }
        return path;
    }

    @NotNull
    public File getTestDataProjectsDir() {
        File file = this.getTestDataFile("projects");
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(30);
        }
        return file;
    }

    @Contract(value="null -> null")
    public File getTestDataProjectsFile(@Nullable String testDataRelativePath) {
        return testDataRelativePath == null ? null : new File(this.getTestDataProjectsDir(), testDataRelativePath);
    }

    @Contract(value="null -> null")
    public File getTestDataFile(@Nullable String testDataRelativePath) {
        return testDataRelativePath == null ? null : new File(this.getTestDataDir(), testDataRelativePath);
    }

    public VirtualFile createTempDir() {
        return CidrTestDataFixture.getVirtualFile(this.createTempIODir());
    }

    public Path createTempPath() {
        return this.createTempIODir().toPath();
    }

    public File createTempIODir() {
        return this.createTempIODir(true);
    }

    public File createTempIODir(boolean deleteOnTearDown) {
        try {
            String randomName = "cidr_test_" + String.valueOf(UUID.randomUUID());
            File result = FileUtil.createTempDirectory((String)randomName, null, (boolean)false).getCanonicalFile();
            if (deleteOnTearDown) {
                this.myTempFiles.add(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void tearDown() {
        for (File each : this.myTempFiles) {
            FileUtil.delete((File)each);
        }
    }

    public VirtualFile createTempFile() {
        return this.createTempFile("");
    }

    public VirtualFile createTempFile(@NotNull String content) {
        if (content == null) {
            CidrTestDataFixture.$$$reportNull$$$0(31);
        }
        return CidrTestDataFixture.prepareFile(this.createTempIOFile(), content);
    }

    public VirtualFile createTempFile(@NotNull String content, @NotNull String suffix) {
        if (content == null) {
            CidrTestDataFixture.$$$reportNull$$$0(32);
        }
        if (suffix == null) {
            CidrTestDataFixture.$$$reportNull$$$0(33);
        }
        return CidrTestDataFixture.prepareFile(this.createTempIOFile(suffix), content);
    }

    private static VirtualFile prepareFile(@NotNull File f, @NotNull String content) {
        if (f == null) {
            CidrTestDataFixture.$$$reportNull$$$0(34);
        }
        if (content == null) {
            CidrTestDataFixture.$$$reportNull$$$0(35);
        }
        try {
            FileUtil.writeToFile((File)f, (byte[])content.getBytes(Charset.defaultCharset()));
            return CidrTestDataFixture.getVirtualFile(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static VirtualFile getVirtualFile(@NotNull File f) {
        if (f == null) {
            CidrTestDataFixture.$$$reportNull$$$0(36);
        }
        VirtualFile result = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(f);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{result});
        return result;
    }

    public File createTempIOFile() {
        return this.createTempIOFile("");
    }

    public File createTempIOFile(@NotNull String suffix) {
        if (suffix == null) {
            CidrTestDataFixture.$$$reportNull$$$0(37);
        }
        return this.createTempIOFile("cidr_test_file_", suffix);
    }

    public File createTempIOFile(@NotNull String prefix, @NotNull String suffix) {
        File f;
        if (prefix == null) {
            CidrTestDataFixture.$$$reportNull$$$0(38);
        }
        if (suffix == null) {
            CidrTestDataFixture.$$$reportNull$$$0(39);
        }
        try {
            f = FileUtil.createTempFile((String)prefix, (String)suffix, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((boolean)f.exists());
        this.myTempFiles.add(f);
        return f;
    }

    public VirtualFile createFile(@NotNull VirtualFile dir, @NotNull String name, @NotNull String content) {
        if (dir == null) {
            CidrTestDataFixture.$$$reportNull$$$0(40);
        }
        if (name == null) {
            CidrTestDataFixture.$$$reportNull$$$0(41);
        }
        if (content == null) {
            CidrTestDataFixture.$$$reportNull$$$0(42);
        }
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> {
                VirtualFile file = dir.findChild(name);
                if (file == null) {
                    file = dir.createChildData((Object)this, name);
                }
                file.setBinaryContent(content.getBytes(Charset.defaultCharset()));
                return file;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateFileText(@NotNull VirtualFile file, @NotNull String append) throws IOException {
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(43);
        }
        if (append == null) {
            CidrTestDataFixture.$$$reportNull$$$0(44);
        }
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file, (String)(VfsUtilCore.loadText((VirtualFile)file) + append)));
    }

    public void writeFileTextExternally(@NotNull VirtualFile file, @NotNull String text2) throws IOException {
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(45);
        }
        if (text2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(46);
        }
        this.writeIOFileText(VfsUtilCore.virtualToIoFile((VirtualFile)file), text2);
        file.refresh(false, false);
    }

    public void updateFileTextExternally(@NotNull VirtualFile file, @NotNull String append) throws IOException {
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(47);
        }
        if (append == null) {
            CidrTestDataFixture.$$$reportNull$$$0(48);
        }
        this.updateIOFileText(VfsUtilCore.virtualToIoFile((VirtualFile)file), append);
        file.refresh(false, false);
    }

    public void writeIOFileText(@NotNull File file, @NotNull String text2) throws IOException {
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(49);
        }
        if (text2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(50);
        }
        FileUtil.writeToFile((File)file, (String)text2);
        this.updateFileTimestamp(file);
    }

    public void updateIOFileText(@NotNull File file, @NotNull String append) throws IOException {
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(51);
        }
        if (append == null) {
            CidrTestDataFixture.$$$reportNull$$$0(52);
        }
        this.writeIOFileText(file, FileUtil.loadFile((File)file, (Charset)StandardCharsets.UTF_8) + append);
    }

    public void updateFileText(@NotNull VirtualFile file, @NotNull String replaceString, @NotNull String replaceWith) throws IOException {
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(53);
        }
        if (replaceString == null) {
            CidrTestDataFixture.$$$reportNull$$$0(54);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(55);
        }
        String original = VfsUtilCore.loadText((VirtualFile)file);
        String replaced = original.replace(replaceString, replaceWith);
        TestCase.assertFalse((String)(replaceString + " not found in \n" + original), (boolean)original.equals(replaced));
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file, (String)replaced));
    }

    public void updateFileTextExternally(@NotNull VirtualFile file, @NotNull String replaceString, @NotNull String replaceWith) throws IOException {
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(56);
        }
        if (replaceString == null) {
            CidrTestDataFixture.$$$reportNull$$$0(57);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(58);
        }
        this.updateIOFileText(VfsUtilCore.virtualToIoFile((VirtualFile)file), replaceString, replaceWith);
        file.refresh(false, false);
    }

    public void updateIOFileText(@NotNull File file, @NotNull String replaceString, @NotNull String replaceWith) throws IOException {
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(59);
        }
        if (replaceString == null) {
            CidrTestDataFixture.$$$reportNull$$$0(60);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(61);
        }
        String original = FileUtil.loadFile((File)file, (String)"UTF-8", (boolean)true);
        String replaced = original.replace(replaceString, replaceWith);
        TestCase.assertFalse((String)(replaceString + " not found in \n" + original), (boolean)original.equals(replaced));
        FileUtil.writeToFile((File)file, (String)replaced);
        this.updateFileTimestamp(file);
    }

    public void updateFileTimestamp(File ... files) {
        if (files == null) {
            CidrTestDataFixture.$$$reportNull$$$0(62);
        }
        for (File file : files) {
            TestCase.assertTrue((boolean)file.setLastModified(file.lastModified() + 3000L));
        }
    }

    public void updateFileRegexpText(@NotNull VirtualFile file, @NotNull @RegExp String regexp, @NotNull String replaceWith) throws IOException {
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(63);
        }
        if (regexp == null) {
            CidrTestDataFixture.$$$reportNull$$$0(64);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(65);
        }
        this.updateFileRegexpText(file, regexp, replaceWith, true);
    }

    public void updateFileRegexpText(@NotNull VirtualFile file, @NotNull @RegExp String regexp, @NotNull String replaceWith, boolean failIfNotFound) throws IOException {
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(66);
        }
        if (regexp == null) {
            CidrTestDataFixture.$$$reportNull$$$0(67);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(68);
        }
        String original = VfsUtilCore.loadText((VirtualFile)file);
        String replaced = CidrTestDataFixture.replaceFirstDotAll(original, regexp, replaceWith, failIfNotFound);
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file, (String)replaced));
    }

    public void updateIOFileRegexpText(@NotNull File file, @NotNull @RegExp String regexp, @NotNull String replaceWith) throws IOException {
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(69);
        }
        if (regexp == null) {
            CidrTestDataFixture.$$$reportNull$$$0(70);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(71);
        }
        String original = FileUtil.loadFile((File)file, (Charset)StandardCharsets.UTF_8);
        String replaced = CidrTestDataFixture.replaceFirstDotAll(original, regexp, replaceWith, true);
        FileUtil.writeToFile((File)file, (String)replaced);
        this.updateFileTimestamp(file);
    }

    private static String replaceFirstDotAll(String original, @RegExp String regexp, String replaceWith, boolean failIfNotFound) {
        Pattern pattern = Pattern.compile(regexp, 32);
        if (failIfNotFound) {
            Assert.assertTrue((String)(regexp + " not found in \n" + original), (boolean)pattern.matcher(original).find());
        }
        return pattern.matcher(original).replaceFirst(replaceWith);
    }

    @NotNull
    public List<File> collectDirectSubDirs(@NotNull File dir) {
        if (dir == null) {
            CidrTestDataFixture.$$$reportNull$$$0(72);
        }
        return CidrTestDataFixture.collectSubDirs(dir, true, new ArrayList<File>());
    }

    @NotNull
    public List<File> collectSubDirs(@NotNull File dir) {
        if (dir == null) {
            CidrTestDataFixture.$$$reportNull$$$0(73);
        }
        return CidrTestDataFixture.collectSubDirs(dir, false, new ArrayList<File>());
    }

    @NotNull
    private static List<File> collectSubDirs(@NotNull File dir, boolean direct, @NotNull List<File> result) {
        File[] subFiles;
        if (dir == null) {
            CidrTestDataFixture.$$$reportNull$$$0(74);
        }
        if (result == null) {
            CidrTestDataFixture.$$$reportNull$$$0(75);
        }
        if ((subFiles = dir.listFiles()) != null) {
            for (File eachSubFile : subFiles) {
                if (!eachSubFile.isDirectory()) continue;
                result.add(eachSubFile);
                if (direct) continue;
                CidrTestDataFixture.collectSubDirs(eachSubFile, false, result);
            }
        }
        List<File> list = result;
        if (list == null) {
            CidrTestDataFixture.$$$reportNull$$$0(76);
        }
        return list;
    }

    public File copyTestData(@NotNull File folderOrZipToCopy, @NotNull File toDir) {
        if (folderOrZipToCopy == null) {
            CidrTestDataFixture.$$$reportNull$$$0(77);
        }
        if (toDir == null) {
            CidrTestDataFixture.$$$reportNull$$$0(78);
        }
        File dir = toDir;
        String action = null;
        try {
            if (folderOrZipToCopy.isFile() && FileUtilRt.extensionEquals((String)folderOrZipToCopy.getName(), (String)"zip")) {
                action = "extract";
                ZipUtil.extract((File)folderOrZipToCopy, (File)toDir, null);
            } else {
                action = "copy";
                dir = new File(toDir, folderOrZipToCopy.getName());
                FileUtil.copyDir((File)folderOrZipToCopy, (File)dir);
            }
            List ideaDirs = FileUtil.findFilesOrDirsByMask((Pattern)IDEA_DIR_NAME_PATTERN, (File)dir);
            for (File ideaDir : ideaDirs) {
                if (!ideaDir.isDirectory()) continue;
                System.out.println("WARN: '.idea' found in test project and will be deleted during copy: " + ideaDir.getPath());
                FileUtil.delete((File)ideaDir);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't " + action + " test data from " + String.valueOf(folderOrZipToCopy) + " to " + String.valueOf(toDir), e);
        }
        File projectDir = new File(toDir, folderOrZipToCopy.getName());
        if (this.myCreateSymLinkedProject) {
            File realDir = this.getRealFolder(projectDir);
            FileUtil.moveDirWithContent((File)projectDir, (File)realDir);
            this.createSymlink(realDir, projectDir.getName());
        }
        return projectDir;
    }

    @NotNull
    protected File getRealFolder(File projectDir) {
        return new File(projectDir.getPath() + REAL_PROJECT_DIR_SUFFIX);
    }

    @NotNull
    public File createSymlink(@NotNull File target) {
        if (target == null) {
            CidrTestDataFixture.$$$reportNull$$$0(79);
        }
        File file = this.createSymlink(target, target.getName() + "-symlink");
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(80);
        }
        return file;
    }

    @NotNull
    public File createSymlink(@NotNull File target, @NotNull String name) {
        if (target == null) {
            CidrTestDataFixture.$$$reportNull$$$0(81);
        }
        if (name == null) {
            CidrTestDataFixture.$$$reportNull$$$0(82);
        }
        File file = this.createSymlink(target, new File(target.getParentFile(), name));
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(83);
        }
        return file;
    }

    @NotNull
    public File createSymlink(@NotNull File target, @NotNull File symlink) {
        if (target == null) {
            CidrTestDataFixture.$$$reportNull$$$0(84);
        }
        if (symlink == null) {
            CidrTestDataFixture.$$$reportNull$$$0(85);
        }
        TestCase.assertFalse((boolean)symlink.exists());
        try {
            IoTestUtil.createSymLink(target.getAbsolutePath(), symlink.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create symlink", e);
        }
        Assert.assertTrue((boolean)symlink.exists());
        File file = symlink;
        if (file == null) {
            CidrTestDataFixture.$$$reportNull$$$0(86);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 77, 78, 79, 81, 82, 84, 85 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrTestDataFixture";
                break;
            }
            case 31: 
            case 32: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 33: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 40: 
            case 72: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 41: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 59: 
            case 63: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 44: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "append";
                break;
            }
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 54: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceString";
                break;
            }
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceWith";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 64: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderOrZipToCopy";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 79: 
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegressionTestData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsmTestData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomCompilerTestData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeTestData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMakefileTestData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoxygenTestData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakePsiTestData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakePsiLegacyTestData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCppDiagnosticsTestData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLangTestData";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTranslateCodeTestData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfaTestData";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerTestData";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageTestData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCLionTestData";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStatusTestData";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getWestTestData";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolchainsTestData";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedTestData";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFolderTestData";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectModelTestData";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompDBTestData";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingTestData";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageManagerTestData";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppCodeTestData";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwiftTestData";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwiftPackageManagerTestData";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getMesonTestData";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataDir";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataProjectsDir";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrTestDataFixture";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSubDirs";
                break;
            }
            case 80: 
            case 83: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymlink";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "prepareFile";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createTempIOFile";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 43: 
            case 44: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "updateFileText";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "writeFileTextExternally";
                break;
            }
            case 47: 
            case 48: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "updateFileTextExternally";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "writeIOFileText";
                break;
            }
            case 51: 
            case 52: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "updateIOFileText";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "updateFileTimestamp";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "updateFileRegexpText";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "updateIOFileRegexpText";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "collectDirectSubDirs";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "collectSubDirs";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "copyTestData";
                break;
            }
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "createSymlink";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 77, 78, 79, 81, 82, 84, 85 -> new IllegalArgumentException(string);
        };
    }
}

