/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrCodeInsightFixtureMarker;
import com.jetbrains.cidr.CidrDebuggingFixtureMarker;
import com.jetbrains.cidr.CidrEmptyProjectFixtureCustomizer;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.CidrProjectDependentFixtureBase;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrProjectFixtureCustomizer;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProject;
import com.jetbrains.cidr.CidrTestProjects;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.hamcrest.Matcher;
import org.hamcrest.number.OrderingComparison;
import org.intellij.lang.annotations.JdkConstants;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class CidrTestCaseBase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixtureMarker, CODE_INSIGHT_FIXTURE extends CidrCodeInsightFixtureMarker>
extends UsefulTestCase
implements CidrProjectDependentFixtureBase {
    private static volatile boolean platformInitialized = false;
    private final List<String> myAllAllowedRoots = new ArrayList<String>();
    protected CidrTestDataFixture myTestDataFixture;
    protected PROJECT_FIXTURE myProjectFixture;
    protected EXECUTION_FIXTURE myExecutionFixture;
    protected DEBUGGING_FIXTURE myDebuggingFixture;
    protected CODE_INSIGHT_FIXTURE myCodeInsightFixture;
    protected CidrProjectFixtureCustomizer myProjectFixtureCustomizer;

    @Override
    protected Duration getCoroutineTimeout() {
        return Duration.ofMinutes(10L);
    }

    @Override
    protected boolean runFromCoroutine() {
        return true;
    }

    @Nullable
    protected DEBUGGING_FIXTURE createDebuggingFixture() {
        return null;
    }

    @RequiresEdt
    protected static void waitForTaskAndDispatchEvents(@NotNull ThrowableRunnable<Throwable> task2) throws ExecutionException, InterruptedException {
        if (task2 == null) {
            CidrTestCaseBase.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertEventDispatchThread();
        try {
            CidrTestCaseBase.waitForTaskAndDispatchEvents(task2, Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    protected static void waitForTaskAndDispatchEvents(@NotNull ThrowableRunnable<Throwable> task2, long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        void unit;
        if (task2 == null) {
            CidrTestCaseBase.$$$reportNull$$$0(1);
        }
        if (timeUnit == null) {
            CidrTestCaseBase.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        CompletableFuture taskCompletedFuture = new CompletableFuture();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                task2.run();
            }
            catch (Throwable thr) {
                taskCompletedFuture.completeExceptionally(thr);
            }
            finally {
                taskCompletedFuture.complete(true);
            }
        });
        CidrTestCaseBase.waitAndDispatchEvents(taskCompletedFuture, timeout, (TimeUnit)unit);
    }

    @RequiresEdt
    public static void waitAndDispatchEvents(@NotNull Future<?> future) throws ExecutionException, InterruptedException {
        if (future == null) {
            CidrTestCaseBase.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        try {
            CidrTestCaseBase.waitAndDispatchEvents(future, Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void initTestFramework() {
        Logger.setFactory(TestLoggerFactory.class);
        if (!platformInitialized) {
            platformInitialized = true;
            try {
                this.initPlatform();
            }
            catch (Throwable e) {
                this.platformInitializationFailed(e);
            }
        }
    }

    protected void onShutdownPlatform(TestApplicationManager app) {
        CidrProjectFixture.cleanupStatics();
        ApplicationManager.getApplication().invokeAndWait(() -> app.dispose());
    }

    protected void initPlatform() {
        TestApplicationManager app = TestApplicationManager.getInstance();
        ShutDownTracker.getInstance().registerShutdownTask(() -> {
            try {
                this.onShutdownPlatform(app);
            }
            catch (Exception e) {
                e.printStackTrace();
                CidrLog.LOG.error((Throwable)e);
            }
        });
        this.initApplication();
    }

    protected void platformInitializationFailed(@NotNull Throwable e) {
        if (e == null) {
            CidrTestCaseBase.$$$reportNull$$$0(4);
        }
        System.err.println("Application initialization issue, exiting.");
        e.printStackTrace();
        try {
            Logger.getInstance((String)("#" + CidrTestCaseBase.class.getPackage().getName())).error("Application initialization issue, exiting.", e);
        }
        finally {
            System.exit(1);
        }
    }

    protected void initApplication() {
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            CidrTestCaseBase.$$$reportNull$$$0(5);
        }
        if (this.shouldRunInWriteAction()) {
            WriteAction.runAndWait(testRunnable);
        } else {
            super.runTestRunnable(testRunnable);
        }
    }

    protected boolean shouldRunInWriteAction() {
        return false;
    }

    protected void beforeCidrSetUp() throws Exception {
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.beforeCidrSetUp();
        Path currentDir = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath();
        Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toAbsolutePath();
        long freeSpaceBytesInCurrentDir = Files.getFileStore(currentDir).getUsableSpace();
        long freeSpaceBytesInTmp = Files.getFileStore(tmpDir).getUsableSpace();
        long minimumFreeSpaceMegabytes = 700L;
        long minimumFreeSpaceBytes = 734003200L;
        String errorMessage = "Not enough free space in %s to run a test (less than %d MB), %d B";
        Assert.assertThat((String)String.format("Not enough free space in %s to run a test (less than %d MB), %d B", currentDir, 700L, freeSpaceBytesInCurrentDir), (Object)freeSpaceBytesInCurrentDir, (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(734003200L)));
        Assert.assertThat((String)String.format("Not enough free space in %s to run a test (less than %d MB), %d B", tmpDir, 700L, freeSpaceBytesInTmp), (Object)freeSpaceBytesInTmp, (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(734003200L)));
        this.opaqueSetAllowedModules();
        this.setUpFixtures();
    }

    protected void opaqueSetAllowedModules() {
    }

    public void registerAllowedRoots(List<String> roots, @NotNull Disposable disposable) {
        if (disposable == null) {
            CidrTestCaseBase.$$$reportNull$$$0(6);
        }
        final ArrayList<String> newRoots = new ArrayList<String>(roots);
        newRoots.removeAll(this.myAllAllowedRoots);
        String[] newRootsArray = ArrayUtilRt.toStringArray(newRoots);
        VfsRootAccess.allowRootAccess((Disposable)disposable, (String[])newRootsArray);
        this.myAllAllowedRoots.addAll(newRoots);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                CidrTestCaseBase.this.myAllAllowedRoots.removeAll(newRoots);
            }
        });
    }

    protected void setUpFixtures() throws Exception {
        this.myTestDataFixture = this.createTestDataFixture();
        this.myProjectFixture = this.createProjectFixture();
        if (this.myProjectFixture != null) {
            this.myProjectFixtureCustomizer = this.createProjectFixtureCustomizer((CidrProjectFixture<?>)this.myProjectFixture);
            ((CidrProjectFixture)this.myProjectFixture).setCustomizer(this.myProjectFixtureCustomizer);
            this.configureProjectFixture(this.myProjectFixture);
            ((CidrProjectFixture)this.myProjectFixture).setUp(this.getClass().getName(), this.getName());
            ((CidrProjectFixture)this.myProjectFixture).addProjectDependentFixture(this);
            ((CidrProjectFixture)this.myProjectFixture).setCleanProjectOption(this.shouldCleanProject());
            ArrayList<String> allowedRoots = new ArrayList<String>();
            ((CidrProjectFixture)this.myProjectFixture).collectAllowedRoots(allowedRoots);
            ((ListAssert)((ListAssert)Assumptions.assumeThat(allowedRoots).as("allowed vfs roots", new Object[0])).doesNotContainNull()).doesNotContain((Object[])new String[]{""});
            this.registerAllowedRoots(allowedRoots, this.getTestRootDisposable());
            this.myExecutionFixture = this.createExecutionFixture();
            if (this.myExecutionFixture != null) {
                ((CidrExecutionFixture)((Object)this.myExecutionFixture)).setUp();
            }
            if (this.myExecutionFixture != null) {
                this.myDebuggingFixture = this.createDebuggingFixture();
                if (this.myDebuggingFixture != null) {
                    this.myDebuggingFixture.setUp();
                }
            }
            this.myCodeInsightFixture = this.createCodeInsightFixture();
            if (this.myCodeInsightFixture != null) {
                this.myCodeInsightFixture.setUp();
            }
        }
    }

    @NotNull
    protected CidrProjectFixtureCustomizer createProjectFixtureCustomizer(@NotNull CidrProjectFixture<?> projectFixture2) {
        if (projectFixture2 == null) {
            CidrTestCaseBase.$$$reportNull$$$0(7);
        }
        return new CidrEmptyProjectFixtureCustomizer();
    }

    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrTestDataFixture(null);
    }

    @Nullable
    protected PROJECT_FIXTURE createProjectFixture() {
        return null;
    }

    protected void configureProjectFixture(@NotNull PROJECT_FIXTURE projectFixture2) {
        if (projectFixture2 == null) {
            CidrTestCaseBase.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    protected EXECUTION_FIXTURE createExecutionFixture() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static void waitAndDispatchEvents(@NotNull Future<?> future, long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        void unit;
        if (future == null) {
            CidrTestCaseBase.$$$reportNull$$$0(9);
        }
        if (timeUnit == null) {
            CidrTestCaseBase.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertEventDispatchThread();
        long timeoutNs = unit.toNanos(timeout);
        long startTimeNs = System.nanoTime();
        while (System.nanoTime() - startTimeNs < timeoutNs) {
            try {
                future.get(50L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException ex) {
                PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
            }
        }
        throw new TimeoutException();
    }

    @Nullable
    protected CODE_INSIGHT_FIXTURE createCodeInsightFixture() {
        return null;
    }

    @Override
    protected boolean shouldContainTempFiles() {
        return false;
    }

    protected CidrProjectFixture.CleanProjectOption shouldCleanProject() {
        return CidrProjectFixture.CleanProjectOption.DO_NOT_CLEAN;
    }

    @Override
    protected void tearDown() throws Exception {
        RunAll.runAll(() -> {
            if (this.myCodeInsightFixture != null) {
                this.myCodeInsightFixture.tearDown();
            }
        }, () -> {
            if (this.myDebuggingFixture != null) {
                this.myDebuggingFixture.tearDown();
            }
        }, () -> {
            if (this.myExecutionFixture != null) {
                ((CidrExecutionFixture)((Object)((Object)this.myExecutionFixture))).tearDown();
            }
        }, () -> {
            if (this.myProjectFixture != null) {
                ((CidrProjectFixture)this.myProjectFixture).removeProjectDependentFixture(this);
            }
        }, () -> {
            if (this.myProjectFixture != null) {
                ((CidrProjectFixture)this.myProjectFixture).tearDown();
            }
        }, () -> {
            if (this.myTestDataFixture != null) {
                this.myTestDataFixture.tearDown();
            }
        }, () -> super.tearDown());
    }

    public static TestApplicationManager getTestApplication() {
        return TestApplicationManager.getInstance();
    }

    @NotNull
    public Project getProject() {
        Project project = ((CidrProjectFixture)this.myProjectFixture).getProject();
        if (project == null) {
            CidrTestCaseBase.$$$reportNull$$$0(11);
        }
        return project;
    }

    protected File getTestDataDir() {
        return this.myTestDataFixture.getTestDataDir();
    }

    protected File getTestDataFile(String testDataRelativePath) {
        return this.myTestDataFixture.getTestDataFile(testDataRelativePath);
    }

    protected File getTestDataProjectsDir() {
        return this.myTestDataFixture.getTestDataProjectsDir();
    }

    protected File getTestDataProjectsFile(String testDataRelativePath) {
        return this.myTestDataFixture.getTestDataProjectsFile(testDataRelativePath);
    }

    public VirtualFile createTempDir() {
        return this.myTestDataFixture.createTempDir();
    }

    public File createTempIODir() {
        return this.myTestDataFixture.createTempIODir();
    }

    public VirtualFile createTempFile() {
        return this.myTestDataFixture.createTempFile();
    }

    public File createTempIOFile() {
        return this.myTestDataFixture.createTempIOFile();
    }

    public VirtualFile createTempFile(String content) {
        return this.myTestDataFixture.createTempFile(content);
    }

    public VirtualFile createFile(VirtualFile dir, String name, String content) {
        return this.myTestDataFixture.createFile(dir, name, content);
    }

    public static void assertMatches(String string, @RegExp String pattern) {
        CidrTestCaseBase.assertMatches(string, pattern, 0);
    }

    public static void assertDoesntMatch(String string, @RegExp String pattern) {
        CidrTestCaseBase.assertDoesntMatch(string, pattern, 0);
    }

    public static void assertMatches(String string, @RegExp String pattern, @JdkConstants.PatternFlags int flags) {
        if (!Pattern.compile(pattern, flags).matcher(string).matches()) {
            CidrTestCaseBase.assertEquals((String)("Text: " + string + "\nShould match pattern: " + pattern), (String)pattern.replace("\\n", "\n"), (String)string);
        }
    }

    public static void assertContains(@NotNull String text2, @NotNull String subString, @NotNull String message) {
        if (text2 == null) {
            CidrTestCaseBase.$$$reportNull$$$0(12);
        }
        if (subString == null) {
            CidrTestCaseBase.$$$reportNull$$$0(13);
        }
        if (message == null) {
            CidrTestCaseBase.$$$reportNull$$$0(14);
        }
        CidrTestCaseBase.assertTrue((String)("Text: '" + text2 + "'\nShould contain substring: " + subString + ". " + message), (boolean)text2.contains(subString));
    }

    public static void assertContains(@NotNull String text2, @NotNull String subString) {
        if (text2 == null) {
            CidrTestCaseBase.$$$reportNull$$$0(15);
        }
        if (subString == null) {
            CidrTestCaseBase.$$$reportNull$$$0(16);
        }
        CidrTestCaseBase.assertContains(text2, subString, "");
    }

    public static void assertDoesntMatch(String string, @RegExp String pattern, @JdkConstants.PatternFlags int flags) {
        CidrTestCaseBase.assertFalse((String)("Text: " + string + "\nShould not match pattern: " + pattern), (boolean)Pattern.compile(pattern, flags).matcher(string).matches());
    }

    public static void printPsiStructure(PsiElement e) {
        System.err.println(CidrTestCaseBase.psiStructure(e));
    }

    public static String psiStructure(PsiElement e) {
        return DebugUtil.psiToString((PsiElement)e, (boolean)true);
    }

    public static void waitForSwing() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        Semaphore s = new Semaphore();
        s.down();
        ApplicationManager.getApplication().invokeLater(() -> s.up());
        try {
            s.waitForUnsafe();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {});
    }

    public void waitForDebuggerAndSwingEvents() {
        this.myDebuggingFixture.waitForDebuggerAndSwingEvents();
    }

    @Nullable
    public VirtualFile findTestProjectSubFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrTestCaseBase.$$$reportNull$$$0(17);
        }
        return ((CidrProjectFixture)this.myProjectFixture).findProjectSubFile(relativePath);
    }

    protected void initProject(@NotNull String projectFileRelativePath) throws Exception {
        if (projectFileRelativePath == null) {
            CidrTestCaseBase.$$$reportNull$$$0(18);
        }
        ((CidrProjectFixture)this.myProjectFixture).initProject(projectFileRelativePath);
    }

    protected void initProject(@NotNull String projectFileRelativePath, @NotNull String folderToCopy) throws Exception {
        if (projectFileRelativePath == null) {
            CidrTestCaseBase.$$$reportNull$$$0(19);
        }
        if (folderToCopy == null) {
            CidrTestCaseBase.$$$reportNull$$$0(20);
        }
        ((CidrProjectFixture)this.myProjectFixture).initProject(projectFileRelativePath, folderToCopy, true);
    }

    @NotNull
    public VirtualFile getTestProjectRoot() {
        VirtualFile virtualFile = ((CidrProjectFixture)this.myProjectFixture).getProjectDir();
        if (virtualFile == null) {
            CidrTestCaseBase.$$$reportNull$$$0(21);
        }
        return virtualFile;
    }

    protected void closeAndReopenProject() throws Exception {
        this.closeAndReopenProject(null);
    }

    protected void closeAndReopenProject(@Nullable Runnable beforeRestart) throws Exception {
        ((CidrProjectFixture)this.myProjectFixture).saveAndCloseProject();
        if (beforeRestart != null) {
            beforeRestart.run();
        }
        ((CidrProjectFixture)this.myProjectFixture).openProject(true);
    }

    @Nullable
    public static String getProjectPathIfOpenAutomatically(@NotNull Class<?> clazz) {
        CidrTestProject annotation;
        if (clazz == null) {
            CidrTestCaseBase.$$$reportNull$$$0(22);
        }
        if ((annotation = CidrTestCaseBase.getProjectPath(clazz)) == null || annotation.project() == CidrTestProjects.NO_PROJECT) {
            return null;
        }
        return annotation.project().getPath();
    }

    @Nullable
    public static String getProjectPathForSorting(@NotNull Class<?> clazz) {
        CidrTestProject annotation;
        if (clazz == null) {
            CidrTestCaseBase.$$$reportNull$$$0(23);
        }
        if ((annotation = CidrTestCaseBase.getProjectPath(clazz)) == null) {
            return null;
        }
        return annotation.project().getPath();
    }

    @Nullable
    public static CidrTestProject getProjectPath(@NotNull Class<?> clazz) {
        if (clazz == null) {
            CidrTestCaseBase.$$$reportNull$$$0(24);
        }
        return CidrTestCaseBase.findAnnotationInClassHierarchy(clazz, CidrTestProject.class);
    }

    @Nullable
    public static <AnnotationClass extends Annotation> AnnotationClass findAnnotationInClassHierarchy(@NotNull Class<?> clazz, @NotNull Class<AnnotationClass> annotationClass) {
        if (clazz == null) {
            CidrTestCaseBase.$$$reportNull$$$0(25);
        }
        if (annotationClass == null) {
            CidrTestCaseBase.$$$reportNull$$$0(26);
        }
        do {
            AnnotationClass annotation;
            if ((annotation = clazz.getAnnotation(annotationClass)) == null) continue;
            return annotation;
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrTestCaseBase";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFileRelativePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderToCopy";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrTestCaseBase";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestProjectRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "waitForTaskAndDispatchEvents";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "waitAndDispatchEvents";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "platformInitializationFailed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerAllowedRoots";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProjectFixtureCustomizer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureProjectFixture";
                break;
            }
            case 11: 
            case 21: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "assertContains";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findTestProjectSubFile";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "initProject";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPathIfOpenAutomatically";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPathForSorting";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPath";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInClassHierarchy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 21 -> new IllegalStateException(string);
        };
    }
}

