/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.system.CpuArch;
import com.jetbrains.performancePlugin.yourkit.YourKitProfilerHandler;
import java.io.File;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class CidrRegressionFixtureBase
extends Assert {
    public static final String ACTIVITY_SEPARATOR = " | ";

    @NotNull
    public static CurveOnChart curveOnChart(@NotNull String chartName, @NotNull String curveName) {
        if (chartName == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(0);
        }
        if (curveName == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(1);
        }
        return new CurveOnChart(curveName, chartName);
    }

    @NotNull
    protected abstract File getDefaultPublishFolder();

    public void tearDown() {
    }

    @SafeVarargs
    public final void logTeamcityMessages(Pair<String, ?> ... logMessages) {
        File serviceMessagesFile = CidrRegressionFixtureBase.getServiceMessagesFile(this.getPublishFolder());
        CidrRegressionFixtureBase.logTeamcityMessages(serviceMessagesFile, logMessages);
    }

    public final void publish(@NotNull File srcFile, @NotNull String publishName) {
        if (srcFile == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(2);
        }
        if (publishName == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(3);
        }
        CidrRegressionFixtureBase.publish(srcFile, publishName, this.getPublishFolder());
    }

    protected double testPerformance(boolean forceFullGCAndMeasureMemoryUsage, CurveOnChart curveOnChart, ThrowableRunnable<? extends Exception> runnable) throws Exception {
        StorageLockContext.forceDirectMemoryCache();
        if (YourKitProfilerHandler.hasValidController()) {
            System.out.println("Starting CPU profiling...");
        }
        YourKitProfilerHandler.startCPUProfiling();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        long gcBefore = gcBeans.stream().mapToLong(GarbageCollectorMXBean::getCollectionTime).sum();
        long before = System.nanoTime();
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            String snapshot = YourKitProfilerHandler.captureCPUSnapshot();
            if (snapshot != null) {
                FileUtil.delete((File)new File(snapshot));
            }
            throw throwable;
        }
        long after2 = System.nanoTime();
        long gcAfter = gcBeans.stream().mapToLong(GarbageCollectorMXBean::getCollectionTime).sum();
        String snapshot = YourKitProfilerHandler.captureCPUSnapshot();
        long nanoTime = after2 - before;
        long milliTime = nanoTime / 1000000L;
        double gcTime = gcAfter - gcBefore;
        double gcTimePercents = gcTime * 100.0 / (double)milliTime;
        this.logTeamcityMessages(Pair.create((Object)curveOnChart.toString(), (Object)milliTime));
        this.logTeamcityMessages(Pair.create((Object)(String.valueOf(curveOnChart) + " | GC time"), (Object)gcTime));
        this.logTeamcityMessages(Pair.create((Object)(String.valueOf(curveOnChart) + " | GC percent"), (Object)gcTimePercents));
        if (forceFullGCAndMeasureMemoryUsage) {
            GCUtil.tryGcSoftlyReachableObjects();
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            long usedMemory = runtime.totalMemory() - runtime.freeMemory();
            this.logTeamcityMessages(Pair.create((Object)(String.valueOf(curveOnChart) + " | Min Used Memory"), (Object)usedMemory));
        }
        if (snapshot != null) {
            File snapshotFile = new File(snapshot);
            this.publish(snapshotFile, CidrRegressionFixtureBase.generateSnapshotResultName(curveOnChart));
            FileUtil.delete((File)snapshotFile);
        }
        return nanoTime;
    }

    @NotNull
    public static String generateResultName(@NotNull CurveOnChart curveOnChart) {
        if (curveOnChart == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(4);
        }
        String string = FileUtil.sanitizeFileName((String)(String.valueOf(curveOnChart) + ACTIVITY_SEPARATOR + new SimpleDateFormat("MM-dd HH-mm-ss").format(new Date())));
        if (string == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private File getPublishFolder() {
        File defaultPublishFolder = this.getDefaultPublishFolder();
        return CidrRegressionFixtureBase.getPublishFolderFile(defaultPublishFolder);
    }

    @SafeVarargs
    public static void logTeamcityMessages(File serviceMessagesFile, Pair<String, ?> ... logMessages) {
        for (Pair<String, ?> pair : logMessages) {
            String message = "##teamcity[buildStatisticValue key='" + (String)pair.getFirst() + "' value='" + String.valueOf(pair.getSecond()) + "']\n";
            System.out.println(">> " + (String)pair.getFirst() + " = " + String.valueOf(pair.getSecond()));
            System.out.println(message);
            if (serviceMessagesFile == null) continue;
            try {
                FileUtil.appendToFile((File)serviceMessagesFile, (String)message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    public static File getServiceMessagesFile() {
        String teamCityPath = System.getProperty("test.results.path");
        return teamCityPath == null ? null : CidrRegressionFixtureBase.getServiceMessagesFile(new File(teamCityPath));
    }

    @NotNull
    private static String generateSnapshotResultName(@NotNull CurveOnChart curveOnChart) {
        if (curveOnChart == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(6);
        }
        String string = CidrRegressionFixtureBase.generateResultName(curveOnChart) + ".snapshot";
        if (string == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static File getPublishFolderFile(@NotNull File defaultPublishFolder) {
        String teamCityPath;
        if (defaultPublishFolder == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(8);
        }
        File file = (teamCityPath = System.getProperty("test.results.path")) != null ? new File(teamCityPath) : defaultPublishFolder;
        if (file == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(9);
        }
        return file;
    }

    @Nullable
    private static File getServiceMessagesFile(@NotNull File publishFolder) {
        String serviceMessagesFile;
        if (publishFolder == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(10);
        }
        return (serviceMessagesFile = System.getProperty("test.results.serviceMessages.file")) == null ? null : new File(publishFolder, serviceMessagesFile);
    }

    private static void publish(@NotNull File srcFile, @NotNull String publishName, @NotNull File publishFolder) {
        if (srcFile == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(11);
        }
        if (publishName == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(12);
        }
        if (publishFolder == null) {
            CidrRegressionFixtureBase.$$$reportNull$$$0(13);
        }
        File zipFile = new File(publishFolder, publishName + ".zip");
        System.out.println("Publishing results in: " + String.valueOf(zipFile));
        CidrRegressionFixtureBase.assertTrue((String)("Cannot create directory : " + String.valueOf(zipFile.getParentFile())), (boolean)FileUtil.createDirectory((File)zipFile.getParentFile()));
        try (Compressor.Zip zip = new Compressor.Zip(zipFile);){
            if (srcFile.isDirectory()) {
                zip.addDirectory(srcFile);
            } else {
                zip.addFile(publishName, srcFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chartName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curveName";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curveOnChart";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrRegressionFixtureBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPublishFolder";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrRegressionFixtureBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateResultName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSnapshotResultName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublishFolderFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "curveOnChart";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "publish";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateResultName";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateSnapshotResultName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPublishFolderFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getServiceMessagesFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9 -> new IllegalStateException(string);
        };
    }

    public static class CurveOnChart {
        private final String curveName;
        private final String chartName;

        public CurveOnChart(String curveName, String chartName) {
            this.curveName = curveName;
            this.chartName = chartName;
        }

        public String toString() {
            String prefix = CpuArch.isArm64() ? "<arm64>" : "";
            return prefix + this.chartName + CidrRegressionFixtureBase.ACTIVITY_SEPARATOR + this.curveName;
        }
    }
}

