/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorWithDelayedPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrRegressionFixtureBase;
import com.jetbrains.cidr.CidrRegressionRunner;
import com.jetbrains.cidr.CidrRegressionTest;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.OCTestUtil;
import com.jetbrains.cidr.ProjectDescription;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.inspections.OCHiddenInspection;
import com.jetbrains.cidr.lang.modulemap.resolve.AppCodeModuleErrorsTestChecker;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCModuleMapBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CidrRegressionFixture
extends CidrRegressionFixtureBase {
    private static final Set<String> MANDATORY_INSPECTIONS = Set.of("Annotator");
    private static final Set<String> DISABLED_INSPECTIONS = Set.of("SpellCheckingInspection", "GrazieInspection", "GrazieStyle", "InconsistentLineSeparators", "ProblematicWhitespace", "LossyEncoding", "LongLine", "TodoComment", "OCClangCompiler", "OCClangAnalyzer", "IncorrectFormatting");
    private static final Set<String> PERF_ONLY_INSPECTIONS = Set.of("OCUnusedMethod", "OCUnusedGlobalDeclaration", "OCUnusedStruct", "OCUnusedClass", "OCUnusedInstanceVariable", "OCUnusedProperty", "OCUnusedMacro", "UnusedParameter", "HidingNonVirtualFunction", "InfiniteRecursion", "OCDFA", "OCNotReleasedIvar", "OCSimplify", "OCNotLocalizedString", "UnusedImportStatement", "OCUnusedIncludeDirective", "NotImplementedMethods", "ValueMayNotFitIntoReceiver");
    private boolean isPrepareProjectCalled;
    private final boolean isPerformanceTest;
    private final TestCase myTestCase;
    private final String myProjectDisplayName;
    private final String myRelativeProjectPath;
    private final String myPathToCopy;
    private boolean myUseAsFewInspectionsAsPossible;
    @NotNull
    private final CidrTestDataFixture myTestDataFixture;
    @NotNull
    private final CidrProjectFixture<?> myProjectFixture;
    static CidrRegressionTest.Chain ourCurrentTestChain = null;

    public void setUseAsFewInspectionsAsPossible(boolean useAsFewInspectionsAsPossible) {
        this.myUseAsFewInspectionsAsPossible = useAsFewInspectionsAsPossible;
    }

    public static void main(String[] args) throws Exception {
        String project = "Cocos2D";
        String testName = "testInspections";
        String date = "...";
        boolean showFullResults = true;
    }

    public CidrRegressionFixture(boolean isPerformanceTest, TestCase testCase, String projectDisplayName, String relativeProjectPath, String pathToCopy, @NotNull CidrTestDataFixture testDataFixture, @NotNull CidrProjectFixture<?> projectFixture2) {
        if (testDataFixture == null) {
            CidrRegressionFixture.$$$reportNull$$$0(0);
        }
        if (projectFixture2 == null) {
            CidrRegressionFixture.$$$reportNull$$$0(1);
        }
        this.myUseAsFewInspectionsAsPossible = false;
        this.isPerformanceTest = isPerformanceTest;
        this.myTestCase = testCase;
        this.myProjectDisplayName = projectDisplayName;
        this.myRelativeProjectPath = relativeProjectPath;
        this.myPathToCopy = pathToCopy;
        this.myTestDataFixture = testDataFixture;
        this.myProjectFixture = projectFixture2;
    }

    public CidrRegressionFixture(boolean isPerformanceTest, TestCase testCase, ProjectDescription projectDescription, @NotNull CidrTestDataFixture testDataFixture, @NotNull CidrProjectFixture<?> projectFixture2) {
        if (testDataFixture == null) {
            CidrRegressionFixture.$$$reportNull$$$0(2);
        }
        if (projectFixture2 == null) {
            CidrRegressionFixture.$$$reportNull$$$0(3);
        }
        this(isPerformanceTest, testCase, projectDescription.projectName, projectDescription.projectFile, projectDescription.projectBundle, testDataFixture, projectFixture2);
    }

    public void setUp() {
        ApplicationManagerEx.setInStressTest((boolean)true);
        Disposer.register((Disposable)this.myProjectFixture.getTestRootDisposable(), () -> ApplicationManagerEx.setInStressTest((boolean)false));
    }

    @NotNull
    protected Project getProject() {
        Project project = this.myProjectFixture.getProject();
        if (project == null) {
            CidrRegressionFixture.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    public final CidrRegressionFixtureBase.CurveOnChart curveOnChart(@NotNull String chartName) {
        if (chartName == null) {
            CidrRegressionFixture.$$$reportNull$$$0(5);
        }
        CidrRegressionFixtureBase.CurveOnChart curveOnChart = CidrRegressionFixtureBase.curveOnChart(chartName, this.myProjectDisplayName);
        if (curveOnChart == null) {
            CidrRegressionFixture.$$$reportNull$$$0(6);
        }
        return curveOnChart;
    }

    @Override
    public double testPerformance(boolean forceFullGCAndMeasureMemoryUsage, CidrRegressionFixtureBase.CurveOnChart curveOnChart, ThrowableRunnable<? extends Exception> runnable) throws Exception {
        if (!this.isPerformanceTest) {
            runnable.run();
            return 0.0;
        }
        return super.testPerformance(forceFullGCAndMeasureMemoryUsage, curveOnChart, runnable);
    }

    @Override
    @NotNull
    protected File getDefaultPublishFolder() {
        File file = this.myTestDataFixture.getTestDataFile("results");
        if (file == null) {
            CidrRegressionFixture.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    private File getExpectedInspectionsResultsDir() {
        return CidrRegressionFixture.getExpectedInspectionsResultsDir(this.getProject().getName());
    }

    @NotNull
    private static File getExpectedInspectionsResultsDir(String projectName) {
        List parts = StringUtil.split((String)projectName, (String)"-");
        String path = "inspections-" + StringUtil.join((Collection)parts, (String)File.separator);
        File file = CidrTestDataFixture.getRegressionTestData().resolve(path).toFile();
        if (file == null) {
            CidrRegressionFixture.$$$reportNull$$$0(8);
        }
        return file;
    }

    public void prepareProject() throws Exception {
        this.prepareProject(true);
    }

    public void prepareProject(boolean openProject2) throws Exception {
        Assert.assertFalse((String)"prepareProject() should only be called once in a test", (boolean)this.isPrepareProjectCalled);
        AppCodeModuleErrorsTestChecker.INSTANCE.disable(this.myProjectFixture.getTestRootDisposable());
        this.isPrepareProjectCalled = true;
        CidrRegressionTest info = this.getRegressionInfo();
        CidrRegressionTest.Chain testChain = info.value();
        if (ourCurrentTestChain != testChain || !this.myProjectFixture.isProjectAlreadyOpened(this.myRelativeProjectPath, this.myPathToCopy)) {
            switch (testChain) {
                case INITIAL: {
                    this.myProjectFixture.closeProjectAndCleanup();
                    OCTestUtil.setupSerialization(this.myProjectFixture, false, true);
                    this.myProjectFixture.initProject(new CidrTestProjectDescription(this.myRelativeProjectPath, this.myPathToCopy, openProject2));
                    break;
                }
                case AFTER_REOPENING: {
                    this.myProjectFixture.initProject(new CidrTestProjectDescription(this.myRelativeProjectPath, this.myPathToCopy, true));
                    this.myProjectFixture.saveAndCloseProject();
                    if (!openProject2) break;
                    this.myProjectFixture.openProject(true);
                    break;
                }
                default: {
                    Assert.fail((String)("Unexpected chain: " + String.valueOf((Object)testChain)));
                }
            }
            ourCurrentTestChain = testChain;
        } else {
            Assert.assertNotSame((String)"Incorrect order of test, probably @RunWith is not set", (Object)((Object)CidrRegressionTest.Order.FIRST), (Object)((Object)info.order()));
            this.myProjectFixture.initProject(new CidrTestProjectDescription(this.myRelativeProjectPath, this.myPathToCopy, openProject2));
        }
    }

    @NotNull
    public CidrRegressionTest getRegressionInfo() {
        CidrRegressionTest order = CidrRegressionRunner.getAnnotation(this.myTestCase);
        Assert.assertNotNull((String)("Test is not annotated: " + String.valueOf(this.myTestCase)), (Object)order);
        CidrRegressionTest cidrRegressionTest = order;
        if (cidrRegressionTest == null) {
            CidrRegressionFixture.$$$reportNull$$$0(9);
        }
        return cidrRegressionTest;
    }

    public void testInitialOpening() throws Exception {
        this.prepareProject(false);
        CidrRegressionFixture.runWithProgress("Opening project...", () -> this.testPerformance(this.curveOnChart("Initial Project Opening"), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> this.myProjectFixture.openProject())));
    }

    public void testReopening() throws Exception {
        this.prepareProject(false);
        CidrRegressionFixture.runWithProgress("Reopening project...", () -> this.testPerformance(this.curveOnChart("Project Reopening"), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> this.myProjectFixture.openProject(true))));
    }

    public void testRebuildingIndices() throws Exception {
        this.prepareProject();
        CidrRegressionFixture.runWithProgress("Rebuilding indices...", () -> this.testPerformance(this.curveOnChart("Rebuilding Indices"), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> OCSymbolTablesBuildingActivity.getInstance((Project)this.getProject()).rebuildSymbols())));
    }

    public void testProcessingAllSymbols() throws Exception {
        this.prepareProject();
        CidrRegressionFixture.runWithProgress("Processing symbols...", () -> this.testPerformance(this.curveOnChart("Processing Symbols"), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> ApplicationManager.getApplication().runReadAction(() -> {
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols((Project)this.getProject(), (Processor)CommonProcessors.alwaysTrue(), null, (boolean)false);
            for (VirtualFile eachProjectFile : OCSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)this.getProject())) {
                PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(eachProjectFile);
                if (!(psiFile instanceof OCFile)) continue;
                OCFileGlobalSymbolsCache.processFile((PsiFile)psiFile, symbol -> true, null);
            }
        }))));
    }

    public void testRainbowHighlighting(@NotNull RainbowVisitor rainbowVisitor, @Nullable String fileToHighlight) throws Exception {
        VirtualFile vFile;
        if (rainbowVisitor == null) {
            CidrRegressionFixture.$$$reportNull$$$0(10);
        }
        CidrRegressionFixture.runWithProgress("Opening project...", () -> this.prepareProject());
        if (fileToHighlight != null) {
            VirtualFile file = FileUtil.isAbsolute((String)fileToHighlight) ? LocalFileSystem.getInstance().findFileByPath(fileToHighlight) : this.myProjectFixture.findProjectSubFile(fileToHighlight);
            Assert.assertNotNull((String)("file not found: " + fileToHighlight), (Object)file);
            vFile = file;
        } else {
            vFile = null;
        }
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.runWriteAction(() -> PsiManager.getInstance((Project)this.getProject()).dropPsiCaches()));
        CidrRegressionFixture.runWithProgress("Highlighting...", () -> this.testPerformance(CidrRegressionFixtureBase.curveOnChart("Rainbow Highlighting", this.myProjectDisplayName + (String)(vFile != null ? "/" + vFile.getName() : "")), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> application.runReadAction(() -> {
            if (vFile != null) {
                this.rainbowProcessor(rainbowVisitor, vFile);
            } else {
                for (VirtualFile eachProjectFile : OCSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)this.getProject())) {
                    this.rainbowProcessor(rainbowVisitor, eachProjectFile);
                }
            }
        }))));
    }

    protected void rainbowProcessor(@NotNull RainbowVisitor rainbowVisitor, @NotNull VirtualFile vFile) {
        PsiFile file;
        if (rainbowVisitor == null) {
            CidrRegressionFixture.$$$reportNull$$$0(11);
        }
        if (vFile == null) {
            CidrRegressionFixture.$$$reportNull$$$0(12);
        }
        if (rainbowVisitor.suitableForFile(file = PsiManager.getInstance((Project)this.getProject()).findFile(vFile))) {
            HighlightInfoHolder infoHolder = new HighlightInfoHolder(file, new HighlightInfoFilter[0]);
            rainbowVisitor.analyze(file, true, infoHolder, () -> PsiTreeUtil.processElements((PsiElement)file, element -> {
                rainbowVisitor.visit(element);
                return true;
            }));
        }
    }

    public void testSymbolsPresentation() throws Exception {
        this.prepareProject();
        CidrTestCase.waitForResolve(this.getProject());
        ArrayList symbols = new ArrayList();
        CidrRegressionFixture.runWithProgress("Processing symbols...", () -> OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols((Project)this.getProject(), symbol -> {
            symbols.add(symbol);
            return true;
        }, null, (boolean)false));
        CidrRegressionFixture.runWithProgress("Computing presentations...", () -> this.testPerformance(this.curveOnChart("Symbol Presentations"), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> ApplicationManager.getApplication().runReadAction(() -> {
            for (OCSymbol symbol : symbols) {
                symbol.getBaseIcon();
                symbol.getPresentableName();
                symbol.getLocationString();
            }
        }))));
        CidrRegressionFixture.runWithProgress("Computing presentations...", () -> this.testPerformance(this.curveOnChart("Full Icons computation"), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> ApplicationManager.getApplication().runReadAction(() -> {
            for (OCSymbol symbol : symbols) {
                symbol.computeFullIconNow(null, this.getProject());
            }
        }))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResponsivenessDuringIndexing() throws Exception {
        for (Field each : OCElementTypes.class.getDeclaredFields()) {
            each.setAccessible(true);
            each.get(OCElementTypes.class);
        }
        Pair<Supplier<@NotNull ProgressIndicator>, ResponsivenessResult> checker = CidrRegressionFixture.createResponsivenessChecker();
        OCSymbolTableBuildingUtil.setIndicatorFactory((Supplier)((Supplier)checker.first));
        try {
            this.myProjectFixture.closeProjectAndCleanup();
            ProgressManagerImpl.__testWhileAlwaysCheckingCanceled(() -> {
                try {
                    this.prepareProject();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        finally {
            OCSymbolTableBuildingUtil.setIndicatorFactory(null);
        }
        ((ResponsivenessResult)checker.second).check(this, "Responsiveness During Indexing");
    }

    public void testResponsivenessDuringInspections() throws Exception {
        this.prepareProject();
        Pair<Supplier<@NotNull ProgressIndicator>, ResponsivenessResult> checker = CidrRegressionFixture.createResponsivenessChecker();
        this.runInspections(null, runnable -> ProgressManagerImpl.__testWhileAlwaysCheckingCanceled(() -> ProgressManager.getInstance().runProcess(() -> {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }, (ProgressIndicator)((Supplier)checker.first).get())));
        ((ResponsivenessResult)checker.second).check(this, "Responsiveness During Inspections");
    }

    private static void updateCheckStatus(boolean isStartingUp, ConcurrentMap<Long, CheckStatus> perThreadStatus, ThreadMXBean bean, ResponsivenessResult result) {
        long id = Thread.currentThread().getId();
        CheckStatus status = (CheckStatus)perThreadStatus.get(id);
        if (!isStartingUp && status != null && !((CheckStatus)perThreadStatus.get((Object)Long.valueOf((long)id))).timesShouldBeUpdated) {
            return;
        }
        long now = bean.getCurrentThreadUserTime() / 1000000L;
        if (!isStartingUp && status != null) {
            result.updateMaxDelay(now - status.lastCanceled);
        }
        status = new CheckStatus();
        status.lastCanceled = status.lastProbed = now;
        status.timesShouldBeUpdated = false;
        perThreadStatus.put(id, status);
    }

    private static Runnable createCheckRunnable(ConcurrentMap<Long, CheckStatus> perThreadStatus, ThreadMXBean bean, ResponsivenessResult result) {
        return () -> {
            block3: for (Map.Entry each : perThreadStatus.entrySet()) {
                long id = (Long)each.getKey();
                CheckStatus status = (CheckStatus)each.getValue();
                long now = bean.getThreadUserTime(id) / 1000000L;
                long delay2 = now - status.lastCanceled;
                long probeInterval = now - status.lastProbed;
                status.timesShouldBeUpdated = true;
                if (delay2 < 300L || probeInterval < 100L) continue;
                status.lastProbed = now;
                status.probes.incrementAndGet();
                ThreadInfo info = bean.getThreadInfo(id, 100);
                for (StackTraceElement eachFrame : info.getStackTrace()) {
                    if (!eachFrame.toString().contains("SchedulingWrapper$MyScheduledFutureTask")) continue;
                    StringBuilder builder = new StringBuilder();
                    CidrRegressionFixture.printStackTrace(info, builder);
                    System.out.println("Skipping scheduled task stack:\n" + String.valueOf(builder));
                    continue block3;
                }
                MultiMap<Long, ResponsivenessResult.DelayInfo> multiMap = result.blockingInfos;
                synchronized (multiMap) {
                    System.out.println("Thread: " + id + " probe " + String.valueOf(status.probes) + " in " + probeInterval + " total delay " + delay2);
                    result.blockingInfos.putValue((Object)id, (Object)new ResponsivenessResult.DelayInfo(status.probes.get(), now - status.lastCanceled, info));
                }
            }
        };
    }

    private static Pair<Supplier<@NotNull ProgressIndicator>, ResponsivenessResult> createResponsivenessChecker() {
        final ResponsivenessResult result = new ResponsivenessResult();
        final ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        final ConcurrentHashMap<Long, CheckStatus> perThreadStatus = new ConcurrentHashMap<Long, CheckStatus>();
        final Runnable checkRunnable = CidrRegressionFixture.createCheckRunnable(perThreadStatus, bean, result);
        Supplier<@NotNull ProgressIndicator> producer = new Supplier<ProgressIndicator>(){
            private final Object myLock = new Object();
            private int myStartedIndicators = 0;
            private ScheduledFuture<?> checkCanceledFuture;

            @Override
            @NotNull
            public ProgressIndicator get() {
                return new CidrRegressionProgressIndicatorBase(){

                    public void cancel() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void start() {
                        super.start();
                        CidrRegressionFixture.updateCheckStatus(true, perThreadStatus, bean, result);
                        Object object = myLock;
                        synchronized (object) {
                            if (myStartedIndicators++ == 0) {
                                checkCanceledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(checkRunnable, 50L, 50L, TimeUnit.MILLISECONDS);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void stop() {
                        super.stop();
                        CidrRegressionFixture.updateCheckStatus(false, perThreadStatus, bean, result);
                        Object object = myLock;
                        synchronized (object) {
                            if (--myStartedIndicators == 0) {
                                checkCanceledFuture.cancel(false);
                                checkRunnable.run();
                            }
                        }
                        perThreadStatus.remove(Thread.currentThread().getId());
                    }

                    public boolean isCanceled() {
                        CidrRegressionFixture.updateCheckStatus(false, perThreadStatus, bean, result);
                        return super.isCanceled();
                    }
                };
            }
        };
        return Pair.create((Object)producer, (Object)result);
    }

    public void testHighlightingFile(@NotNull String fileToHighlight) throws Exception {
        if (fileToHighlight == null) {
            CidrRegressionFixture.$$$reportNull$$$0(13);
        }
        String title = "Highlighting";
        EdtTestUtil.runInEdtAndWait(() -> {
            CidrRegressionFixture.runWithProgress("Opening project...", () -> this.prepareProject());
            CidrRegressionFixture.runWithProgress("Highlighting file...", () -> {
                VirtualFile file = FileUtil.isAbsolute((String)fileToHighlight) ? LocalFileSystem.getInstance().findFileByPath(fileToHighlight) : this.myProjectFixture.findProjectSubFile(fileToHighlight);
                Assert.assertNotNull((String)("file not found: " + fileToHighlight), (Object)file);
                CidrRegressionFixtureBase.CurveOnChart curveOnChart = CidrRegressionFixtureBase.curveOnChart("Highlighting" + (this.getRegressionInfo().value() == CidrRegressionTest.Chain.AFTER_REOPENING ? " After Reopening" : ""), this.myProjectDisplayName + "/" + file.getName());
                this.testPerformance(curveOnChart, (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> {
                    FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.getProject());
                    Editor editor2 = fileEditorManager.openTextEditor(new OpenFileDescriptor(this.getProject(), file, 0), false);
                    PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                    PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(editor2.getDocument());
                    TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor2);
                    try {
                        CodeInsightTestFixtureImpl.instantiateAndRun(psiFile, editor2, new int[0], false);
                    }
                    finally {
                        TextEditorProvider.getInstance().disposeEditor((FileEditor)textEditor);
                        fileEditorManager.closeFile(file);
                        ((FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileClosed(fileEditorManager, file);
                    }
                }));
            });
        });
    }

    private static void printStackTrace(ThreadInfo info, StringBuilder builder) {
        for (StackTraceElement eachFrame : info.getStackTrace()) {
            builder.append("  at ").append(eachFrame.toString()).append("\n");
        }
    }

    public void testInspections() throws Exception {
        this.testInspections(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInspections(@Nullable Runnable beforeRunRunnable) throws Exception {
        Path[] output = new Path[]{null};
        try {
            CidrRegressionFixture.runWithProgress("Opening project...", () -> this.prepareProject());
            output[0] = this.myTestDataFixture.createTempIODir().toPath();
            Assert.assertTrue((String)("can't create results dir: " + String.valueOf(output[0])), (boolean)FileUtil.createDirectory((File)output[0].toFile()));
            AssertionFailedError performanceAssertion = null;
            CidrRegressionFixtureBase.CurveOnChart curveOnChart = this.curveOnChart(this.getRegressionInfo().value() == CidrRegressionTest.Chain.AFTER_REOPENING ? "Inspections After Reopening" : "Inspections");
            try {
                this.runInspections(output[0], runnable -> {
                    if (beforeRunRunnable != null) {
                        beforeRunRunnable.run();
                    }
                    this.testPerformance(curveOnChart, (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> CidrRegressionFixture.runWithProgress(InspectionsBundle.message((String)"inspection.display.name", (Object[])new Object[0]), runnable)));
                });
            }
            catch (AssertionFailedError e) {
                performanceAssertion = e;
            }
            CidrRegressionFixture.convertInspectionsResults(output[0]);
            try {
                if (!this.isPerformanceTest) {
                    this.compareInspectionsResults(output[0], performanceAssertion);
                }
            }
            catch (AssertionFailedError e) {
                if (performanceAssertion != null) {
                    performanceAssertion.printStackTrace();
                }
                throw e;
            }
            finally {
                if (!this.isPerformanceTest) {
                    this.publish(output[0].toFile(), CidrRegressionFixtureBase.generateResultName(curveOnChart));
                }
            }
            if (performanceAssertion != null) {
                throw performanceAssertion;
            }
        }
        finally {
            if (output[0] != null) {
                FileUtil.delete((Path)output[0]);
            }
        }
    }

    public void testBuildingModuleMaps() throws Exception {
        Disposable disposable = Disposer.newDisposable();
        try {
            ModuleMapCache.disableModuleCacheBuilding((Disposable)disposable);
            CidrRegressionFixture.runWithProgress("Opening project...", this::prepareProject);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        CidrRegressionFixtureBase.CurveOnChart curveOnChart = this.curveOnChart(this.getRegressionInfo().value() == CidrRegressionTest.Chain.AFTER_REOPENING ? "Module Maps Building After Reopening" : "Module Maps Building");
        try {
            ModuleMapCache.setShouldReloadCache((Boolean)(this.getRegressionInfo().value() == CidrRegressionTest.Chain.AFTER_REOPENING ? 1 : 0));
            ModuleMapCache.getInstance((Project)this.getProject()).reset();
            CidrRegressionFixture.runWithProgress("Building module maps...", () -> this.testPerformance(curveOnChart, (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> OCModuleMapBuildingActivity.rebuildModuleMaps((Project)this.getProject()))));
        }
        finally {
            ModuleMapCache.setShouldReloadCache(null);
        }
    }

    public double testPerformance(CidrRegressionFixtureBase.CurveOnChart curveOnChart, ThrowableRunnable<? extends Exception> runnable) throws Exception {
        return this.testPerformance(true, curveOnChart, runnable);
    }

    private <T extends Throwable> void runInspections(@Nullable Path output, @NotNull ThrowableConsumer<ThrowableRunnable<T>, T> runner) throws Exception {
        if (runner == null) {
            CidrRegressionFixture.$$$reportNull$$$0(14);
        }
        boolean previousInitInspections = InspectionProfileImpl.INIT_INSPECTIONS;
        InspectionProfileImpl.INIT_INSPECTIONS = true;
        try {
            InspectionManagerEx im = (InspectionManagerEx)InspectionManager.getInstance((Project)this.getProject());
            GlobalInspectionContextImpl context2 = im.createNewGlobalContext();
            InspectionProfileImpl profile = new InspectionProfileImpl("Foo");
            for (InspectionToolWrapper entry : profile.getInspectionTools(null)) {
                String shortName = entry.getShortName();
                profile.setToolEnabled(shortName, this.isToolEnabled(entry.getTool(), shortName), this.getProject());
            }
            context2.setExternalProfile(profile);
            context2.initializeTools(new ArrayList(), new ArrayList(), new ArrayList());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    runner.consume(() -> {
                        AnalysisScope scope = new AnalysisScope(this.getProject(), (Collection)ReadAction.compute(() -> OCSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)this.getProject())));
                        boolean onlyGlobal = false;
                        if (output == null) {
                            context2.performInspectionsWithProgress(scope, onlyGlobal, false);
                        } else {
                            context2.performInspectionsWithProgressAndExportResults(scope, onlyGlobal, false, output, new ArrayList());
                        }
                    });
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }).get();
        }
        catch (Exception e) {
            ForkJoinPool pool = ForkJoinPool.commonPool();
            while (pool.getQueuedTaskCount() > 0L || pool.getRunningThreadCount() > 0) {
                PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            }
            throw e;
        }
        finally {
            InspectionProfileImpl.INIT_INSPECTIONS = previousInitInspections;
        }
    }

    private boolean isToolEnabled(InspectionProfileEntry tool, @NotNull String shortName) {
        if (shortName == null) {
            CidrRegressionFixture.$$$reportNull$$$0(15);
        }
        if (DISABLED_INSPECTIONS.contains(shortName)) {
            return false;
        }
        if (!this.isPerformanceTest && PERF_ONLY_INSPECTIONS.contains(shortName)) {
            return false;
        }
        if (tool instanceof OCHiddenInspection) {
            return true;
        }
        return !this.myUseAsFewInspectionsAsPossible || MANDATORY_INSPECTIONS.contains(shortName);
    }

    private void compareInspectionsResults(@NotNull Path produced, @Nullable AssertionFailedError performanceAssertion) throws Exception {
        if (produced == null) {
            CidrRegressionFixture.$$$reportNull$$$0(16);
        }
        CidrRegressionFixture.compareInspectionsResults(this.getExpectedInspectionsResultsDir(), produced, performanceAssertion);
    }

    private static void convertInspectionsResults(@NotNull Path dir) {
        if (dir == null) {
            CidrRegressionFixture.$$$reportNull$$$0(17);
        }
        Assert.assertTrue((String)("dir not found: " + String.valueOf(dir)), (boolean)Files.exists(dir, new LinkOption[0]));
        File[] files = dir.toFile().listFiles();
        Assert.assertNotNull((String)("no files in " + String.valueOf(dir)), (Object)files);
        Comparator<XmlProblemInfo> comparator = Comparator.comparing(XmlProblemInfo::getFile).thenComparingInt(o -> StringUtil.parseInt((String)o.getLine(), (int)0)).thenComparing(XmlProblemInfo::getSeverity).thenComparing(XmlProblemInfo::getDescription);
        LinkedHashMap categoriesWithInfos = new LinkedHashMap();
        for (File eachFile : files) {
            if (eachFile.isDirectory() || !StringUtil.endsWithIgnoreCase((String)eachFile.getName(), (String)".xml") || FileUtil.getNameWithoutExtension((File)eachFile).equals("ProjectFingerprint")) continue;
            Object category = FileUtilRt.getNameWithoutExtension((String)eachFile.getName());
            if (((String)category).startsWith("FakeIssue")) {
                category = "ClangAnalyzer";
            }
            if (!categoriesWithInfos.containsKey(category)) {
                categoriesWithInfos.put(category, new ArrayList());
            }
            ArrayList infos = (ArrayList)categoriesWithInfos.get(category);
            try {
                for (Element eachChild : JDOMUtil.load((Path)eachFile.toPath()).getChildren()) {
                    XmlProblemInfo problemInfo = new XmlProblemInfo((String)category, eachChild);
                    if (problemInfo.isIgnored()) continue;
                    infos.add(problemInfo);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("can't read " + String.valueOf(eachFile), e);
            }
            FileUtil.delete((File)eachFile);
        }
        for (Map.Entry entry : categoriesWithInfos.entrySet()) {
            ArrayList infos = (ArrayList)entry.getValue();
            if (infos.isEmpty()) continue;
            infos.sort(comparator);
            ArrayList<CallSite> strings = new ArrayList<CallSite>();
            for (XmlProblemInfo each : infos) {
                strings.add((CallSite)((Object)(each.getFile() + ":" + each.getLine() + ": " + each.getSeverity() + ": " + each.getDescription().replace('\n', ' '))));
            }
            Path result = dir.resolve((String)entry.getKey() + ".txt");
            PathKt.write((Path)result, (CharSequence)StringUtil.join(strings, (String)"\n"));
        }
    }

    private static void compareInspectionsResults(File expected, @NotNull Path produced, AssertionFailedError performanceAssertion) throws IOException {
        if (produced == null) {
            CidrRegressionFixture.$$$reportNull$$$0(18);
        }
        List<StringProblemInfo> reportedProblems = CidrRegressionFixture.loadProblems(produced.toFile());
        List<StringProblemInfo> expectedProblems = CidrRegressionFixture.loadProblems(expected);
        ArrayList<StringProblemInfo> unreportedProblems = new ArrayList<StringProblemInfo>(expectedProblems);
        ArrayList<StringProblemInfo> unexpectedProblems = new ArrayList<StringProblemInfo>(reportedProblems);
        unreportedProblems.removeAll(reportedProblems);
        unexpectedProblems.removeAll(expectedProblems);
        if (expectedProblems.isEmpty() && unreportedProblems.isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append("Expected problems: ").append(expectedProblems.size()).append("\n");
        message.append("Reported problems: ").append(reportedProblems.size()).append("\n");
        CidrRegressionFixture.calcCategories("Unreported problems: ", unreportedProblems, message);
        CidrRegressionFixture.calcCategories("Unexpected problems: ", unexpectedProblems, message);
        if (performanceAssertion != null) {
            message.append("\n\n").append((Object)performanceAssertion);
        }
        UsefulTestCase.assertOrderedEquals(message.toString(), reportedProblems, expectedProblems);
    }

    private static void calcCategories(String title, List<StringProblemInfo> problemsList, StringBuilder message) {
        message.append(title).append(problemsList.size()).append("\n");
        LinkedHashMap<String, Integer> categories = new LinkedHashMap<String, Integer>();
        for (StringProblemInfo stringProblemInfo : problemsList) {
            String category = stringProblemInfo.getCategory();
            if (categories.containsKey(category)) {
                categories.put(category, (Integer)categories.get(category) + 1);
                continue;
            }
            categories.put(category, 1);
        }
        for (String string : categories.keySet()) {
            message.append("  ").append(string).append(": ").append(categories.get(string)).append("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<StringProblemInfo> loadProblems(@NotNull File problemsDir) throws IOException {
        File zip;
        if (problemsDir == null) {
            CidrRegressionFixture.$$$reportNull$$$0(19);
        }
        if (!problemsDir.exists() && (zip = new File(problemsDir.getPath() + ".zip")).exists()) {
            problemsDir = zip;
        }
        Assert.assertTrue((String)("dir not found: " + String.valueOf(problemsDir)), (boolean)problemsDir.exists());
        boolean delete = false;
        if (StringUtil.endsWithIgnoreCase((String)problemsDir.getName(), (String)".zip")) {
            File tempDir2 = FileUtil.createTempDirectory((String)problemsDir.getName(), null, (boolean)true);
            ZipUtil.extract((File)problemsDir, (File)tempDir2, null);
            problemsDir = tempDir2;
            delete = true;
        }
        ArrayList<StringProblemInfo> result = new ArrayList<StringProblemInfo>();
        try {
            File[] files = problemsDir.listFiles();
            Assert.assertNotNull((String)("no files in " + String.valueOf(problemsDir)), (Object)files);
            Arrays.sort(files, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName())));
            for (File eachFile : files) {
                if (eachFile.isDirectory() || !StringUtil.endsWithIgnoreCase((String)eachFile.getName(), (String)".txt")) continue;
                List strings = FileUtil.loadLines((File)eachFile, (String)"UTF-8");
                result.addAll(ContainerUtil.map((Collection)strings, eachLine -> new StringProblemInfo(FileUtilRt.getNameWithoutExtension((String)eachFile.getName()), (String)eachLine)));
            }
        }
        finally {
            if (delete) {
                FileUtil.delete((File)problemsDir);
            }
        }
        return result;
    }

    public static <T extends Throwable> void runWithProgress(String title, ThrowableRunnable<T> process) throws T {
        MyDaemonProgressIndicator progress = new MyDaemonProgressIndicator(title);
        Ref rethrow = new Ref();
        ProgressManager.getInstance().runProcess(() -> {
            try {
                process.run();
            }
            catch (Throwable t) {
                rethrow.set((Object)t);
            }
        }, (ProgressIndicator)progress);
        if (!rethrow.isNull()) {
            throw (Throwable)rethrow.get();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFixture";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrRegressionFixture";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chartName";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rainbowVisitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToHighlight";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "produced";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrRegressionFixture";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "curveOnChart";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPublishFolder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedInspectionsResultsDir";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegressionInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "curveOnChart";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "testRainbowHighlighting";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "rainbowProcessor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "testHighlightingFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runInspections";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isToolEnabled";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "compareInspectionsResults";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertInspectionsResults";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadProblems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class ResponsivenessResult {
        final MultiMap<Long, DelayInfo> blockingInfos = new MultiMap();
        final AtomicLong maxDelay = new AtomicLong(-1L);

        private ResponsivenessResult() {
        }

        public void check(CidrRegressionFixture fixture, String chartName) {
            Assert.assertTrue((String)"checkCanceled or checkExpire was not called", (this.maxDelay.get() >= 0L ? 1 : 0) != 0);
            fixture.logTeamcityMessages(Pair.create((Object)fixture.curveOnChart(chartName).toString(), (Object)this.maxDelay));
            if (!this.blockingInfos.isEmpty()) {
                StringBuilder allDelays = new StringBuilder();
                StringBuilder probes = new StringBuilder("Probes:\n");
                long[] numberOfDelays = new long[]{0L};
                for (Long key : this.blockingInfos.keySet()) {
                    long[] currentDelay = new long[]{0L};
                    Runnable registerCurrentDelay = () -> {
                        if (currentDelay[0] != 0L) {
                            numberOfDelays[0] = numberOfDelays[0] + 1L;
                            allDelays.append("Block ").append(numberOfDelays[0]).append(": ").append(currentDelay[0]).append("ms.\n");
                        }
                    };
                    probes.append("\n").append("Thread ").append(key).append(":\n");
                    for (DelayInfo each : this.blockingInfos.get((Object)key)) {
                        if (each.probe == 1) {
                            registerCurrentDelay.run();
                        }
                        currentDelay[0] = each.delay;
                        probes.append("Probe ").append(each.probe).append(". Blocked for ").append(each.delay).append(" ms.\n");
                        CidrRegressionFixture.printStackTrace(each.threadInfo, probes);
                    }
                    registerCurrentDelay.run();
                }
                String message = numberOfDelays[0] + " blocks found across " + this.blockingInfos.size() + " threads. Longest block: " + String.valueOf(this.maxDelay) + "ms.\n" + String.valueOf(allDelays) + "\n" + String.valueOf(probes);
                Assert.fail((String)message);
            }
        }

        public void updateMaxDelay(long value2) {
            this.maxDelay.updateAndGet(operand -> Math.max(operand, value2));
        }

        private static class DelayInfo {
            final int probe;
            final long delay;
            final ThreadInfo threadInfo;

            DelayInfo(int probe, long delay2, ThreadInfo threadInfo) {
                this.probe = probe;
                this.delay = delay2;
                this.threadInfo = threadInfo;
            }
        }
    }

    private static class CheckStatus {
        volatile long lastCanceled;
        volatile long lastProbed;
        final AtomicInteger probes = new AtomicInteger();
        volatile boolean timesShouldBeUpdated;

        private CheckStatus() {
        }
    }

    static class XmlProblemInfo {
        private final String myCategory;
        private final String myFile;
        private final String myLine;
        private final String mySeverity;
        private final String myDescription;

        XmlProblemInfo(@NotNull String category, @NotNull Element element) {
            if (category == null) {
                XmlProblemInfo.$$$reportNull$$$0(0);
            }
            if (element == null) {
                XmlProblemInfo.$$$reportNull$$$0(1);
            }
            this.myCategory = category;
            this.myFile = StringUtil.trimStart((String)StringUtil.trimStart((String)element.getChildText("file"), (String)"file://"), (String)"$PROJECT_DIR$/");
            this.myLine = element.getChildText("line");
            Element problemClass = element.getChild("problem_class");
            this.mySeverity = problemClass != null ? problemClass.getAttributeValue("severity") : null;
            this.myDescription = element.getChildText("description");
        }

        public String getCategory() {
            return this.myCategory;
        }

        public String getLine() {
            return this.myLine;
        }

        public String getFile() {
            return this.myFile;
        }

        public String getSeverity() {
            return this.mySeverity;
        }

        public String getDescription() {
            return this.myDescription;
        }

        private boolean isIgnored() {
            return !OCFileTypeHelpers.isHeaderFile((String)this.getFile()) && !OCFileTypeHelpers.isSourceFile((String)this.getFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "category";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/CidrRegressionFixture$XmlProblemInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class StringProblemInfo {
        @NotNull
        final String myCategory;
        @NotNull
        final String myText;

        StringProblemInfo(@NotNull String category, @NotNull String text2) {
            if (category == null) {
                StringProblemInfo.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                StringProblemInfo.$$$reportNull$$$0(1);
            }
            this.myCategory = category;
            this.myText = text2;
        }

        @NotNull
        public String getCategory() {
            String string = this.myCategory;
            if (string == null) {
                StringProblemInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                StringProblemInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String toString() {
            return this.myCategory + " | " + this.myText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringProblemInfo info = (StringProblemInfo)o;
            if (!this.myText.equals(info.myText)) {
                return false;
            }
            return this.myCategory.equals(info.myCategory);
        }

        public int hashCode() {
            int result = this.myText.hashCode();
            result = 31 * result + this.myCategory.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/CidrRegressionFixture$StringProblemInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/CidrRegressionFixture$StringProblemInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCategory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyDaemonProgressIndicator
    extends CidrRegressionProgressIndicatorBase {
        private String myLastStatus = "";
        private final long myStartTime = System.currentTimeMillis();
        private final String myTitle;

        private MyDaemonProgressIndicator(String title) {
            this.myTitle = title;
        }

        public void setFraction(double fraction) {
            super.setFraction(fraction);
            this.update();
        }

        public void setText(String text2) {
            super.setText(text2);
            this.update();
        }

        private void update() {
            String status;
            if (this.isIndeterminate()) {
                status = this.myTitle + " " + this.getText();
            } else {
                int percent = (int)(this.getFraction() * 100.0);
                status = this.myTitle + " " + this.getText() + " " + percent + " %";
            }
            if (!status.equals(this.myLastStatus)) {
                System.out.format("%s (elapsed %ds)\n", status, (System.currentTimeMillis() - this.myStartTime) / 1000L);
                this.myLastStatus = status;
            }
        }
    }

    private static abstract class CidrRegressionProgressIndicatorBase
    extends AbstractProgressIndicatorExBase
    implements StandardProgressIndicator,
    ProgressIndicatorWithDelayedPresentation {
        private CidrRegressionProgressIndicatorBase() {
        }

        public void setDelayInMillis(int delayInMillis) {
        }
    }

    public static class ExpectedEqualToReportedTest
    extends TestCase {
        private static final String PREFIX = "Inspections___";
        private static final String SUFFIX = ".zip";

        @NotNull
        private String strip(@NotNull String name) {
            if (name == null) {
                ExpectedEqualToReportedTest.$$$reportNull$$$0(0);
            }
            String string = name.replaceAll("_", "").toLowerCase();
            if (string == null) {
                ExpectedEqualToReportedTest.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        private String findProjectResults(@NotNull String project, @NotNull Path dir) {
            File[] files;
            if (project == null) {
                ExpectedEqualToReportedTest.$$$reportNull$$$0(2);
            }
            if (dir == null) {
                ExpectedEqualToReportedTest.$$$reportNull$$$0(3);
            }
            for (File file : files = dir.toFile().listFiles((unused, name) -> name.startsWith(PREFIX) && name.endsWith(SUFFIX))) {
                String name2 = file.getName();
                if (!this.strip(name2).contains(this.strip(project))) continue;
                String string = name2;
                if (string == null) {
                    ExpectedEqualToReportedTest.$$$reportNull$$$0(4);
                }
                return string;
            }
            ExpectedEqualToReportedTest.fail((String)("file for project '" + project + "' not found in '" + String.valueOf(dir) + "'"));
            if (null == null) {
                ExpectedEqualToReportedTest.$$$reportNull$$$0(5);
            }
            return null;
        }

        public void _testCompareResults() throws Exception {
            String project = Project.cinder.name();
            Path dir = Paths.get("/Users/jetbrains/2del/we fix we regress we fix again", new String[0]);
            Path result = dir.resolve(this.findProjectResults(project, dir));
            CidrRegressionFixture.compareInspectionsResults(CidrRegressionFixture.getExpectedInspectionsResultsDir(project), result, null);
        }

        public void _testConvertResults() throws Exception {
            CidrRegressionFixture.convertInspectionsResults(Paths.get("/Users/anton/Work/IDEA/trunk/CIDR/regression-testData/inspections-cinder", new String[0]));
            CidrRegressionFixture.convertInspectionsResults(Paths.get("/Users/anton/Work/IDEA/trunk/CIDR/regression-testData/inspections-cocos2d", new String[0]));
            CidrRegressionFixture.convertInspectionsResults(Paths.get("/Users/anton/Work/IDEA/trunk/CIDR/regression-testData/inspections-Crypto", new String[0]));
            CidrRegressionFixture.convertInspectionsResults(Paths.get("/Users/anton/Work/IDEA/trunk/CIDR/regression-testData/inspections-LabSound", new String[0]));
            CidrRegressionFixture.convertInspectionsResults(Paths.get("/Users/anton/Work/IDEA/trunk/CIDR/regression-testData/inspections-LLDB", new String[0]));
            CidrRegressionFixture.convertInspectionsResults(Paths.get("/Users/anton/Work/IDEA/trunk/CIDR/regression-testData/inspections-ReactiveCocoa", new String[0]));
            CidrRegressionFixture.convertInspectionsResults(Paths.get("/Users/anton/Work/IDEA/trunk/CIDR/regression-testData/inspections-RestKit", new String[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/CidrRegressionFixture$ExpectedEqualToReportedTest";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/CidrRegressionFixture$ExpectedEqualToReportedTest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "strip";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findProjectResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "strip";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findProjectResults";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4, 5 -> new IllegalStateException(string);
            };
        }

        private static enum Project {
            cinder,
            cocos2d,
            RestKit,
            Crypto,
            LabSound,
            ReactiveCocoa,
            LLDB;

        }
    }
}

