/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.UsefulTestCase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CidrProjectMarkup {
    private static final List<String> SUPPORTED_EXTENSIONS = Arrays.asList("c", "cpp", "m", "mm", "h", "strings", "storyboard", "swift", "asm", "s", "S", "kt", "ixx", "txt", "rs");
    private final boolean myProcessAllFiles;
    public final Map<String, Integer> OFFSETS;

    public CidrProjectMarkup(@NotNull VirtualFile testProjectRoot, boolean processAllFiles) {
        if (testProjectRoot == null) {
            CidrProjectMarkup.$$$reportNull$$$0(0);
        }
        this.OFFSETS = new HashMap<String, Integer>();
        this.myProcessAllFiles = processAllFiles;
        VfsUtilCore.processFilesRecursively((VirtualFile)testProjectRoot, file -> {
            try {
                this.processFile((VirtualFile)file);
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.assertAllFieldsSetup();
    }

    private void processFile(VirtualFile file) throws Exception {
        String name;
        if (file.isDirectory() || file.getFileType().isBinary() || !SUPPORTED_EXTENSIONS.contains(file.getExtension())) {
            return;
        }
        CharSequence text2 = LoadTextUtil.loadText((VirtualFile)file);
        String[] lines2 = LineTokenizer.tokenize((CharSequence)text2, (boolean)true);
        if (lines2.length == 0) {
            return;
        }
        Field[] fields = this.getClass().getDeclaredFields();
        boolean toProcess = false;
        for (Field eachField : fields) {
            eachField.setAccessible(true);
            name = eachField.getName();
            if (!name.startsWith("FILE_") || eachField.get(this) != null || !lines2[0].contains(name)) continue;
            eachField.set(this, file);
            toProcess = true;
            break;
        }
        if (!toProcess && !this.myProcessAllFiles) {
            return;
        }
        block1: for (Field eachField : fields) {
            eachField.setAccessible(true);
            name = eachField.getName();
            if (!name.startsWith("LINE_") || eachField.getInt(this) != 0) continue;
            Pattern pattern = Pattern.compile("\\b" + name + "\\b");
            int length = lines2.length;
            for (int i = 0; i < length; ++i) {
                String eachLine = lines2[i];
                if (!pattern.matcher(eachLine).find()) continue;
                eachField.setInt(this, i);
                continue block1;
            }
        }
        Matcher m = Pattern.compile("(<!--|/\\*)offset:(\\w*)(\\+(\\d*))?(-->|\\*/)").matcher(text2);
        while (m.find()) {
            String label = m.group(2);
            int offset = m.end();
            String shiftStr = m.group(4);
            if (shiftStr != null) {
                offset += Integer.parseInt(shiftStr);
            }
            this.OFFSETS.put(label, offset);
        }
    }

    private void assertAllFieldsSetup() {
        ArrayList<String> notSet = new ArrayList<String>();
        for (Field each : this.getClass().getDeclaredFields()) {
            each.setAccessible(true);
            String name = each.getName();
            try {
                if (name.startsWith("FILE_") && each.get(this) == null) {
                    notSet.add(name);
                }
                if (!name.startsWith("LINE_") || each.getInt(this) != 0) continue;
                notSet.add(name);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        UsefulTestCase.assertEmpty(notSet);
    }

    public void deleteOffsetComment(@NotNull PsiFile file, String ... keys) {
        if (file == null) {
            CidrProjectMarkup.$$$reportNull$$$0(1);
        }
        if (keys == null) {
            CidrProjectMarkup.$$$reportNull$$$0(2);
        }
        int diff = 0;
        for (String key : keys) {
            int keySourceOffset = this.OFFSETS.get(key) - diff;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
            Document document = documentManager.getDocument(file);
            int newOffset = keySourceOffset - key.length() - "/*offset:*/".length();
            WriteCommandAction.runWriteCommandAction((Project)file.getProject(), () -> {
                document.replaceString(newOffset, keySourceOffset, (CharSequence)"");
                documentManager.commitDocument(document);
            });
            this.OFFSETS.put(key, newOffset);
            diff += keySourceOffset - newOffset;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProjectRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/CidrProjectMarkup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteOffsetComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

