/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.StartupActivityTestUtil;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.common.ThreadUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.EDT;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.jetbrains.cidr.CidrProjectDependentFixtureBase;
import com.jetbrains.cidr.CidrProjectFixtureCustomizer;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.CidrTestUtils;
import com.jetbrains.cidr.WaitUtilKt;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceListener;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceState;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import com.jetbrains.cidr.project.workspace.OCWorkspaceModelRootsBuilder;
import com.jetbrains.cidr.util.InitializationWaiter;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.junit.Assert;

public abstract class CidrProjectFixture<BUILD_CONFIGURATION_TYPE>
extends Assert
implements CidrProjectDependentFixtureBase {
    private static final Logger LOG = Logger.getInstance((String)("#" + CidrProjectFixture.class.getPackage().getName()));
    private static final Key<Set<String>> BUILT_CONFIGURATIONS = Key.create((String)"BUILT_CONFIGURATIONS");
    private SdkLeakTracker myOldSdks;
    @NotNull
    protected final CidrTestDataFixture myTestDataFixture;
    private CleanProjectOption myCleanProjectOption;
    private static volatile Runnable ourProjectCleanup;
    private static volatile boolean ourRunningFixture;
    private static volatile ProjectInfo ourProjectInfo;
    private static volatile ThrowableConsumer<Project, Throwable> ourCloseProjectRunnable;
    private static final List<ThrowableRunnable<Throwable>> ourAdditionalProjectCleanUpRunnableList;
    private static final Map<ProjectTestData, ProjectTiming> ourProjectTimingMap;
    private static volatile VirtualFile ourTestRoot;
    private static volatile File ourTestRootFile;
    private static volatile VirtualFile ourProjectDir;
    private static volatile VirtualFile ourProjectFile;
    private static volatile Project ourProject;
    private static volatile boolean ourTestFilesChanged;
    private static volatile BulkFileListener ourTestFilesListener;
    private static volatile VirtualFilePointerTracker ourVirtualFilePointerTracker;
    private boolean myInitProjectHasBeenCalled;
    private boolean myOpenProjectHasBeenCalledOnce;
    private Disposable myProjectDisposable;
    private String myCurrentTestClassFQN;
    protected String myCurrentTestName;
    protected final LinkedHashMap<CidrProjectDependentFixtureBase, String> myDependentFixtures;
    @NotNull
    protected OpenProjectTask openProjectOptions;
    @Nullable
    protected CidrProjectFixtureCustomizer myCustomizer;
    public static final int NOT_IN_SCOPE = 0;
    public static final int IN_PROJECT = 1;
    public static final int IN_CONTENT = 3;
    public static final int IN_CONTENT_SOURCES = 4;
    public static final int IN_LIBRARIES = 8;
    public static final int IN_CONTENT_SOURCES_GENERATED = 16;
    public static final int IN_CONTENT_AND_LIBRARIES = 10;

    public void setOpenProjectOptions(@NotNull OpenProjectTask openProjectOptions) {
        if (openProjectOptions == null) {
            CidrProjectFixture.$$$reportNull$$$0(0);
        }
        this.openProjectOptions = openProjectOptions;
    }

    public CidrProjectFixture(@NotNull CidrTestDataFixture testDataFixture) {
        if (testDataFixture == null) {
            CidrProjectFixture.$$$reportNull$$$0(1);
        }
        this.myCleanProjectOption = CleanProjectOption.DO_NOT_CLEAN;
        this.myInitProjectHasBeenCalled = false;
        this.myOpenProjectHasBeenCalledOnce = false;
        this.myDependentFixtures = new LinkedHashMap();
        this.openProjectOptions = OpenProjectTask.build();
        this.myCustomizer = null;
        this.myTestDataFixture = testDataFixture;
    }

    public void setCleanProjectOption(@NotNull CleanProjectOption option) {
        if (option == null) {
            CidrProjectFixture.$$$reportNull$$$0(2);
        }
        this.myCleanProjectOption = option;
    }

    public void setCustomizer(@NotNull CidrProjectFixtureCustomizer customizer) {
        if (customizer == null) {
            CidrProjectFixture.$$$reportNull$$$0(3);
        }
        this.myCustomizer = customizer;
    }

    @NotNull
    public CidrProjectFixtureCustomizer getCustomizer() {
        CidrProjectFixture.assertNotNull((String)"Customizer is not yet initialized", (Object)this.myCustomizer);
        CidrProjectFixtureCustomizer cidrProjectFixtureCustomizer = this.myCustomizer;
        if (cidrProjectFixtureCustomizer == null) {
            CidrProjectFixture.$$$reportNull$$$0(4);
        }
        return cidrProjectFixtureCustomizer;
    }

    public Collection<CidrProjectDependentFixtureBase> getDependentFixture() {
        return this.myDependentFixtures.keySet();
    }

    public void setUp(@NotNull String testClassFQN, @NotNull String testName) throws Exception {
        if (testClassFQN == null) {
            CidrProjectFixture.$$$reportNull$$$0(5);
        }
        if (testName == null) {
            CidrProjectFixture.$$$reportNull$$$0(6);
        }
        this.myCustomizer.preSetUp();
        ourRunningFixture = true;
        try {
            this.myProjectDisposable = Disposer.newDisposable();
            this.myCurrentTestClassFQN = testClassFQN;
            this.myCurrentTestName = testName;
            this.myDependentFixtures.remove(this);
            if (!this.myDependentFixtures.isEmpty()) {
                LOG.warn("some of dependent fixtures were not removed by previous test: ");
                for (Map.Entry<CidrProjectDependentFixtureBase, String> entry : this.myDependentFixtures.entrySet()) {
                    LOG.warn("  " + entry.getValue() + " => " + String.valueOf(entry.getKey()));
                }
                this.myDependentFixtures.clear();
            }
            this.addProjectDependentFixture(this);
            this.myOldSdks = new SdkLeakTracker();
        }
        catch (Exception e) {
            ourRunningFixture = false;
            throw e;
        }
    }

    public void tearDown() throws Exception {
        try {
            this.myCustomizer.preTearDown();
        }
        finally {
            ourRunningFixture = false;
            EdtTestUtil.runInEdtAndWait(() -> Disposer.dispose((Disposable)this.myProjectDisposable));
            if (this.myCleanProjectOption == CleanProjectOption.CLEAN_EACH_TIME) {
                this.closeProjectAndCleanup();
            }
            WriteAction.runAndWait(() -> ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).dropAllUnsavedDocuments());
        }
    }

    public void collectAllowedRoots(@NotNull List<? super String> result) {
        if (result == null) {
            CidrProjectFixture.$$$reportNull$$$0(7);
        }
    }

    public void addProjectDependentFixture(@NotNull CidrProjectDependentFixtureBase fixture) throws Exception {
        if (fixture == null) {
            CidrProjectFixture.$$$reportNull$$$0(8);
        }
        CidrProjectFixture.assertNull((String)"dependent fixture already registered", (Object)this.myDependentFixtures.put(fixture, this.myCurrentTestName));
        if (this.myInitProjectHasBeenCalled && ourProject != null) {
            fixture.afterProjectOpened();
        }
    }

    public void removeProjectDependentFixture(@NotNull CidrProjectDependentFixtureBase fixture) throws Exception {
        if (fixture == null) {
            CidrProjectFixture.$$$reportNull$$$0(9);
        }
        if (this.myInitProjectHasBeenCalled && ourProject != null) {
            fixture.beforeProjectClosed();
        }
        CidrProjectFixture.assertNotNull((String)("dependent fixture not found: " + String.valueOf(fixture)), this.myDependentFixtures.remove(fixture));
    }

    private static <R extends OCResolveConfiguration, B> void notifyDependentFixtures(boolean notifyOpen, @Nullable CidrProjectFixture<B> holder) throws Exception {
        if (ourProject != null && holder != null && holder.myInitProjectHasBeenCalled) {
            for (CidrProjectDependentFixtureBase each : holder.myDependentFixtures.keySet()) {
                if (notifyOpen) {
                    each.afterProjectOpened();
                    continue;
                }
                each.beforeProjectClosed();
            }
        }
    }

    public void initProject(@NotNull String relativeProjectPath) throws Exception {
        if (relativeProjectPath == null) {
            CidrProjectFixture.$$$reportNull$$$0(10);
        }
        this.initProject(relativeProjectPath, null, true);
    }

    public void initProject(@NotNull String relativeProjectPath, @Nullable String relativeFilesToCopyPath, boolean openProject2) throws Exception {
        if (relativeProjectPath == null) {
            CidrProjectFixture.$$$reportNull$$$0(11);
        }
        this.initProject(new CidrTestProjectDescription(relativeProjectPath, relativeFilesToCopyPath, openProject2));
    }

    public void initProjectAsDirectory(@NotNull String relativeProjectPath) throws Exception {
        if (relativeProjectPath == null) {
            CidrProjectFixture.$$$reportNull$$$0(12);
        }
        this.initProject(new CidrTestProjectDescription(relativeProjectPath, null, true), OpenProjectKind.AS_DIRECTORY);
    }

    public void initProject(@NotNull CidrTestProjectDescription projectDescription) throws Exception {
        if (projectDescription == null) {
            CidrProjectFixture.$$$reportNull$$$0(13);
        }
        this.initProject(projectDescription, OpenProjectKind.AS_SPECIFIED_FILE);
    }

    public void initProject(@NotNull CidrTestProjectDescription projectDescription, OpenProjectKind kind) throws Exception {
        if (projectDescription == null) {
            CidrProjectFixture.$$$reportNull$$$0(14);
        }
        LOG.assertTrue(this.myCustomizer != null, (Object)"Customizer is not initialized");
        LOG.debug("Initializing project. " + String.valueOf(projectDescription) + this.myCustomizer.getDescription());
        ProjectInfo info = this.getProjectInfo(projectDescription.getRelativeProjectPath(), projectDescription.getRelativeFolderToCopy());
        boolean shouldReinitialize = false;
        if (ourTestFilesChanged || ourProject == null || !info.equals(ourProjectInfo) || this.myCustomizer.shouldReinitialize() || this.projectChangedSomehow(ourProject)) {
            this.closeProjectAndCleanup();
            shouldReinitialize = true;
        }
        boolean wasAlreadyInitialized = this.myInitProjectHasBeenCalled;
        this.myInitProjectHasBeenCalled = true;
        this.myOpenProjectHasBeenCalledOnce = false;
        this.myCustomizer.setShouldBuildTablesInTests();
        if (!shouldReinitialize) {
            if (projectDescription.getOpenProject()) {
                if (!wasAlreadyInitialized) {
                    CidrProjectFixture.notifyDependentFixtures(true, this);
                }
                this.myCustomizer.rebuildSymbolsIfNeeded(this.getProject());
            } else {
                this.closeProject();
            }
            return;
        }
        ourProjectInfo = info;
        this.myCustomizer.beforeInitializing();
        if (ourProjectCleanup == null) {
            ourProjectCleanup = () -> {
                CidrProjectFixture.closeProject(null, true);
                this.logProjectTimings();
            };
            PlatformTestUtil.registerProjectCleanup(ourProjectCleanup);
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectOpened(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!ourRunningFixture) {
                        CidrProjectFixture.this.myOldSdks = null;
                        CidrProjectFixture.this.closeProjectAndCleanup();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/CidrProjectFixture$1", "projectOpened"));
                }
            });
        }
        ourCloseProjectRunnable = this.getCloseProjectRunnable();
        this.addProjectCleanUpRunnables(ourAdditionalProjectCleanUpRunnableList);
        try {
            CidrProjectFixture.measureTiming("Copy Test Data", () -> WriteAction.runAndWait(() -> {
                File root = this.myTestDataFixture.createTempIODir(false);
                FileUtil.delete((File)root);
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(root);
                File adjustedProjectDir = new File(root, info.adjustedRelativePathToCopy);
                File copyDestination = adjustedProjectDir.getParentFile();
                File projectDir = this.myTestDataFixture.copyTestData(info.testData.dirToCopy, copyDestination);
                if (!projectDir.getCanonicalPath().equals(adjustedProjectDir.getCanonicalPath())) {
                    ourProjectFile = ourProjectDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectDir);
                } else {
                    this.afterTestDataCopied(copyDestination, adjustedProjectDir);
                    ourTestRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(root);
                    if (ourTestRoot.isValid()) {
                        ourTestRootFile = new File(ourTestRoot.getPath());
                    }
                    CidrProjectFixture.assertNotNull((String)("Test root not found: " + String.valueOf(root)), (Object)ourTestRoot);
                    ourProjectDir = ourTestRoot.findFileByRelativePath(info.adjustedRelativeProjectPath);
                    ourProjectFile = ourTestRoot.findFileByRelativePath(projectDescription.getRelativeProjectPath());
                    CidrProjectFixture.assertNotNull((String)("Project dir not found at " + String.valueOf(ourTestRoot) + "/" + info.adjustedRelativeProjectPath), (Object)ourProjectDir);
                    CidrProjectFixture.assertNotNull((String)("Project file not found at " + String.valueOf(ourTestRoot) + "/" + projectDescription.getRelativeProjectPath()), (Object)ourProjectFile);
                }
                if (this.myTestDataFixture.isSymlinked()) {
                    VirtualFile each;
                    for (each = ourProjectDir; each != null && !ourTestRoot.equals(each) && !each.is(VFileProperty.SYMLINK); each = each.getParent()) {
                    }
                    if (ourTestRoot.equals(each)) {
                        CidrProjectFixture.fail((String)"Project path should point at a symlink");
                    }
                }
                CidrProjectFixture.initTestFilesListener();
            }));
        }
        catch (Throwable e) {
            this.closeProjectAndCleanup();
            ExceptionUtil.rethrow((Throwable)e);
        }
        if (projectDescription.getOpenProject()) {
            this.openProject(kind, true);
        }
        if (EDT.isCurrentThreadEdt()) {
            PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
        }
    }

    public boolean isProjectAlreadyOpened(@NotNull String relativeProjectPath, @Nullable String relativeFolderToCopy) {
        if (relativeProjectPath == null) {
            CidrProjectFixture.$$$reportNull$$$0(15);
        }
        return this.getProjectInfo(relativeProjectPath, relativeFolderToCopy).equals(ourProjectInfo);
    }

    @NotNull
    private ProjectInfo getProjectInfo(@NotNull String relativeProjectPath, @Nullable String relativeFolderToCopy) {
        if (relativeProjectPath == null) {
            CidrProjectFixture.$$$reportNull$$$0(16);
        }
        ProjectInfo info = new ProjectInfo();
        info.adjustedRelativeProjectPath = FileUtil.toSystemIndependentName((String)this.getAdjustedProjectDir(relativeProjectPath));
        info.adjustedRelativePathToCopy = relativeFolderToCopy == null ? info.adjustedRelativeProjectPath : relativeFolderToCopy;
        info.testData.adjustedProjectDir = this.myTestDataFixture.getTestDataProjectsFile(info.adjustedRelativeProjectPath);
        info.testData.projectDir = this.myTestDataFixture.getTestDataProjectsFile(relativeProjectPath);
        info.testData.dirToCopy = this.myTestDataFixture.getTestDataProjectsFile(info.adjustedRelativePathToCopy);
        info.testDataFixtureClass = this.myTestDataFixture.getClass();
        info.isSymlinked = this.myTestDataFixture.isSymlinked();
        info.cleanKey = switch (this.myCleanProjectOption.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> null;
            case 1 -> new Object();
            case 2 -> this.myCurrentTestClassFQN;
        };
        ProjectInfo projectInfo = info;
        if (projectInfo == null) {
            CidrProjectFixture.$$$reportNull$$$0(17);
        }
        return projectInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Throwable> void measureTiming(@NotNull String step, ThrowableRunnable<T> runnable) throws T {
        if (step == null) {
            CidrProjectFixture.$$$reportNull$$$0(18);
        }
        long before = System.currentTimeMillis();
        try {
            runnable.run();
            if (ourProjectInfo == null) return;
        }
        catch (Throwable throwable) {
            if (ourProjectInfo == null) throw throwable;
            long time = System.currentTimeMillis() - before;
            ProjectTiming timing = ourProjectTimingMap.computeIfAbsent(CidrProjectFixture.ourProjectInfo.testData, info -> new ProjectTiming());
            ProjectTiming.Step stepTiming = timing.steps.computeIfAbsent(step, s -> new ProjectTiming.Step());
            if (stepTiming.first == -1L) {
                stepTiming.first = stepTiming.total = time;
            } else {
                stepTiming.total += time;
            }
            ++stepTiming.performedTimes;
            throw throwable;
        }
        long time = System.currentTimeMillis() - before;
        ProjectTiming timing = ourProjectTimingMap.computeIfAbsent(CidrProjectFixture.ourProjectInfo.testData, info -> new ProjectTiming());
        ProjectTiming.Step stepTiming = timing.steps.computeIfAbsent(step, s -> new ProjectTiming.Step());
        if (stepTiming.first == -1L) {
            stepTiming.first = stepTiming.total = time;
        } else {
            stepTiming.total += time;
        }
        ++stepTiming.performedTimes;
    }

    private void logProjectTimings() {
        this.myCustomizer.logStats(LOG);
        StringBuilder s = new StringBuilder();
        s.append("Unique project uses: ").append(ourProjectTimingMap.size()).append("\n");
        LinkedHashMap<String, ProjectTiming.Step> totalStepTimings = new LinkedHashMap<String, ProjectTiming.Step>();
        LinkedHashMap<String, List> stepSortedProjects = new LinkedHashMap<String, List>();
        for (Map.Entry<ProjectTestData, ProjectTiming> entry : ourProjectTimingMap.entrySet()) {
            int maxStepTimes = 0;
            for (Map.Entry<String, ProjectTiming.Step> eachStep : entry.getValue().steps.entrySet()) {
                ProjectTiming.Step stepTiming = eachStep.getValue();
                ProjectTiming.Step total = totalStepTimings.computeIfAbsent(eachStep.getKey(), __ -> new ProjectTiming.Step());
                total.first += stepTiming.first;
                total.total += stepTiming.total;
                if (stepTiming.performedTimes > 1) {
                    total.performedTimes += stepTiming.performedTimes;
                }
                maxStepTimes = Math.max(maxStepTimes, stepTiming.performedTimes);
                List sortedProjects = stepSortedProjects.computeIfAbsent(eachStep.getKey(), __ -> new SortedList((o1, o2) -> Long.compare(((ProjectTiming.Step)o2.second).total, ((ProjectTiming.Step)o1.second).total)));
                sortedProjects.add(Pair.create((Object)entry.getKey(), (Object)eachStep.getValue()));
            }
        }
        for (Map.Entry<ProjectTestData, ProjectTiming> entry : totalStepTimings.entrySet()) {
            int topProjects = 10;
            s.append("Projects ").append((String)((Object)entry.getKey())).append("\n").append("\tfirst time: ").append(StringUtil.formatDuration((long)((ProjectTiming.Step)((Object)entry.getValue())).first)).append("\n").append("\ttotal time: ").append(StringUtil.formatDuration((long)((ProjectTiming.Step)((Object)entry.getValue())).total)).append("\n").append("\tNumber of extra times called: ").append(((ProjectTiming.Step)((Object)entry.getValue())).performedTimes).append("\n").append("\tTop ").append(topProjects).append(" project repeatedly used: \n");
            for (Pair topProject : ContainerUtil.getFirstItems((List)((List)stepSortedProjects.get(entry.getKey())), (int)topProjects)) {
                s.append("\t\tTotal time: ").append(StringUtil.formatDuration((long)((ProjectTiming.Step)topProject.second).total)).append(", called ").append(((ProjectTiming.Step)topProject.second).performedTimes).append(" times: ").append(((ProjectTestData)topProject.first).projectDir).append("\n");
            }
        }
        LOG.info(s.toString());
    }

    @NotNull
    protected String getAdjustedProjectDir(@NotNull String relativeProjectFilePath) {
        if (relativeProjectFilePath == null) {
            CidrProjectFixture.$$$reportNull$$$0(19);
        }
        String string = relativeProjectFilePath;
        if (string == null) {
            CidrProjectFixture.$$$reportNull$$$0(20);
        }
        return string;
    }

    protected boolean projectChangedSomehow(@NotNull Project project) {
        if (project == null) {
            CidrProjectFixture.$$$reportNull$$$0(21);
        }
        return false;
    }

    private static void initTestFilesListener() {
        if (ourTestFilesListener != null) {
            return;
        }
        MessageBus bus = ApplicationManager.getApplication().getMessageBus();
        ourTestFilesListener = new BulkFileListener(){

            public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.after(events);
            }

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (ourProjectInfo == null) {
                    return;
                }
                for (VFileEvent vFileEvent : events) {
                    if (!FileUtil.isAncestor((File)CidrProjectFixture.ourProjectInfo.testData.dirToCopy, (File)new File(vFileEvent.getPath()), (boolean)true)) continue;
                    ourTestFilesChanged = true;
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/jetbrains/cidr/CidrProjectFixture$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)ourTestFilesListener);
    }

    public void closeProjectAndCleanup() {
        CidrProjectFixture.closeProject(this, true);
    }

    public final void openProject() throws Exception {
        this.openProject(false);
    }

    public final void openProject(boolean forceOpenAsExistingDotIdeaProject) throws Exception {
        this.openProject(forceOpenAsExistingDotIdeaProject ? OpenProjectKind.AS_DOT_IDEA : OpenProjectKind.AS_SPECIFIED_FILE);
    }

    public final void openProject(OpenProjectKind openProjectKind) throws Exception {
        this.openProject(openProjectKind, false);
    }

    public final void openProject(OpenProjectKind openProjectKind, boolean isInitProject) throws Exception {
        this.checkInitProjectCalled();
        CidrProjectFixture.assertNull((String)"Project is already open; close it before opening another one.", (Object)ourProject);
        List<Project> before = List.of(ProjectManager.getInstance().getOpenProjects());
        try {
            Ref project = new Ref();
            ThrowableRunnable openingRunnable = () -> {
                if (openProjectKind == OpenProjectKind.AS_DOT_IDEA) {
                    project.set((Object)PlatformProjectOpenProcessor.openProjectLegacyJavaApi((VirtualFile)ourProjectDir, null, (boolean)true));
                } else if (openProjectKind == OpenProjectKind.AS_RECENT) {
                    project.set((Object)RecentProjectsManagerBase.getInstanceEx().openProjectSync(Path.of(ourProjectDir.getPath(), new String[0])));
                } else if (openProjectKind == OpenProjectKind.AS_DIRECTORY) {
                    project.set((Object)ProjectUtil.openOrImport((String)ourProjectDir.getPath(), null, (boolean)true));
                } else {
                    project.set((Object)this.doOpenProject(ourProjectFile, isInitProject));
                }
                if (!CidrTestUtils.hasRadler() && !CidrTestUtils.hasKMP()) {
                    StartupActivityTestUtil.waitForProjectActivitiesToComplete((Project)project.get());
                }
                IndexingTestUtil.waitUntilIndexesAreReady((Project)project.get());
            };
            if (this.myOpenProjectHasBeenCalledOnce) {
                openingRunnable.run();
            } else {
                this.myOpenProjectHasBeenCalledOnce = true;
                CidrProjectFixture.measureTiming("Opening", openingRunnable);
            }
            CidrProjectFixture.measureTiming("waiting for project model", () -> this.waitForProjectModel((Project)project.get()));
            CidrProjectFixture.measureTiming("waiting for symbols", () -> this.myCustomizer.waitForSymbols((Project)project.get()));
            ApplicationManager.getApplication().invokeAndWait(() -> {
                ourVirtualFilePointerTracker = new VirtualFilePointerTracker();
                try {
                    CidrProjectFixture.setProject(this, (Project)project.get());
                }
                catch (Exception e) {
                    ExceptionUtil.rethrow((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Failed to open project, deadlock might happen", (Throwable)e);
            if (ourProject == null) {
                ArrayList<Project> after2 = new ArrayList<Project>(Arrays.asList(ProjectManager.getInstance().getOpenProjects()));
                after2.removeAll(before);
                for (Project eachHanging : after2) {
                    if (eachHanging.isDefault()) continue;
                    try {
                        PlatformTestUtil.forceCloseProjectWithoutSaving(eachHanging);
                    }
                    catch (Throwable closeException) {
                        closeException.printStackTrace();
                    }
                }
            }
            throw e;
        }
        this.checkProjectOpenedCorrectly();
    }

    public <E extends Throwable> void waitForRootsUpdated(ThrowableRunnable<E> block) throws E {
        this.waitForRootsUpdated(() -> {
            block.run();
            return null;
        });
    }

    public <T, E extends Throwable> T waitForRootsUpdated(ThrowableComputable<T, E> block) throws E {
        return CidrTestUtils.waitForRootsUpdated(this.getTestRootDisposable(), block);
    }

    @NotNull
    protected abstract Project doOpenProject(@NotNull VirtualFile var1, boolean var2) throws Exception;

    protected void checkProjectOpenedCorrectly() {
    }

    public static void cleanupStatics() {
        if (ourProjectCleanup != null) {
            ourProjectCleanup.run();
            ourProjectCleanup = null;
        }
    }

    public final void closeProject() {
        CidrProjectFixture.closeProject(this, false);
    }

    public static <B> void closeProject(@Nullable CidrProjectFixture<B> holder, boolean cleanup) {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (ourProject != null) {
            actions.add(() -> LOG.debug("Cleaning test project"));
            if (cleanup) {
                actions.addAll(ourAdditionalProjectCleanUpRunnableList);
                ourAdditionalProjectCleanUpRunnableList.clear();
            }
            actions.add(() -> EdtTestUtil.runInEdtAndWait(() -> CidrProjectFixture.notifyDependentFixtures(false, holder)));
            actions.add(() -> EdtTestUtil.runInEdtAndWait(() -> TestApplicationManager.getInstance().setDataProvider(null)));
            actions.add(() -> EdtTestUtil.runInEdtAndWait(() -> ourCloseProjectRunnable.consume((Object)ourProject)));
            actions.add(() -> EdtTestUtil.runInEdtAndWait(() -> ourVirtualFilePointerTracker.assertPointersAreDisposed()));
            actions.add(() -> EdtTestUtil.runInEdtAndWait(() -> {
                CidrProjectFixture.setProject(holder, null);
                LightPlatformTestCase.checkEditorsReleased();
                if (holder != null && holder.myOldSdks != null) {
                    holder.myOldSdks.checkForJdkTableLeaks();
                }
            }));
            actions.add(() -> LOG.debug("Cleaned test project"));
        }
        actions.add(() -> {
            LOG.debug("Cleaning test resources");
            if (cleanup) {
                if (ourTestRoot != null && ourTestRoot.isValid()) {
                    WriteAction.runAndWait(() -> {
                        try {
                            FileUtil.delete((File)new File(ourTestRoot.getPath()));
                            ourTestRoot.refresh(false, false);
                        }
                        catch (AlreadyDisposedException ex) {
                            FileUtil.delete((File)ourTestRootFile);
                        }
                    });
                }
                ourVirtualFilePointerTracker = null;
                ourProjectInfo = null;
                ourTestRoot = null;
                ourTestRootFile = null;
                ourProjectDir = null;
                ourProjectFile = null;
                ourTestFilesChanged = false;
            }
        });
        new RunAll(actions).run();
    }

    @NotNull
    protected ThrowableConsumer<Project, Throwable> getCloseProjectRunnable() {
        ThrowableConsumer throwableConsumer = project -> {
            ProjectManagerEx.getInstanceEx().forceCloseProject(project);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!ourRunningFixture) {
                    HeavyPlatformTestCase.cleanupProjectDependentCaches(project);
                } else {
                    HeavyPlatformTestCase.cleanupApplicationCaches(project);
                }
            }, ModalityState.nonModal());
        };
        if (throwableConsumer == null) {
            CidrProjectFixture.$$$reportNull$$$0(22);
        }
        return throwableConsumer;
    }

    protected void addProjectCleanUpRunnables(List<ThrowableRunnable<Throwable>> list) {
        list.add((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            OCWorkspace workspace;
            if (this.isProjectOpened() && (workspace = OCWorkspace.getInstance((Project)this.getProject())) instanceof OCWorkspaceImpl) {
                PathKt.delete((Path)((OCWorkspaceImpl)workspace).getStateFile());
            }
        }));
    }

    public final void saveAndCloseProject() {
        this.saveProject();
        this.closeProject();
    }

    public void saveProject() {
        EdtTestUtil.runInEdtAndWait(() -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            PlatformTestUtil.saveProject(this.getProject(), true);
        });
    }

    protected void afterTestDataCopied(@NotNull File copyDestination, @NotNull File adjustedProjectDir) throws Exception {
        if (copyDestination == null) {
            CidrProjectFixture.$$$reportNull$$$0(23);
        }
        if (adjustedProjectDir == null) {
            CidrProjectFixture.$$$reportNull$$$0(24);
        }
    }

    private static <B> void setProject(@Nullable CidrProjectFixture<B> holder, @Nullable Project project) throws Exception {
        ourProject = project;
        if (project != null && holder != null) {
            ProjectEx projectEx;
            String projectName = project.getName();
            if (project instanceof ProjectEx && !(projectEx = (ProjectEx)project).isLight()) {
                String usedInTestNames;
                String currentTestName = holder.myCurrentTestClassFQN + "." + holder.myCurrentTestName;
                String creationTestName = (String)projectEx.getUserData(ProjectImpl.CREATION_TEST_NAME);
                if (creationTestName == null) {
                    projectEx.putUserData(ProjectImpl.CREATION_TEST_NAME, (Object)currentTestName);
                }
                if ((usedInTestNames = (String)projectEx.getUserData(ProjectImpl.USED_TEST_NAMES)) == null) {
                    projectEx.putUserData(ProjectImpl.USED_TEST_NAMES, (Object)currentTestName);
                } else if (!StringUtil.containsIgnoreCase((String)usedInTestNames, (String)currentTestName)) {
                    projectEx.putUserData(ProjectImpl.USED_TEST_NAMES, (Object)(usedInTestNames + ", " + currentTestName));
                }
            }
        }
        TestApplicationManager.getInstance().setDataProvider(project == null ? null : new TestDataProvider(project));
        CidrProjectFixture.notifyDependentFixtures(true, holder);
    }

    @NotNull
    public VirtualFile getTestRoot() {
        VirtualFile virtualFile = ourTestRoot;
        if (virtualFile == null) {
            CidrProjectFixture.$$$reportNull$$$0(25);
        }
        return virtualFile;
    }

    @NotNull
    public File getTestIORoot() {
        return new File(this.getTestRootPath());
    }

    @NotNull
    public String getTestRootPath() {
        String string = ourTestRoot.getPath();
        if (string == null) {
            CidrProjectFixture.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public VirtualFile getProjectFile() {
        VirtualFile virtualFile = ourProjectFile;
        if (virtualFile == null) {
            CidrProjectFixture.$$$reportNull$$$0(27);
        }
        return virtualFile;
    }

    @NotNull
    public File getProjectIOFile() {
        return new File(this.getProjectFilePath());
    }

    @NotNull
    public String getProjectFilePath() {
        String string = ourProjectFile.getPath();
        if (string == null) {
            CidrProjectFixture.$$$reportNull$$$0(28);
        }
        return string;
    }

    public VirtualFile getProjectDir() {
        return ourProjectDir;
    }

    @NotNull
    public Path getProjectIODir() {
        Path path = Paths.get(this.getProjectDirPath(), new String[0]);
        if (path == null) {
            CidrProjectFixture.$$$reportNull$$$0(29);
        }
        return path;
    }

    @NotNull
    public String getProjectDirPath() {
        String string = ourProjectDir.getPath();
        if (string == null) {
            CidrProjectFixture.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public Project getProject() {
        this.checkInitProjectCalled();
        if (!this.isProjectOpened()) {
            throw new RuntimeException("Project is not opened.");
        }
        Project project = ourProject;
        if (project == null) {
            CidrProjectFixture.$$$reportNull$$$0(31);
        }
        return project;
    }

    @Nullable
    public Project getProjectUnchecked() {
        return ourProject;
    }

    public boolean isProjectOpened() {
        return ourProject != null;
    }

    public Module getModule() {
        return OCRootsSynchronizer.getInstance((Project)this.getProject()).getModuleIfExists();
    }

    public List<String> getContentRootPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            for (String eachUrl : ModuleRootManager.getInstance((Module)module2).getContentRootUrls()) {
                result.add(FileUtil.toCanonicalPath((String)VfsUtilCore.urlToPath((String)eachUrl)));
            }
        }
        return result;
    }

    public List<VirtualFile> getContentRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            result.addAll(Arrays.asList(ModuleRootManager.getInstance((Module)module2).getContentRoots()));
        }
        return result;
    }

    public List<String> getSourceRootPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            for (String eachUrl : ModuleRootManager.getInstance((Module)module2).getSourceRootUrls()) {
                result.add(FileUtil.toCanonicalPath((String)VfsUtilCore.urlToPath((String)eachUrl)));
            }
        }
        return result;
    }

    public List<VirtualFile> getSourceRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            result.addAll(Arrays.asList(ModuleRootManager.getInstance((Module)module2).getSourceRoots()));
        }
        return result;
    }

    public List<String> getExcludeRootPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            for (String eachUrl : ModuleRootManager.getInstance((Module)module2).getExcludeRootUrls()) {
                result.add(FileUtil.toCanonicalPath((String)VfsUtilCore.urlToPath((String)eachUrl)));
            }
        }
        for (VirtualFileUrl excludedUrl : OCWorkspaceModelRootsBuilder.excludedSourceUrls((Project)this.getProject())) {
            result.add(FileUtil.toCanonicalPath((String)VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)excludedUrl).toString()));
        }
        return result;
    }

    public List<VirtualFile> getExcludeRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            result.addAll(Arrays.asList(ModuleRootManager.getInstance((Module)module2).getExcludeRoots()));
        }
        for (VirtualFileUrl excludedUrl : OCWorkspaceModelRootsBuilder.excludedSourceUrls((Project)this.getProject())) {
            VirtualFile virtualFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)excludedUrl);
            if (virtualFile == null) continue;
            result.add(virtualFile);
        }
        return result;
    }

    public List<String> getLibraryRootPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            for (OrderEntry each : ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
                if (!(each instanceof LibraryOrderEntry)) continue;
                for (String eachUrl : ((LibraryOrderEntry)each).getRootUrls(OrderRootType.CLASSES)) {
                    result.add(FileUtil.toCanonicalPath((String)VfsUtilCore.urlToPath((String)eachUrl)));
                }
            }
        }
        return result;
    }

    public List<VirtualFile> getLibraryRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            for (OrderEntry each : ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
                if (!(each instanceof LibraryOrderEntry)) continue;
                result.addAll(Arrays.asList(((LibraryOrderEntry)each).getRootFiles(OrderRootType.CLASSES)));
            }
        }
        return result;
    }

    @NotNull
    public OCWorkspace getWorkspace() {
        OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)this.getProject());
        if (oCWorkspace == null) {
            CidrProjectFixture.$$$reportNull$$$0(32);
        }
        return oCWorkspace;
    }

    private void checkInitProjectCalled() {
        if (!this.myInitProjectHasBeenCalled) {
            throw new RuntimeException("CidrProjectFixture.initProject has never been called for this test.");
        }
    }

    protected boolean isProjectInitialized() {
        return this.myInitProjectHasBeenCalled;
    }

    @NotNull
    public String getProjectSubPath(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrProjectFixture.$$$reportNull$$$0(33);
        }
        String string = FileUtil.toCanonicalPath((String)this.getProjectSubIOFile(relativePath).getPath());
        if (string == null) {
            CidrProjectFixture.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public File getProjectSubIOFile(@Nullable String relativePath) {
        return relativePath == null ? new File(ourProjectDir.getPath()) : new File(ourProjectDir.getPath(), relativePath);
    }

    @NotNull
    public Path getProjectSubNIOPath(@Nullable String relativePath) {
        Path path = relativePath == null ? this.getProjectIODir() : this.getProjectIODir().resolve(relativePath);
        if (path == null) {
            CidrProjectFixture.$$$reportNull$$$0(35);
        }
        return path;
    }

    @NotNull
    public File findProjectSubIOFile(@Nullable String relativePath) {
        File file = this.getProjectSubIOFile(relativePath);
        if (file == null) {
            CidrProjectFixture.$$$reportNull$$$0(36);
        }
        return file;
    }

    @Nullable
    public VirtualFile findProjectSubFile(@Nullable String relativePath) {
        return relativePath == null ? ourProjectDir : ourProjectDir.findFileByRelativePath(relativePath);
    }

    @NotNull
    public VirtualFile getProjectSubFile(@Nullable String relativePath) {
        VirtualFile result = this.findProjectSubFile(relativePath);
        CidrProjectFixture.assertNotNull((String)("File not found: " + relativePath), (Object)result);
        VirtualFile virtualFile = result;
        if (virtualFile == null) {
            CidrProjectFixture.$$$reportNull$$$0(37);
        }
        return virtualFile;
    }

    @Nullable
    public PsiFile findProjectSubPsiFile(@Nullable String relativePath) {
        VirtualFile file = this.findProjectSubFile(relativePath);
        return file == null ? null : (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(file));
    }

    @Nullable
    public PsiDirectory findProjectSubPsiDirectory(@Nullable String relativePath) {
        VirtualFile file = this.findProjectSubFile(relativePath);
        return file == null ? null : (PsiDirectory)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findDirectory(file));
    }

    @NotNull
    public PsiFile getProjectSubPsiFile(@Nullable String relativePath) {
        PsiFile result = this.findProjectSubPsiFile(relativePath);
        CidrProjectFixture.assertNotNull((String)("File not found: " + relativePath), (Object)result);
        PsiFile psiFile = result;
        if (psiFile == null) {
            CidrProjectFixture.$$$reportNull$$$0(38);
        }
        return psiFile;
    }

    @NotNull
    public PsiDirectory getProjectSubPsiDirectory(@Nullable String relativePath) {
        PsiDirectory result = this.findProjectSubPsiDirectory(relativePath);
        CidrProjectFixture.assertNotNull((String)("Dir not found: " + relativePath), (Object)result);
        PsiDirectory psiDirectory = result;
        if (psiDirectory == null) {
            CidrProjectFixture.$$$reportNull$$$0(39);
        }
        return psiDirectory;
    }

    @NotNull
    public Module findModuleForFile(@NotNull String fileName) {
        if (fileName == null) {
            CidrProjectFixture.$$$reportNull$$$0(40);
        }
        VirtualFile file = this.findProjectSubFile(fileName);
        CidrProjectFixture.assertNotNull((Object)file);
        Module module2 = this.findModuleForFile(file);
        if (module2 == null) {
            CidrProjectFixture.$$$reportNull$$$0(41);
        }
        return module2;
    }

    @NotNull
    public Module findModuleForFile(@NotNull VirtualFile file) {
        if (file == null) {
            CidrProjectFixture.$$$reportNull$$$0(42);
        }
        Module module2 = (Module)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)this.getProject()).getModuleForFile(file, false));
        CidrProjectFixture.assertNotNull((Object)module2);
        Module module3 = module2;
        if (module3 == null) {
            CidrProjectFixture.$$$reportNull$$$0(43);
        }
        return module3;
    }

    public void assertFiles(Collection<VirtualFile> files, String ... expectedRelativePaths) {
        this.assertFiles(files, Arrays.asList(expectedRelativePaths));
    }

    public void assertFiles(Collection<VirtualFile> files, List<String> expectedRelativePaths) {
        this.assertIOFiles(this.collectIOFiles(files), expectedRelativePaths);
    }

    public void assertIOFiles(Collection<File> files, String ... expectedRelativePaths) {
        this.assertIOFiles(files, Arrays.asList(expectedRelativePaths));
    }

    public void assertIOFiles(Collection<File> files, List<String> expectedRelativePaths) {
        UsefulTestCase.assertSameElements(this.collectIOFilesPaths(files), expectedRelativePaths);
    }

    @NotNull
    public List<VirtualFile> collectProjectFiles(String ... relativePaths) {
        List<VirtualFile> list = this.collectProjectFiles(Arrays.asList(relativePaths));
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<String> collectProjectFilesPaths(List<String> relativePaths) {
        List list = ContainerUtil.map(relativePaths, s -> this.getProjectSubPath((String)s));
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(45);
        }
        return list;
    }

    @NotNull
    public List<String> collectProjectFilesPaths(String ... relativePaths) {
        List<String> list = this.collectProjectFilesPaths(Arrays.asList(relativePaths));
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(46);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> collectProjectFiles(List<String> relativePaths) {
        List list = ContainerUtil.map(relativePaths, s -> this.getProjectSubFile((String)s));
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(47);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> collectFilesFromPaths(String ... paths) {
        List<VirtualFile> list = this.collectFilesFromPaths(Arrays.asList(paths));
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<VirtualFile> collectFilesFromPaths(Collection<String> paths) {
        List list = ContainerUtil.map(paths, (Function)((NotNullFunction)path -> {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            CidrProjectFixture.assertNotNull((String)("file not found: " + path), (Object)file);
            return file;
        }));
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(49);
        }
        return list;
    }

    @NotNull
    public List<File> collectIOFiles(Collection<VirtualFile> files) {
        List list = VfsUtilCore.virtualToIoFiles(files);
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    public List<String> collectFilesPaths(Collection<VirtualFile> files) {
        List<String> list = this.collectIOFilesPaths(this.collectIOFiles(files));
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(51);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<String> collectFullFilesPaths(Collection<VirtualFile> files) {
        List list = ContainerUtil.map(files, file -> file.getCanonicalPath());
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(52);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<String> collectIOFilesPaths(Collection<File> files) {
        File base = this.getProjectIODir().toFile();
        List list = ContainerUtil.map(files, file -> FileUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)base, (File)file)));
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(53);
        }
        return list;
    }

    public void assertScope(int mask, String ... relativePaths) {
        this.assertScope(mask, this.collectProjectFiles(relativePaths));
    }

    public void assertScope(int mask, VirtualFile ... files) {
        this.assertScope(mask, Arrays.asList(files));
    }

    public void assertScope(int mask, List<VirtualFile> files) {
        ApplicationManager.getApplication().runReadAction(() -> {
            StringBuilder m = new StringBuilder();
            m.append(CidrProjectFixture.assertScope(ProjectScope.getAllScope((Project)this.getProject()), "all", (mask & 3) != 0 || (mask & 8) != 0, files));
            m.append(CidrProjectFixture.assertScope(ProjectScope.getProjectScope((Project)this.getProject()), "project", (mask & 1) != 0, files));
            m.append(CidrProjectFixture.assertScope(ProjectScope.getLibrariesScope((Project)this.getProject()), "libraries", (mask & 8) != 0, files));
            m.append(CidrProjectFixture.assertScope(ProjectScope.getContentScope((Project)this.getProject()), "content", (mask & 3) != 0, files));
            this.myCustomizer.assertScopeExt(m, mask, files);
            if (!m.isEmpty()) {
                CidrProjectFixture.fail((String)m.toString());
            }
        });
    }

    public static String assertScope(GlobalSearchScope scope, String scopeName, boolean inScope, List<VirtualFile> files) {
        ArrayList<VirtualFile> wrongFiles = new ArrayList<VirtualFile>();
        for (VirtualFile each : files) {
            CidrProjectFixture.assertNotNull((String)"Null file passed into the check", (Object)each);
            if (scope.contains(each) == inScope) continue;
            wrongFiles.add(each);
        }
        if (!wrongFiles.isEmpty()) {
            return "Files should " + (inScope ? "be" : "NOT be") + " in " + scopeName + " scope: \n" + StringUtil.join(wrongFiles, file -> " " + file.getPath(), (String)"\n") + "\n\n";
        }
        return "";
    }

    @Nullable
    public OCResolveConfiguration findResolveConfiguration(String configAndVariantName) {
        for (OCResolveConfiguration each : this.getWorkspace().getConfigurations()) {
            if (!CidrProjectFixture.formatConfigName(each).matches(FileUtil.convertAntToRegexp((String)configAndVariantName))) continue;
            return each;
        }
        return null;
    }

    @NotNull
    protected static String formatConfigName(OCResolveConfiguration each) {
        Object eachName = each.getName();
        OCVariant variant = each.getVariant();
        if (variant != null) {
            eachName = (String)eachName + " [" + variant.getDisplayName() + "]";
        }
        String string = eachName;
        if (string == null) {
            CidrProjectFixture.$$$reportNull$$$0(54);
        }
        return string;
    }

    @Nullable
    public OCResolveConfiguration findResolveConfigurationForTarget(String targetName) {
        for (OCResolveConfiguration each : this.getWorkspace().getConfigurations()) {
            if (!each.getName().equals(targetName)) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public OCResolveConfiguration getFirstResolveConfiguration() {
        OCResolveConfiguration oCResolveConfiguration = (OCResolveConfiguration)this.getWorkspace().getConfigurations().get(0);
        if (oCResolveConfiguration == null) {
            CidrProjectFixture.$$$reportNull$$$0(55);
        }
        return oCResolveConfiguration;
    }

    @NotNull
    public OCResolveConfiguration getResolveConfiguration(String configAndVariantName) {
        OCResolveConfiguration result = this.findResolveConfiguration(configAndVariantName);
        CidrProjectFixture.assertNotNull((String)("configuration not found:" + configAndVariantName + " among " + String.valueOf(ContainerUtil.map((Collection)this.getWorkspace().getConfigurations(), CidrProjectFixture::formatConfigName))), (Object)result);
        OCResolveConfiguration oCResolveConfiguration = result;
        if (oCResolveConfiguration == null) {
            CidrProjectFixture.$$$reportNull$$$0(56);
        }
        return oCResolveConfiguration;
    }

    @NotNull
    public OCResolveConfiguration getResolveConfigurationForTarget(String targetName) {
        OCResolveConfiguration result = this.findResolveConfigurationForTarget(targetName);
        CidrProjectFixture.assertNotNull((String)("configuration not found:" + targetName + " among " + String.valueOf(ContainerUtil.map((Collection)this.getWorkspace().getConfigurations(), CidrProjectFixture::formatConfigName))), (Object)result);
        OCResolveConfiguration oCResolveConfiguration = result;
        if (oCResolveConfiguration == null) {
            CidrProjectFixture.$$$reportNull$$$0(57);
        }
        return oCResolveConfiguration;
    }

    public void assertOrderedResolveConfigurations(String ... expectedConfigNames) {
        this.assertOrderedResolveConfigurations(Arrays.asList(expectedConfigNames));
    }

    public void assertOrderedResolveConfigurations(@NotNull List<String> expectedConfigNames) {
        if (expectedConfigNames == null) {
            CidrProjectFixture.$$$reportNull$$$0(58);
        }
        this.assertOrderedResolveConfigurations((List<OCResolveConfiguration>)this.getWorkspace().getConfigurations(), expectedConfigNames);
    }

    public void assertOrderedResolveConfigurations(@NotNull List<OCResolveConfiguration> configurations, String ... expectedConfigNames) {
        if (configurations == null) {
            CidrProjectFixture.$$$reportNull$$$0(59);
        }
        this.assertOrderedResolveConfigurations(configurations, Arrays.asList(expectedConfigNames));
    }

    public void assertOrderedResolveConfigurations(@NotNull List<OCResolveConfiguration> configurations, List<String> expectedConfigNames) {
        if (configurations == null) {
            CidrProjectFixture.$$$reportNull$$$0(60);
        }
        UsefulTestCase.assertOrderedEquals(this.collectResolveConfigurationsNames(configurations), expectedConfigNames);
    }

    @NotNull
    public @Unmodifiable List<String> collectResolveConfigurationsNames(@NotNull List<OCResolveConfiguration> configurations) {
        if (configurations == null) {
            CidrProjectFixture.$$$reportNull$$$0(61);
        }
        List list = ContainerUtil.map(configurations, CidrProjectFixture::formatConfigName);
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(62);
        }
        return list;
    }

    @NotNull
    public OCResolveConfiguration addResolveConfiguration(@NotNull String id, Consumer<OCResolveConfiguration.ModifiableModel> updater) {
        if (id == null) {
            CidrProjectFixture.$$$reportNull$$$0(63);
        }
        this.updateWorkspace((Consumer<OCWorkspace.ModifiableModel>)((Consumer)model -> {
            OCResolveConfiguration.ModifiableModel configModel = model.addConfiguration(id, id);
            updater.consume((Object)configModel);
        }));
        OCResolveConfiguration oCResolveConfiguration = this.getWorkspace().getConfigurationById(id);
        if (oCResolveConfiguration == null) {
            CidrProjectFixture.$$$reportNull$$$0(64);
        }
        return oCResolveConfiguration;
    }

    public void removeResolveConfiguration(@NotNull OCResolveConfiguration config) {
        if (config == null) {
            CidrProjectFixture.$$$reportNull$$$0(65);
        }
        this.updateWorkspace((Consumer<OCWorkspace.ModifiableModel>)((Consumer)model -> {
            String id = config.getUniqueId();
            OCResolveConfiguration.ModifiableModel configModel = model.getConfigurationById(id);
            CidrProjectFixture.assertNotNull((String)("Configuration not found: " + id), (Object)configModel);
            model.removeConfiguration(configModel);
        }));
    }

    public void updateFirstResolveConfiguration(Consumer<OCResolveConfiguration.ModifiableModel> updater) {
        this.updateResolveConfiguration(null, updater);
    }

    public void updateResolveConfiguration(@Nullable OCResolveConfiguration configOrNullForDefault, Consumer<OCResolveConfiguration.ModifiableModel> updater) {
        this.updateWorkspace((Consumer<OCWorkspace.ModifiableModel>)((Consumer)model -> {
            OCResolveConfiguration.ModifiableModel configModel;
            if (configOrNullForDefault == null) {
                configModel = (OCResolveConfiguration.ModifiableModel)model.getConfigurations().get(0);
            } else {
                String id = configOrNullForDefault.getUniqueId();
                configModel = model.getConfigurationById(id);
                CidrProjectFixture.assertNotNull((String)("Configuration not found: " + id), (Object)configModel);
            }
            updater.consume((Object)configModel);
        }));
    }

    public void updateAllResolveConfigurations(Consumer<OCResolveConfiguration.ModifiableModel> updater) {
        this.updateWorkspace((Consumer<OCWorkspace.ModifiableModel>)((Consumer)model -> {
            for (OCResolveConfiguration.ModifiableModel each : model.getConfigurations()) {
                updater.consume((Object)each);
            }
        }));
    }

    public void updateWorkspace(Consumer<OCWorkspace.ModifiableModel> updater) {
        WriteAction.runAndWait(() -> {
            OCWorkspace.ModifiableModel model = this.getWorkspaceModifiableModel();
            try {
                updater.consume((Object)model);
                model.preCommit();
                model.commit();
            }
            finally {
                Disposer.dispose((Disposable)model);
            }
        });
        IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
    }

    public static void setDefaultFeatures64Bit(@NotNull OCResolveConfiguration.ModifiableModel configuration) {
        if (configuration == null) {
            CidrProjectFixture.$$$reportNull$$$0(66);
        }
        HashMap<OCCompilerFeatures.TypeSize, Short> features = new HashMap<OCCompilerFeatures.TypeSize, Short>();
        features.put(OCCompilerFeatures.TypeSize.SIZE_T, (short)8);
        features.put(OCCompilerFeatures.TypeSize.LONG, (short)8);
        features.put(OCCompilerFeatures.TypeSize.DOUBLE, (short)8);
        features.put(OCCompilerFeatures.TypeSize.LONG_DOUBLE, (short)16);
        configuration.getDefaultCompilerSettings().setCompilerFeatures(features);
        for (CLanguageKind eachLang : CLanguageKind.values()) {
            configuration.getLanguageCompilerSettings((OCLanguageKind)eachLang).setCompilerFeatures(features);
        }
    }

    @NotNull
    public HeadersSearchPath createSearchPath(@NotNull File dir, boolean recursive, @NotNull HeadersSearchPath.Kind kind) {
        if (dir == null) {
            CidrProjectFixture.$$$reportNull$$$0(67);
        }
        if (kind == null) {
            CidrProjectFixture.$$$reportNull$$$0(68);
        }
        return new HeadersSearchPath(dir, recursive, kind);
    }

    @Nullable
    public final BUILD_CONFIGURATION_TYPE getBuildConfiguration(@NotNull CidrRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            CidrProjectFixture.$$$reportNull$$$0(69);
        }
        return this.getBuildConfiguration(runConfiguration, null);
    }

    @Nullable
    public abstract BUILD_CONFIGURATION_TYPE getBuildConfiguration(@NotNull CidrRunConfiguration var1, @Nullable ExecutionTarget var2);

    public String buildConfig(BUILD_CONFIGURATION_TYPE config) throws Exception {
        return this.doBuildOrCleanConfig(config, true, false, null);
    }

    public String buildConfig(BUILD_CONFIGURATION_TYPE config, boolean allowBuildToFail) throws Exception {
        return this.doBuildOrCleanConfig(config, true, allowBuildToFail, null);
    }

    public String buildConfig(BUILD_CONFIGURATION_TYPE config, @Nullable ProcessListener listener) throws Exception {
        return this.doBuildOrCleanConfig(config, true, false, listener);
    }

    public String cleanConfig(BUILD_CONFIGURATION_TYPE config) throws Exception {
        return this.doBuildOrCleanConfig(config, false, false, null);
    }

    private String doBuildOrCleanConfig(BUILD_CONFIGURATION_TYPE config, boolean build, boolean allowBuildToFail, @Nullable ProcessListener listener) throws Exception {
        return this.doExecuteConfig(allowBuildToFail, listener, (Function<ProcessListener, ExecutionResult<CidrBuildResult>>)((Function)wrappingListener -> this.doBuildOrCleanConfig(config, build, (ProcessListener)wrappingListener)));
    }

    protected String doExecuteConfig(boolean allowToFail, final @Nullable ProcessListener listener, Function<ProcessListener, ExecutionResult<CidrBuildResult>> executor) throws Exception {
        final StringBuilder outputBuilder = new StringBuilder();
        ProcessListener wrappingListener = new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (listener != null) {
                    listener.startNotified(event);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (listener != null) {
                    listener.processTerminated(event);
                }
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (listener != null) {
                    listener.processWillTerminate(event, willBeDestroyed);
                }
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(4);
                }
                outputBuilder.append(event.getText());
                if (listener != null) {
                    listener.onTextAvailable(event, outputType);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/CidrProjectFixture$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ExecutionResult result = (ExecutionResult)executor.fun((Object)wrappingListener);
        try {
            Boolean[] success = new Boolean[1];
            CidrProjectFixture.measureTiming("Build", () -> {
                success[0] = ((CidrBuildResult)result.get(5L, TimeUnit.MINUTES)).getSucceeded();
            });
            String output = outputBuilder.toString();
            this.disposeBuildToolWindow();
            if (!allowToFail) {
                CidrProjectFixture.assertTrue((String)output, (boolean)success[0]);
            }
            return output;
        }
        catch (Exception e) {
            System.err.println(outputBuilder);
            if (e instanceof TimeoutException) {
                ThreadUtil.printThreadDump();
            }
            throw e;
        }
    }

    public String disposeBuildToolWindow() {
        return CidrTestUtils.disposeBuildToolWindow(this.getProject(), this.myProjectDisposable);
    }

    protected abstract ExecutionResult<CidrBuildResult> doBuildOrCleanConfig(@NotNull BUILD_CONFIGURATION_TYPE var1, boolean var2, @Nullable ProcessListener var3);

    @NotNull
    public BUILD_CONFIGURATION_TYPE buildIfNeeded(@NotNull CidrRunConfiguration runConfiguration) throws Exception {
        if (runConfiguration == null) {
            CidrProjectFixture.$$$reportNull$$$0(70);
        }
        BUILD_CONFIGURATION_TYPE BUILD_CONFIGURATION_TYPE = this.buildIfNeeded(runConfiguration, null);
        if (BUILD_CONFIGURATION_TYPE == null) {
            CidrProjectFixture.$$$reportNull$$$0(71);
        }
        return BUILD_CONFIGURATION_TYPE;
    }

    @NotNull
    public BUILD_CONFIGURATION_TYPE buildIfNeeded(@NotNull CidrRunConfiguration runConfiguration, @Nullable ExecutionTarget executionTarget) throws Exception {
        BUILD_CONFIGURATION_TYPE configuration;
        if (runConfiguration == null) {
            CidrProjectFixture.$$$reportNull$$$0(72);
        }
        if ((configuration = this.getBuildConfiguration(runConfiguration, executionTarget)) == null) {
            List targets = runConfiguration.getHelper().getTargets();
            String targetsString = targets.isEmpty() ? "NO TARGETS! Has the project configuration succeeded?" : "Available targets: " + String.valueOf(targets);
            CidrProjectFixture.fail((String)("Unable to get build configuration. " + targetsString + "\nRequested run configuration: " + String.valueOf(runConfiguration.getTargetAndConfigurationData())));
        }
        BUILD_CONFIGURATION_TYPE BUILD_CONFIGURATION_TYPE = this.buildIfNeeded(configuration);
        if (BUILD_CONFIGURATION_TYPE == null) {
            CidrProjectFixture.$$$reportNull$$$0(73);
        }
        return BUILD_CONFIGURATION_TYPE;
    }

    @NotNull
    public BUILD_CONFIGURATION_TYPE buildIfNeeded(@NotNull BUILD_CONFIGURATION_TYPE buildConfiguration) throws Exception {
        String id;
        Set<String> builtConfigurations;
        if (buildConfiguration == null) {
            CidrProjectFixture.$$$reportNull$$$0(74);
        }
        if (!(builtConfigurations = this.getBuiltConfigurations()).contains(id = (String)ReadAction.compute(() -> this.getConfigBuildId(buildConfiguration)))) {
            this.buildConfig(buildConfiguration);
            builtConfigurations.add(id);
        }
        BUILD_CONFIGURATION_TYPE BUILD_CONFIGURATION_TYPE = buildConfiguration;
        if (BUILD_CONFIGURATION_TYPE == null) {
            CidrProjectFixture.$$$reportNull$$$0(75);
        }
        return BUILD_CONFIGURATION_TYPE;
    }

    @NotNull
    public BUILD_CONFIGURATION_TYPE cleanIfNeeded(@NotNull BUILD_CONFIGURATION_TYPE config) throws Exception {
        Set<String> builtConfigurations;
        if (config == null) {
            CidrProjectFixture.$$$reportNull$$$0(76);
        }
        if ((builtConfigurations = this.getBuiltConfigurations()).remove(this.getConfigBuildId(config))) {
            this.cleanConfig(config);
        }
        BUILD_CONFIGURATION_TYPE BUILD_CONFIGURATION_TYPE = config;
        if (BUILD_CONFIGURATION_TYPE == null) {
            CidrProjectFixture.$$$reportNull$$$0(77);
        }
        return BUILD_CONFIGURATION_TYPE;
    }

    protected abstract String getConfigBuildId(@NotNull BUILD_CONFIGURATION_TYPE var1);

    private Set<String> getBuiltConfigurations() {
        if (!this.isProjectOpened()) {
            return Collections.emptySet();
        }
        HashSet builtConfigurations = (HashSet)this.getProject().getUserData(BUILT_CONFIGURATIONS);
        if (builtConfigurations == null) {
            builtConfigurations = new HashSet();
            this.getProject().putUserData(BUILT_CONFIGURATIONS, builtConfigurations);
        }
        return builtConfigurations;
    }

    @NotNull
    public OCCompilerKind getCompilerType() {
        if (SystemInfo.isWindows) {
            MSVCCompilerKind mSVCCompilerKind = MSVCCompilerKind.INSTANCE;
            if (mSVCCompilerKind == null) {
                CidrProjectFixture.$$$reportNull$$$0(78);
            }
            return mSVCCompilerKind;
        }
        if (SystemInfo.isLinux) {
            GCCCompilerKind gCCCompilerKind = GCCCompilerKind.INSTANCE;
            if (gCCCompilerKind == null) {
                CidrProjectFixture.$$$reportNull$$$0(79);
            }
            return gCCCompilerKind;
        }
        if (SystemInfo.isMac) {
            ClangCompilerKind clangCompilerKind = ClangCompilerKind.INSTANCE;
            if (clangCompilerKind == null) {
                CidrProjectFixture.$$$reportNull$$$0(80);
            }
            return clangCompilerKind;
        }
        UnknownCompilerKind unknownCompilerKind = UnknownCompilerKind.INSTANCE;
        if (unknownCompilerKind == null) {
            CidrProjectFixture.$$$reportNull$$$0(81);
        }
        return unknownCompilerKind;
    }

    public Pair<Boolean, String> executeProjectTask(@NotNull BiConsumer<ProjectTaskManager, java.util.function.Consumer<ProjectTaskManager.Result>> taskExecutor) throws Exception {
        if (taskExecutor == null) {
            CidrProjectFixture.$$$reportNull$$$0(82);
        }
        return CidrTestUtils.executeProjectTask(this.getProject(), this.myProjectDisposable, taskExecutor);
    }

    public Pair<Boolean, String> executeProjectTasks(@NotNull List<ProjectTask> tasks) throws Exception {
        if (tasks == null) {
            CidrProjectFixture.$$$reportNull$$$0(83);
        }
        ProjectTaskList task2 = tasks.size() == 1 ? tasks.get(0) : new ProjectTaskList(tasks);
        return this.executeProjectTask((arg_0, arg_1) -> CidrProjectFixture.lambda$executeProjectTasks$51((ProjectTask)task2, arg_0, arg_1));
    }

    public Pair<Boolean, String> executeProjectTasks(ProjectTask ... tasks) throws Exception {
        if (tasks == null) {
            CidrProjectFixture.$$$reportNull$$$0(84);
        }
        return this.executeProjectTasks(Arrays.asList(tasks));
    }

    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull String name, @NotNull ConfigurationTypeBase type, @Nullable BuildTargetAndConfigurationData buildTargetAndConfigurationData, boolean temporary, boolean shared, @Nullable Consumer<CidrRunConfiguration<?, ?>> configurator) throws Exception {
        if (name == null) {
            CidrProjectFixture.$$$reportNull$$$0(85);
        }
        if (type == null) {
            CidrProjectFixture.$$$reportNull$$$0(86);
        }
        return CidrTestUtils.createRunConfiguration(name, type, buildTargetAndConfigurationData, temporary, shared, this.getProject(), configurator);
    }

    protected RunnerAndConfigurationSettings createRunConfiguration(@NotNull RunnerAndConfigurationSettings settings, @Nullable BuildTargetAndConfigurationData buildTargetAndConfigurationData, boolean temporary, boolean shared, @Nullable Consumer<CidrRunConfiguration<?, ?>> configurator) {
        if (settings == null) {
            CidrProjectFixture.$$$reportNull$$$0(87);
        }
        return CidrTestUtils.createRunConfiguration(settings, buildTargetAndConfigurationData, temporary, shared, this.getProject(), configurator);
    }

    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull ConfigurationTypeBase type, @Nullable BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration<?, ?>> configurator) throws Exception {
        if (type == null) {
            CidrProjectFixture.$$$reportNull$$$0(88);
        }
        return this.createRunConfiguration("__test__", type, buildTargetAndConfigurationData, true, true, configurator);
    }

    @NotNull
    public abstract CidrWorkspace getCidrWorkspace();

    public final // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull OCWorkspace.ModifiableModel getWorkspaceModifiableModel() {
        OCWorkspace.ModifiableModel modifiableModel = this.getWorkspaceModifiableModel(false);
        if (modifiableModel == null) {
            CidrProjectFixture.$$$reportNull$$$0(89);
        }
        return modifiableModel;
    }

    public abstract // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull OCWorkspace.ModifiableModel getWorkspaceModifiableModel(boolean var1);

    public void changeContentRoot(@NotNull VirtualFile root) {
        if (root == null) {
            CidrProjectFixture.$$$reportNull$$$0(90);
        }
        WriteAction.runAndWait(() -> this.getCidrWorkspace().changeContentRootBlocking(root));
    }

    @NotNull
    public String getProjectName() {
        String string = this.getProject().getName();
        if (string == null) {
            CidrProjectFixture.$$$reportNull$$$0(91);
        }
        return string;
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        Disposable disposable = this.myProjectDisposable;
        if (disposable == null) {
            CidrProjectFixture.$$$reportNull$$$0(92);
        }
        return disposable;
    }

    private void waitForProjectModel(final @NotNull Project project) {
        if (project == null) {
            CidrProjectFixture.$$$reportNull$$$0(93);
        }
        final ArrayList stateChangeLog = new ArrayList();
        AtomicBoolean value2 = new AtomicBoolean(false);
        Function0 valueUpdater = () -> {
            value2.set(true);
            return null;
        };
        new InitializationWaiter(project){

            protected boolean isInitialized() {
                return CidrProjectFixture.this.projectModelsAreReady(project);
            }

            protected void subscribeToInitialization(@NotNull Project project2, @NotNull Disposable parentDisposable, final @NotNull Function0 callBack) {
                if (project2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (parentDisposable == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (callBack == null) {
                    4.$$$reportNull$$$0(2);
                }
                project2.getMessageBus().connect(parentDisposable).subscribe(CidrWorkspaceListener.TOPIC, (Object)new CidrWorkspaceListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void workspaceStateChanged(@NotNull CidrWorkspace workspace, @NotNull CidrWorkspaceState oldState, @NotNull CidrWorkspaceState newState, @NotNull Map<CidrWorkspace, ? extends CidrWorkspaceState> allWorkspaces) {
                        if (workspace == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (oldState == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (newState == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (allWorkspaces == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        List list = stateChangeLog;
                        synchronized (list) {
                            stateChangeLog.add(String.valueOf(workspace) + ", oldState = " + String.valueOf(oldState) + ", newState = " + String.valueOf(newState) + ", modelIsReady = " + this.isInitialized() + ", time = " + String.valueOf(LocalTime.now()));
                        }
                        callBack.invoke();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "workspace";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "oldState";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "newState";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[0] = "allWorkspaces";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/cidr/CidrProjectFixture$4$1";
                        objectArray[2] = "workspaceStateChanged";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parentDisposable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callBack";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/CidrProjectFixture$4";
                objectArray[2] = "subscribeToInitialization";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.waitForInitialization(this.getTestRootDisposable(), valueUpdater);
        WaitUtilKt.waitForEvent((Function0<Boolean>)((Function0)() -> value2.get()), (Function0<String>)((Function0)() -> CidrProjectFixture.generateProjectModelTimeoutErrorMessage(project, stateChangeLog)));
    }

    protected boolean projectModelsAreReady(@NotNull Project project) {
        if (project == null) {
            CidrProjectFixture.$$$reportNull$$$0(94);
        }
        return CidrWorkspaceManager.getInstance((Project)project).getModelsAreReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static String generateProjectModelTimeoutErrorMessage(@NotNull Project project, @NotNull List<String> stateChangeLog) {
        if (project == null) {
            CidrProjectFixture.$$$reportNull$$$0(95);
        }
        if (stateChangeLog == null) {
            CidrProjectFixture.$$$reportNull$$$0(96);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Waiting for project model for too long, Aborting.\n");
        builder.append("  ").append(project).append("\n");
        CidrWorkspaceManager workspaceManager = CidrWorkspaceManager.getInstance((Project)project);
        builder.append(workspaceManager.dumpWorkspaceState());
        builder.append("State change log:\n");
        List<String> list = stateChangeLog;
        synchronized (list) {
            for (String s : stateChangeLog) {
                builder.append("  ").append(s).append("\n");
            }
        }
        builder.append("End\n");
        String string = builder.toString();
        if (string == null) {
            CidrProjectFixture.$$$reportNull$$$0(97);
        }
        return string;
    }

    private static /* synthetic */ void lambda$executeProjectTasks$51(ProjectTask task2, ProjectTaskManager taskManager, java.util.function.Consumer callback) {
        taskManager.run(task2).onProcessed(callback);
    }

    static {
        ourRunningFixture = false;
        ourAdditionalProjectCleanUpRunnableList = new SmartList();
        ourProjectTimingMap = new HashMap<ProjectTestData, ProjectTiming>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 17, 20, 22, 25, 26, 27, 28, 29, 30, 31, 32, 34, 35, 36, 37, 38, 39, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 62, 64, 71, 73, 75, 77, 78, 79, 80, 81, 89, 91, 92, 97 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openProjectOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFixture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
            case 4: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 89: 
            case 91: 
            case 92: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrProjectFixture";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassFQN";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeProjectPath";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescription";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeProjectFilePath";
                break;
            }
            case 21: 
            case 93: 
            case 94: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyDestination";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adjustedProjectDir";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedConfigNames";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 65: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 69: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildConfiguration";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateChangeLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrProjectFixture";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomizer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectInfo";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjustedProjectDir";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseProjectRunnable";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRoot";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRootPath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFilePath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectIODir";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDirPath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspace";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSubPath";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSubNIOPath";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findProjectSubIOFile";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSubFile";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSubPsiFile";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSubPsiDirectory";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "findModuleForFile";
                break;
            }
            case 44: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProjectFiles";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProjectFilesPaths";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilesFromPaths";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIOFiles";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilesPaths";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFullFilesPaths";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIOFilesPaths";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "formatConfigName";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstResolveConfiguration";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveConfiguration";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveConfigurationForTarget";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "collectResolveConfigurationsNames";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "addResolveConfiguration";
                break;
            }
            case 71: 
            case 73: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "buildIfNeeded";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanIfNeeded";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerType";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspaceModifiableModel";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRootDisposable";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProjectModelTimeoutErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setOpenProjectOptions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCleanProjectOption";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCustomizer";
                break;
            }
            case 4: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 89: 
            case 91: 
            case 92: 
            case 97: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setUp";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAllowedRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addProjectDependentFixture";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectDependentFixture";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initProject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "initProjectAsDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isProjectAlreadyOpened";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getProjectInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "measureTiming";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedProjectDir";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "projectChangedSomehow";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "afterTestDataCopied";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSubPath";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForFile";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "assertOrderedResolveConfigurations";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "collectResolveConfigurationsNames";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addResolveConfiguration";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "removeResolveConfiguration";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultFeatures64Bit";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createSearchPath";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getBuildConfiguration";
                break;
            }
            case 70: 
            case 72: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "buildIfNeeded";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "cleanIfNeeded";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "executeProjectTask";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "executeProjectTasks";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfiguration";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "changeContentRoot";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "waitForProjectModel";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "projectModelsAreReady";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "generateProjectModelTimeoutErrorMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 17, 20, 22, 25, 26, 27, 28, 29, 30, 31, 32, 34, 35, 36, 37, 38, 39, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 62, 64, 71, 73, 75, 77, 78, 79, 80, 81, 89, 91, 92, 97 -> new IllegalStateException(string);
        };
    }

    public static enum CleanProjectOption {
        DO_NOT_CLEAN,
        CLEAN_EACH_TIME,
        CLEAN_FOR_TESTCASE;

    }

    public static enum OpenProjectKind {
        AS_SPECIFIED_FILE,
        AS_DOT_IDEA,
        AS_RECENT,
        AS_DIRECTORY;

    }

    private static class ProjectInfo {
        String adjustedRelativeProjectPath;
        String adjustedRelativePathToCopy;
        ProjectTestData testData = new ProjectTestData();
        boolean isSymlinked;
        Class<? extends CidrTestDataFixture> testDataFixtureClass;
        Object cleanKey;

        private ProjectInfo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectInfo info = (ProjectInfo)o;
            if (!Objects.equals(this.testData, info.testData)) {
                return false;
            }
            if (!Objects.equals(this.cleanKey, info.cleanKey)) {
                return false;
            }
            if (!Objects.equals(this.testDataFixtureClass, info.testDataFixtureClass)) {
                return false;
            }
            return this.isSymlinked == info.isSymlinked;
        }

        public int hashCode() {
            int result = this.testData.hashCode();
            result = 31 * result + Objects.hashCode(this.cleanKey);
            result = 31 * result + Objects.hashCode(this.testDataFixtureClass);
            result = 31 * result + (this.isSymlinked ? 1 : 0);
            return result;
        }

        public String toString() {
            return "ProjectInfo{adjustedRelativeProjectPath='" + this.adjustedRelativeProjectPath + "', adjustedRelativePathToCopy='" + this.adjustedRelativePathToCopy + "', testData=" + String.valueOf(this.testData) + ", isSymlinked=" + this.isSymlinked + ", cleanKey=" + String.valueOf(this.cleanKey) + "}";
        }
    }

    private static class ProjectTestData {
        File adjustedProjectDir;
        File projectDir;
        File dirToCopy;

        private ProjectTestData() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectTestData data = (ProjectTestData)o;
            if (!FileUtil.filesEqual((File)this.adjustedProjectDir, (File)data.adjustedProjectDir)) {
                return false;
            }
            if (!FileUtil.filesEqual((File)this.dirToCopy, (File)data.dirToCopy)) {
                return false;
            }
            return FileUtil.filesEqual((File)this.projectDir, (File)data.projectDir);
        }

        public int hashCode() {
            int result = FileUtil.fileHashCode((File)this.adjustedProjectDir);
            result = 31 * result + FileUtil.fileHashCode((File)this.projectDir);
            result = 31 * result + FileUtil.fileHashCode((File)this.dirToCopy);
            return result;
        }

        public String toString() {
            return "ProjectTestData{adjustedProjectDir=" + String.valueOf(this.adjustedProjectDir) + ", projectDir=" + String.valueOf(this.projectDir) + ", dirToCopy=" + String.valueOf(this.dirToCopy) + "}";
        }
    }

    private static class ProjectTiming {
        final Map<String, Step> steps = new LinkedHashMap<String, Step>();

        private ProjectTiming() {
        }

        private static class Step {
            long first = -1L;
            long total = -1L;
            int performedTimes = 0;

            private Step() {
            }
        }
    }
}

