/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableRunnable;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.jetbrains.cidr.CidrDebuggerPerformanceProjectMarkup;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrRegressionFixture;
import com.jetbrains.cidr.CidrRegressionFixtureBase;
import com.jetbrains.cidr.CidrRegressionTest;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.ProjectDescription;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingTestCase;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public abstract class CidrDebuggingPerformanceTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrDebuggingTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CidrDebuggerPerformanceProjectMarkup> {
    protected ProjectDescription myProjectDescription;
    protected CidrRegressionFixture myRegressionFixture;

    public CidrDebuggingPerformanceTestCase(@NotNull ProjectDescription projectDescription, DebuggerDriverKind backend, String targetName) {
        if (projectDescription == null) {
            CidrDebuggingPerformanceTestCase.$$$reportNull$$$0(0);
        }
        super(backend, targetName, projectDescription.projectFile, projectDescription.projectBundle);
        this.myProjectDescription = projectDescription;
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myRegressionFixture = new CidrRegressionFixture(this.isPerformanceTest(), this, this.myProjectDescription, this.myTestDataFixture, this.myProjectFixture);
        this.myRegressionFixture.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myRegressionFixture.tearDown();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    @NotNull
    protected CidrDebuggerPerformanceProjectMarkup createProjectMarkup(@NotNull VirtualFile projectDir) throws Exception {
        if (projectDir == null) {
            CidrDebuggingPerformanceTestCase.$$$reportNull$$$0(1);
        }
        return new CidrDebuggerPerformanceProjectMarkup(projectDir);
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrTestDataFixture(CidrTestDataFixture.getDebuggerTestData().toFile());
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testStartup() throws Exception {
        this.myRegressionFixture.testPerformance(this.getChartName("Startup"), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> {
            XDebuggerTestUtil.toggleBreakpoint(this.getProject(), ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
            this.startDebugSessionAndWaitForPause();
        }));
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testStartupAndShutdown() throws Exception {
        this.myRegressionFixture.testPerformance(this.getChartName("Startup and shutdown"), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> {
            ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSession(new XDebugSessionListener[0]);
            CidrDebuggingPerformanceTestCase.assertTrue((boolean)CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler()));
        }));
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testSteppingWithCData() throws Exception {
        this.doTestSteppingWithVariables("stepping_c", ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_C, "Stepping with c data", false, 31);
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testSteppingWithExpandedClasses() throws Exception {
        this.doTestSteppingWithVariables("stepping_classes", ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_CLASSES, "Stepping with expanded classes", true, 11);
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testSteppingWithArrays() throws Exception {
        this.doTestSteppingWithVariables("stepping_arrays", ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_ARRAYS, "Stepping with arrays", false, 11);
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testSteppingWithExpandedArrays() throws Exception {
        this.doTestSteppingWithVariables("stepping_arrays", ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_ARRAYS, "Stepping with expanded arrays", true, 11);
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testExpandingArrays() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint(this.getProject(), ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_ARRAYS);
        this.startDebugSessionAndWaitForPause("stepping_arrays");
        this.myRegressionFixture.testPerformance(this.getChartName("Expanding arrays"), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> this.doTestListingsVariables(true, 11)));
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testExpandingPointers() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint(this.getProject(), ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_POINTERS);
        this.startDebugSessionAndWaitForPause("stepping_pointers");
        this.myRegressionFixture.testPerformance(this.getChartName("Expanding pointers"), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> this.doTestListingsVariables(2, 12)));
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testSteppingWithStrings() throws Exception {
        this.doTestSteppingWithVariables("stepping_strings", ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_STRINGS, "Stepping with strings", false, 32);
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testSteppingWithSTLCollections() throws Exception {
        this.doTestSteppingWithVariables("stepping_stl_collections", ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_STL_COLLECTIONS, "Stepping with STL collections", false, 19);
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testSteppingWithExpandedSTLCollections() throws Exception {
        this.doTestSteppingWithVariables("stepping_stl_collections", ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_STL_COLLECTIONS, "Stepping with expanded STL collections", true, 19);
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testSteppingWithDeepStacks() throws Exception {
        this.doTestSteppingWithVariables("stepping_deep_stack", ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_DEEP_STACK, "Stepping with deep stacks", false, 1);
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testCollectingDeepStacks() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint(this.getProject(), ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_DEEP_STACK);
        this.startDebugSessionAndWaitForPause("stepping_deep_stack");
        this.myRegressionFixture.testPerformance(this.getChartName("Collecting deep stacks"), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> {
            List<XStackFrame> frames = ((CidrDebuggingFixture)this.myDebuggingFixture).collectFrames();
            int size = frames.size();
            CidrDebuggingPerformanceTestCase.assertTrue((String)("Size: " + size), (size > 10000 && size < 10020 ? 1 : 0) != 0);
            for (XStackFrame each : frames) {
                CidrDebuggingFixture.computeFramePresentation(each);
            }
        }));
    }

    @CidrRegressionTest(value=CidrRegressionTest.Chain.INITIAL)
    @Test
    public void testSteppingWithNoData() throws Exception {
        this.doTestStepping("stepping_no_data", ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebuggerPerformanceProjectMarkup)this.myProjectMarkup).LINE_STEPPING_NO_DATA, "Stepping with no data", 100, (ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {}));
    }

    public void doTestSteppingWithVariables(String functionName, VirtualFile file, int breakpointLine, String chartName, boolean expandVariables, int expectedVariables) throws Exception {
        this.doTestStepping(functionName, file, breakpointLine, chartName, 10, (ThrowableRunnable<Exception>)((ThrowableRunnable)() -> this.doTestListingsVariables(expandVariables, expectedVariables)));
    }

    public void doTestStepping(String functionName, VirtualFile file, int breakpointLine, String chartName, int steps, @Nullable ThrowableRunnable<? extends Exception> onEveryStep) throws Exception {
        XDebuggerTestUtil.toggleBreakpoint(this.getProject(), file, breakpointLine);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause(functionName);
        this.myRegressionFixture.testPerformance(this.getChartName(chartName), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> {
            for (int i = 0; i < steps; ++i) {
                if (onEveryStep != null) {
                    onEveryStep.run();
                }
                this.getSession().resume();
                if (i >= steps - 1) continue;
                CidrDebuggingPerformanceTestCase.assertEquals((Object)CidrDebuggingFixture.DebuggerState.RESUMED, CidrExecutionFixture.waitFor(state));
                CidrDebuggingPerformanceTestCase.assertEquals((Object)CidrDebuggingFixture.DebuggerState.PAUSED, CidrExecutionFixture.waitFor(state));
            }
        }));
    }

    private CidrRegressionFixtureBase.CurveOnChart getChartName(String chartName) {
        return CidrRegressionFixtureBase.curveOnChart(chartName, this.myBackend.getName() + " | " + this.myTargetName);
    }

    public void doTestListingsVariables(boolean expandChildren, int expectedVariables) throws Exception {
        this.doTestListingsVariables(expandChildren ? 1 : 0, expectedVariables);
    }

    public void doTestListingsVariables(int expandChildren, int expectedVariables) throws Exception {
        List<XValue> vars = this.collectVars(0);
        CidrDebuggingPerformanceTestCase.assertSize(expectedVariables, vars);
        for (XValue eachVar : vars) {
            XDebuggerTestUtil.computePresentation(eachVar);
            for (int i = 0; i < expandChildren; ++i) {
                for (XValue eachChild : XDebuggerTestUtil.collectChildren((XValueContainer)eachVar)) {
                    XDebuggerTestUtil.computePresentation(eachChild);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescription";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/CidrDebuggingPerformanceTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createProjectMarkup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

