/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.incorrectFormatting.IncorrectFormattingInspection;
import com.intellij.codeInspection.longLine.LongLineInspection;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.grazie.spellcheck.GrazieSpellCheckingInspection;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.InconsistentLineSeparatorsInspection;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.intellij.testFramework.fixtures.CompletionAutoPopupTester;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.icons.RowIcon;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrCodeInsightFixtureAdapter;
import com.jetbrains.cidr.CidrCodeInsightFixtureMarker;
import com.jetbrains.cidr.CidrExternalAnnotationsProvider;
import com.jetbrains.cidr.CidrProjectDependentFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestUtils;
import com.jetbrains.cidr.TestAnnotationInfoList;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.daemon.OCBasicHighlighter;
import com.jetbrains.cidr.lang.daemon.OCHiddenNonVirtualFunctionAnnotator;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.daemon.TestAnnotationHolder;
import com.jetbrains.cidr.lang.inspections.CidrInspectionToolProvider;
import com.jetbrains.cidr.lang.inspections.OCChecksSettings;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureProcessor;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.util.ClangdCommonUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import icons.CidrLangIcons;
import icons.CidrProjectModelIcons;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CidrCodeInsightFixture
implements CidrProjectDependentFixture,
CidrCodeInsightFixtureMarker {
    public static final String FND = "#import \"foundation.h\"\n";
    public static final String SIZE_T_DEFINITION = "typedef unsigned int size_t; namespace std { typedef unsigned int size_t; }\n";
    public static final Key<Object> DISABLE_CLANG_ERRORS = Key.create((String)"DISABLE_CLANG_ERRORS");
    public static final Key<Object> ENABLE_CLANG_WARNINGS = Key.create((String)"DISABLE_CLANG_WARNINGS");
    @NotNull
    protected CidrProjectFixture myProjectFixture;
    @NotNull
    protected CidrCodeInsightFixtureAdapter myProjectAdapter;
    @Nullable
    protected CodeInsightTestFixture myFixture;
    @Nullable
    private CompletionAutoPopupTester myCompletionAutoPopupTester;
    @Nullable
    private final String myTestFilesPath;
    @Nullable
    private String myTestFilesExtension;
    private final Set<VirtualFile> myCreatedFiles;
    private final Map<VirtualFile, String> myUpdatedFiles;
    private final List<FileTracker> myFileCreationTrackers;
    private static final Map<Icon, String> ICON_TO_TEXT = new HashMap<Icon, String>();

    public CidrCodeInsightFixture(@NotNull CidrProjectFixture projectFixture2, @NotNull CidrCodeInsightFixtureAdapter projectAdapter) {
        if (projectFixture2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(0);
        }
        if (projectAdapter == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(1);
        }
        this(projectFixture2, projectAdapter, null, null);
    }

    public CidrCodeInsightFixture(@NotNull CidrProjectFixture projectFixture2, @NotNull CidrCodeInsightFixtureAdapter projectAdapter, @Nullable String testFilesPath, @Nullable String testFilesExtension) {
        if (projectFixture2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(2);
        }
        if (projectAdapter == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(3);
        }
        this.myCreatedFiles = new HashSet<VirtualFile>();
        this.myUpdatedFiles = new HashMap<VirtualFile, String>();
        this.myFileCreationTrackers = new ArrayList<FileTracker>();
        this.myProjectFixture = projectFixture2;
        this.myProjectAdapter = projectAdapter;
        this.myTestFilesPath = testFilesPath;
        this.myTestFilesExtension = testFilesExtension;
    }

    public Annotator @NotNull [] getTestAnnotators() {
        Annotator[] annotatorArray = new Annotator[]{new OCBasicHighlighter(), new OCHiddenNonVirtualFunctionAnnotator()};
        if (annotatorArray == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(4);
        }
        return annotatorArray;
    }

    public void addFileTracker(@NotNull FileTracker tracker) {
        if (tracker == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(5);
        }
        this.myFileCreationTrackers.add(tracker);
    }

    public void removeFileTracker(@NotNull FileTracker tracker) {
        if (tracker == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(6);
        }
        this.myFileCreationTrackers.remove(tracker);
    }

    @Nullable
    public String getTestFilesPath() {
        return this.myTestFilesPath;
    }

    public void setTestFilesExtension(@Nullable String extension) {
        this.myTestFilesExtension = extension;
    }

    @Override
    public void setUp() throws Exception {
        this.myProjectFixture.addProjectDependentFixture(this);
        CidrTestListUpdater.setSchedulingDisabledInTests((Boolean)true);
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
        if (symbolsKind == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(7);
        }
        return symbolsKind;
    }

    @Override
    public void tearDown() throws Exception {
        this.myProjectFixture.removeProjectDependentFixture(this);
        CidrTestListUpdater.setSchedulingDisabledInTests(null);
    }

    @Override
    public void afterProjectOpened() throws Exception {
        IdeaProjectTestFixture ideaProjectTestFixture = new IdeaProjectTestFixture(){

            @Override
            public Project getProject() {
                return CidrCodeInsightFixture.this.myProjectFixture.getProject();
            }

            @Override
            public Module getModule() {
                return ModuleManager.getInstance((Project)this.getProject()).getModules()[0];
            }

            @Override
            public void setUp() {
            }

            @Override
            public void tearDown() {
            }
        };
        TempDirTestFixtureImpl dirTestFixture = new TempDirTestFixtureImpl(){

            @Override
            protected Path getTempHome() {
                ManagingFS.getInstance();
                return CidrCodeInsightFixture.this.myProjectFixture.getProjectIODir();
            }

            @Override
            public Path createTempFile(@NotNull String path) throws IOException {
                if (path == null) {
                    2.$$$reportNull$$$0(0);
                }
                return 2.createEmptyTempFile(this.getTempHome(), path);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/CidrCodeInsightFixture$2", "createTempFile"));
            }
        };
        CidrCodeInsightTextFixture fixture = this.createTestFixture(ideaProjectTestFixture, dirTestFixture);
        this.setFixture(fixture);
        Project project = this.getProject();
        OCCompilerFeatures.resetFeatures((Project)project);
        project.putUserData(OCChecksSettings.UNUSED_CHECKS, (Object)OCChecksSettings.UnusedChecksMode.DISABLED);
        project.putUserData(OCChecksSettings.UNUSED_EXPRESSION_CHECKS, (Object)OCChecksSettings.UnusedChecksMode.DISABLED);
        project.putUserData(OCChecksSettings.DFA_UNUSED_CHECKS, (Object)OCChecksSettings.UnusedChecksMode.DISABLED);
        project.putUserData(OCChecksSettings.DFA_UNREACHABLE_CODE, (Object)false);
        project.putUserData(OCChangeSignatureProcessor.CHECK_CONFLICTS, (Object)Boolean.TRUE);
        project.putUserData(OCNewFileActionBase.FILE_FACTORY, (Object)new OCNewFileActionBase.FileFactory(){

            public PsiFile createFileFromText(@NotNull String fileName, @Nullable FileType fileType, @NotNull String text2) {
                if (fileName == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (text2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                TestCase.assertEquals((Object)OCFileType.INSTANCE, (Object)fileType);
                try {
                    text2 = text2.replaceAll("#import <Foundation/Foundation.h>\n", CidrCodeInsightFixture.FND);
                    return CidrCodeInsightFixture.this.configureByText(text2, fileName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fileName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$3";
                objectArray[2] = "createFileFromText";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        WriteAction.runAndWait(() -> {
            for (PsiFile each : PsiManagerEx.getInstanceEx((Project)project).getFileManager().getAllCachedFiles()) {
                if (!(each instanceof PsiFileImpl)) continue;
                each.clearCaches();
            }
        });
        CodeStyle.setTemporarySettings((Project)this.getProject(), (CodeStyleSettings)CodeStyle.createTestSettings());
        this.getOCSettings().INTRODUCE_GENERATE_PROPERTY = true;
        this.myCompletionAutoPopupTester = new CompletionAutoPopupTester(this.getFixture());
    }

    @NotNull
    protected CidrCodeInsightTextFixture createTestFixture(@NotNull IdeaProjectTestFixture ideaProjectTestFixture, @NotNull TempDirTestFixtureImpl dirTestFixture) {
        if (ideaProjectTestFixture == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(8);
        }
        if (dirTestFixture == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(9);
        }
        return new CidrCodeInsightTextFixture(ideaProjectTestFixture, dirTestFixture);
    }

    private void prepareVirtualFile(@NotNull VirtualFile file) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(10);
        }
        for (FileTracker tracker : this.myFileCreationTrackers) {
            tracker.onCreated(file);
        }
    }

    private void setFixture(@Nullable CodeInsightTestFixture fixture) throws Exception {
        if (this.myFixture != null) {
            this.myFixture.tearDown();
        }
        this.myFixture = fixture;
        if (this.myFixture != null) {
            if (this.myTestFilesPath != null) {
                this.myFixture.setTestDataPath(this.myTestFilesPath);
            }
            this.myFixture.setUp();
        }
    }

    @Override
    public void beforeProjectClosed() throws Exception {
        this.deleteCreatedFiles();
        Project project = this.getProject();
        project.putUserData(OCChecksSettings.UNUSED_CHECKS, null);
        project.putUserData(OCChecksSettings.UNUSED_EXPRESSION_CHECKS, null);
        project.putUserData(OCChecksSettings.DFA_UNUSED_CHECKS, null);
        project.putUserData(OCChecksSettings.DFA_UNREACHABLE_CODE, null);
        project.putUserData(OCChangeSignatureProcessor.CHECK_CONFLICTS, null);
        project.putUserData(OCNewFileActionBase.FILE_FACTORY, null);
        OCCompilerFeatures.resetFeatures((Project)project);
        CodeStyle.dropTemporarySettings((Project)project);
        this.setFixture(null);
    }

    public void deleteCreatedFiles() {
        WriteAction.runAndWait(() -> {
            for (Map.Entry<VirtualFile, String> entry : this.myUpdatedFiles.entrySet()) {
                if (!entry.getKey().isValid()) continue;
                this.doWriteToExistingFile(entry.getKey(), entry.getValue());
            }
            this.myUpdatedFiles.clear();
            for (VirtualFile virtualFile : this.myCreatedFiles) {
                this.deleteCreatedFile(virtualFile);
            }
            this.myCreatedFiles.clear();
        });
    }

    private void deleteCreatedFile(@NotNull VirtualFile each) {
        if (each == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(11);
        }
        if (!each.isValid()) {
            return;
        }
        if (each instanceof VirtualFileWindow) {
            each = ((VirtualFileWindow)each).getDelegate();
        }
        this.removeFileFromProject(each, false);
        FileEditorManager.getInstance((Project)this.getProject()).closeFile(each);
        try {
            each.delete((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertCMakeFindUsages(CharSequence fileText, int expectedUsagesCount, Pair<String, Class<?>> ... usages) throws Exception {
        UsefulTestCase.assertEquals((int)expectedUsagesCount, (int)usages.length);
        File tempCMakeFile = FileUtil.createTempFile((File)new File(this.getProject().getBasePath()), (String)"test", (String)".cmake");
        try {
            this.configureByText(CidrTestUtils.trimMargin(fileText.toString()), tempCMakeFile.getName());
            PsiElement resolved = TargetElementUtilBase.findTargetElement((Editor)this.myFixture.getEditor(), (int)3, (int)this.myFixture.getEditor().getCaretModel().getOffset());
            Assert.assertNotNull((Object)resolved);
            FindUsagesHandler handler = ((FindManagerImpl)FindManager.getInstance((Project)this.getProject())).getFindUsagesManager().getFindUsagesHandler(resolved, false);
            Assert.assertNotNull((Object)handler);
            FindUsagesOptions options = handler.getFindUsagesOptions();
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
            LinkedHashSet<PsiElement> results = new LinkedHashSet<PsiElement>();
            for (PsiElement element : handler.getPrimaryElements()) {
                results.add(element);
                handler.processElementUsages(element, (Processor)processor, options);
            }
            for (PsiElement element : handler.getSecondaryElements()) {
                results.add(element);
                handler.processElementUsages(element, (Processor)processor, options);
            }
            for (UsageInfo usage : processor.getResults()) {
                results.add(usage.getElement());
            }
            UsefulTestCase.assertEquals((int)expectedUsagesCount, (int)results.size());
            ContainerUtil.zip(results, Arrays.stream(usages).toList()).forEach(it -> {
                PsiElement actualElement = (PsiElement)it.first;
                Pair expectedInfo = (Pair)it.second;
                Assert.assertNotNull((Object)actualElement);
                UsefulTestCase.assertEquals((String)((String)expectedInfo.getFirst()), (String)actualElement.getText());
                UsefulTestCase.assertInstanceOf(actualElement, (Class)expectedInfo.getSecond());
            });
        }
        finally {
            Assert.assertTrue((boolean)tempCMakeFile.delete());
        }
    }

    public void removeFilesFromProject(PsiFile ... files) {
        for (PsiFile file : files) {
            this.removeFileFromProject(file.getVirtualFile());
        }
    }

    public void addFileToProject(@NotNull VirtualFile file, boolean forceCachesReset) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(12);
        }
        EdtTestUtil.runInEdtAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile fileToAdd = file;
            while (true) {
                if (!(fileToAdd instanceof VirtualFileWindow)) {
                    this.myProjectAdapter.addFileToProject(fileToAdd);
                    this.resetFileCaches(fileToAdd, forceCachesReset);
                    return;
                }
                fileToAdd = ((VirtualFileWindow)fileToAdd).getDelegate();
            }
        }));
        IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
    }

    public void removeFileFromProject(@NotNull VirtualFile file) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(13);
        }
        this.removeFileFromProject(file, true);
    }

    public void removeFileFromProject(@NotNull VirtualFile file, boolean forceCachesReset) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(14);
        }
        EdtTestUtil.runInEdtAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            this.myProjectAdapter.removeFileFromProject(file);
            this.resetFileCaches(file, forceCachesReset);
        }));
    }

    public CodeStyleSettings getCodeStyleSettings() {
        return CodeStyle.getSettings((Project)this.getProject());
    }

    public CommonCodeStyleSettings getOCCommonSettings() {
        return this.getCodeStyleSettings().getCommonSettings(LanguageUtils.getInstance().getConfigLanguage());
    }

    public OCCodeStyleSettings getOCSettings() {
        return (OCCodeStyleSettings)this.getCodeStyleSettings().getCustomSettings(OCCodeStyleSettings.class);
    }

    public void resetFileCaches(@NotNull VirtualFile file, boolean resetSymbols) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(15);
        }
        if (!file.isValid()) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        Assert.assertNotNull((Object)psiFile);
        psiFile.clearCaches();
        if (resetSymbols) {
            this.myProjectFixture.getCustomizer().resetSymbols(this.getProject(), psiFile, true);
        }
    }

    @NotNull
    public CodeInsightTestFixture getFixture() {
        Assert.assertNotNull((String)"trying to access non-initialized code fixture", (Object)this.myFixture);
        CodeInsightTestFixture codeInsightTestFixture = this.myFixture;
        if (codeInsightTestFixture == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(16);
        }
        return codeInsightTestFixture;
    }

    public void setCaresAboutInjectionIfFixtureIsInitialized(boolean value2) {
        CodeInsightTestFixture fixture = this.myFixture;
        if (fixture != null) {
            fixture.setCaresAboutInjection(value2);
        }
    }

    public Project getProject() {
        return this.myProjectFixture.getProject();
    }

    public Editor getEditor() {
        return this.getFixture().getEditor();
    }

    public PsiFile getFile() {
        PsiFile file = this.getFixture().getFile();
        if (file == null) {
            return null;
        }
        VirtualFile mayBeInjectedVFile = file.getViewProvider().getVirtualFile();
        while (mayBeInjectedVFile instanceof VirtualFileWindow) {
            mayBeInjectedVFile = ((VirtualFileWindow)mayBeInjectedVFile).getDelegate();
        }
        VirtualFile hostFile = mayBeInjectedVFile;
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(hostFile));
    }

    public OCFile getOCFile() {
        return (OCFile)this.getFile(LanguageUtils.getInstance().getSlowLanguage());
    }

    @NotNull
    public PsiFile getFile(@NotNull Language language) {
        if (language == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(17);
        }
        PsiFile file = this.getFile().getViewProvider().getPsi(language);
        Assert.assertNotNull((Object)file);
        PsiFile psiFile = file;
        if (psiFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(18);
        }
        return psiFile;
    }

    public Document getDocument() {
        return this.getFixture().getDocument(this.getFile());
    }

    public int getCaretOffset() {
        return this.getFixture().getCaretOffset();
    }

    public TextRange getSelection() {
        SelectionModel sm = this.getEditor().getSelectionModel();
        return sm.hasSelection() ? new TextRange(sm.getSelectionStart(), sm.getSelectionEnd()) : this.getFile().getTextRange();
    }

    @Nullable
    public PsiElement resolveElementAtCaret(@NotNull PsiFile file) {
        PsiReference reference;
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(19);
        }
        return (reference = this.findReferenceAtCaret(file)) != null ? reference.resolve() : null;
    }

    @Nullable
    public PsiReference findReferenceAtCaret(@NotNull PsiFile file) {
        PsiElement elementAtCaret;
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(20);
        }
        for (elementAtCaret = this.findElementAtCaret(file); elementAtCaret != null && elementAtCaret.getReference() == null; elementAtCaret = elementAtCaret.getParent()) {
        }
        return elementAtCaret != null ? elementAtCaret.getReference() : null;
    }

    @Nullable
    public <T extends PsiElement> T findElementByText(@NotNull String text2, @NotNull Language language, @NotNull Class<T> elementClass) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(21);
        }
        if (language == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(22);
        }
        if (elementClass == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(23);
        }
        PsiFile file = this.getFile(language);
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        Assert.assertNotNull((Object)document);
        int pos = document.getText().indexOf(text2);
        Assert.assertTrue((String)text2, (pos >= 0 ? 1 : 0) != 0);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(pos), elementClass);
    }

    @NotNull
    public PsiElement findElementAtCaret(PsiFile file) {
        PsiElement result = file.findElementAt(this.getFixture().getCaretOffset());
        Assert.assertNotNull((String)"Cannot find element at caret", (Object)result);
        PsiElement psiElement = result;
        if (psiElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(24);
        }
        return psiElement;
    }

    @NotNull
    public <T extends PsiElement> T findElementOfClassAtCaret(PsiFile file, Class<T> elementClass) {
        PsiElement element = this.findElementAtCaret(file);
        PsiElement result = PsiTreeUtil.getParentOfType((PsiElement)element, elementClass);
        Assert.assertNotNull((String)("Cannot find " + elementClass.getSimpleName() + " element at caret"), (Object)result);
        PsiElement psiElement = result;
        if (psiElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(25);
        }
        return (T)psiElement;
    }

    @NotNull
    public OCExpression findExpressionAtCaret(PsiFile file) {
        OCExpression oCExpression = this.findElementOfClassAtCaret(file, OCExpression.class);
        if (oCExpression == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(26);
        }
        return oCExpression;
    }

    @NotNull
    public <T extends PsiElement> T findNodeAtSelection(PsiFile file, Class<T> nodeClass) {
        if (PsiFile.class.isAssignableFrom(nodeClass)) {
            PsiFile psiFile = file;
            if (psiFile == null) {
                CidrCodeInsightFixture.$$$reportNull$$$0(27);
            }
            return (T)psiFile;
        }
        SelectionModel m = this.getFixture().getEditor().getSelectionModel();
        for (PsiElement elt = OCLanguageUtils.tryGetOCFile((PsiFile)file).findElementAt(m.getSelectionStart()); elt != null; elt = elt.getParent()) {
            TextRange range;
            if (!nodeClass.isAssignableFrom(elt.getClass()) || (range = elt.getTextRange()).getStartOffset() != m.getSelectionStart() || range.getEndOffset() != m.getSelectionEnd()) continue;
            PsiElement psiElement = elt;
            if (psiElement == null) {
                CidrCodeInsightFixture.$$$reportNull$$$0(28);
            }
            return (T)psiElement;
        }
        throw new AssertionFailedError("Cannot find " + nodeClass.getName() + " in exact range of selection");
    }

    @NotNull
    public OCExpression findExpressionAtSelection(PsiFile file) {
        OCExpression oCExpression = this.findNodeAtSelection(file, OCExpression.class);
        if (oCExpression == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(29);
        }
        return oCExpression;
    }

    public void checkFindUsages(String expected, String errorDetails, @Nullable SearchScope scope) {
        PsiElement targetElement = this.getFindUsageTargetElement(errorDetails);
        String res = this.findUsages(targetElement, scope);
        UsefulTestCase.assertEquals((String)("Wrong usages for referenced element: " + errorDetails), (String)expected.trim(), (String)res.trim());
    }

    public void checkFindUsagesOnNonDispatchThread(String expected, String errorDetails, @Nullable SearchScope scope) {
        PsiElement targetElement = this.getFindUsageTargetElement(errorDetails);
        final FindUsagesHandler handler = ((FindManagerImpl)FindManager.getInstance((Project)this.getProject())).getFindUsagesManager().getFindUsagesHandler(targetElement, false);
        String targetName = targetElement.toString();
        Assert.assertNotNull((String)("Cannot find handler for: " + targetName), (Object)handler);
        final CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        final PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler.getPrimaryElements(), (Object[])handler.getSecondaryElements());
        Future future = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(new Task.Backgroundable(this, this.getProject(), "hasNull"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    FindUsagesOptions options = handler.getFindUsagesOptions(null);
                    for (PsiElement psiElement : psiElements) {
                        handler.processElementUsages(psiElement, (Processor)processor, options);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/CidrCodeInsightFixture$4", "run"));
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            UsefulTestCase.fail((String)e.getMessage());
        }
        Collection usageInfos = processor.getResults();
        String res = this.usageInfosToString(usageInfos);
        UsefulTestCase.assertEquals((String)("Wrong usages for referenced element: " + errorDetails), (String)expected.trim(), (String)res.trim());
    }

    public String findUsages(@NotNull PsiElement targetElement) {
        if (targetElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(30);
        }
        return this.findUsages(targetElement, null);
    }

    public String findUsages(@NotNull PsiElement targetElement, @Nullable SearchScope scope) {
        if (targetElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(31);
        }
        Collection<UsageInfo> usages = ((CodeInsightTestFixtureImpl)this.getFixture()).findUsages(targetElement, scope);
        return this.usageInfosToString(usages);
    }

    private PsiElement getFindUsageTargetElement(@NotNull String errorDetails) {
        if (errorDetails == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(32);
        }
        PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)this.getEditor(), (int)TargetElementUtil.getInstance().getReferenceSearchFlags());
        Assert.assertNotNull((Object)targetElement);
        Assert.assertNotNull((String)("Cannot find referenced element: " + errorDetails), (Object)targetElement);
        return targetElement;
    }

    private String usageInfosToString(@NotNull Collection<UsageInfo> usages) {
        if (usages == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(33);
        }
        List results = ContainerUtil.sorted((Collection)ContainerUtil.map(usages, info -> {
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(info.getFile());
            int startOffset = info.getSegment().getStartOffset();
            int line = document.getLineNumber(startOffset);
            return info.getVirtualFile().getName() + ":" + (line + 1) + ":" + (startOffset - document.getLineStartOffset(line) + 1);
        }));
        return StringUtil.join((Collection)results, (String)"\n");
    }

    @Nullable
    public OCFile findOCFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(34);
        }
        return CidrCodeInsightFixture.findOCFile(relativePath, this.myProjectFixture);
    }

    @Nullable
    public static OCFile findOCFile(@NotNull String relativePath, @NotNull CidrProjectFixture projectFixture2) {
        PsiFile file;
        if (relativePath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(35);
        }
        if (projectFixture2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(36);
        }
        if ((file = projectFixture2.findProjectSubPsiFile(relativePath)) != null) {
            UsefulTestCase.assertInstanceOf(file, OCPsiFile.class);
            return ((OCPsiFile)file).getOCFile();
        }
        return null;
    }

    @Nullable
    public OCFile findProjectSubOCFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(37);
        }
        return this.findOCFile(relativePath);
    }

    @NotNull
    public OCFile getOCFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(38);
        }
        return CidrCodeInsightFixture.getOCFile(relativePath, this.myProjectFixture);
    }

    @NotNull
    public static OCFile getOCFile(@NotNull String relativePath, @NotNull CidrProjectFixture<?> projectFixture2) {
        if (relativePath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(39);
        }
        if (projectFixture2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(40);
        }
        OCFile result = CidrCodeInsightFixture.findOCFile(relativePath, projectFixture2);
        Assert.assertNotNull((String)("File not found: " + relativePath), (Object)result);
        OCFile oCFile = result;
        if (oCFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(41);
        }
        return oCFile;
    }

    @NotNull
    public OCFile getProjectSubOCFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(42);
        }
        OCFile oCFile = this.getOCFile(relativePath);
        if (oCFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(43);
        }
        return oCFile;
    }

    @Nullable
    public PsiFile findFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(44);
        }
        return this.myProjectFixture.findProjectSubPsiFile(relativePath);
    }

    @Nullable
    public VirtualFile findVirtualFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(45);
        }
        return this.myProjectFixture.findProjectSubFile(relativePath);
    }

    public void processOCFiles(final @NotNull PairProcessor<? super OCFile, ? super VirtualFile> processor, int expectedCount) {
        if (processor == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(46);
        }
        class CountingIterator
        implements ContentIterator {
            public int processed = 0;

            CountingIterator() {
            }

            public boolean processFile(@NotNull VirtualFile file) {
                if (file == null) {
                    CountingIterator.$$$reportNull$$$0(0);
                }
                if (file.isDirectory() || !OCFileTypeHelpers.isHeaderFile((String)file.getName()) && !OCFileTypeHelpers.isSourceFile((String)file.getName())) {
                    return true;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)CidrCodeInsightFixture.this.getProject()).findFile(file);
                Assert.assertNotNull((Object)psiFile);
                PsiDocumentManager.getInstance((Project)CidrCodeInsightFixture.this.getProject()).getDocument(psiFile);
                UsefulTestCase.assertInstanceOf(psiFile, OCFile.class);
                ++this.processed;
                return processor.process((Object)((OCFile)psiFile), (Object)file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/CidrCodeInsightFixture$1CountingIterator", "processFile"));
            }
        }
        CountingIterator iterator = new CountingIterator();
        ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().iterateContent((ContentIterator)iterator);
        TestCase.assertEquals((String)"Wrong number of files processed", (int)expectedCount, (int)iterator.processed);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(String name, @Nullable Class<T> clazz) {
        return (T)CidrTestUtil.findSymbol((String)name, clazz, (Project)this.getProject());
    }

    @NotNull
    public <T extends OCSymbol> List<T> findSymbols(String name, @Nullable Class<T> clazz) {
        List list = CidrTestUtil.findSymbols((String)name, clazz, (Project)this.getProject());
        if (list == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(47);
        }
        return list;
    }

    @NotNull
    public List<OCClassSymbol> findClassSymbols(String name, @Nullable String category) {
        List list = CidrTestUtil.findClassSymbols((String)name, (String)category, (Project)this.getProject());
        if (list == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(48);
        }
        return list;
    }

    public OCSymbol lookup(@NotNull PsiFile psiFile, @Nullable String symbolName, @NotNull OCLanguageKind kind) {
        if (psiFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(49);
        }
        if (kind == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(50);
        }
        FileSymbolTable table = FileSymbolTable.forFile((PsiFile)psiFile, (OCInclusionContext)OCInclusionContext.empty((OCLanguageKind)kind, (PsiFile)psiFile));
        Assert.assertNotNull((Object)table);
        OCSymbol[] answer = new OCSymbol[]{null};
        FileSymbolTable.ProcessingState state = new FileSymbolTable.ProcessingState(OCInclusionContext.empty((OCLanguageKind)kind, (PsiFile)psiFile), false);
        table.processSymbols(ocSymbol -> {
            answer[0] = ocSymbol;
            return true;
        }, symbolName, state, null, null, null);
        return answer[0];
    }

    public OCType parseTypeCpp(@NotNull String type) {
        if (type == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(51);
        }
        return this.parseDeclTypeCpp(type + " x;");
    }

    public OCType parseDeclTypeCpp(@NotNull CharSequence text2) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(52);
        }
        CLanguageKind kind = CLanguageKind.CPP;
        PsiFile psiFile = this.configureByText(text2.toString(), (OCLanguageKind)kind);
        OCType type = this.lookup(psiFile, "x", (OCLanguageKind)kind).getType().resolve((PsiElement)psiFile);
        return OCTypeCloneVisitor.cloneType((OCType)type, (OCTypeCloneVisitor)new OCTypeCloneVisitor(this, false){

            public OCType visitReferenceType(OCReferenceType type) {
                OCSymbolReference reference = type.getReference();
                OCReferenceTypeBuilder resultBuilder = new OCReferenceTypeBuilder(reference);
                resultBuilder.setProtocolSubstitutionARCFromType(type);
                resultBuilder.setConstVolatile(this.isConstCopy((OCType)type), this.isVolatileCopy((OCType)type));
                resultBuilder.setFunctionParameterType(type.isFunctionParameterType());
                resultBuilder.setIsKindof(type.isKindof());
                resultBuilder.setNullability(type.getNullability());
                return resultBuilder.build();
            }
        });
    }

    public OCType parseTypeObjC(@NotNull CharSequence text2) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(53);
        }
        CLanguageKind kind = CLanguageKind.OBJ_C;
        PsiFile psiFile = this.configureByText("#import <Foundation/Foundation.h>\n" + String.valueOf(text2) + " x;", (OCLanguageKind)kind);
        return this.lookup(psiFile, "x", (OCLanguageKind)kind).getType().resolve((PsiElement)psiFile);
    }

    @NotNull
    private static String textForExpression(@NotNull String text2) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(54);
        }
        String string = "#import \"foundation.h\"\n@implementation -(void) foo {\n    " + text2.trim() + ";\n} @end";
        if (string == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(55);
        }
        return string;
    }

    public PsiFile configureByExpressionOCpp(@NotNull String text2) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(56);
        }
        return this.configureByTextOCpp(CidrCodeInsightFixture.textForExpression(text2));
    }

    public PsiFile configureByExpressionOC(@NotNull String text2) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(57);
        }
        return this.configureByTextOC(CidrCodeInsightFixture.textForExpression(text2));
    }

    public PsiFile configureByTextC(@NotNull String text2) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(58);
        }
        return this.configureByText(text2, (OCLanguageKind)CLanguageKind.C);
    }

    public PsiFile configureByTextOCpp(@NotNull String text2) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(59);
        }
        return this.configureByText(text2, (OCLanguageKind)CLanguageKind.OBJ_CPP);
    }

    public PsiFile configureByTextCpp(@NotNull String text2) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(60);
        }
        return this.configureByText(text2, (OCLanguageKind)CLanguageKind.CPP);
    }

    public PsiFile configureByTextOC(@NotNull String text2) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(61);
        }
        return this.configureByText(text2, (OCLanguageKind)CLanguageKind.OBJ_C);
    }

    public PsiFile configureByText(@NotNull String text2, @NotNull OCLanguageKind languageKind) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(62);
        }
        if (languageKind == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(63);
        }
        Object file = this.configureByText(text2, "test." + languageKind.getDefaultSourceExtension());
        return file;
    }

    public PsiFile configureByTextOC(@NotNull String text2, @NotNull String fileName) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(64);
        }
        if (fileName == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(65);
        }
        Object file = this.configureByText(text2, fileName);
        return file;
    }

    public <T extends PsiFile> T configureByText(@NotNull String text2, @NotNull String fileName) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(66);
        }
        if (fileName == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(67);
        }
        return this.configureByText(text2, fileName, true);
    }

    @NotNull
    public <T extends PsiFile> T configureByText(@NotNull String text2, @NotNull String fileName, String directory) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(68);
        }
        if (fileName == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(69);
        }
        T t = this.configureByText(text2, fileName, directory, true);
        if (t == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(70);
        }
        return t;
    }

    public <T extends PsiFile> T configureByText(@NotNull String text2, @NotNull String fileName, boolean forceResetCaches) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(71);
        }
        if (fileName == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(72);
        }
        com.jetbrains.cidr.TestAnnotationHolder.findAndSetEnabledLanguageFeatures(text2, this.getProject());
        this.getProject().putUserData(ClangdCommonUtil.DISABLED_WARNINGS, com.jetbrains.cidr.TestAnnotationHolder.findDisabledClangWarnings(text2, this.getProject()));
        PsiFile existing = this.tryConfigureWithExistingFile(fileName, text2, forceResetCaches);
        if (existing != null) {
            return (T)existing;
        }
        VirtualFile file = this.getFixture().configureByText(fileName, text2).getVirtualFile();
        this.postConfigureByFile(file, forceResetCaches);
        return (T)this.getFile();
    }

    @NotNull
    public <T extends PsiFile> T configureByTextInExistingFile(@NotNull String text2, @NotNull String path) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(73);
        }
        if (path == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(74);
        }
        PsiFile psiFile = Objects.requireNonNull(this.tryConfigureWithExistingFile(path, text2, true));
        if (psiFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(75);
        }
        return (T)psiFile;
    }

    @NotNull
    public <T extends PsiFile> T configureByText(@NotNull String text2, @NotNull String fileName, @NotNull String directory, boolean forceResetCaches) {
        VirtualFile file;
        PsiFile existing;
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(76);
        }
        if (fileName == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(77);
        }
        if (directory == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(78);
        }
        if ((existing = this.tryConfigureWithExistingFile(directory + "/" + fileName, text2, forceResetCaches)) != null) {
            PsiFile psiFile = existing;
            if (psiFile == null) {
                CidrCodeInsightFixture.$$$reportNull$$$0(79);
            }
            return (T)psiFile;
        }
        try {
            file = (VirtualFile)WriteAction.computeAndWait(() -> {
                File dir = new File(String.valueOf(this.myProjectFixture.getProjectIODir()) + "/" + directory);
                Assert.assertTrue((boolean)FileUtil.createDirectory((File)dir));
                VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir).findOrCreateChildData((Object)this, fileName);
                VfsUtil.saveText((VirtualFile)vFile, (String)text2);
                com.jetbrains.cidr.TestAnnotationHolder.findAndSetEnabledLanguageFeatures(text2, this.getProject());
                this.getProject().putUserData(ClangdCommonUtil.DISABLED_WARNINGS, com.jetbrains.cidr.TestAnnotationHolder.findDisabledClangWarnings(text2, this.getProject()));
                this.getFixture().configureFromExistingVirtualFile(vFile);
                return vFile;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.postConfigureByFile(file, forceResetCaches);
        PsiFile psiFile = this.getFile();
        if (psiFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(80);
        }
        return (T)psiFile;
    }

    @Nullable
    protected PsiFile tryConfigureWithExistingFile(@NotNull String fileName, @NotNull String text2, boolean forceResetCaches) {
        VirtualFile existing;
        if (fileName == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(81);
        }
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(82);
        }
        if ((existing = this.findExistingFileAndSetText(fileName, text2)) == null) {
            return null;
        }
        return (PsiFile)WriteCommandAction.writeCommandAction((Project)this.getProject()).compute(() -> {
            this.myFixture.configureFromExistingVirtualFile(existing);
            this.prepareVirtualFile(existing);
            this.updateCaretOffset();
            this.resetFileCaches(existing, forceResetCaches);
            return this.getFile();
        });
    }

    private void postConfigureByFile(@NotNull VirtualFile virtualFile, boolean forceResetCaches) {
        if (virtualFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(83);
        }
        this.updateCreatedFiles(virtualFile, forceResetCaches);
        this.updateCaretOffset();
    }

    private void updateCaretOffset() {
        UIUtil.invokeAndWaitIfNeeded(() -> ReadAction.run(() -> {
            int selectionStart = this.getEditor().getSelectionModel().getSelectionStart();
            if (selectionStart > 0 && this.getEditor().getCaretModel().getOffset() == 0) {
                this.getEditor().getCaretModel().moveToOffset(selectionStart);
            }
        }));
    }

    private void updateCreatedFiles(@NotNull VirtualFile virtualFile, boolean forceResetCaches) {
        if (virtualFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(84);
        }
        this.myCreatedFiles.stream().filter(f -> f.getPath().equals(virtualFile.getPath())).forEach(this::removeFileFromProject);
        this.myCreatedFiles.add(virtualFile);
        this.addFileToProject(virtualFile, forceResetCaches);
    }

    @NotNull
    public PsiFile addFileToProject(String text2, String fileName) {
        VirtualFile file;
        VirtualFile existing = this.findExistingFileAndSetText(fileName, text2);
        if (existing != null) {
            this.prepareVirtualFile(existing);
            file = existing;
        } else {
            file = this.getFixture().addFileToProject(fileName, text2).getVirtualFile();
            this.updateCreatedFiles(file, true);
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(file));
        if (psiFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(85);
        }
        return psiFile;
    }

    @Nullable
    protected VirtualFile findExistingFileAndSetText(@NotNull String fileName, @NotNull String text2) {
        VirtualFile file;
        if (fileName == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(86);
        }
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(87);
        }
        if ((file = this.findVirtualFile(fileName)) == null) {
            return null;
        }
        OCResolveRootAndConfigurationCache.getInstance((Project)this.getProject()).invalidateFor(file);
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> this.doWriteToExistingFile(file, text2));
        return file;
    }

    private void doWriteToExistingFile(@NotNull VirtualFile file, @NotNull String text2) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(88);
        }
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(89);
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(file);
        Assert.assertNotNull((String)"File must be writeable", (Object)document);
        this.myUpdatedFiles.putIfAbsent(file, document.getText());
        if (documentManager.isDocumentUnsaved(document)) {
            documentManager.saveDocument(document);
        }
        Objects.requireNonNull(this.myFixture).saveText(file, text2);
    }

    public PsiFile configureByFile(String testName) throws Exception {
        return this.configureByFile(testName, "." + this.myTestFilesExtension, null);
    }

    public PsiFile configureByFile(String testName, String fileNameSuffix) throws Exception {
        return this.configureByFile(testName, fileNameSuffix, null);
    }

    protected PsiFile configureByFile(String testName, String fileNameSuffix, @Nullable String text2) throws Exception {
        String fileName = this.getFullFileName(testName, fileNameSuffix);
        if (text2 == null) {
            text2 = this.loadFile(fileName);
        }
        Object file = this.configureByText(text2, fileName);
        return file;
    }

    @NotNull
    public String loadFile(@TestDataFile String name) throws IOException {
        String string = CidrCodeInsightFixture.doLoadFile(this.getFullFilePath(name));
        if (string == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(90);
        }
        return string;
    }

    public String loadFile(String testName, String fileName) throws IOException {
        return this.loadFile(this.getFullFileName(testName, fileName));
    }

    public String tryLoadFile(@TestDataFile String name) throws IOException {
        String fullPath = this.getFullFilePath(name);
        return FileUtil.exists((String)fullPath) ? this.loadFile(name) : null;
    }

    private static String doLoadFile(String fullPath) throws IOException {
        String text2 = FileUtil.loadFile((File)new File(fullPath), (Charset)StandardCharsets.UTF_8);
        text2 = StringUtil.convertLineSeparators((String)text2);
        return text2;
    }

    @NotNull
    public String getFullFilePath(@NotNull String fileName) {
        if (fileName == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(91);
        }
        String string = this.myTestFilesPath + File.separatorChar + fileName;
        if (string == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(92);
        }
        return string;
    }

    public String getFullFileName(String testName, String fileNameSuffix) {
        Object fileName = StringUtil.join((Object[])UsefulTestCase.getTestName(testName, true).split("_"), StringUtil::decapitalize, (String)"-");
        if (!fileNameSuffix.isEmpty()) {
            fileName = (String)fileName + (String)(fileNameSuffix.startsWith(".") ? fileNameSuffix : "-" + fileNameSuffix);
        }
        return fileName;
    }

    public void checkResult(@NotNull String text2) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(93);
        }
        this.getFixture().checkResult(text2);
    }

    public void checkResult(@NotNull String text2, boolean stripTrailingSpaces) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(94);
        }
        this.getFixture().checkResult(text2, stripTrailingSpaces);
    }

    public void checkResultWithoutFormatting(String expectedFileText) {
        this.checkResultWithoutFormatting(expectedFileText, this.getFile());
    }

    public void checkResultWithoutFormatting(String expectedFileText, PsiFile file) {
        UsefulTestCase.assertEquals((String)CidrCodeInsightFixture.removeFormatting(expectedFileText), (String)CidrCodeInsightFixture.removeFormatting(file.getText()));
    }

    public static String removeFormatting(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char symbol = string.charAt(i);
            if (Character.isWhitespace(symbol)) continue;
            result.append(symbol);
        }
        return result.toString();
    }

    public void typeWithPauses(String text2) {
        this.myCompletionAutoPopupTester.typeWithPauses(text2);
    }

    public void runWithAutoPopupEnabled(@NotNull ThrowableRunnable<Throwable> runnable) throws Throwable {
        if (runnable == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(95);
        }
        this.myCompletionAutoPopupTester.runWithAutoPopupEnabled(runnable);
    }

    public void assertSearchEverywhereShowsSameItems(String name, boolean isClass, ChooseByNameContributor contributor, boolean includeNonProjectItems) {
        List<NavigationItem> items = Arrays.asList(contributor.getItemsByName(name, name, this.getProject(), includeNonProjectItems));
        UsefulTestCase.assertNotEmpty(items);
        List mismatchingSymbolNames = ContainerUtil.map((Collection)ContainerUtil.filter(items, item -> isClass ? !SearchEverywhereClassifier.EP_Manager.isClass((Object)item) : !SearchEverywhereClassifier.EP_Manager.isSymbol((Object)item)), item -> item.getPresentation().getPresentableText());
        UsefulTestCase.assertEmpty("Non " + (isClass ? "classes" : "symbols") + " were shown", mismatchingSymbolNames);
    }

    public void assertGuttersAtCaret(GutterInfo ... expectedGutters) {
        if (expectedGutters == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(96);
        }
        UsefulTestCase.assertOrderedEquals(ContainerUtil.map(this.getFixture().findGuttersAtCaret(), GutterInfo::new), expectedGutters);
    }

    public List<OCImportSymbolFix> findAutoImports(PsiElement element) {
        PsiFile file = element.getContainingFile();
        TestAnnotationHolder testHolder = new TestAnnotationHolder(this, file);
        try {
            this.runCheckAndGetAnnotations(file, this.getEditor(), element, testHolder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ContainerUtil.findAll(testHolder.getQuickFixes(), OCImportSymbolFix.class);
    }

    public void assertAutoImports(PsiFile file) {
        this.assertAutoImports(file, new AutoImportFix[0]);
    }

    public void assertAutoImports(PsiFile file, AutoImportChoice ... expectedChoices) {
        this.assertAutoImportsAtSelection(file, OCFile.class, expectedChoices);
    }

    public void assertAutoImports(PsiFile file, AutoImportFix ... expectedFixes) {
        this.assertAutoImportsAtSelection(file, OCFile.class, expectedFixes);
    }

    public void assertAutoImportsAtSelection(PsiFile file, Class<? extends PsiElement> elementToCheck) {
        this.assertAutoImportsAtSelection(file, elementToCheck, new AutoImportFix[0]);
    }

    public void assertAutoImportsAtSelection(PsiFile file, Class<? extends PsiElement> elementToCheck, AutoImportChoice ... expectedChoices) {
        AutoImportFix[] expectedFixes = expectedChoices.length == 0 ? new AutoImportFix[]{} : new AutoImportFix[]{new AutoImportFix("<any_auto_import_title>", "<any_auto_import_title>", expectedChoices)};
        this.assertAutoImportsAtSelection(file, elementToCheck, expectedFixes);
    }

    public void assertAutoImportsAtSelection(PsiFile file, Class<? extends PsiElement> elementToCheck, AutoImportFix ... expectedFixes) {
        PsiElement selection = this.findNodeAtSelection(file, elementToCheck);
        List<OCImportSymbolFix> fixes = this.findAutoImports(selection);
        this.assertAutoImports(file, fixes, expectedFixes);
    }

    public void assertAutoImports(PsiFile file, List<OCImportSymbolFix> fixes, AutoImportFix ... expectedFixes) {
        ArrayList<AutoImportFix> actualFixes2 = new ArrayList<AutoImportFix>();
        for (OCImportSymbolFix eachFix : fixes) {
            ArrayList<AutoImportChoice> choices = new ArrayList<AutoImportChoice>();
            for (OCImportSymbolFix.AutoImportItem eachItem : eachFix.getAutoImportItems()) {
                PsiFile copy = (PsiFile)file.copy();
                eachItem.invoke(this.getProject(), copy);
                Pair titleAndLocation = eachItem.getTitleAndLocation();
                choices.add(new AutoImportChoice((String)titleAndLocation.first + " @ " + (String)titleAndLocation.second, copy.getText()));
            }
            Pair popupText = eachFix.getText(true);
            actualFixes2.add(new AutoImportFix(eachFix.getText(), (String)popupText.first + ((Boolean)popupText.second != false ? "..." : ""), choices));
        }
        UsefulTestCase.assertOrderedEquals(actualFixes2, expectedFixes);
    }

    public void type(String text2) {
        this.getFixture().type(text2);
    }

    public void runActionInCommandAction(IntentionAction action, PsiFile file) {
        if (action.startInWriteAction()) {
            WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> action.invoke(file.getProject(), this.getEditor(), file));
        } else {
            CommandProcessor.getInstance().executeCommand(this.getProject(), () -> action.invoke(file.getProject(), this.getEditor(), file), null, null);
        }
    }

    public void runActionInCommandAction(CodeInsightActionHandler action, PsiFile file) {
        Runnable runnable = () -> {
            action.invoke(file.getProject(), this.getEditor(), file);
            PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        };
        if (action.startInWriteAction()) {
            WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (Runnable)runnable);
        } else {
            CommandProcessor.getInstance().executeCommand(this.getProject(), runnable, null, null);
        }
    }

    public void checkAnnotations(String testName) throws Exception {
        this.checkAnnotations(this.configureByFile(testName));
    }

    public <T extends PsiFile> void checkAnnotations(@NotNull T file) throws Exception {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(97);
        }
        this.checkAnnotations(file, null, null);
    }

    public <T extends PsiFile> void checkAnnotations(@NotNull T file, @Nullable HighlightSeverity minimalSeverityOrNull, @Nullable Function<? super T, String> extraInfoProvider) throws Exception {
        List<String> messages;
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(98);
        }
        if ((messages = this.getAnnotationMessages(file, minimalSeverityOrNull)) == null) {
            System.out.println("Disabled");
        } else if (!messages.isEmpty()) {
            String message = "\n" + (String)(extraInfoProvider == null ? "" : extraInfoProvider.apply(file) + "\n") + StringUtil.join(messages, (String)"\n");
            UsefulTestCase.fail((String)message);
        }
    }

    public List<String> getAnnotationMessages(@NotNull PsiFile file, @Nullable HighlightSeverity minimalSeverityOrNull) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(99);
        }
        return (List)ReadAction.compute(() -> {
            final ArrayList messages = new ArrayList();
            file.getProject().putUserData(OCChecksSettings.DFA_UNREACHABLE_CODE, (Object)true);
            com.jetbrains.cidr.TestAnnotationHolder testHolder = new com.jetbrains.cidr.TestAnnotationHolder(this, minimalSeverityOrNull, file){

                @Override
                protected void fail(String message) {
                    messages.add(message);
                }

                @Override
                protected void assertTrue(String message, boolean condition) {
                    if (!condition) {
                        messages.add(message);
                    }
                }
            };
            if (testHolder.isTestDisabled()) {
                return null;
            }
            ArrayList nodes = new ArrayList();
            OCElementUtil.fillChildrenRecursive((PsiElement)file, nodes);
            this.runCheckAndGetAnnotations(file, null, nodes, (PsiElement)(testHolder.isRunInspections() ? file : null), testHolder);
            testHolder.checkAllExpectedAnnotationsFound();
            return messages;
        });
    }

    public void runCheckAndGetAnnotations(@NotNull PsiFile file, @Nullable Editor editor2, @NotNull PsiElement nodeToCheck, @NotNull TestAnnotationInfoList testHolder) throws Exception {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(100);
        }
        if (nodeToCheck == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(101);
        }
        if (testHolder == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(102);
        }
        ArrayList<PsiElement> nodes = new ArrayList<PsiElement>();
        if (nodeToCheck instanceof OCFile) {
            OCElementUtil.fillChildrenRecursive((PsiElement)nodeToCheck, nodes);
        }
        nodes.add(nodeToCheck);
        this.runCheckAndGetAnnotations(file, editor2, nodes, nodeToCheck, testHolder);
    }

    @Nullable
    static CidrExternalAnnotationsProvider getCidrExternalAnnotationsProvider() {
        try {
            return ServiceLoader.load(CidrExternalAnnotationsProvider.class).findFirst().orElse(null);
        }
        catch (ServiceConfigurationError ignored) {
            return null;
        }
    }

    private void runCheckAndGetAnnotations(@NotNull PsiFile file, @Nullable Editor editor2, @NotNull List<? extends PsiElement> nodesForAnnotator, @Nullable PsiElement nodeForInspections, @NotNull TestAnnotationInfoList testHolder) {
        CidrExternalAnnotationsProvider provider;
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(103);
        }
        if (nodesForAnnotator == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(104);
        }
        if (testHolder == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(105);
        }
        ProblemsHolder problemsHolder = CidrCodeInsightFixture.getTestProblemsHolder(false, file, editor2, testHolder);
        testHolder.annotationsAdded(CidrCodeInsightFixture.runAnnotators(file, nodesForAnnotator, this.getTestAnnotators()));
        if (nodeForInspections != null) {
            List<ProblemDescriptor> descriptors = CidrCodeInsightFixture.runInspections(file, nodeForInspections);
            descriptors.forEach(descriptor -> problemsHolder.registerProblem(descriptor));
        }
        if ((provider = CidrCodeInsightFixture.getCidrExternalAnnotationsProvider()) != null) {
            provider.addExternalAnnotations(file, editor2, nodesForAnnotator, nodeForInspections, testHolder);
        }
    }

    @NotNull
    public static List<Annotation> runAnnotators(@NotNull PsiFile file, @NotNull List<? extends PsiElement> elements, Annotator ... annotators) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(106);
        }
        if (elements == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(107);
        }
        if (annotators == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(108);
        }
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotator annotator : annotators) {
            result.addAll(CodeInsightTestUtil.testAnnotator(annotator, elements.toArray(PsiElement.EMPTY_ARRAY)));
        }
        ArrayList<Annotation> arrayList = result;
        if (arrayList == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(109);
        }
        return arrayList;
    }

    @NotNull
    public static List<ProblemDescriptor> runInspections(@NotNull PsiFile file, @NotNull PsiElement nodeForInspections) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(110);
        }
        if (nodeForInspections == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(111);
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        List<Class> standaloneInspectionClasses = List.of(CidrInspectionToolProvider.getStandaloneInspectionClasses());
        List localInspections = ContainerUtil.map((Object[])((LocalInspectionEP[])LocalInspectionEP.LOCAL_INSPECTION.getExtensions()), ex -> {
            try {
                return Class.forName(ex.implementationClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        for (Class clazz : ContainerUtil.concat(standaloneInspectionClasses, (List)localInspections)) {
            if (!LocalInspectionTool.class.isAssignableFrom(clazz) || CidrCodeInsightFixture.isIgnoredInspection(clazz)) continue;
            LocalInspectionTool inspection = (LocalInspectionTool)ReflectionUtil.newInstance((Class)clazz);
            result.addAll(CidrCodeInsightFixture.runInspection(file, nodeForInspections, inspection, true));
        }
        ArrayList<ProblemDescriptor> arrayList = result;
        if (arrayList == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(112);
        }
        return arrayList;
    }

    private static boolean isIgnoredInspection(Class<?> clazz) {
        return IncorrectFormattingInspection.class == clazz || GrazieSpellCheckingInspection.class == clazz || InconsistentLineSeparatorsInspection.class == clazz || LongLineInspection.class == clazz;
    }

    @NotNull
    public static List<ProblemDescriptor> runInspection(@NotNull PsiFile file, final @NotNull PsiElement nodeForInspections, @NotNull LocalInspectionTool inspection, boolean isOnTheFly) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(113);
        }
        if (nodeForInspections == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(114);
        }
        if (inspection == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(115);
        }
        Ref result = new Ref();
        ProgressManager.getInstance().runProcess(() -> ReadAction.run(() -> {
            final ArrayList elements = new ArrayList();
            nodeForInspections.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if (element == nodeForInspections || !element.getClass().equals(nodeForInspections.getClass())) {
                        elements.add(element);
                    }
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/CidrCodeInsightFixture$7", "visitElement"));
                }
            });
            Collections.reverse(elements);
            Map map = InspectionEngine.inspectElements(Collections.singletonList(new LocalInspectionToolWrapper(inspection)), (PsiFile)file, (TextRange)file.getTextRange(), (boolean)true, (boolean)isOnTheFly, (ProgressIndicator)ProgressIndicatorProvider.getGlobalProgressIndicator(), elements, (PairProcessor)PairProcessor.alwaysTrue());
            result.set((Object)ContainerUtil.flatten(map.values()));
        }), (ProgressIndicator)new DaemonProgressIndicator());
        List list = (List)result.get();
        if (list == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(116);
        }
        return list;
    }

    @NotNull
    public static ProblemsHolder getTestProblemsHolder(final boolean checkRanges, @NotNull PsiFile file, final @Nullable Editor editor2, final @NotNull TestAnnotationInfoList testHolder) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(117);
        }
        if (testHolder == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(118);
        }
        return new ProblemsHolder(InspectionManager.getInstance((Project)file.getProject()), file, true){

            public void registerProblem(@NotNull ProblemDescriptor problem) {
                if (problem == null) {
                    8.$$$reportNull$$$0(0);
                }
                int offset = problem.getStartElement().getTextOffset();
                if (!checkRanges || editor2.getSelectionModel().getSelectionStart() <= offset && offset < editor2.getSelectionModel().getSelectionEnd()) {
                    TextRange range = new TextRange(problem.getStartElement().getTextRange().getStartOffset(), problem.getEndElement().getTextRange().getEndOffset());
                    testHolder.annotationAdded(HighlightSeverity.WARNING, range, problem.getDescriptionTemplate());
                    for (QuickFix quickFix : problem.getFixes()) {
                        if (quickFix instanceof IntentionWrapper) {
                            testHolder.createQuickFix((Segment)range, ((IntentionWrapper)quickFix).getAction());
                            continue;
                        }
                        if (!(quickFix instanceof LocalQuickFix) || !(quickFix instanceof IntentionAction)) continue;
                        testHolder.createQuickFix((Segment)range, (IntentionAction)quickFix);
                    }
                    if (problem.getProblemGroup() instanceof OCProblemGroup) {
                        for (QuickFix quickFix : ((OCProblemGroup)problem.getProblemGroup()).getSuppressActions(null)) {
                            testHolder.createQuickFix((Segment)range, (IntentionAction)quickFix);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problem", "com/jetbrains/cidr/CidrCodeInsightFixture$8", "registerProblem"));
            }
        };
    }

    public void edit(@NotNull PsiFile file, @NotNull Function<? super Document, Void> docFunction) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(119);
        }
        if (docFunction == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(120);
        }
        CommandProcessor.getInstance().executeCommand(file.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
            Document document = manager.getDocument(file);
            Assert.assertNotNull((Object)document);
            docFunction.apply(document);
            manager.commitDocument(document);
            FileDocumentManager.getInstance().saveDocumentAsIs(document);
        }), "change doc", (Object)"");
    }

    public void assertIcons(@NotNull PsiElement rootElement, @Nullable Function<? super PsiElement, ? extends OCSymbol> symbolExtractor, String ... expectedIcons) {
        if (rootElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(121);
        }
        List actual = (List)ReadAction.compute(() -> this.getIconsAsStrings(rootElement, symbolExtractor));
        UsefulTestCase.assertOrderedEquals(actual, expectedIcons);
    }

    @RequiresReadLock
    @NotNull
    public List<String> getIconsAsStrings(@NotNull PsiElement rootElement, final @Nullable Function<? super PsiElement, ? extends OCSymbol> symbolExtractor) {
        if (rootElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(122);
        }
        ThreadingAssertions.softAssertReadAccess();
        final ArrayList<String> actualIcons = new ArrayList<String>();
        rootElement.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (!(element instanceof ElementBase)) {
                    super.visitElement(element);
                }
                OCSymbol symbol = null;
                if (symbolExtractor != null) {
                    symbol = (OCSymbol)symbolExtractor.apply(element);
                }
                if (symbol == null && element instanceof OCSymbolDeclarator) {
                    symbol = ((OCSymbolDeclarator)element).getSymbol();
                }
                Object result = null;
                try {
                    Method method = ElementBase.class.getDeclaredMethod("getBaseIcon", new Class[0]);
                    method.setAccessible(true);
                    Icon baseIcon = (Icon)method.invoke((Object)element, new Object[0]);
                    method = ElementBase.class.getDeclaredMethod("getElementIcon", Integer.TYPE);
                    method.setAccessible(true);
                    Icon fullIcon = (Icon)method.invoke((Object)element, 0);
                    if (baseIcon != null && fullIcon != null) {
                        result = CidrCodeInsightFixture.printIcon(baseIcon, fullIcon);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (result != null && symbol != null) {
                    String symbolIcons;
                    Icon baseIcon = symbol.getBaseIcon();
                    Icon fullIcon = symbol.computeFullIconNow(element, CidrCodeInsightFixture.this.getProject());
                    if (baseIcon != null && fullIcon != null && !(symbolIcons = CidrCodeInsightFixture.printIcon(baseIcon, fullIcon)).equals(result)) {
                        result = (String)result + " | " + symbolIcons;
                    }
                }
                if (result != null) {
                    boolean sameFunctionElement;
                    boolean bl = sameFunctionElement = element.getParent() instanceof OCFunctionDeclaration && ((String)actualIcons.get(actualIcons.size() - 1)).equals(result);
                    if (!sameFunctionElement) {
                        actualIcons.add(result);
                    }
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/CidrCodeInsightFixture$9", "visitElement"));
            }
        });
        ArrayList<String> arrayList = actualIcons;
        if (arrayList == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(123);
        }
        return arrayList;
    }

    public void assertLineMarkerIcons(@NotNull PsiElement rootElement, @NotNull RunLineMarkerContributor lineMarkerProvider, String ... expectedIcons) {
        if (rootElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(124);
        }
        if (lineMarkerProvider == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(125);
        }
        this.cleanTestsHistory();
        List actual = (List)ReadAction.compute(() -> this.getLineMarkerIcons(rootElement, lineMarkerProvider));
        UsefulTestCase.assertOrderedEquals(actual, expectedIcons);
    }

    private void cleanTestsHistory() {
        TestStateStorage instance = TestStateStorage.getInstance((Project)this.getProject());
        instance.getKeys().forEach(key -> instance.removeState(key));
    }

    @RequiresReadLock
    @NotNull
    public List<String> getLineMarkerIcons(@NotNull PsiElement rootElement, final @NotNull RunLineMarkerContributor lineMarkerProvider) {
        if (rootElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(126);
        }
        if (lineMarkerProvider == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(127);
        }
        ThreadingAssertions.softAssertReadAccess();
        final ArrayList<String> actualIcons = new ArrayList<String>();
        rootElement.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                RunLineMarkerContributor.Info info;
                if (element == null) {
                    10.$$$reportNull$$$0(0);
                }
                if ((info = lineMarkerProvider.getInfo(element)) != null) {
                    actualIcons.add(CidrCodeInsightFixture.printIcon(info.icon, info.icon));
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/CidrCodeInsightFixture$10", "visitElement"));
            }
        });
        ArrayList<String> arrayList = actualIcons;
        if (arrayList == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(128);
        }
        return arrayList;
    }

    @NotNull
    public static String printIcon(Icon baseIcon, Icon fullIcon) {
        String fullText;
        String baseText = CidrCodeInsightFixture.printIcon(baseIcon);
        Object object = baseText.equals(fullText = CidrCodeInsightFixture.printIcon(fullIcon)) ? baseText : baseText + " - " + fullText;
        if (object == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(129);
        }
        return object;
    }

    public void assertIcon(Icon expected, Icon actual) {
        UsefulTestCase.assertEquals((String)CidrCodeInsightFixture.printIcon(expected), (String)CidrCodeInsightFixture.printIcon(actual));
    }

    @NotNull
    public static String printIcon(Icon icon) {
        String string = CidrCodeInsightFixture.printIcon(new StringBuilder(), icon).toString();
        if (string == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(130);
        }
        return string;
    }

    private static StringBuilder printIcon(StringBuilder builder, Icon icon) {
        while (true) {
            if (icon instanceof DeferredIcon) {
                DeferredIcon deferredIcon = (DeferredIcon)icon;
                icon = deferredIcon.evaluate();
                continue;
            }
            if (!(icon instanceof RetrievableIcon)) break;
            Icon[] retrievableIcon = (Icon[])icon;
            icon = retrievableIcon.retrieveIcon();
        }
        if (icon instanceof LayeredIcon) {
            builder.append("[");
            for (Icon subicon : ((LayeredIcon)icon).getAllLayers()) {
                CidrCodeInsightFixture.printIcon(builder, subicon);
                builder.append(",");
            }
            if (builder.charAt(builder.length() - 1) == ',') {
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append("]");
            return builder;
        }
        if (icon instanceof RowIcon) {
            builder.append("<");
            for (int i = 0; i < ((RowIcon)icon).getIconCount(); ++i) {
                CidrCodeInsightFixture.printIcon(builder, ((RowIcon)icon).getIcon(i));
                builder.append(",");
            }
            if (builder.charAt(builder.length() - 1) == ',') {
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append(">");
            return builder;
        }
        builder.append(CidrCodeInsightFixture.iconToText(icon));
        return builder;
    }

    private static String iconToText(Icon icon) {
        if (icon == null) {
            return null;
        }
        String result = ICON_TO_TEXT.get(icon);
        return result == null ? icon.toString() : result;
    }

    public static void addIconsClass(Class<?> c) {
        CidrCodeInsightFixture.processIconContainerClass(ICON_TO_TEXT, c);
    }

    private static void processIconContainerClass(Map<Icon, String> map, Class clazz) {
        String ICON_PREFIX = "CodeAssistant";
        try {
            for (Field field : clazz.getDeclaredFields()) {
                String name;
                Object value2;
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || field.getAnnotation(Deprecated.class) != null || !((value2 = field.get(null)) instanceof Icon)) continue;
                if (value2 instanceof RetrievableIcon) {
                    value2 = ((RetrievableIcon)value2).retrieveIcon();
                }
                if (map.containsValue(name = StringUtil.trimStart((String)field.getName(), (String)ICON_PREFIX))) {
                    name = CidrCodeInsightFixture.getFieldFQN(field, name);
                }
                map.put((Icon)value2, name);
            }
            for (AnnotatedElement annotatedElement : clazz.getDeclaredClasses()) {
                CidrCodeInsightFixture.processIconContainerClass(map, (Class)annotatedElement);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static String getFieldFQN(@NotNull Field field, @NotNull String fieldName) {
        if (field == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(131);
        }
        if (fieldName == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(132);
        }
        ArrayList<String> qualifiers = new ArrayList<String>();
        qualifiers.add(fieldName);
        for (Class<?> declClass = field.getDeclaringClass(); declClass != null; declClass = declClass.getDeclaringClass()) {
            qualifiers.add(declClass.getSimpleName());
        }
        String string = StringUtil.join((Collection)ContainerUtil.reverse(qualifiers), (String)".");
        if (string == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(133);
        }
        return string;
    }

    public void expectCompletion(String prefix, String ... items) {
        this.expectCompletion(prefix, 1, items);
    }

    public void expectCompletion(String prefix, int time, String ... items) {
        this.doExpectCompletionContains(prefix, time, true, items);
    }

    public void expectCompletionContains(String prefix, int time, String ... items) {
        this.doExpectCompletionContains(prefix, time, false, items);
    }

    private void doExpectCompletionContains(String prefix, int time, boolean exactSet, String ... expectedItems) {
        List actualItems = ContainerUtil.map((Collection)ContainerUtil.notNullize(this.complete(time).getItems()), String::trim);
        ArrayList<LookupElement> expectedLookupElement = new ArrayList<LookupElement>();
        for (String element : expectedItems) {
            expectedLookupElement.add((LookupElement)LookupElementBuilder.create((String)element));
        }
        String expectedString = StringUtil.join(new CompletionResult(prefix, expectedLookupElement).getItems(), (String)", ");
        if (exactSet) {
            String actualString = StringUtil.join((Collection)actualItems, (String)", ");
            UsefulTestCase.assertEquals((String)expectedString, (String)actualString);
        } else {
            UsefulTestCase.assertContainsElements(actualItems, expectedItems);
        }
    }

    public void expectEmptyCompletion(int time) {
        CompletionResult result = this.complete(time);
        UsefulTestCase.assertEquals((String)new CompletionResult(null, null).toString(), (String)result.toString());
    }

    @NotNull
    public CompletionResult complete() {
        CompletionResult completionResult = this.complete(1);
        if (completionResult == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(134);
        }
        return completionResult;
    }

    public CompletionResult complete(CompletionType type) {
        return this.complete(type, 1);
    }

    @NotNull
    public CompletionResult complete(int time) {
        CompletionResult completionResult = this.complete(CompletionType.BASIC, time);
        if (completionResult == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(135);
        }
        return completionResult;
    }

    @NotNull
    public CompletionResult complete(@NotNull CompletionType type, int time) {
        if (type == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(136);
        }
        new CodeCompletionHandlerBase(type).invokeCompletion(this.getProject(), this.getEditor(), time);
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.getEditor());
        if (lookup == null) {
            return new CompletionResult(null, null);
        }
        return new CompletionResult(lookup.itemPattern((LookupElement)lookup.getItems().get(0)), lookup.getItems());
    }

    public void checkFolding(String content, String folded) {
        this.checkFolding(content, folded, "test.m");
    }

    public void checkFoldingCPP(String content, String folded) {
        this.checkFolding(content, folded, "test.cpp");
    }

    public PsiFile checkFolding(String content, String folded, String fileName) {
        return this.checkFolding(content, folded, false, fileName, true);
    }

    public <T extends PsiFile> T checkFolding(String content, String folded, boolean performCollapseBlock, String fileName, boolean waitForCodePass) {
        content = CidrTestUtils.trimMargin(content);
        folded = CidrTestUtils.trimMargin(folded);
        T file = this.configureByText(content, fileName);
        if (performCollapseBlock) {
            this.getFixture().performEditorAction("CollapseBlock");
        }
        if (waitForCodePass) {
            this.getFixture().doHighlighting();
        }
        UsefulTestCase.assertEquals((String)folded, (String)((CodeInsightTestFixtureImpl)this.getFixture()).getFoldingDescription(true));
        return file;
    }

    public void assertLanguageStandard(@NotNull String relativeFile, OCLanguageStandard ... expected) {
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(137);
        }
        if (expected == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(138);
        }
        PsiFile psiFile = this.myProjectFixture.getProjectSubPsiFile(relativeFile);
        this.assertLanguageStandard(psiFile, expected);
    }

    public void assertLanguageStandard(@NotNull PsiFile file, OCLanguageStandard ... expected) {
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(139);
        }
        if (expected == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(140);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            OCLanguageStandard std = (OCLanguageStandard)OCCompilerFeaturesHelper.getFeatureForFile((PsiFile)file, null, (OCCompilerFeatures.Type)OCCompilerFeatures.LANGUAGE_STANDARD);
            Assert.assertTrue((String)("Wrong language standard for " + file.getName() + "\n\texpected: " + Arrays.toString(expected) + "\n\tactual:   " + String.valueOf(std)), (boolean)ArrayUtil.contains((Object)std, (Object[])expected));
        });
    }

    public void assertClangFeature(@NotNull String relativeFile, @NotNull String feature, @Nullable String value2) {
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(141);
        }
        if (feature == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(142);
        }
        this.doAssertClangFeatureOrExtension(true, null, relativeFile, feature, value2);
    }

    public void assertClangFeature(@NotNull OCResolveConfiguration configuration, @NotNull String relativeFile, @NotNull String feature, @Nullable String value2) {
        if (configuration == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(143);
        }
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(144);
        }
        if (feature == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(145);
        }
        this.doAssertClangFeatureOrExtension(true, configuration, relativeFile, feature, value2);
    }

    public void assertClangExtension(@NotNull String relativeFile, @NotNull String feature, @Nullable String value2) {
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(146);
        }
        if (feature == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(147);
        }
        this.doAssertClangFeatureOrExtension(false, null, relativeFile, feature, value2);
    }

    public void assertClangExtension(@NotNull OCResolveConfiguration configuration, @NotNull String relativeFile, @NotNull String feature, @Nullable String value2) {
        if (configuration == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(148);
        }
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(149);
        }
        if (feature == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(150);
        }
        this.doAssertClangFeatureOrExtension(false, configuration, relativeFile, feature, value2);
    }

    void doAssertClangFeatureOrExtension(boolean isFeature, @Nullable OCResolveConfiguration configuration, @NotNull String relativeFile, @NotNull String name, @Nullable String value2) {
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(151);
        }
        if (name == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(152);
        }
        String kind = isFeature ? "feature" : "extension";
        String macroCallText = "__has_" + kind + "(" + name + ")";
        PsiFile file = this.setFileConfiguration(configuration, this.myProjectFixture.getProjectSubPsiFile(relativeFile));
        OCExpression expression = (OCExpression)WriteAction.computeAndWait(() -> OCElementFactory.expressionFromText((String)macroCallText, (PsiElement)file, (boolean)false));
        ApplicationManager.getApplication().runReadAction(() -> {
            String expectedValue = value2 == null ? macroCallText : value2;
            String actualValue = expression instanceof OCLiteralExpression ? ((OCLiteralExpression)expression).getUnescapedLiteralText() : expression.getText();
            UsefulTestCase.assertEquals((String)(kind + " " + name + " expected to be " + expectedValue + " in file " + relativeFile), (String)expectedValue, (String)StringUtil.nullize((String)actualValue));
        });
    }

    @NotNull
    public CompletionResult assertAutoPopup(@NotNull String text2, @NotNull String typedText, @NotNull OCLanguageKind ocLanguageKind, boolean shouldPopup) {
        if (text2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(153);
        }
        if (typedText == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(154);
        }
        if (ocLanguageKind == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(155);
        }
        this.configureByText(text2, ocLanguageKind);
        CompletionResult completionResult = this.assertAutoPopup(typedText, shouldPopup);
        if (completionResult == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(156);
        }
        return completionResult;
    }

    @NotNull
    public CompletionResult assertAutoPopup(@NotNull String typedText, boolean shouldPopup) {
        if (typedText == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(157);
        }
        this.typeWithPauses(typedText);
        LookupImpl lookup = this.getLookup();
        if (shouldPopup) {
            Assert.assertNotNull((Object)lookup);
        } else {
            UsefulTestCase.assertNull((Object)lookup);
        }
        if (lookup == null) {
            return new CompletionResult(null, null);
        }
        List items = lookup.getItems();
        return new CompletionResult(lookup.itemPattern((LookupElement)items.get(0)), items);
    }

    @Nullable
    private LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup((Editor)this.getEditor());
    }

    @NotNull
    public <T extends PsiFile> T setFileConfiguration(OCResolveConfiguration configuration, T file) {
        PsiFile result = (PsiFile)WriteAction.computeAndWait(() -> {
            OCFileActiveConfigurationCache.setUserSelectedConfiguration((PsiFile)file, (OCResolveConfiguration)configuration);
            if (file.isValid()) {
                return file;
            }
            FileViewProvider provider = PsiManager.getInstance((Project)this.getProject()).findViewProvider(file.getVirtualFile());
            return provider.getPsi(file.getLanguage());
        });
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread()) {
            application.invokeAndWait(() -> UIUtil.dispatchAllInvocationEvents());
        }
        IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
        DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode(() -> FileSymbolTablesCache.getInstance((Project)this.getProject()).ensurePendingFilesProcessed());
        PsiFile psiFile = result;
        if (psiFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(158);
        }
        return (T)psiFile;
    }

    public static DefineDescription resolved(@NotNull String name) {
        if (name == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(159);
        }
        return new DefineDescription(name, DefineDescription.State.resolved, null);
    }

    public static DefineDescription resolved(@NotNull String name, @NotNull String value2) {
        if (name == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(160);
        }
        if (value2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(161);
        }
        return new DefineDescription(name, DefineDescription.State.resolved, value2);
    }

    public static DefineDescription notResolved(@NotNull String name) {
        if (name == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(162);
        }
        return new DefineDescription(name, DefineDescription.State.not_resolved, null);
    }

    public static DefineDescription declared(@NotNull String name) {
        if (name == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(163);
        }
        return new DefineDescription(name, DefineDescription.State.declared, null);
    }

    @NotNull
    public String convertToOsDependentPath(@NotNull String anyPath) {
        if (anyPath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(164);
        }
        if (SystemInfo.isWindows) {
            String string = anyPath.replace('/', '\\');
            if (string == null) {
                CidrCodeInsightFixture.$$$reportNull$$$0(165);
            }
            return string;
        }
        String string = anyPath;
        if (string == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(166);
        }
        return string;
    }

    public static void assertDefines(@NotNull OCResolveConfiguration configuration, @NotNull OCFile ocFile, String[] @NotNull [] cmdLineDefines) {
        if (configuration == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(167);
        }
        if (ocFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(168);
        }
        OCInclusionContext context2 = OCInclusionContext.sourceParsingContext((OCResolveConfiguration)configuration, (OCLanguageKind)ocFile.getKind(), (PsiFile)ocFile);
        ArrayList<CallSite> problems = new ArrayList<CallSite>();
        for (String[] macroName2Value : cmdLineDefines) {
            OCMacroSymbol def = context2.getDefinition(macroName2Value[0]);
            if (def == null) {
                problems.add((CallSite)((Object)("Undefined macro " + macroName2Value[0])));
                continue;
            }
            if (macroName2Value[1].equals(def.toString())) continue;
            problems.add((CallSite)((Object)("Wrong macro from compiler flag:\nexpected: " + macroName2Value[1] + "\nactual: " + String.valueOf(def))));
        }
        UsefulTestCase.assertEmpty(problems);
    }

    public void assertDefines(@NotNull OCResolveConfiguration configuration, @NotNull PsiFile file, DefineDescription ... expectedDefines) {
        if (configuration == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(169);
        }
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(170);
        }
        final ArrayList actual = new ArrayList();
        PsiFile finalFile = this.setFileConfiguration(configuration, file);
        ApplicationManager.getApplication().invokeAndWait(() -> {});
        EdtTestUtil.runInEdtAndWait(() -> ApplicationManager.getApplication().runReadAction(() -> finalFile.accept((PsiElementVisitor)new OCRecursiveVisitor(this){

            public void visitOCElement(OCElement elem) {
                if (elem instanceof OCReferenceElement) {
                    if (elem.getParent() instanceof OCMacroCall) {
                        actual.add(CidrCodeInsightFixture.resolved(((OCReferenceElement)elem).getName(), ((OCMacroCall)elem.getParent()).getReplacementText()));
                    } else if (elem.getParent() instanceof OCReferenceExpression || elem.getParent() instanceof OCTypeElement) {
                        OCReferenceElement elem1 = (OCReferenceElement)elem;
                        actual.add(elem1.resolve() != null ? CidrCodeInsightFixture.resolved(elem1.getName()) : CidrCodeInsightFixture.notResolved(elem1.getName()));
                    }
                } else if (OCElementUtil.getElementMacroCall((PsiElement)elem) == null && elem instanceof OCDeclaration) {
                    List declarators = ((OCDeclaration)elem).getDeclarators();
                    OCTypeElement type = ((OCDeclaration)elem).getTypeElement();
                    if (declarators.isEmpty()) {
                        actual.add(CidrCodeInsightFixture.notResolved(type.getText()));
                    } else if (type.isEmpty()) {
                        actual.add(CidrCodeInsightFixture.notResolved(((OCDeclarator)declarators.get(0)).getText()));
                    } else {
                        String name = ((OCDeclarator)declarators.get(0)).getName();
                        if (!"ignore".equals(name)) {
                            actual.add(CidrCodeInsightFixture.declared(name));
                        }
                    }
                }
                super.visitOCElement(elem);
            }
        })));
        UsefulTestCase.assertOrderedEquals("Incorrect defines for file " + file.getName() + " in config " + configuration.getDisplayName(), actual, expectedDefines);
    }

    public static IncludeDescription unresolved(@NotNull String includeText) {
        if (includeText == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(171);
        }
        return new IncludeDescription(includeText);
    }

    public static IncludeDescription inc(@NotNull String includeText, @NotNull PsiFile includeFile) {
        if (includeText == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(172);
        }
        if (includeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(173);
        }
        return new IncludeDescription(includeText, includeFile);
    }

    public static IncludeDescription inc(@NotNull String includeText, @NotNull String includedPath) {
        if (includeText == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(174);
        }
        if (includedPath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(175);
        }
        return new IncludeDescription(includeText, includedPath);
    }

    public void assertIncludes(@NotNull OCResolveConfiguration configuration, @NotNull OCFile file, IncludeDescription ... expected) {
        if (configuration == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(176);
        }
        if (file == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(177);
        }
        OCFile finalFile = file = this.setFileConfiguration(configuration, file);
        ApplicationManager.getApplication().invokeAndWait(() -> {});
        EdtTestUtil.runInEdtAndWait(() -> ApplicationManager.getApplication().runReadAction(() -> {
            ArrayList<IncludeDescription> actual = new ArrayList<IncludeDescription>();
            for (OCIncludeDirective each : finalFile.findIncludeDirectives()) {
                boolean library = each.isAngleBrackets();
                String pref = library ? "<" : "\"";
                String suf = library ? ">" : "\"";
                String importedText = pref + each.getReferenceText() + suf;
                PsiFile importedFile = each.getIncludedFile();
                IncludeDescription desc = importedFile == null ? new IncludeDescription(importedText) : (VfsUtilCore.isAncestor((VirtualFile)this.myProjectFixture.getProjectDir(), (VirtualFile)importedFile.getVirtualFile(), (boolean)false) ? new IncludeDescription(importedText, importedFile) : new IncludeDescription(importedText, importedFile.getName()));
                actual.add(desc);
            }
            UsefulTestCase.assertOrderedEquals("incorrect imports in configuration " + configuration.getDisplayName() + " for file " + finalFile.getName(), actual, expected);
        }));
    }

    @NotNull
    public List<Crumb> getBreadcrumbsAt(int offset) {
        PsiElement element = this.getFile().findElementAt(offset);
        if (element == null) {
            List<Crumb> list = Collections.emptyList();
            if (list == null) {
                CidrCodeInsightFixture.$$$reportNull$$$0(178);
            }
            return list;
        }
        Language language = element.getContainingFile().getLanguage();
        BreadcrumbsProvider provider = BreadcrumbsUtil.getInfoProvider((Language)language);
        if (provider == null) {
            List<Crumb> list = Collections.emptyList();
            if (list == null) {
                CidrCodeInsightFixture.$$$reportNull$$$0(179);
            }
            return list;
        }
        ArrayList<Crumb.Impl> result = new ArrayList<Crumb.Impl>();
        while (element != null) {
            if (provider.acceptElement(element)) {
                result.add(new Crumb.Impl(provider, element));
            }
            element = provider.getParent(element);
        }
        List list = ContainerUtil.reverse(result);
        if (list == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(180);
        }
        return list;
    }

    static {
        CidrCodeInsightFixture.processIconContainerClass(ICON_TO_TEXT, CidrLangIcons.class);
        CidrCodeInsightFixture.processIconContainerClass(ICON_TO_TEXT, CidrProjectModelIcons.class);
        CidrCodeInsightFixture.processIconContainerClass(ICON_TO_TEXT, AllIcons.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 16, 18, 24, 25, 26, 27, 28, 29, 41, 43, 47, 48, 55, 70, 75, 79, 80, 85, 90, 92, 109, 112, 116, 123, 128, 129, 130, 133, 134, 135, 156, 158, 165, 166, 178, 179, 180 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectAdapter";
                break;
            }
            case 4: 
            case 7: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 41: 
            case 43: 
            case 47: 
            case 48: 
            case 55: 
            case 70: 
            case 75: 
            case 79: 
            case 80: 
            case 85: 
            case 90: 
            case 92: 
            case 109: 
            case 112: 
            case 116: 
            case 123: 
            case 128: 
            case 129: 
            case 130: 
            case 133: 
            case 134: 
            case 135: 
            case 156: 
            case 158: 
            case 165: 
            case 166: 
            case 178: 
            case 179: 
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrCodeInsightFixture";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaProjectTestFixture";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirTestFixture";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 88: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 103: 
            case 106: 
            case 110: 
            case 113: 
            case 117: 
            case 119: 
            case 139: 
            case 170: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 21: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 76: 
            case 82: 
            case 87: 
            case 89: 
            case 93: 
            case 94: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorDetails";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 51: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 77: 
            case 81: 
            case 86: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedGutters";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeToCheck";
                break;
            }
            case 102: 
            case 105: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testHolder";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesForAnnotator";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotators";
                break;
            }
            case 111: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeForInspections";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docFunction";
                break;
            }
            case 121: 
            case 122: 
            case 124: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 125: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineMarkerProvider";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 137: 
            case 141: 
            case 144: 
            case 146: 
            case 149: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeFile";
                break;
            }
            case 138: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 142: 
            case 145: 
            case 147: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 143: 
            case 148: 
            case 167: 
            case 169: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 152: 
            case 159: 
            case 160: 
            case 162: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 154: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedText";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocLanguageKind";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyPath";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocFile";
                break;
            }
            case 171: 
            case 172: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeText";
                break;
            }
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeFile";
                break;
            }
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrCodeInsightFixture";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestAnnotators";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTables";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixture";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementAtCaret";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementOfClassAtCaret";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findExpressionAtCaret";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findNodeAtSelection";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findExpressionAtSelection";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getOCFile";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSubOCFile";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "findSymbols";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassSymbols";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "textForExpression";
                break;
            }
            case 70: 
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "configureByText";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "configureByTextInExistingFile";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "addFileToProject";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullFilePath";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "runAnnotators";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "runInspections";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "runInspection";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconsAsStrings";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineMarkerIcons";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "printIcon";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldFQN";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "complete";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "assertAutoPopup";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "setFileConfiguration";
                break;
            }
            case 165: 
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToOsDependentPath";
                break;
            }
            case 178: 
            case 179: 
            case 180: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreadcrumbsAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 41: 
            case 43: 
            case 47: 
            case 48: 
            case 55: 
            case 70: 
            case 75: 
            case 79: 
            case 80: 
            case 85: 
            case 90: 
            case 92: 
            case 109: 
            case 112: 
            case 116: 
            case 123: 
            case 128: 
            case 129: 
            case 130: 
            case 133: 
            case 134: 
            case 135: 
            case 156: 
            case 158: 
            case 165: 
            case 166: 
            case 178: 
            case 179: 
            case 180: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFileTracker";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeFileTracker";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTestFixture";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareVirtualFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deleteCreatedFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFileToProject";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeFileFromProject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resetFileCaches";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementAtCaret";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceAtCaret";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findElementByText";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsageTargetElement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "usageInfosToString";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findOCFile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findProjectSubOCFile";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getOCFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSubOCFile";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFile";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processOCFiles";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lookup";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeCpp";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "parseDeclTypeCpp";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeObjC";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "textForExpression";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "configureByExpressionOCpp";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "configureByExpressionOC";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "configureByTextC";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "configureByTextOCpp";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "configureByTextCpp";
                break;
            }
            case 61: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "configureByTextOC";
                break;
            }
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "configureByText";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "configureByTextInExistingFile";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "tryConfigureWithExistingFile";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "postConfigureByFile";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "updateCreatedFiles";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "findExistingFileAndSetText";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "doWriteToExistingFile";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getFullFilePath";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "checkResult";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "runWithAutoPopupEnabled";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "assertGuttersAtCaret";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotations";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationMessages";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "runCheckAndGetAnnotations";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotators";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "runInspections";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "getTestProblemsHolder";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "assertIcons";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getIconsAsStrings";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "assertLineMarkerIcons";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerIcons";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getFieldFQN";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "assertLanguageStandard";
                break;
            }
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "assertClangFeature";
                break;
            }
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "assertClangExtension";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "doAssertClangFeatureOrExtension";
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "assertAutoPopup";
                break;
            }
            case 159: 
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "resolved";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "notResolved";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "declared";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "convertToOsDependentPath";
                break;
            }
            case 167: 
            case 168: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "assertDefines";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "unresolved";
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "inc";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "assertIncludes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 16, 18, 24, 25, 26, 27, 28, 29, 41, 43, 47, 48, 55, 70, 75, 79, 80, 85, 90, 92, 109, 112, 116, 123, 128, 129, 130, 133, 134, 135, 156, 158, 165, 166, 178, 179, 180 -> new IllegalStateException(string);
        };
    }

    protected class CidrCodeInsightTextFixture
    extends CodeInsightTestFixtureImpl {
        public CidrCodeInsightTextFixture(@NotNull IdeaProjectTestFixture projectFixture2, TempDirTestFixture tempDirTestFixture) {
            if (projectFixture2 == null) {
                CidrCodeInsightTextFixture.$$$reportNull$$$0(0);
            }
            if (tempDirTestFixture == null) {
                CidrCodeInsightTextFixture.$$$reportNull$$$0(1);
            }
            super(projectFixture2, tempDirTestFixture);
        }

        @Override
        protected boolean shouldTrackVirtualFilePointers() {
            return false;
        }

        @Override
        protected void prepareVirtualFile(@NotNull VirtualFile file) {
            if (file == null) {
                CidrCodeInsightTextFixture.$$$reportNull$$$0(2);
            }
            CidrCodeInsightFixture.this.prepareVirtualFile(file);
            super.prepareVirtualFile(file);
        }

        @Override
        @NotNull
        protected Editor createEditor(@NotNull VirtualFile file) {
            if (file == null) {
                CidrCodeInsightTextFixture.$$$reportNull$$$0(3);
            }
            Editor editor2 = super.createEditor(file);
            editor2.getCaretModel().moveToOffset(0);
            Editor editor3 = editor2;
            if (editor3 == null) {
                CidrCodeInsightTextFixture.$$$reportNull$$$0(4);
            }
            return editor3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectFixture";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tempDirTestFixture";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/CidrCodeInsightFixture$CidrCodeInsightTextFixture";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$CidrCodeInsightTextFixture";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareVirtualFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createEditor";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static interface FileTracker {
        public void onCreated(@NotNull VirtualFile var1);
    }

    public static class AutoImportFix {
        public static final String ANY_TITLE = "<any_auto_import_title>";
        @NotNull
        String fixTitle;
        @NotNull
        String popupTitle;
        @NotNull
        List<AutoImportChoice> choices;

        public AutoImportFix(@NotNull String fixTitle, @NotNull String popupTitle, AutoImportChoice ... choices) {
            if (fixTitle == null) {
                AutoImportFix.$$$reportNull$$$0(0);
            }
            if (popupTitle == null) {
                AutoImportFix.$$$reportNull$$$0(1);
            }
            if (choices == null) {
                AutoImportFix.$$$reportNull$$$0(2);
            }
            this(fixTitle, popupTitle, Arrays.asList(choices));
        }

        public AutoImportFix(@NotNull String fixTitle, @NotNull String popupTitle, @NotNull List<AutoImportChoice> choices) {
            if (fixTitle == null) {
                AutoImportFix.$$$reportNull$$$0(3);
            }
            if (popupTitle == null) {
                AutoImportFix.$$$reportNull$$$0(4);
            }
            if (choices == null) {
                AutoImportFix.$$$reportNull$$$0(5);
            }
            this.fixTitle = fixTitle;
            this.popupTitle = popupTitle;
            this.choices = choices;
        }

        public String toString() {
            return this.fixTitle + "\n" + this.popupTitle + ":\n------\n" + StringUtil.join(this.choices, (String)"\n------\n") + "\n===================";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoImportFix fix = (AutoImportFix)o;
            if (this.fixTitle != ANY_TITLE && fix.fixTitle != ANY_TITLE && !this.fixTitle.equals(fix.fixTitle)) {
                return false;
            }
            if (this.popupTitle != ANY_TITLE && fix.popupTitle != ANY_TITLE && !this.popupTitle.equals(fix.popupTitle)) {
                return false;
            }
            return this.choices.equals(fix.choices);
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixTitle";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "popupTitle";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "choices";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$AutoImportFix";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AutoImportChoice {
        public static final String ANY_RESULT = "<any_auto_import_choice>";
        @NotNull
        protected final String name;
        @NotNull
        protected final String resultWithFormatting;
        @NotNull
        protected final String resultWithoutFormatting;
        private final boolean checkWithFormat;

        public AutoImportChoice(@NotNull String name, @NotNull String result) {
            if (name == null) {
                AutoImportChoice.$$$reportNull$$$0(0);
            }
            if (result == null) {
                AutoImportChoice.$$$reportNull$$$0(1);
            }
            this(name, result, false);
        }

        public AutoImportChoice(@NotNull String name, @NotNull String result, boolean checkWithFormat) {
            if (name == null) {
                AutoImportChoice.$$$reportNull$$$0(2);
            }
            if (result == null) {
                AutoImportChoice.$$$reportNull$$$0(3);
            }
            this.name = name;
            this.resultWithFormatting = result;
            this.resultWithoutFormatting = CidrCodeInsightFixture.removeFormatting(result);
            this.checkWithFormat = checkWithFormat;
        }

        public String toString() {
            return this.name + ":\n" + this.resultWithFormatting;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoImportChoice anImport = (AutoImportChoice)o;
            if (!this.name.equals(anImport.name)) {
                return false;
            }
            if (this.resultWithFormatting != ANY_RESULT && anImport.resultWithFormatting != ANY_RESULT) {
                return this.checkWithFormat || anImport.checkWithFormat ? this.resultWithFormatting.equals(anImport.resultWithFormatting) : this.resultWithoutFormatting.equals(anImport.resultWithoutFormatting);
            }
            return true;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$AutoImportChoice";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CompletionResult {
        private final String myPrefix;
        private final List<LookupElement> myElements;

        public CompletionResult(String prefix, List<LookupElement> elements) {
            this.myPrefix = prefix;
            this.myElements = elements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompletionResult other = (CompletionResult)o;
            return Objects.equals(this.myPrefix, other.myPrefix) && Comparing.equal(this.getItems(), other.getItems());
        }

        public int hashCode() {
            int result = this.myPrefix.hashCode();
            result = 31 * result + this.getItems().hashCode();
            return result;
        }

        public String toString() {
            return "CompletionResult{myPrefix='" + this.myPrefix + "', myElements=" + String.valueOf(this.getItems()) + "}";
        }

        public List<String> getItems() {
            return this.getItemImpl(LookupElement::getLookupString);
        }

        public List<String> getItems(boolean sorted, @Nullable Function<? super LookupElement, Boolean> filter) {
            return this.getItemImpl(element -> {
                if (filter != null && !((Boolean)filter.apply((LookupElement)element)).booleanValue()) {
                    return null;
                }
                return element.getLookupString();
            }, sorted);
        }

        public List<String> getFullRenderedItems() {
            return this.getFullRenderedItems(true, null);
        }

        public List<String> getFullRenderedItems(boolean sorted, @Nullable Function<? super LookupElement, Boolean> filter) {
            return this.getItemImpl(element -> {
                LookupElementPresentation presentation;
                if (filter != null && !((Boolean)filter.apply((LookupElement)element)).booleanValue()) {
                    return null;
                }
                LookupElementRenderer expensiveRenderer = element.getExpensiveRenderer();
                if (expensiveRenderer != null) {
                    presentation = new LookupElementPresentation();
                    expensiveRenderer.renderElement(element, presentation);
                } else {
                    presentation = LookupElementPresentation.renderElement((LookupElement)element);
                }
                StringBuilder buffer = new StringBuilder();
                if (presentation.isStrikeout()) {
                    buffer.append("~");
                }
                if (presentation.getItemText() != null) {
                    buffer.append(presentation.getItemText());
                }
                if (presentation.getTailText() != null) {
                    buffer.append(presentation.getTailText());
                }
                if (presentation.getTypeText() != null) {
                    buffer.append(":").append(presentation.getTypeText());
                }
                if (presentation.isStrikeout()) {
                    buffer.append("~");
                }
                return buffer.toString();
            }, sorted);
        }

        public List<LookupElementPresentation> getRenderedElementPresentations() {
            if (this.myElements == null) {
                return null;
            }
            return this.myElements.stream().map(element -> LookupElementPresentation.renderElement((LookupElement)element)).sorted(Comparator.comparing(LookupElementPresentation::getItemText)).collect(Collectors.toList());
        }

        @Nullable
        public List<LookupElement> getElements() {
            if (this.myElements == null) {
                return null;
            }
            return Collections.unmodifiableList(this.myElements);
        }

        @Nullable
        private List<String> getItemImpl(Function<LookupElement, @Nullable String> map, boolean sorted) {
            if (this.myElements == null) {
                return null;
            }
            ArrayList<String> answer = new ArrayList<String>();
            for (LookupElement element : this.myElements) {
                String mapped = map.apply(element);
                if (mapped == null) continue;
                answer.add(map.apply(element));
            }
            if (sorted) {
                Collections.sort(answer);
            }
            return answer;
        }

        @Nullable
        private List<String> getItemImpl(Function<LookupElement, String> map) {
            return this.getItemImpl(map, true);
        }
    }

    public static class DefineDescription {
        final String name;
        final State state;
        final String value;

        public DefineDescription(String name, State state, String value2) {
            this.name = name;
            this.state = state;
            this.value = value2;
        }

        public String toString() {
            return String.valueOf((Object)this.state) + " " + this.name + (String)(this.value != null ? "=" + this.value : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefineDescription that = (DefineDescription)o;
            if (this.state != that.state) {
                return false;
            }
            if (!Objects.equals(this.name, that.name)) {
                return false;
            }
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.state.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        static enum State {
            declared,
            resolved,
            not_resolved;

        }
    }

    public static final class IncludeDescription {
        @NotNull
        String includeText;
        String includedPath;
        PsiFile includedFile;

        private IncludeDescription(@NotNull String includeText) {
            if (includeText == null) {
                IncludeDescription.$$$reportNull$$$0(0);
            }
            this.includeText = includeText;
        }

        private IncludeDescription(@NotNull String includeText, @NotNull String includedPath) {
            if (includeText == null) {
                IncludeDescription.$$$reportNull$$$0(1);
            }
            if (includedPath == null) {
                IncludeDescription.$$$reportNull$$$0(2);
            }
            this.includeText = includeText;
            this.includedPath = includedPath;
        }

        private IncludeDescription(@NotNull String includeText, @NotNull PsiFile includedFile) {
            if (includeText == null) {
                IncludeDescription.$$$reportNull$$$0(3);
            }
            if (includedFile == null) {
                IncludeDescription.$$$reportNull$$$0(4);
            }
            this.includeText = includeText;
            this.includedFile = includedFile;
        }

        public String toString() {
            String result = this.includeText + "->";
            result = this.includedFile != null ? result + this.includedFile.getVirtualFile().getPath() : (this.includedPath != null ? result + this.includedPath : result + "<unresolved>");
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IncludeDescription that = (IncludeDescription)o;
            if (!this.includeText.equals(that.includeText)) {
                return false;
            }
            if (!Objects.equals(this.includedFile, that.includedFile)) {
                return false;
            }
            return Objects.equals(this.includedPath, that.includedPath);
        }

        public int hashCode() {
            int result = this.includeText.hashCode();
            result = 31 * result + (this.includedPath != null ? this.includedPath.hashCode() : 0);
            result = 31 * result + (this.includedFile != null ? this.includedFile.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "includeText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "includedPath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "includedFile";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$IncludeDescription";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class GutterInfo {
        @NotNull
        public final Icon icon;
        @NotNull
        public final String tooltip;

        public GutterInfo(@NotNull Icon icon, @NotNull String tooltip) {
            if (icon == null) {
                GutterInfo.$$$reportNull$$$0(0);
            }
            if (tooltip == null) {
                GutterInfo.$$$reportNull$$$0(1);
            }
            this.icon = icon;
            this.tooltip = tooltip;
        }

        public GutterInfo(@NotNull GutterMark mark) {
            if (mark == null) {
                GutterInfo.$$$reportNull$$$0(2);
            }
            this.icon = mark.getIcon();
            this.tooltip = mark.getTooltipText();
        }

        public String toString() {
            return "GutterInfo{tooltip='" + this.tooltip + "'icon='" + String.valueOf(this.icon) + "'@" + System.identityHashCode(this.icon) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GutterInfo info = (GutterInfo)o;
            if (!this.icon.equals(info.icon)) {
                return false;
            }
            return this.tooltip.equals(info.tooltip);
        }

        public int hashCode() {
            int result = this.icon.hashCode();
            result = 31 * result + this.tooltip.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tooltip";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mark";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$GutterInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

