/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHintFixture
implements EditorHintListener {
    private LightweightHint myCurrentHint;

    public EditorHintFixture(Disposable parentDisposable) {
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(EditorHintListener.TOPIC, (Object)this);
    }

    public void hintShown(@NotNull Editor editor2, @NotNull LightweightHint hint, int flags, @NotNull HintHint hintInfo) {
        if (editor2 == null) {
            EditorHintFixture.$$$reportNull$$$0(0);
        }
        if (hint == null) {
            EditorHintFixture.$$$reportNull$$$0(1);
        }
        if (hintInfo == null) {
            EditorHintFixture.$$$reportNull$$$0(2);
        }
        hint.putUserData(LightweightHint.SHOWN_AT_DEBUG, (Object)Boolean.TRUE);
        this.myCurrentHint = hint;
        hint.addHintListener(event -> {
            LightweightHint source = (LightweightHint)event.getSource();
            source.putUserData(LightweightHint.SHOWN_AT_DEBUG, null);
            if (source == this.myCurrentHint) {
                this.myCurrentHint = null;
            }
        });
    }

    @Nullable
    public String getCurrentHintText() {
        return this.myCurrentHint == null ? null : EditorHintFixture.removeCurrentParameterColor(this.myCurrentHint.getComponent().toString());
    }

    public static String removeCurrentParameterColor(String text2) {
        return text2 == null ? null : text2.replace("<b color=1d1d1d>", "<b>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "hint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "hintInfo";
                break;
            }
        }
        objectArray[1] = "com/intellij/testFramework/fixtures/EditorHintFixture";
        objectArray[2] = "hintShown";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

