/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.impl;

import com.intellij.build.events.BuildEvent;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.cidr.cpp.makefile.MakefileBundle;
import com.jetbrains.cidr.cpp.makefile.io.MkEnvironmentAware;
import com.jetbrains.cidr.cpp.makefile.io.MkEnvironmentAwarePathMapper;
import com.jetbrains.cidr.cpp.makefile.io.MkPathMapper;
import com.jetbrains.cidr.cpp.makefile.io.MkPathUtils;
import com.jetbrains.cidr.cpp.makefile.io.MkReaders;
import com.jetbrains.cidr.cpp.makefile.project.resolver.MakefilePipelineStageListener;
import com.jetbrains.cidr.cpp.makefile.project.resolver.MakefileResolverState;
import com.jetbrains.cidr.cpp.makefile.project.resolver.analysis.MkEnvironmentAwareProcessEnvironmentProvider;
import com.jetbrains.cidr.cpp.makefile.project.resolver.analysis.makeOutput.processListeners.MkProcessListenersKt;
import com.jetbrains.cidr.cpp.makefile.project.resolver.issues.MakefileIssuesKt;
import com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.api.MkProjectPreConfigurator;
import com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.api.MkShellScriptWriter;
import com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.impl.MkDefaultProjectPreConfigurator;
import com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.messages.MkPreConfigureFailure;
import com.jetbrains.cidr.cpp.makefile.settings.MakefileExecutionSettings;
import com.jetbrains.cidr.cpp.makefile.util.command.MkParsedArg;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/impl/MkDefaultProjectPreConfigurator;", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/api/MkProjectPreConfigurator;", "<init>", "()V", "preConfigure", "", "state", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/MakefileResolverState;", "stageListener", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/MakefilePipelineStageListener;", "cancellationDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "intellij.clion.makefile"})
@SourceDebugExtension(value={"SMAP\nMkDefaultProjectPreConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MkDefaultProjectPreConfigurator.kt\ncom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/impl/MkDefaultProjectPreConfigurator\n+ 2 MkDefaultProjectPreConfigurator.kt\ncom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/impl/MkDefaultProjectPreConfigurator$Companion\n+ 3 MkEnvironmentAwarePathMapper.kt\ncom/jetbrains/cidr/cpp/makefile/io/MkEnvironmentAwarePathMapper$Companion\n+ 4 MkReaders.kt\ncom/jetbrains/cidr/cpp/makefile/io/MkReaders\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,257:1\n165#2:258\n179#3:259\n63#4,3:260\n66#4:265\n1321#5,2:263\n1#6:266\n13#7:267\n*S KotlinDebug\n*F\n+ 1 MkDefaultProjectPreConfigurator.kt\ncom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/impl/MkDefaultProjectPreConfigurator\n*L\n63#1:258\n65#1:259\n76#1:260,3\n76#1:265\n77#1:263,2\n161#1:267\n*E\n"})
public final class MkDefaultProjectPreConfigurator
implements MkProjectPreConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @RequiresBackgroundThread
    public boolean preConfigure(@NotNull MakefileResolverState state, @NotNull MakefilePipelineStageListener stageListener, @NotNull Disposable cancellationDisposable) throws CancellationException, ProcessCanceledException {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stageListener, (String)"stageListener");
        Intrinsics.checkNotNullParameter((Object)cancellationDisposable, (String)"cancellationDisposable");
        try {
            KFunction kFunction;
            CPPEnvironment environment = state.getEnvironment();
            Charset charset = EncodingManager.getInstance().getDefaultConsoleEncoding();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getDefaultConsoleEncoding(...)");
            Charset shellScriptCharset = charset;
            Companion companion = Companion;
            CPPEnvironment $this$isNativeWindows$iv = environment;
            boolean $i$f$isNativeWindows = false;
            if ($this$isNativeWindows$iv.isMSVC() || $this$isNativeWindows$iv.isMinGW()) {
                kFunction = (KFunction)preConfigure.shellScriptWriter.1.INSTANCE;
            } else if (environment.isCygwin()) {
                kFunction = (KFunction)preConfigure.shellScriptWriter.2.INSTANCE;
            } else {
                MkEnvironmentAwarePathMapper.Companion this_$iv = MkEnvironmentAwarePathMapper.Companion;
                CPPEnvironment $this$isWsl$iv = environment;
                boolean $i$f$isWsl$intellij_clion_makefile = false;
                kFunction = $this$isWsl$iv.getToolSet().isWSL() ? (KFunction)preConfigure.shellScriptWriter.3.INSTANCE : (KFunction)preConfigure.shellScriptWriter.4.INSTANCE;
            }
            MkShellScriptWriter shellScriptWriter2 = (MkShellScriptWriter)((Function2)kFunction).invoke((Object)environment, (Object)shellScriptCharset);
            MakefileExecutionSettings settings = state.getExecutionSettings();
            Pair<Path, List<MkParsedArg>> pair = shellScriptWriter2.writeAndReturnCommandLine(settings.getPreConfigureCommands(), LOGGER.isDebugEnabled());
            Path shellScript = (Path)pair.component1();
            List commandLine = (List)pair.component2();
            try {
                boolean bl;
                Integer exitCode;
                Object[] $this$forEach$iv;
                void $this$useLines_u24default$iv;
                InputStream inputStream = Files.newInputStream(shellScript, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Closeable closeable = inputStream;
                Reader reader = new InputStreamReader((InputStream)closeable, shellScriptCharset);
                int n = 8192;
                closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                Function1 readLineExt$iv = MkReaders.useLines.1.INSTANCE;
                boolean $i$f$useLines = false;
                Closeable closeable2 = $this$useLines_u24default$iv;
                int n2 = 8192;
                closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n2);
                Throwable throwable = null;
                try {
                    BufferedReader reader$iv = (BufferedReader)closeable2;
                    boolean bl2 = false;
                    Object[] shellScriptLines = MkReaders.lineSequence(reader$iv, (Function1<? super BufferedReader, String>)readLineExt$iv);
                    boolean bl3 = false;
                    $this$forEach$iv = shellScriptLines;
                    boolean $i$f$forEach = false;
                    for (Object e : $this$forEach$iv) {
                        String shellScriptLine = (String)e;
                        boolean bl4 = false;
                        String string = shellScriptLine + "\n";
                        ProcessOutputType processOutputType = ProcessOutputType.SYSTEM;
                        Intrinsics.checkNotNullExpressionValue((Object)processOutputType, (String)"SYSTEM");
                        stageListener.onOutput(string, processOutputType);
                    }
                    reader$iv = Unit.INSTANCE;
                }
                catch (Throwable bl2) {
                    throwable = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
                Regex shellScriptPattern = new Regex("\\Q" + shellScript + "\\E(?:\\[\\d+])?:\\h*");
                Function2 outputFilter = (arg_0, arg_1) -> MkDefaultProjectPreConfigurator.preConfigure$lambda$1(shellScriptPattern, arg_0, arg_1);
                Path localProjectDirectory = state.getProjectPath();
                Path localWorkDirectory = localProjectDirectory.resolve(settings.getBuildDirectory()).normalize();
                Intrinsics.checkNotNull((Object)localWorkDirectory);
                if (!MkPathUtils.isSameFileAs(localProjectDirectory, localWorkDirectory) && !MkPathUtils.isAncestorOf(localProjectDirectory, localWorkDirectory)) {
                    LOGGER.warn("Local build directory: " + localWorkDirectory + " is not a sub-directory of the local project directory: " + localProjectDirectory);
                }
                MkPathMapper $this$preConfigure_u24lambda_u242 = MkEnvironmentAwarePathMapper.Companion.asPathMapper$intellij_clion_makefile(environment);
                boolean bl5 = false;
                String envWorkDirectory = $this$preConfigure_u24lambda_u242.toEnvPath-bUHPgTw(localWorkDirectory);
                LOGGER.info("Build directory within the target environment: " + MkParsedArg.toString-impl(envWorkDirectory));
                $this$preConfigure_u24lambda_u242.createDirectories-k752RL4(envWorkDirectory, new FileAttribute[0]);
                Future futureExitCode2 = MkDefaultProjectPreConfigurator.Companion.execAsync(MkEnvironmentAwareProcessEnvironmentProvider.Companion.asProcessEnvironmentProvider(state, shellScriptCharset), commandLine, localWorkDirectory, (Function2<? super String, ? super ProcessOutputType, Unit>)MkProcessListenersKt.filterOutput((Function2<? super String, ? super ProcessOutputType, Unit>)((Function2)new Function2<String, ProcessOutputType, Unit>((Object)stageListener){

                    public final void invoke(String p0, ProcessOutputType p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        ((MakefilePipelineStageListener)this.receiver).onOutput(p0, p1);
                    }
                }), (Function2<? super String, ? super ProcessOutputType, String>)outputFilter));
                Disposer.register((Disposable)cancellationDisposable, () -> MkDefaultProjectPreConfigurator.preConfigure$lambda$3(futureExitCode2));
                Integer n3 = exitCode = (Integer)futureExitCode2.get();
                if (n3 != null && n3 == 0) {
                    bl = true;
                } else {
                    String string;
                    if (exitCode == null) {
                        string = MakefileBundle.message("preconfigure.project.commands.not.started", new Object[0]);
                    } else {
                        $this$forEach$iv = new Object[]{exitCode};
                        string = MakefileBundle.message("preconfigure.project.commands.finished", $this$forEach$iv);
                    }
                    String string2 = string;
                    Intrinsics.checkNotNull((Object)string2);
                    String p0 = string2;
                    boolean bl6 = false;
                    MkPreConfigureFailure failure = new MkPreConfigureFailure(p0, null, 2, null);
                    stageListener.onEvent((BuildEvent)MakefileIssuesKt.asBuildIssueEvent(failure, "MAKEFILE_REPLACE_ID"));
                    bl = false;
                }
                boolean bl7 = bl;
                return bl7;
            }
            finally {
                Files.delete(shellScript);
            }
        }
        catch (IOException ioe) {
            LOGGER.warn((Throwable)ioe);
            String string = MakefileBundle.message("preconfigure.project.commands.io.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MkPreConfigureFailure failure = new MkPreConfigureFailure(string, ioe);
            stageListener.onEvent((BuildEvent)MakefileIssuesKt.asBuildIssueEvent(failure, "MAKEFILE_REPLACE_ID"));
            return false;
        }
        catch (CancellationException ce) {
            throw ce;
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable t) {
            Object[] objectArray = new Object[]{t.toString()};
            String string = MakefileBundle.message("preconfigure.project.commands.unknown.error", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MkPreConfigureFailure failure = new MkPreConfigureFailure(string, t);
            stageListener.onEvent((BuildEvent)MakefileIssuesKt.asBuildIssueEvent(failure, "MAKEFILE_REPLACE_ID"));
            throw t;
        }
    }

    private static final String preConfigure$lambda$1(Regex $shellScriptPattern, String outputLine, ProcessOutputType outputType) {
        Intrinsics.checkNotNullParameter((Object)outputLine, (String)"outputLine");
        Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
        return outputType.isStderr() && $shellScriptPattern.containsMatchIn((CharSequence)outputLine) ? $shellScriptPattern.replace((CharSequence)outputLine, "") : outputLine;
    }

    private static final void preConfigure$lambda$3(Future $futureExitCode) {
        $futureExitCode.cancel(true);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MkDefaultProjectPreConfigurator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jo\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b*\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00132?\u0010\u0014\u001a;\u0012\u0018\u0012\u00160\u0016\u00a2\u0006\u0002\b\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001d0\u0015j\u0002`\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00020\u0007*\u00020\b8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/impl/MkDefaultProjectPreConfigurator$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "isNativeWindows", "", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "(Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;)Z", "execAsync", "Ljava/util/concurrent/Future;", "", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/MkEnvironmentAwareProcessEnvironmentProvider;", "argv", "", "Lcom/jetbrains/cidr/cpp/makefile/util/command/MkParsedArg;", "Lcom/jetbrains/cidr/cpp/makefile/util/command/MkParsedArgs;", "localWorkDirectory", "Ljava/nio/file/Path;", "outputListener", "Lkotlin/Function2;", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lkotlin/ParameterName;", "name", "newlineTerminatedOutputLine", "Lcom/intellij/execution/process/ProcessOutputType;", "outputType", "", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/makeOutput/processListeners/MkProcessOutputListener;", "intellij.clion.makefile"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isNativeWindows(CPPEnvironment $this$isNativeWindows) {
            boolean $i$f$isNativeWindows = false;
            return $this$isNativeWindows.isMSVC() || $this$isNativeWindows.isMinGW();
        }

        private final Future<Integer> execAsync(MkEnvironmentAwareProcessEnvironmentProvider $this$execAsync, List<MkParsedArg> argv, Path localWorkDirectory, Function2<? super String, ? super ProcessOutputType, Unit> outputListener) {
            BaseProcessHandler baseProcessHandler;
            CompletableFuture<Integer> futureExitCode2 = new CompletableFuture<Integer>();
            try {
                baseProcessHandler = MkEnvironmentAware.Companion.createProcess$intellij_clion_makefile$default(MkEnvironmentAware.Companion, $this$execAsync, argv, localWorkDirectory, false, false, false, null, 60, null);
            }
            catch (ExecutionException ee) {
                LOGGER.warn((Throwable)ee);
                String string = ee + "\n";
                ProcessOutputType processOutputType = ProcessOutputType.SYSTEM;
                Intrinsics.checkNotNullExpressionValue((Object)processOutputType, (String)"SYSTEM");
                outputListener.invoke((Object)string, (Object)processOutputType);
                futureExitCode2.complete(null);
                return futureExitCode2;
            }
            BaseProcessHandler process2 = baseProcessHandler;
            futureExitCode2.whenComplete((arg_0, arg_1) -> Companion.execAsync$lambda$1((arg_0, arg_1) -> Companion.execAsync$lambda$0($this$execAsync, process2, arg_0, arg_1), arg_0, arg_1));
            process2.addProcessListener((ProcessListener)new ProcessAdapter((BaseProcessHandler<? extends Process>)process2, futureExitCode2, outputListener){
                final /* synthetic */ BaseProcessHandler<? extends Process> $process;
                final /* synthetic */ CompletableFuture<Integer> $futureExitCode;
                final /* synthetic */ Function2<String, ProcessOutputType, Unit> $outputListener;
                {
                    this.$process = $process;
                    this.$futureExitCode = $futureExitCode;
                    this.$outputListener = $outputListener;
                }

                public void startNotified(ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.$process.getProcess().getOutputStream().close();
                }

                public void processTerminated(ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.$futureExitCode.complete(event.getExitCode());
                }

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    if (this.$futureExitCode.isCancelled()) {
                        return;
                    }
                    Key<?> key = outputType;
                    if (!Intrinsics.areEqual(key, (Object)ProcessOutputType.SYSTEM) && key instanceof ProcessOutputType) {
                        String string = event.getText();
                        if (string == null) {
                            return;
                        }
                        String newlineTerminatedOutputLine = string;
                        this.$outputListener.invoke((Object)newlineTerminatedOutputLine, outputType);
                    }
                }
            });
            process2.startNotify();
            return futureExitCode2;
        }

        private static final Unit execAsync$lambda$0(MkEnvironmentAwareProcessEnvironmentProvider $this_execAsync, BaseProcessHandler $process, Integer exitCode, Throwable cause) {
            if (cause == null) {
                LOGGER.info("Pre-configuration commands finished with code: " + exitCode);
            } else {
                if (cause instanceof CancellationException) {
                    LOGGER.info("Pre-configuration commands cancelled");
                } else {
                    LOGGER.info("Pre-configuration commands finished with code: " + exitCode);
                    LOGGER.warn(cause);
                }
                $this_execAsync.getEnvironment().getHostMachine().killProcessTree($process);
            }
            return Unit.INSTANCE;
        }

        private static final void execAsync$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

