/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.makefile.project.resolver.analysis;

import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.AbstractBuildEvent;
import com.intellij.build.events.impl.DerivedResultImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.jetbrains.cidr.cpp.makefile.MakefileBundle;
import com.jetbrains.cidr.cpp.makefile.MakefileLog;
import com.jetbrains.cidr.cpp.makefile.project.resolver.MakefilePipelineStageListener;
import com.jetbrains.cidr.cpp.makefile.project.resolver.MakefileProjectAnalyzer;
import com.jetbrains.cidr.cpp.makefile.project.resolver.MakefileResolverState;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b`\u0018\u00002\u00020\u0001:\u0002\u000e\u000fR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/MakefileProjectAnalyzerStage;", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/MakefileProjectAnalyzer;", "type", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/MakefileProjectAnalyzerStage$Type;", "getType", "()Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/MakefileProjectAnalyzerStage$Type;", "listener", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/MakefilePipelineStageListener;", "getListener", "()Lcom/jetbrains/cidr/cpp/makefile/project/resolver/MakefilePipelineStageListener;", "name", "", "getName", "()Ljava/lang/String;", "Type", "Listener", "intellij.clion.makefile"})
public interface MakefileProjectAnalyzerStage
extends MakefileProjectAnalyzer {
    @NotNull
    public Type getType();

    @NotNull
    public MakefilePipelineStageListener getListener();

    @NonNls
    @NotNull
    default public String getName() {
        return this.getType().name();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/MakefileProjectAnalyzerStage$Listener;", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/MakefilePipelineStageListener;", "stageType", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/MakefileProjectAnalyzerStage$Type;", "resolverState", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/MakefileResolverState;", "parentListener", "<init>", "(Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/MakefileProjectAnalyzerStage$Type;Lcom/jetbrains/cidr/cpp/makefile/project/resolver/MakefileResolverState;Lcom/jetbrains/cidr/cpp/makefile/project/resolver/MakefilePipelineStageListener;)V", "startEventId", "", "viewManager", "Lcom/intellij/build/SyncViewManager;", "onOutput", "", "text", "outputType", "Lcom/intellij/execution/process/ProcessOutputType;", "onEvent", "event", "Lcom/intellij/build/events/BuildEvent;", "onStarted", "onFinished", "success", "", "intellij.clion.makefile"})
    @SourceDebugExtension(value={"SMAP\nMakefileProjectAnalyzerStage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakefileProjectAnalyzerStage.kt\ncom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/MakefileProjectAnalyzerStage$Listener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,131:1\n30#2,2:132\n*S KotlinDebug\n*F\n+ 1 MakefileProjectAnalyzerStage.kt\ncom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/MakefileProjectAnalyzerStage$Listener\n*L\n69#1:132,2\n*E\n"})
    public static final class Listener
    implements MakefilePipelineStageListener {
        @NotNull
        private final Type stageType;
        @NotNull
        private final MakefileResolverState resolverState;
        @NotNull
        private final MakefilePipelineStageListener parentListener;
        @Nullable
        private volatile String startEventId;
        @NotNull
        private final SyncViewManager viewManager;

        public Listener(@NotNull Type stageType, @NotNull MakefileResolverState resolverState, @NotNull MakefilePipelineStageListener parentListener) {
            Intrinsics.checkNotNullParameter((Object)((Object)stageType), (String)"stageType");
            Intrinsics.checkNotNullParameter((Object)resolverState, (String)"resolverState");
            Intrinsics.checkNotNullParameter((Object)parentListener, (String)"parentListener");
            this.stageType = stageType;
            this.resolverState = resolverState;
            this.parentListener = parentListener;
            ComponentManager $this$service$iv = (ComponentManager)this.resolverState.getProject();
            boolean $i$f$service = false;
            Class<SyncViewManager> serviceClass$iv = SyncViewManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            this.viewManager = (SyncViewManager)object;
        }

        @Override
        public void onOutput(@NotNull String text, @NotNull ProcessOutputType outputType) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
            if (this.startEventId == null) {
                MakefileLog.LOG.error("MakefileProjectAnalyzerStage.Listener(" + this.stageType.name() + "): onOutput() called before onStarted()");
                return;
            }
            this.viewManager.onEvent((Object)this.resolverState.getId(), (BuildEvent)new OutputBuildEventImpl((Object)this.startEventId, text, outputType));
        }

        @Override
        public void onEvent(@NotNull BuildEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.startEventId == null) {
                MakefileLog.LOG.error("MakefileProjectAnalyzerStage.Listener(" + this.stageType.name() + "): onEvent() called before onStarted()");
                return;
            }
            if (event instanceof AbstractBuildEvent && Intrinsics.areEqual((Object)((AbstractBuildEvent)event).getParentId(), (Object)"MAKEFILE_REPLACE_ID")) {
                ((AbstractBuildEvent)event).setParentId((Object)this.startEventId);
            }
            this.parentListener.onEvent(event);
        }

        @Override
        public void onStarted() {
            this.startEventId = this.stageType.name() + UUID.randomUUID();
            String string = this.startEventId;
            Intrinsics.checkNotNull((Object)string);
            StartEventImpl startEvent = new StartEventImpl((Object)string, (Object)"MAKEFILE_REPLACE_ID", System.currentTimeMillis(), this.stageType.getDisplayName());
            this.parentListener.onEvent((BuildEvent)startEvent);
        }

        @Override
        public void onFinished(boolean success) {
            if (this.startEventId == null) {
                MakefileLog.LOG.error("MakefileProjectAnalyzerStage.Listener(" + this.stageType.name() + "): onFinished() called before onStarted()");
                return;
            }
            String string = this.startEventId;
            Intrinsics.checkNotNull((Object)string);
            FinishEventImpl finishEvent = new FinishEventImpl((Object)string, (Object)"MAKEFILE_REPLACE_ID", System.currentTimeMillis(), success ? this.stageType.getDisplayName() : this.stageType.getErrorMessage(), success ? (EventResult)new DerivedResultImpl() : (EventResult)new FailureResultImpl());
            this.parentListener.onEvent((BuildEvent)finishEvent);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/MakefileProjectAnalyzerStage$Type;", "", "displayName", "", "errorMessage", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "getErrorMessage", "MAKE_OUTPUT", "BUILD_TARGETS", "CLEAN", "intellij.clion.makefile"})
    public static final class Type
    extends Enum<Type> {
        @NotNull
        private final String displayName;
        @NotNull
        private final String errorMessage;
        public static final /* enum */ Type MAKE_OUTPUT;
        public static final /* enum */ Type BUILD_TARGETS;
        public static final /* enum */ Type CLEAN;
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(String displayName, String errorMessage) {
            this.displayName = displayName;
            this.errorMessage = errorMessage;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            String string = MakefileBundle.message("make.output.analysis.stage.display.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = MakefileBundle.message("make.output.analysis.stage.failure.general.message.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            MAKE_OUTPUT = new Type(string, string2);
            String string3 = MakefileBundle.message("build.targets.analysis.stage.display.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            String string4 = MakefileBundle.message("build.targets.analysis.stage.failure.general.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            BUILD_TARGETS = new Type(string3, string4);
            String string5 = MakefileBundle.message("clean.analysis.stage.display.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            String string6 = MakefileBundle.message("clean.analysis.stage.failure.general.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
            CLEAN = new Type(string5, string6);
            $VALUES = typeArray = new Type[]{Type.MAKE_OUTPUT, Type.BUILD_TARGETS, Type.CLEAN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

