/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.translateCode;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a)\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0006\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001\u00a8\u0006\r"}, d2={"pathOrNull", "Ljava/nio/file/Path;", "first", "", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "isSameFile", "", "path1Str", "path2Str", "path", "path2", "intellij.cidr.translateCode"})
public final class UtilKt {
    @Nullable
    public static final Path pathOrNull(@NotNull String first, String ... more) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        try {
            path = Path.of(first, Arrays.copyOf(more, more.length));
        }
        catch (InvalidPathException e) {
            path = null;
        }
        return path;
    }

    public static final boolean isSameFile(@NotNull String path1Str, @NotNull String path2Str) {
        Intrinsics.checkNotNullParameter((Object)path1Str, (String)"path1Str");
        Intrinsics.checkNotNullParameter((Object)path2Str, (String)"path2Str");
        if (Intrinsics.areEqual((Object)path1Str, (Object)path2Str)) {
            return true;
        }
        Path path = UtilKt.pathOrNull(path1Str, new String[0]);
        if (path == null) {
            return false;
        }
        Path path1 = path;
        Path path2 = UtilKt.pathOrNull(path2Str, new String[0]);
        if (path2 == null) {
            return false;
        }
        Path path22 = path2;
        return UtilKt.isSameFile(path1, path22);
    }

    public static final boolean isSameFile(@NotNull Path path, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        try {
            return Files.isSameFile(path, path2);
        }
        catch (IOException e) {
            return false;
        }
    }
}

