/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.translateCode;

import com.intellij.cidr.translateCode.CidrTranslationResultBuilder;
import com.intellij.cidr.translateCode.UtilKt;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0019\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\u0004\u0018\u00010\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J$\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/cidr/translateCode/Masm;", "", "msvcAssemblyOutput", "", "srcFilePath", "isRaw", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "processOutput", "", "builder", "Lcom/intellij/cidr/translateCode/CidrTranslationResultBuilder;", "parseSrcLineMarker", "", "line", "(Ljava/lang/String;)Ljava/lang/Integer;", "findNextNonBlankLine", "lines", "", "startIndex", "demangleBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "demangleNames", "demangledNames", "", "Companion", "intellij.cidr.translateCode"})
public final class Masm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String msvcAssemblyOutput;
    @NotNull
    private final String srcFilePath;
    private final boolean isRaw;
    @NotNull
    private final StringBuilder demangleBuffer;
    @NotNull
    private static final String PUBLIC = "PUBLIC";
    @NotNull
    private static final String EXTRN = "EXTRN";
    @NotNull
    private static final String EXTERN = "EXTERN";
    @NotNull
    private static final List<String> symbolNameDirectives;
    @NotNull
    private static final HashSet<String> directivesToSkip;
    @NotNull
    private static final String FILE_MARK_PREFIX = "; File ";
    @NotNull
    private static final String LINE_NUMBER_PREFIX = "; ";
    @NotNull
    private static final String PROC_BEGIN = "PROC";
    @NotNull
    private static final String PROC_END = "ENDP";

    public Masm(@NotNull String msvcAssemblyOutput, @NotNull String srcFilePath, boolean isRaw) {
        Intrinsics.checkNotNullParameter((Object)msvcAssemblyOutput, (String)"msvcAssemblyOutput");
        Intrinsics.checkNotNullParameter((Object)srcFilePath, (String)"srcFilePath");
        this.msvcAssemblyOutput = msvcAssemblyOutput;
        this.srcFilePath = srcFilePath;
        this.isRaw = isRaw;
        this.demangleBuffer = new StringBuilder();
    }

    public final void processOutput(@NotNull CidrTranslationResultBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Map matchingPaths = new LinkedHashMap();
        boolean codeFromSrcFile = false;
        boolean isInsideProc = false;
        List lines = StringsKt.lines((CharSequence)this.msvcAssemblyOutput);
        HashMap demangledNames = new HashMap();
        if (!this.isRaw) {
            for (String line : lines) {
                Pair names;
                Pair pair = Masm.Companion.parseMangledNameDirective(line);
                if (pair == null) {
                    pair = Masm.Companion.parseDemangledNameFromFuncHeader(line);
                }
                if ((names = pair) == null) continue;
                ((Map)demangledNames).put(names.getFirst(), names.getSecond());
            }
        }
        Iterator<Object> iterator = ((Iterable)lines).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            String line = (String)iterator.next();
            if (StringsKt.startsWith$default((String)line, (String)FILE_MARK_PREFIX, (boolean)false, (int)2, null)) {
                String string = line.substring(7);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String path = ((Object)StringsKt.trim((CharSequence)string)).toString();
                Boolean bl = matchingPaths.computeIfAbsent(path, arg_0 -> Masm.processOutput$lambda$1(arg_0 -> Masm.processOutput$lambda$0(this, path, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
                codeFromSrcFile = bl;
                if (!codeFromSrcFile) {
                    builder.resetSrcLine();
                }
            } else {
                Integer srcLine1;
                Integer n2 = srcLine1 = codeFromSrcFile ? this.parseSrcLineMarker(line) : null;
                if (srcLine1 != null) {
                    builder.markSrcLine(srcLine1);
                }
            }
            if (this.isRaw) {
                builder.addTranslatedCodeLine(line);
                continue;
            }
            String noCommentsLine = Companion.stripComments(line);
            if (StringsKt.isBlank((CharSequence)noCommentsLine) || Companion.isDirectiveToSkip(noCommentsLine)) continue;
            if (Masm.Companion.isProcBegin(noCommentsLine)) {
                Integer srcLine1;
                isInsideProc = true;
                builder.resetSrcLine();
                builder.addTranslatedCodeLine("");
                Integer n3 = srcLine1 = codeFromSrcFile ? this.parseSrcLineMarker(this.findNextNonBlankLine(lines, idx + 1)) : null;
                if (srcLine1 != null) {
                    builder.markSrcLine(srcLine1);
                }
            } else if (Masm.Companion.isProcEnd(noCommentsLine)) {
                isInsideProc = false;
                builder.addTranslatedCodeLine(this.demangleNames(noCommentsLine, demangledNames));
            }
            if (!isInsideProc) continue;
            builder.addTranslatedCodeLine(this.demangleNames(noCommentsLine, demangledNames));
        }
    }

    private final Integer parseSrcLineMarker(String line) {
        String string = line;
        if (!(string != null ? StringsKt.startsWith$default((String)string, (String)LINE_NUMBER_PREFIX, (boolean)false, (int)2, null) : false)) {
            return null;
        }
        int colonIdx = StringsKt.indexOf$default((CharSequence)line, (String)":", (int)2, (boolean)false, (int)4, null);
        if (colonIdx == -1) {
            return null;
        }
        String string2 = line.substring(2, colonIdx);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
    }

    private final String findNextNonBlankLine(List<String> lines, int startIndex) {
        int idx = startIndex;
        int n = CollectionsKt.getLastIndex(lines);
        if (idx <= n) {
            while (true) {
                String line;
                if (!StringsKt.isBlank((CharSequence)(line = ((Object)StringsKt.trimEnd((CharSequence)lines.get(idx))).toString()))) {
                    return line;
                }
                if (idx == n) break;
                ++idx;
            }
        }
        return null;
    }

    private final String demangleNames(String line, Map<String, String> demangledNames) {
        this.demangleBuffer.setLength(0);
        int idx = 0;
        while (idx < line.length()) {
            String mangledName;
            int nameStartIdx = StringsKt.indexOf$default((CharSequence)line, (char)'?', (int)idx, (boolean)false, (int)4, null);
            if (nameStartIdx == -1) {
                if (idx == 0) {
                    return line;
                }
                this.demangleBuffer.append(line.subSequence(idx, line.length()));
                break;
            }
            this.demangleBuffer.append(line.subSequence(idx, nameStartIdx));
            char[] cArray = new char[]{' ', '\t'};
            int nameEndIdx = StringsKt.indexOfAny$default((CharSequence)line, (char[])cArray, (int)nameStartIdx, (boolean)false, (int)4, null);
            if (nameEndIdx == -1) {
                nameEndIdx = line.length();
            }
            Intrinsics.checkNotNullExpressionValue((Object)line.substring(nameStartIdx, nameEndIdx), (String)"substring(...)");
            String demangledName = demangledNames.get(mangledName);
            StringBuilder stringBuilder = demangledName != null ? this.demangleBuffer.append(demangledName) : this.demangleBuffer.append(mangledName);
            idx = nameEndIdx;
        }
        String string = this.demangleBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Boolean processOutput$lambda$0(Masm this$0, String $path, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UtilKt.isSameFile(this$0.srcFilePath, $path);
    }

    private static final Boolean processOutput$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{PUBLIC, EXTRN, EXTERN};
        symbolNameDirectives = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"include", "INCLUDELIB", PUBLIC, EXTRN, EXTERN};
        directivesToSkip = SetsKt.hashSetOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001e\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001e\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u000bj\b\u0012\u0004\u0012\u00020\u0005`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/cidr/translateCode/Masm$Companion;", "", "<init>", "()V", "PUBLIC", "", "EXTRN", "EXTERN", "symbolNameDirectives", "", "directivesToSkip", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "FILE_MARK_PREFIX", "LINE_NUMBER_PREFIX", "PROC_BEGIN", "PROC_END", "stripComments", "line", "isDirectiveToSkip", "", "isIdChar", "c", "", "skipId", "", "s", "isProcBegin", "lineWithoutComments", "isProcEnd", "stripDirective", "directive", "stripSymbolNameDirectives", "parseMangledNameDirective", "Lkotlin/Pair;", "parseDemangledNameFromFuncHeader", "intellij.cidr.translateCode"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String stripComments(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            int commentStartIdx = StringsKt.indexOf$default((CharSequence)line, (char)';', (int)0, (boolean)false, (int)6, null);
            if (commentStartIdx != -1) {
                return ((Object)StringsKt.trimEnd((CharSequence)StringsKt.substring((String)line, (IntRange)RangesKt.until((int)0, (int)commentStartIdx)))).toString();
            }
            return ((Object)StringsKt.trimEnd((CharSequence)line)).toString();
        }

        public final boolean isDirectiveToSkip(@NotNull String line) {
            char c;
            int idx;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            for (idx = 0; idx < line.length() && ((c = line.charAt(idx)) == ' ' || c == '\t'); ++idx) {
            }
            if (idx == line.length()) {
                return false;
            }
            int wordStart = idx;
            char[] cArray = new char[]{' ', '\t'};
            int wordEnd = StringsKt.indexOfAny$default((CharSequence)line, (char[])cArray, (int)idx, (boolean)false, (int)4, null);
            if (wordEnd == -1) {
                return false;
            }
            return directivesToSkip.contains(StringsKt.substring((String)line, (IntRange)RangesKt.until((int)wordStart, (int)wordEnd)));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isIdChar(char c) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if ('a' <= c) {
                if (c < '{') {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if ('A' <= c) {
                if (c < '[') {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if ('0' <= c) {
                if (c < ':') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (c == '@') return true;
            if (c == '_') return true;
            if (c == '$') return true;
            if (c != '?') return false;
            return true;
        }

        private final int skipId(String s) {
            int idx;
            for (idx = 0; idx < s.length() && this.isIdChar(s.charAt(idx)); ++idx) {
            }
            return idx;
        }

        private final boolean isProcBegin(String lineWithoutComments) {
            int idx = this.skipId(lineWithoutComments);
            if (idx == 0 || idx == lineWithoutComments.length()) {
                return false;
            }
            if (!CharsKt.isWhitespace((char)lineWithoutComments.charAt(idx))) {
                return false;
            }
            while (idx < lineWithoutComments.length() && CharsKt.isWhitespace((char)lineWithoutComments.charAt(idx))) {
                ++idx;
            }
            if (!StringsKt.startsWith$default((String)lineWithoutComments, (String)Masm.PROC_BEGIN, (int)idx, (boolean)false, (int)4, null)) {
                return false;
            }
            return idx + 4 == lineWithoutComments.length() || CharsKt.isWhitespace((char)lineWithoutComments.charAt(idx + 4));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isProcEnd(String lineWithoutComments) {
            if (!StringsKt.endsWith$default((String)lineWithoutComments, (String)Masm.PROC_END, (boolean)false, (int)2, null)) return false;
            Character c = StringsKt.getOrNull((CharSequence)lineWithoutComments, (int)(lineWithoutComments.length() - 4 - 1));
            if (c == null) return false;
            if (!CharsKt.isWhitespace((char)c.charValue())) return false;
            return true;
        }

        private final String stripDirective(String line, String directive) {
            if (StringsKt.startsWith$default((String)line, (String)directive, (boolean)false, (int)2, null)) {
                Character c = StringsKt.getOrNull((CharSequence)line, (int)directive.length());
                boolean bl = c != null ? CharsKt.isWhitespace((char)c.charValue()) : false;
                if (bl) {
                    String string = line.substring(directive.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    return ((Object)StringsKt.trimStart((CharSequence)string)).toString();
                }
            }
            return null;
        }

        private final String stripSymbolNameDirectives(String line) {
            for (String directive : symbolNameDirectives) {
                String noDirective = this.stripDirective(line, directive);
                if (noDirective == null) continue;
                return noDirective;
            }
            return null;
        }

        private final Pair<String, String> parseMangledNameDirective(String line) {
            String string = this.stripSymbolNameDirectives(line);
            if (string == null) {
                return null;
            }
            String noDirective = string;
            if (!StringsKt.startsWith$default((String)noDirective, (String)"?", (boolean)false, (int)2, null)) {
                return null;
            }
            int commentIdx = StringsKt.indexOf$default((CharSequence)noDirective, (char)';', (int)0, (boolean)false, (int)6, null);
            if (commentIdx == -1) {
                return null;
            }
            String string2 = noDirective.substring(0, commentIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String mangledName = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (StringsKt.endsWith$default((String)mangledName, (String)":PROC", (boolean)false, (int)2, null)) {
                String string3 = mangledName.substring(0, mangledName.length() - 5);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                mangledName = string3;
            }
            String string4 = noDirective.substring(commentIdx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String demangledName = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            return TuplesKt.to((Object)mangledName, (Object)demangledName);
        }

        private final Pair<String, String> parseDemangledNameFromFuncHeader(String line) {
            int commentIdx = StringsKt.indexOf$default((CharSequence)line, (char)';', (int)0, (boolean)false, (int)6, null);
            if (commentIdx <= 0) {
                return null;
            }
            int procEndIdx = StringUtil.skipWhitespaceBackward((CharSequence)line, (int)(commentIdx - 1));
            if (procEndIdx == 0) {
                return null;
            }
            char[] cArray = new char[]{' ', '\t'};
            int spaceBeforeProcIdx = StringsKt.lastIndexOfAny$default((CharSequence)line, (char[])cArray, (int)(procEndIdx - 1), (boolean)false, (int)4, null);
            if (spaceBeforeProcIdx <= 0) {
                return null;
            }
            String string = line.substring(spaceBeforeProcIdx + 1, procEndIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (!Intrinsics.areEqual((Object)Masm.PROC_BEGIN, (Object)string)) {
                return null;
            }
            int mangledNameEnd = StringUtil.skipWhitespaceBackward((CharSequence)line, (int)spaceBeforeProcIdx);
            String string2 = line.substring(0, mangledNameEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String mangledName = string2;
            String string3 = line.substring(commentIdx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String demangledName = StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (CharSequence)", COMDAT");
            return TuplesKt.to((Object)mangledName, (Object)demangledName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

