/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.radler.core.ui;

import com.intellij.CommonBundle;
import com.intellij.clion.radler.core.RadBundle;
import com.intellij.clion.radler.core.projectmodel.RadProjectModelHost;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.psi.PsiManager;
import com.intellij.util.ApplicationKt;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.OCFileScopeProvider;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.InterfacesKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.cpp.fileType.psi.CppFile;
import com.jetbrains.rider.model.CppFileContext;
import com.jetbrains.rider.model.RadEditorContextModel_PregeneratedKt;
import com.jetbrains.rider.model.RadLanguageKind;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/clion/radler/core/ui/RadResolveContextWidget;", "Lcom/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "ID", "", "createPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "createInstance", "Lcom/intellij/openapi/wm/StatusBarWidget;", "getComponent", "Ljavax/swing/JComponent;", "getWidgetState", "Lcom/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup$WidgetState;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.clion.radler.core"})
public final class RadResolveContextWidget
extends EditorBasedStatusBarPopup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "ActiveRadlerBuildConfiguration";
    @NotNull
    private static final String PREFIX_SEPARATOR = " | ";
    @NotNull
    private static final String CONTEXT_PREFIX = RadBundle.INSTANCE.message("resolve.contexts.prefix", new Object[0]) + " | ";
    @NotNull
    private static final EditorBasedStatusBarPopup.WidgetState LOADING_STATE = new EditorBasedStatusBarPopup.WidgetState(RadBundle.INSTANCE.message("resolve.contexts.loading", new Object[0]), CONTEXT_PREFIX + CommonBundle.getLoadingTreeNodeText(), false);
    @NotNull
    private static final EditorBasedStatusBarPopup.WidgetState NO_CONTEXT_STATE = new EditorBasedStatusBarPopup.WidgetState(RadBundle.INSTANCE.message("resolve.contexts.prefix.no.context", new Object[0]), CONTEXT_PREFIX + RadBundle.INSTANCE.message("resolve.contexts.no.context", new Object[0]), false);

    public RadResolveContextWidget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, false);
        Lifetime lifetime = LifetimeDisposableExKt.createLifetime((Disposable)((Disposable)this));
        ApplicationKt.getApplication().invokeLater(() -> RadResolveContextWidget._init_$lambda$0(project, lifetime, this), project.getDisposed());
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @Nullable
    protected ListPopup createPopup(@NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return null;
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (StatusBarWidget)new RadResolveContextWidget(project);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent component = super.getComponent();
        component.setName(ID);
        return component;
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        CppFileContext context;
        if (file == null || !(PsiManager.getInstance((Project)this.getProject()).findFile(file) instanceof CppFile)) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        if (!OCFileScopeProvider.Companion.getProjectSourceLocationKind(this.getProject(), file).isInProject()) {
            return NO_CONTEXT_STATE;
        }
        Editor editor = this.getEditor();
        if (editor == null || (editor = DocumentExKt.getTextControlId((Editor)editor)) == null) {
            return LOADING_STATE;
        }
        Editor textControlId = editor;
        CppFileContext cppFileContext = context = (CppFileContext)RadEditorContextModel_PregeneratedKt.getRadEditorContextModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.getProject())).getEditorToRoot().get((Object)textControlId);
        if ((cppFileContext != null ? cppFileContext.getConfigName() : null) == null) {
            return LOADING_STATE;
        }
        if (Intrinsics.areEqual((Object)context.getConfigName(), (Object)"")) {
            return NO_CONTEXT_STATE;
        }
        CLanguageKind kind = switch (WhenMappings.$EnumSwitchMapping$0[context.getLanguage().ordinal()]) {
            case 1 -> CLanguageKind.C;
            case 2 -> CLanguageKind.CPP;
            case 3 -> CUDALanguageKind.CUDA;
            default -> throw new NoWhenBranchMatchedException();
        };
        String string = context.getConfigName();
        Intrinsics.checkNotNull((Object)string);
        String configName = string;
        String text = ((OCLanguageKind)kind).getShortDisplayName() + PREFIX_SEPARATOR + StringUtil.shortenTextWithEllipsis((String)configName, (int)40, (int)15);
        Object[] objectArray = new Object[]{((OCLanguageKind)kind).getDisplayName(), configName};
        String tooltip = RadBundle.INSTANCE.message("resolve.contexts.current.file", objectArray);
        return new EditorBasedStatusBarPopup.WidgetState(tooltip, text, false);
    }

    private static final void _init_$lambda$0(Project $project, Lifetime $lifetime, RadResolveContextWidget this$0) {
        IScheduler scheduler = InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)SolutionHostExtensionsKt.getSolution((Project)$project))).getScheduler();
        RadEditorContextModel_PregeneratedKt.getRadEditorContextModel((Solution)SolutionHostExtensionsKt.getSolution((Project)$project)).getEditorToRoot().adviseOn($lifetime, scheduler, arg_0 -> RadResolveContextWidget.lambda$0$0($lifetime, $project, this$0, arg_0));
    }

    private static final Unit lambda$0$0(Lifetime $lifetime, Project $project, RadResolveContextWidget this$0, IViewableMap.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $lifetime.executeIfAlive(() -> RadResolveContextWidget.lambda$0$0$0($project, this$0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$0(Project $project, RadResolveContextWidget this$0) {
        if (RadProjectModelHost.Companion.getInstance($project).isProjectSyncedAtLeastOnce()) {
            this$0.update();
        } else {
            CidrLogService.LOG.debug("Early resolve context request!");
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/clion/radler/core/ui/RadResolveContextWidget$Companion;", "", "<init>", "()V", "ID", "", "Lorg/jetbrains/annotations/NonNls;", "PREFIX_SEPARATOR", "CONTEXT_PREFIX", "Lcom/intellij/openapi/util/NlsContexts$StatusBarText;", "LOADING_STATE", "Lcom/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup$WidgetState;", "NO_CONTEXT_STATE", "intellij.clion.radler.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RadLanguageKind.values().length];
            try {
                nArray[RadLanguageKind.C.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RadLanguageKind.Cpp.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RadLanguageKind.CUDA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

