/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.radler.core.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.icons.IconPathProvider;
import icons.CidrLangIcons;
import icons.SpellcheckerIcons;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/clion/radler/core/ui/RadIconPatcher;", "Lcom/intellij/openapi/util/IconPathPatcher;", "<init>", "()V", "patchPath", "", "path", "classLoader", "Ljava/lang/ClassLoader;", "getContextClassLoader", "originalClassLoader", "Companion", "intellij.clion.radler.core"})
@VisibleForTesting
public final class RadIconPatcher
extends IconPathPatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy<Unit> myInstallPatcher$delegate;
    @NotNull
    private static final Companion.IconAndClassLoader NO_ICON;
    @NotNull
    private static final Companion.IconAndClassLoader myUnclassifiedUsageKind;
    @NotNull
    private static final Map<String, Companion.IconAndClassLoader> myIconsOverrideMap;
    @NotNull
    private static final Set<String> myIgnoredIcons;

    @Nullable
    public String patchPath(@NotNull String path, @Nullable ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Companion.tryPatchPath(path);
    }

    @Nullable
    public ClassLoader getContextClassLoader(@NotNull String path, @Nullable ClassLoader originalClassLoader) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Companion.IconAndClassLoader iconAndClassLoader = myIconsOverrideMap.get(RadIconPatcher.Companion.normalize(path));
        if (iconAndClassLoader == null) {
            return null;
        }
        Companion.IconAndClassLoader iconAndClassLoader2 = iconAndClassLoader;
        ClassLoader classLoader = iconAndClassLoader2.getClassLoader();
        if (classLoader == null) {
            classLoader = originalClassLoader;
        }
        return classLoader;
    }

    private static final Unit myInstallPatcher_delegate$lambda$0() {
        IconLoader.installPathPatcher((IconPathPatcher)new RadIconPatcher());
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance((String)RadIconPatcher.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        myInstallPatcher$delegate = LazyKt.lazy(RadIconPatcher::myInstallPatcher_delegate$lambda$0);
        Icon icon = AllIcons.Nodes.EmptyNode;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"EmptyNode");
        NO_ICON = RadIconPatcher.Companion.all(icon);
        Icon icon2 = AllIcons.Nodes.EmptyNode;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"EmptyNode");
        myUnclassifiedUsageKind = RadIconPatcher.Companion.all(icon2);
        Pair[] pairArray = new Pair[85];
        Icon icon3 = CidrLangIcons.FileTypes.Cpp;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Cpp");
        pairArray[0] = TuplesKt.to((Object)"/rider/fileTypes/cpp.svg", (Object)RadIconPatcher.Companion.cidr(icon3));
        Icon icon4 = CidrLangIcons.FileTypes.H;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"H");
        pairArray[1] = TuplesKt.to((Object)"/rider/fileTypes/cppHeader.svg", (Object)RadIconPatcher.Companion.cidr(icon4));
        Icon icon5 = CidrLangIcons.FileTypes.Cpp;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Cpp");
        pairArray[2] = TuplesKt.to((Object)"/RiderIcons.FileTypes.Cpp", (Object)RadIconPatcher.Companion.cidr(icon5));
        Icon icon6 = CidrLangIcons.FileTypes.H;
        Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"H");
        pairArray[3] = TuplesKt.to((Object)"/RiderIcons.FileTypes.CppHeader", (Object)RadIconPatcher.Companion.cidr(icon6));
        Icon icon7 = AllIcons.Nodes.Folder;
        Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"Folder");
        pairArray[4] = TuplesKt.to((Object)"/resharper/ProjectModel/Directory.svg", (Object)RadIconPatcher.Companion.all(icon7));
        Icon icon8 = CidrLangIcons.AssocFile;
        Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"AssocFile");
        pairArray[5] = TuplesKt.to((Object)"/resharper/PsiServices/Switch.svg", (Object)RadIconPatcher.Companion.cidr(icon8));
        Icon icon9 = AllIcons.Gutter.ImplementingMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"ImplementingMethod");
        pairArray[6] = TuplesKt.to((Object)"/resharper/PsiServices/Implements.svg", (Object)RadIconPatcher.Companion.all(icon9));
        Icon icon10 = AllIcons.Gutter.OverridingMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"OverridingMethod");
        pairArray[7] = TuplesKt.to((Object)"/resharper/PsiServices/Overrides.svg", (Object)RadIconPatcher.Companion.all(icon10));
        Icon icon11 = AllIcons.Gutter.OverridingMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon11, (String)"OverridingMethod");
        pairArray[8] = TuplesKt.to((Object)"/resharper/PsiServices/OverridesAndImplements", (Object)RadIconPatcher.Companion.all(icon11));
        Icon icon12 = AllIcons.Gutter.OverridingMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon12, (String)"OverridingMethod");
        pairArray[9] = TuplesKt.to((Object)"/resharper/PsiServices/Overrides.svg", (Object)RadIconPatcher.Companion.all(icon12));
        Icon icon13 = AllIcons.Gutter.OverridingMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon13, (String)"OverridingMethod");
        pairArray[10] = TuplesKt.to((Object)"/resharper/PsiServices/Hides.svg", (Object)RadIconPatcher.Companion.all(icon13));
        Icon icon14 = AllIcons.Gutter.OverridingMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon14, (String)"OverridingMethod");
        pairArray[11] = TuplesKt.to((Object)"/resharper/PsiServices/HidesAndImplements.svg", (Object)RadIconPatcher.Companion.all(icon14));
        Icon icon15 = AllIcons.Gutter.ImplementedMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon15, (String)"ImplementedMethod");
        pairArray[12] = TuplesKt.to((Object)"/resharper/PsiServices/HasImplementations.svg", (Object)RadIconPatcher.Companion.all(icon15));
        Icon icon16 = AllIcons.Gutter.OverridenMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon16, (String)"OverridenMethod");
        pairArray[13] = TuplesKt.to((Object)"/resharper/PsiServices/HasOverrides.svg", (Object)RadIconPatcher.Companion.all(icon16));
        Icon icon17 = AllIcons.Gutter.RecursiveMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon17, (String)"RecursiveMethod");
        pairArray[14] = TuplesKt.to((Object)"/resharper/Daemon/Recursion.svg", (Object)RadIconPatcher.Companion.all(icon17));
        Icon icon18 = CidrLangIcons.CodeAssistantFunctionInvocation;
        Intrinsics.checkNotNullExpressionValue((Object)icon18, (String)"CodeAssistantFunctionInvocation");
        pairArray[15] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageInvocation.svg", (Object)RadIconPatcher.Companion.cidr(icon18));
        Icon icon19 = AllIcons.FileTypes.Text;
        Intrinsics.checkNotNullExpressionValue((Object)icon19, (String)"Text");
        pairArray[16] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageString.svg", (Object)RadIconPatcher.Companion.all(icon19));
        Icon icon20 = AllIcons.Nodes.Annotationtype;
        Intrinsics.checkNotNullExpressionValue((Object)icon20, (String)"Annotationtype");
        pairArray[17] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageAttribute.svg", (Object)RadIconPatcher.Companion.all(icon20));
        Icon icon21 = AllIcons.Actions.Help;
        Intrinsics.checkNotNullExpressionValue((Object)icon21, (String)"Help");
        pairArray[18] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageDocumentation.svg", (Object)RadIconPatcher.Companion.all(icon21));
        Icon icon22 = AllIcons.Nodes.ReadAccess;
        Intrinsics.checkNotNullExpressionValue((Object)icon22, (String)"ReadAccess");
        pairArray[19] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageRead.svg", (Object)RadIconPatcher.Companion.all(icon22));
        Icon icon23 = AllIcons.Nodes.RwAccess;
        Intrinsics.checkNotNullExpressionValue((Object)icon23, (String)"RwAccess");
        pairArray[20] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageReadWrite.svg", (Object)RadIconPatcher.Companion.all(icon23));
        Icon icon24 = AllIcons.Nodes.WriteAccess;
        Intrinsics.checkNotNullExpressionValue((Object)icon24, (String)"WriteAccess");
        pairArray[21] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageWrite.svg", (Object)RadIconPatcher.Companion.all(icon24));
        Icon icon25 = CidrLangIcons.CodeAssistantClassExtension;
        Intrinsics.checkNotNullExpressionValue((Object)icon25, (String)"CodeAssistantClassExtension");
        pairArray[22] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageExtendedType.svg", (Object)RadIconPatcher.Companion.cidr(icon25));
        Icon icon26 = CidrLangIcons.CodeAssistantClass;
        Intrinsics.checkNotNullExpressionValue((Object)icon26, (String)"CodeAssistantClass");
        pairArray[23] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageBase.svg", (Object)RadIconPatcher.Companion.cidr(icon26));
        Icon icon27 = AllIcons.Nodes.Interface;
        Intrinsics.checkNotNullExpressionValue((Object)icon27, (String)"Interface");
        pairArray[24] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageInterface.svg", (Object)RadIconPatcher.Companion.all(icon27));
        pairArray[25] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageCompilerRelated.svg", (Object)myUnclassifiedUsageKind);
        pairArray[26] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageOther.svg", (Object)myUnclassifiedUsageKind);
        Icon icon28 = AllIcons.Nodes.Field;
        Intrinsics.checkNotNullExpressionValue((Object)icon28, (String)"Field");
        pairArray[27] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageFieldTypeDeclaration.svg", (Object)RadIconPatcher.Companion.all(icon28));
        Icon icon29 = AllIcons.Nodes.Variable;
        Intrinsics.checkNotNullExpressionValue((Object)icon29, (String)"Variable");
        pairArray[28] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageLocalVariableDeclaration.svg", (Object)RadIconPatcher.Companion.all(icon29));
        pairArray[29] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageInstanceCreation.svg", (Object)myUnclassifiedUsageKind);
        pairArray[30] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageArrayCreation.svg", (Object)myUnclassifiedUsageKind);
        pairArray[31] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageOther.svg", (Object)NO_ICON);
        Icon icon30 = AllIcons.Nodes.Parameter;
        Intrinsics.checkNotNullExpressionValue((Object)icon30, (String)"Parameter");
        pairArray[32] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageMethodParameterDeclaration.svg", (Object)RadIconPatcher.Companion.all(icon30));
        Icon icon31 = CidrLangIcons.CodeAssistantClass;
        Intrinsics.checkNotNullExpressionValue((Object)icon31, (String)"CodeAssistantClass");
        pairArray[33] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageTypeArgument.svg", (Object)RadIconPatcher.Companion.cidr(icon31));
        pairArray[34] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageReturnType.svg", (Object)myUnclassifiedUsageKind);
        pairArray[35] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageStaticClassMemberAccess.svg", (Object)myUnclassifiedUsageKind);
        pairArray[36] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageTypeConversions.svg", (Object)myUnclassifiedUsageKind);
        pairArray[37] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageNestedClassAccess.svg", (Object)myUnclassifiedUsageKind);
        pairArray[38] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageInUsings.svg", (Object)myUnclassifiedUsageKind);
        pairArray[39] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageConstantDeclaration.svg", (Object)myUnclassifiedUsageKind);
        pairArray[40] = TuplesKt.to((Object)"/resharper/ServicesNavigation/UsageString.svg", (Object)myUnclassifiedUsageKind);
        Icon icon32 = CidrLangIcons.CodeAssistantClass;
        Intrinsics.checkNotNullExpressionValue((Object)icon32, (String)"CodeAssistantClass");
        pairArray[41] = TuplesKt.to((Object)"/resharper/PsiSymbols/Class.svg", (Object)RadIconPatcher.Companion.cidr(icon32));
        Icon icon33 = CidrLangIcons.FileTypes.H;
        Intrinsics.checkNotNullExpressionValue((Object)icon33, (String)"H");
        pairArray[42] = TuplesKt.to((Object)"/resharper/PsiSymbols/CppHeader.svg", (Object)RadIconPatcher.Companion.cidr(icon33));
        Icon icon34 = CidrLangIcons.FileTypes.Cpp;
        Intrinsics.checkNotNullExpressionValue((Object)icon34, (String)"Cpp");
        pairArray[43] = TuplesKt.to((Object)"/resharper/PsiSymbols/CppSource.svg", (Object)RadIconPatcher.Companion.cidr(icon34));
        Icon icon35 = CidrLangIcons.CodeAssistantFunction;
        Intrinsics.checkNotNullExpressionValue((Object)icon35, (String)"CodeAssistantFunction");
        pairArray[44] = TuplesKt.to((Object)"/resharper/PsiSymbols/Constructor.svg", (Object)RadIconPatcher.Companion.cidr(icon35));
        Icon icon36 = CidrLangIcons.CodeAssistantEnum;
        Intrinsics.checkNotNullExpressionValue((Object)icon36, (String)"CodeAssistantEnum");
        pairArray[45] = TuplesKt.to((Object)"/resharper/PsiSymbols/Enum.svg", (Object)RadIconPatcher.Companion.cidr(icon36));
        Icon icon37 = CidrLangIcons.CodeAssistantEnumConst;
        Intrinsics.checkNotNullExpressionValue((Object)icon37, (String)"CodeAssistantEnumConst");
        pairArray[46] = TuplesKt.to((Object)"/resharper/PsiSymbols/EnumMember.svg", (Object)RadIconPatcher.Companion.cidr(icon37));
        Icon icon38 = CidrLangIcons.CodeAssistantField;
        Intrinsics.checkNotNullExpressionValue((Object)icon38, (String)"CodeAssistantField");
        pairArray[47] = TuplesKt.to((Object)"/resharper/PsiSymbols/Field.svg", (Object)RadIconPatcher.Companion.cidr(icon38));
        Icon icon39 = CidrLangIcons.CodeAssistantFunction;
        Intrinsics.checkNotNullExpressionValue((Object)icon39, (String)"CodeAssistantFunction");
        pairArray[48] = TuplesKt.to((Object)"/resharper/PsiSymbols/GlobalFunction.svg", (Object)RadIconPatcher.Companion.cidr(icon39));
        Icon icon40 = CidrLangIcons.CodeAssistantGlobal;
        Intrinsics.checkNotNullExpressionValue((Object)icon40, (String)"CodeAssistantGlobal");
        pairArray[49] = TuplesKt.to((Object)"/resharper/PsiSymbols/GlobalVariable.svg", (Object)RadIconPatcher.Companion.cidr(icon40));
        pairArray[50] = TuplesKt.to((Object)"/resharper/PsiSymbols/Keyword.svg", (Object)NO_ICON);
        Icon icon41 = CidrLangIcons.CodeAssistantLocal;
        Intrinsics.checkNotNullExpressionValue((Object)icon41, (String)"CodeAssistantLocal");
        pairArray[51] = TuplesKt.to((Object)"/resharper/PsiSymbols/LocalConst.svg", (Object)RadIconPatcher.Companion.cidr(icon41));
        Icon icon42 = CidrLangIcons.CodeAssistantMacro;
        Intrinsics.checkNotNullExpressionValue((Object)icon42, (String)"CodeAssistantMacro");
        pairArray[52] = TuplesKt.to((Object)"/resharper/PsiSymbols/Macro.svg", (Object)RadIconPatcher.Companion.cidr(icon42));
        Icon icon43 = CidrLangIcons.CodeAssistantFunction;
        Intrinsics.checkNotNullExpressionValue((Object)icon43, (String)"CodeAssistantFunction");
        pairArray[53] = TuplesKt.to((Object)"/resharper/PsiSymbols/Method.svg", (Object)RadIconPatcher.Companion.cidr(icon43));
        Icon icon44 = AllIcons.Nodes.StaticMark;
        Intrinsics.checkNotNullExpressionValue((Object)icon44, (String)"StaticMark");
        pairArray[54] = TuplesKt.to((Object)"/resharper/PsiSymbols/ModifiersStatic.svg", (Object)RadIconPatcher.Companion.all(icon44));
        Icon icon45 = CidrLangIcons.CodeAssistantNamespace;
        Intrinsics.checkNotNullExpressionValue((Object)icon45, (String)"CodeAssistantNamespace");
        pairArray[55] = TuplesKt.to((Object)"/resharper/PsiSymbols/Namespace.svg", (Object)RadIconPatcher.Companion.cidr(icon45));
        Icon icon46 = CidrLangIcons.CodeAssistantOperator;
        Intrinsics.checkNotNullExpressionValue((Object)icon46, (String)"CodeAssistantOperator");
        pairArray[56] = TuplesKt.to((Object)"/resharper/PsiSymbols/Operator.svg", (Object)RadIconPatcher.Companion.cidr(icon46));
        Icon icon47 = CidrLangIcons.CodeAssistantParameter;
        Intrinsics.checkNotNullExpressionValue((Object)icon47, (String)"CodeAssistantParameter");
        pairArray[57] = TuplesKt.to((Object)"/resharper/PsiSymbols/Parameter.svg", (Object)RadIconPatcher.Companion.cidr(icon47));
        Icon icon48 = CidrLangIcons.CodeAssistantStruct;
        Intrinsics.checkNotNullExpressionValue((Object)icon48, (String)"CodeAssistantStruct");
        pairArray[58] = TuplesKt.to((Object)"/resharper/PsiSymbols/Struct.svg", (Object)RadIconPatcher.Companion.cidr(icon48));
        Icon icon49 = CidrLangIcons.CodeAssistantType;
        Intrinsics.checkNotNullExpressionValue((Object)icon49, (String)"CodeAssistantType");
        pairArray[59] = TuplesKt.to((Object)"/resharper/PsiSymbols/TypeDef.svg", (Object)RadIconPatcher.Companion.cidr(icon49));
        Icon icon50 = CidrLangIcons.CodeAssistantType;
        Intrinsics.checkNotNullExpressionValue((Object)icon50, (String)"CodeAssistantType");
        pairArray[60] = TuplesKt.to((Object)"/resharper/PsiSymbols/Typeparameter.svg", (Object)RadIconPatcher.Companion.cidr(icon50));
        Icon icon51 = CidrLangIcons.CodeAssistantUnion;
        Intrinsics.checkNotNullExpressionValue((Object)icon51, (String)"CodeAssistantUnion");
        pairArray[61] = TuplesKt.to((Object)"/resharper/PsiSymbols/Union.svg", (Object)RadIconPatcher.Companion.cidr(icon51));
        Icon icon52 = CidrLangIcons.CodeAssistantLocal;
        Intrinsics.checkNotNullExpressionValue((Object)icon52, (String)"CodeAssistantLocal");
        pairArray[62] = TuplesKt.to((Object)"/resharper/PsiSymbols/Variable.svg", (Object)RadIconPatcher.Companion.cidr(icon52));
        pairArray[63] = TuplesKt.to((Object)"/resharper/PsiSymbols/ExtensionMethod.svg", (Object)NO_ICON);
        Icon icon53 = AllIcons.Nodes.Template;
        Intrinsics.checkNotNullExpressionValue((Object)icon53, (String)"Template");
        pairArray[64] = TuplesKt.to((Object)"/resharper/Services/LiveTemplate.svg", (Object)RadIconPatcher.Companion.all(icon53));
        Icon icon54 = AllIcons.Gutter.RecursiveMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon54, (String)"RecursiveMethod");
        pairArray[65] = TuplesKt.to((Object)"/resharper/Services/Recursion2.svg", (Object)RadIconPatcher.Companion.all(icon54));
        pairArray[66] = TuplesKt.to((Object)"/resharper/Bulb/BulbFrame.svg", (Object)NO_ICON);
        Icon icon55 = AllIcons.Actions.RealIntentionBulb;
        Intrinsics.checkNotNullExpressionValue((Object)icon55, (String)"RealIntentionBulb");
        pairArray[67] = TuplesKt.to((Object)"/resharper/Bulb/ContextAction.svg", (Object)RadIconPatcher.Companion.all(icon55));
        Icon icon56 = AllIcons.Actions.RealIntentionBulb;
        Intrinsics.checkNotNullExpressionValue((Object)icon56, (String)"RealIntentionBulb");
        pairArray[68] = TuplesKt.to((Object)"/resharper/Bulb/ContextActionVS.svg", (Object)RadIconPatcher.Companion.all(icon56));
        Icon icon57 = AllIcons.Actions.Cancel;
        Intrinsics.checkNotNullExpressionValue((Object)icon57, (String)"Cancel");
        pairArray[69] = TuplesKt.to((Object)"/resharper/Bulb/DisableBulb.svg", (Object)RadIconPatcher.Companion.all(icon57));
        Icon icon58 = AllIcons.Actions.IntentionBulbGrey;
        Intrinsics.checkNotNullExpressionValue((Object)icon58, (String)"IntentionBulbGrey");
        pairArray[70] = TuplesKt.to((Object)"/resharper/Bulb/GhostBulb.svg", (Object)RadIconPatcher.Companion.all(icon58));
        Icon icon59 = AllIcons.Actions.IntentionBulbGrey;
        Intrinsics.checkNotNullExpressionValue((Object)icon59, (String)"IntentionBulbGrey");
        pairArray[71] = TuplesKt.to((Object)"/resharper/Bulb/OptionsVS.svg", (Object)RadIconPatcher.Companion.all(icon59));
        Icon icon60 = AllIcons.Actions.QuickfixBulb;
        Intrinsics.checkNotNullExpressionValue((Object)icon60, (String)"QuickfixBulb");
        pairArray[72] = TuplesKt.to((Object)"/resharper/Bulb/RedBulb.svg", (Object)RadIconPatcher.Companion.all(icon60));
        Icon icon61 = AllIcons.Actions.QuickfixBulb;
        Intrinsics.checkNotNullExpressionValue((Object)icon61, (String)"QuickfixBulb");
        pairArray[73] = TuplesKt.to((Object)"/resharper/Bulb/RedBulbVS.svg", (Object)RadIconPatcher.Companion.all(icon61));
        Icon icon62 = AllIcons.Actions.IntentionBulb;
        Intrinsics.checkNotNullExpressionValue((Object)icon62, (String)"IntentionBulb");
        pairArray[74] = TuplesKt.to((Object)"/resharper/Bulb/YellowBulb.svg", (Object)RadIconPatcher.Companion.all(icon62));
        Icon icon63 = AllIcons.Actions.IntentionBulb;
        Intrinsics.checkNotNullExpressionValue((Object)icon63, (String)"IntentionBulb");
        pairArray[75] = TuplesKt.to((Object)"/resharper/Bulb/YellowBulbVS.svg", (Object)RadIconPatcher.Companion.all(icon63));
        pairArray[76] = TuplesKt.to((Object)"/resharper/ReSpeller/ReSpellerIcon.svg", (Object)new Companion.IconAndClassLoader(SpellcheckerIcons.Spellcheck, SpellcheckerIcons.class.getClassLoader()));
        Icon icon64 = AllIcons.General.Settings;
        Intrinsics.checkNotNullExpressionValue((Object)icon64, (String)"Settings");
        pairArray[77] = TuplesKt.to((Object)"/resharper/FeaturesEnvironmentOptions/Highlighting.svg", (Object)RadIconPatcher.Companion.all(icon64));
        Icon icon65 = AllIcons.General.Settings;
        Intrinsics.checkNotNullExpressionValue((Object)icon65, (String)"Settings");
        pairArray[78] = TuplesKt.to((Object)"/resharper/Options/Options.svg", (Object)RadIconPatcher.Companion.all(icon65));
        pairArray[79] = TuplesKt.to((Object)"/resharper/ProjectModel/CppProject.svg", (Object)NO_ICON);
        pairArray[80] = TuplesKt.to((Object)"/resharper/Cpp/CppModule.svg", (Object)NO_ICON);
        Icon icon66 = AllIcons.General.Add;
        Intrinsics.checkNotNullExpressionValue((Object)icon66, (String)"Add");
        pairArray[81] = TuplesKt.to((Object)"/resharper/LiveTemplates/AddLiveTemplate.svg", (Object)RadIconPatcher.Companion.all(icon66));
        Icon icon67 = AllIcons.Actions.Copy;
        Intrinsics.checkNotNullExpressionValue((Object)icon67, (String)"Copy");
        pairArray[82] = TuplesKt.to((Object)"/resharper/Common/Duplicate.svg", (Object)RadIconPatcher.Companion.all(icon67));
        Icon icon68 = AllIcons.General.Remove;
        Intrinsics.checkNotNullExpressionValue((Object)icon68, (String)"Remove");
        pairArray[83] = TuplesKt.to((Object)"/resharper/LiveTemplates/DeleteLiveTemplate.svg", (Object)RadIconPatcher.Companion.all(icon68));
        Icon icon69 = AllIcons.Actions.RefactoringBulb;
        Intrinsics.checkNotNullExpressionValue((Object)icon69, (String)"RefactoringBulb");
        pairArray[84] = TuplesKt.to((Object)"/resharper/PsiFeaturesUnsorted/FuncZoneRefactoring.svg", (Object)RadIconPatcher.Companion.all(icon69));
        myIconsOverrideMap = MapsKt.mapOf((Pair[])pairArray);
        myIgnoredIcons = SetsKt.setOf((Object)"/resharper/PsiSymbols/PsiSymbolTypicalSizePlaceholder.svg");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001 B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\r\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00100\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/clion/radler/core/ui/RadIconPatcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "myInstallPatcher", "", "getMyInstallPatcher", "()Lkotlin/Unit;", "myInstallPatcher$delegate", "Lkotlin/Lazy;", "install", "install$intellij_clion_radler_core", "cidr", "Lcom/intellij/clion/radler/core/ui/RadIconPatcher$Companion$IconAndClassLoader;", "icon", "Ljavax/swing/Icon;", "all", "NO_ICON", "normalize", "", "path", "myUnclassifiedUsageKind", "myIconsOverrideMap", "", "myIgnoredIcons", "", "tryPatchPath", "isDotNetIcon", "", "IconAndClassLoader", "intellij.clion.radler.core"})
    public static final class Companion {
        private Companion() {
        }

        private final Unit getMyInstallPatcher() {
            Lazy lazy = myInstallPatcher$delegate;
            lazy.getValue();
            return Unit.INSTANCE;
        }

        public final void install$intellij_clion_radler_core() {
            this.getMyInstallPatcher();
        }

        private final IconAndClassLoader cidr(Icon icon) {
            return new IconAndClassLoader(icon, CidrLangIcons.class.getClassLoader());
        }

        private final IconAndClassLoader all(Icon icon) {
            return new IconAndClassLoader(icon, AllIcons.class.getClassLoader());
        }

        private final String normalize(String path) {
            if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                return "/" + path;
            }
            return path;
        }

        @VisibleForTesting
        @Nullable
        public final String tryPatchPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String normalizedPath = this.normalize(path);
            IconAndClassLoader iconAndClassLoader = (IconAndClassLoader)myIconsOverrideMap.get(normalizedPath);
            if (iconAndClassLoader == null) {
                if (this.isDotNetIcon(normalizedPath) && !myIgnoredIcons.contains(normalizedPath)) {
                    LOG.warn("No mapped CLion icon for " + normalizedPath);
                }
                return null;
            }
            Icon icon = iconAndClassLoader.getIcon();
            if (icon instanceof IconPathProvider) {
                if (ExperimentalUI.Companion.isNewUI() && ((IconPathProvider)icon).getExpUIPath() != null) {
                    return ((IconPathProvider)icon).getExpUIPath();
                }
                return ((IconPathProvider)icon).getOriginalPath();
            }
            return null;
        }

        private final boolean isDotNetIcon(String path) {
            return StringsKt.startsWith$default((String)path, (String)"/resharper", (boolean)false, (int)2, null) || StringsKt.startsWith((String)path, (String)"/Rider", (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/clion/radler/core/ui/RadIconPatcher$Companion$IconAndClassLoader;", "", "icon", "Ljavax/swing/Icon;", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Ljavax/swing/Icon;Ljava/lang/ClassLoader;)V", "getIcon", "()Ljavax/swing/Icon;", "getClassLoader", "()Ljava/lang/ClassLoader;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.clion.radler.core"})
        private static final class IconAndClassLoader {
            @Nullable
            private final Icon icon;
            @Nullable
            private final ClassLoader classLoader;

            public IconAndClassLoader(@Nullable Icon icon, @Nullable ClassLoader classLoader) {
                this.icon = icon;
                this.classLoader = classLoader;
            }

            @Nullable
            public final Icon getIcon() {
                return this.icon;
            }

            @Nullable
            public final ClassLoader getClassLoader() {
                return this.classLoader;
            }

            @Nullable
            public final Icon component1() {
                return this.icon;
            }

            @Nullable
            public final ClassLoader component2() {
                return this.classLoader;
            }

            @NotNull
            public final IconAndClassLoader copy(@Nullable Icon icon, @Nullable ClassLoader classLoader) {
                return new IconAndClassLoader(icon, classLoader);
            }

            public static /* synthetic */ IconAndClassLoader copy$default(IconAndClassLoader iconAndClassLoader, Icon icon, ClassLoader classLoader, int n, Object object) {
                if ((n & 1) != 0) {
                    icon = iconAndClassLoader.icon;
                }
                if ((n & 2) != 0) {
                    classLoader = iconAndClassLoader.classLoader;
                }
                return iconAndClassLoader.copy(icon, classLoader);
            }

            @NotNull
            public String toString() {
                return "IconAndClassLoader(icon=" + this.icon + ", classLoader=" + this.classLoader + ")";
            }

            public int hashCode() {
                int result = this.icon == null ? 0 : this.icon.hashCode();
                result = result * 31 + (this.classLoader == null ? 0 : this.classLoader.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IconAndClassLoader)) {
                    return false;
                }
                IconAndClassLoader iconAndClassLoader = (IconAndClassLoader)other;
                if (!Intrinsics.areEqual((Object)this.icon, (Object)iconAndClassLoader.icon)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.classLoader, (Object)iconAndClassLoader.classLoader);
            }
        }
    }
}

