/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.radler.core.settings.migration;

import com.intellij.application.options.CodeStyle;
import com.intellij.clion.radler.core.clangFormat.RadClangFormatHelper;
import com.intellij.clion.radler.core.statistics.RadCollectorsUtil;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.util.ApplicationKt;
import com.jetbrains.cidr.CidrProjectApplicationVersion;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.CidrCodeStyleSettings;
import com.jetbrains.rd.ide.model.KeyPathComponents;
import com.jetbrains.rd.ide.model.PredefinedValue;
import com.jetbrains.rider.settings.RiderCustomCodeStyleSettings;
import com.jetbrains.rider.settings.SettingsSynchronizerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/clion/radler/core/settings/migration/RadMigrateCodeStyleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "intellij.clion.radler.core"})
public final class RadMigrateCodeStyleAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CPP_OPTION_PREFIX = "CodeStyle/CodeFormatting/CppFormatting";
    @NotNull
    private static final String ID_MIGRATION_ACTION = "RadMigrateCodeStyle";

    public RadMigrateCodeStyleAction() {
        RadMigrateCodeStyleAction.Companion.log("Action instantiated");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = DumbAwareAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Companion.resetCodeStyle(project2);
        RadMigrateCodeStyleAction.Companion.performMigration(project2, true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001c\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0012\u0010\u0012\u001a\u00020\r2\b\b\u0001\u0010\u0011\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J&\u0010\u0016\u001a\u00020\r2\b\b\u0001\u0010\u0011\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\nH\u0002J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J?\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001c\"\n\b\u0000\u0010 \u0018\u0001*\u00020\u00012\u0006\u0010!\u001a\u00020\r2\u000e\b\u0004\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0\u001eH\u0082\bJ\u0010\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\rH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/clion/radler/core/settings/migration/RadMigrateCodeStyleAction$Companion;", "", "<init>", "()V", "resetCodeStyle", "", "project", "Lcom/intellij/openapi/project/Project;", "performMigration", "migrateForNovaProjects", "", "fireCodeStyleSettingChanged", "CPP_OPTION_PREFIX", "", "cppEntry", "optionName", "getTernaryOperatorAlignStyle", "option", "getSimpleEmbeddedStatementStyle", "", "getConvertedWrapStyle", "getConvertedWrapToSimpleEmbeddedStatementStyle", "getBraceFormatStyleStyle", "withSpace", "withCompactOption", "ID_MIGRATION_ACTION", "migrateCodeStyleFromCidrToRad", "radEntry", "Lkotlin/Pair;", "Lcom/jetbrains/rd/ide/model/KeyPathComponents;", "Lkotlin/Function0;", "Lcom/jetbrains/rd/ide/model/PredefinedValue;", "T", "reSharperKey", "accessor", "log", "message", "intellij.clion.radler.core"})
    @SourceDebugExtension(value={"SMAP\nRadMigrateCodeStyleAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadMigrateCodeStyleAction.kt\ncom/intellij/clion/radler/core/settings/migration/RadMigrateCodeStyleAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,407:1\n399#1:412\n399#1:413\n399#1:414\n399#1:415\n399#1:416\n399#1:417\n399#1:418\n399#1:419\n399#1:420\n399#1:421\n399#1:422\n399#1:423\n399#1:424\n399#1:425\n399#1:426\n399#1:427\n399#1:428\n399#1:429\n399#1:430\n399#1:431\n399#1:432\n399#1:433\n399#1:434\n399#1:435\n399#1:436\n399#1:437\n399#1:438\n399#1:439\n399#1:440\n399#1:441\n399#1:442\n399#1:443\n399#1:444\n399#1:445\n399#1:446\n399#1:447\n399#1:448\n399#1:449\n399#1:450\n399#1:451\n399#1:452\n399#1:453\n399#1:454\n399#1:455\n399#1:456\n399#1:457\n399#1:458\n399#1:459\n399#1:460\n399#1:461\n399#1:462\n399#1:463\n399#1:464\n399#1:465\n399#1:466\n399#1:467\n399#1:468\n399#1:469\n399#1:470\n399#1:471\n399#1:472\n399#1:473\n399#1:474\n399#1:475\n399#1:476\n399#1:477\n399#1:478\n399#1:479\n399#1:480\n399#1:481\n399#1:482\n399#1:483\n399#1:484\n399#1:485\n399#1:486\n399#1:487\n399#1:488\n399#1:489\n399#1:490\n399#1:491\n399#1:492\n399#1:493\n399#1:494\n399#1:495\n399#1:496\n399#1:497\n399#1:498\n399#1:499\n399#1:500\n399#1:501\n399#1:502\n399#1:503\n399#1:504\n399#1:505\n399#1:506\n399#1:507\n1869#2,2:408\n1869#2,2:508\n30#3,2:410\n13#4:510\n*S KotlinDebug\n*F\n+ 1 RadMigrateCodeStyleAction.kt\ncom/intellij/clion/radler/core/settings/migration/RadMigrateCodeStyleAction$Companion\n*L\n89#1:412\n90#1:413\n95#1:414\n96#1:415\n98#1:416\n99#1:417\n100#1:418\n101#1:419\n103#1:420\n106#1:421\n108#1:422\n109#1:423\n111#1:424\n112#1:425\n113#1:426\n115#1:427\n129#1:428\n130#1:429\n133#1:430\n134#1:431\n136#1:432\n139#1:433\n140#1:434\n142#1:435\n143#1:436\n145#1:437\n147#1:438\n148#1:439\n150#1:440\n154#1:441\n156#1:442\n157#1:443\n158#1:444\n160#1:445\n161#1:446\n163#1:447\n164#1:448\n165#1:449\n170#1:450\n184#1:451\n186#1:452\n187#1:453\n188#1:454\n189#1:455\n191#1:456\n195#1:457\n196#1:458\n197#1:459\n200#1:460\n203#1:461\n205#1:462\n206#1:463\n208#1:464\n209#1:465\n211#1:466\n212#1:467\n214#1:468\n215#1:469\n216#1:470\n217#1:471\n219#1:472\n220#1:473\n221#1:474\n223#1:475\n224#1:476\n225#1:477\n226#1:478\n228#1:479\n229#1:480\n230#1:481\n231#1:482\n233#1:483\n234#1:484\n235#1:485\n236#1:486\n237#1:487\n238#1:488\n240#1:489\n241#1:490\n243#1:491\n244#1:492\n245#1:493\n247#1:494\n248#1:495\n249#1:496\n251#1:497\n252#1:498\n254#1:499\n256#1:500\n261#1:501\n262#1:502\n263#1:503\n273#1:504\n279#1:505\n280#1:506\n286#1:507\n73#1:408,2\n291#1:508,2\n82#1:410,2\n403#1:510\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void resetCodeStyle(@Nullable Project project) {
            CodeStyleSettings codeStyleSettings = CodeStyle.getProjectOrDefaultSettings((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getProjectOrDefaultSettings(...)");
            CodeStyleSettings settings = codeStyleSettings;
            CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(RiderCustomCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            RiderCustomCodeStyleSettings riderCustomSettings = (RiderCustomCodeStyleSettings)customCodeStyleSettings;
            riderCustomSettings.getData().clear();
            this.fireCodeStyleSettingChanged(project);
        }

        private final void performMigration(Project project, boolean migrateForNovaProjects) {
            if (project != null && CidrProjectApplicationVersion.Companion.getInstance(project).isRadlerProject() && !migrateForNovaProjects) {
                this.log("Skip migration for Nova Projects");
                return;
            }
            CodeStyleSettings codeStyleSettings = CodeStyle.getProjectOrDefaultSettings((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getProjectOrDefaultSettings(...)");
            CodeStyleSettings settings = codeStyleSettings;
            CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(RiderCustomCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            RiderCustomCodeStyleSettings riderCustomSettings = (RiderCustomCodeStyleSettings)customCodeStyleSettings;
            Iterable $this$forEach$iv = riderCustomSettings.getData().keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KeyPathComponents it = (KeyPathComponents)element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it.getRawKey(), (CharSequence)RadMigrateCodeStyleAction.CPP_OPTION_PREFIX, (boolean)false, (int)2, null)) continue;
                Companion.log("Skip migration for Projects with Radler Code Style customization");
                return;
            }
            List options = new ArrayList();
            Object $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service22 = false;
            Object serviceClass$iv = RadClangFormatHelper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            boolean cfIsEnabled = ((RadClangFormatHelper)object).isClangFormatEnabled(project);
            RadCollectorsUtil.INSTANCE.getCLION_NOVA_CODE_STYLE_MIGRATION_EVENT().log((Object)(project != null && CodeStyle.usesOwnSettings((Project)project) ? 1 : 0), (Object)cfIsEnabled);
            $this$service$iv = options;
            Object $i$f$service22 = new Pair[2];
            serviceClass$iv = this;
            Object[] reSharperKey$iv = "CodeStyle/CodeFormatting/CppClangFormat/EnableClangFormatSupport";
            boolean $i$f$radEntry = false;
            $i$f$service22[0] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv), (Object)new Function0<PredefinedValue>(cfIsEnabled){
                final /* synthetic */ boolean $cfIsEnabled$inlined;
                {
                    this.$cfIsEnabled$inlined = bl;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cfIsEnabled$inlined);
                }
            });
            Object this_$iv = this;
            reSharperKey$iv = "CodeStyle/EditorConfig/EnableClangFormatSupport";
            $i$f$radEntry = false;
            $i$f$service22[1] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv), (Object)new Function0<PredefinedValue>(){

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)false);
                }
            });
            CollectionsKt.addAll((Collection)$this$service$iv, (Iterable)CollectionsKt.listOf((Object[])$i$f$service22));
            CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)OCLanguage.getInstance());
            Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
            CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
            $i$f$service22 = options;
            this_$iv = new Pair[36];
            reSharperKey$iv = this;
            Object[] reSharperKey$iv2 = super.cppEntry("ALIGN_MULTILINE_BINARY_EXPRESSIONS_CHAIN");
            boolean $i$f$radEntry2 = false;
            this_$iv[0] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.ALIGN_MULTILINE_BINARY_OPERATION);
                }
            });
            Object this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("ALIGN_MULTILINE_CALLS_CHAIN");
            $i$f$radEntry2 = false;
            this_$iv[1] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.ALIGN_MULTILINE_CHAINED_METHODS);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("ALIGN_MULTILINE_EXPRESSION");
            $i$f$radEntry2 = false;
            this_$iv[2] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("ALIGN_MULTILINE_FOR_STMT");
            $i$f$radEntry2 = false;
            this_$iv[3] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.ALIGN_MULTILINE_FOR);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("ALIGN_MULTIPLE_DECLARATION");
            $i$f$radEntry2 = false;
            this_$iv[4] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.ALIGN_GROUP_FIELD_DECLARATIONS);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("ALIGN_TERNARY");
            $i$f$radEntry2 = false;
            this_$iv[5] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.access$getTernaryOperatorAlignStyle(RadMigrateCodeStyleAction.Companion, this.$commonSettings$inlined.ALIGN_MULTILINE_TERNARY_OPERATION));
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("BLANK_LINES_AROUND_CLASS_DEFINITION");
            $i$f$radEntry2 = false;
            this_$iv[6] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.BLANK_LINES_AROUND_CLASS);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("KEEP_BLANK_LINES_IN_DECLARATIONS");
            $i$f$radEntry2 = false;
            this_$iv[7] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("KEEP_BLANK_LINES_IN_CODE");
            $i$f$radEntry2 = false;
            this_$iv[8] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.KEEP_BLANK_LINES_IN_CODE);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("KEEP_USER_LINEBREAKS");
            $i$f$radEntry2 = false;
            this_$iv[9] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.KEEP_LINE_BREAKS);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("INDENT_CASE_FROM_SWITCH");
            $i$f$radEntry2 = false;
            this_$iv[10] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.INDENT_CASE_FROM_SWITCH);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("INDENT_COMMENT");
            $i$f$radEntry2 = false;
            this_$iv[11] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.KEEP_FIRST_COLUMN_COMMENT);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("INT_ALIGN_EQ");
            $i$f$radEntry2 = false;
            this_$iv[12] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.ALIGN_GROUP_FIELD_DECLARATIONS);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SIMPLE_BLOCK_STYLE");
            $i$f$radEntry2 = false;
            this_$iv[13] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    String string;
                    boolean bl = false;
                    boolean bl2 = this.$commonSettings$inlined.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
                    if (!bl2) {
                        string = "LINE_BREAK";
                    } else if (bl2) {
                        string = "DO_NOT_CHANGE";
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    return SettingsSynchronizerKt.asPredefinedType((Object)string);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPACE_AFTER_COMMA_IN_TEMPLATE_ARGS");
            $i$f$radEntry2 = false;
            this_$iv[14] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPACE_AFTER_COMMA_IN_TEMPLATE_PARAMS");
            $i$f$radEntry2 = false;
            this_$iv[15] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPACE_AFTER_FOR_SEMICOLON");
            $i$f$radEntry2 = false;
            this_$iv[16] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPACE_AFTER_SEMICOLON);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPACE_BEFORE_FOR_SEMICOLON");
            $i$f$radEntry2 = false;
            this_$iv[17] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPACE_BEFORE_SEMICOLON);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPACE_AFTER_UNARY_OPERATOR");
            $i$f$radEntry2 = false;
            this_$iv[18] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPACE_AROUND_UNARY_OPERATOR);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPACE_WITHIN_ARRAY_ACCESS_BRACKETS");
            $i$f$radEntry2 = false;
            this_$iv[19] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPACE_WITHIN_BRACKETS);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPACE_WITHIN_CAST_EXPRESSION_PARENTHESES");
            $i$f$radEntry2 = false;
            this_$iv[20] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPACE_WITHIN_CAST_PARENTHESES);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPACE_WITHIN_EMPTY_INITIALIZER_BRACES");
            $i$f$radEntry2 = false;
            this_$iv[21] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPACE_WITHIN_EMPTY_METHOD_PARENTHESES");
            $i$f$radEntry2 = false;
            this_$iv[22] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPACE_WITHIN_EMPTY_METHOD_PARENTHESES);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPACE_WITHIN_INITIALIZER_BRACES");
            $i$f$radEntry2 = false;
            this_$iv[23] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPECIAL_ELSE_IF_TREATMENT");
            $i$f$radEntry2 = false;
            this_$iv[24] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPECIAL_ELSE_IF_TREATMENT);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("SPACE_AFTER_CAST_EXPRESSION_PARENTHESES");
            $i$f$radEntry2 = false;
            this_$iv[25] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.SPACE_AFTER_TYPE_CAST);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("WRAP_AFTER_BINARY_OPSIGN");
            $i$f$radEntry2 = false;
            this_$iv[26] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)(this.$commonSettings$inlined.BINARY_OPERATION_WRAP != 0 ? 1 : 0));
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("WRAP_BEFORE_TERNARY_OPSIGNS");
            $i$f$radEntry2 = false;
            this_$iv[27] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)(this.$commonSettings$inlined.TERNARY_OPERATION_WRAP != 0 ? 1 : 0));
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("TYPE_DECLARATION_BRACES");
            $i$f$radEntry2 = false;
            this_$iv[28] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$commonSettings$inlined.CLASS_BRACE_STYLE, this.$commonSettings$inlined.SPACE_BEFORE_CLASS_LBRACE, false, 4, null));
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("OTHER_BRACES");
            $i$f$radEntry2 = false;
            this_$iv[29] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.access$getBraceFormatStyleStyle(RadMigrateCodeStyleAction.Companion, this.$commonSettings$inlined.BRACE_STYLE, true, true));
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("CASE_BLOCK_BRACES");
            $i$f$radEntry2 = false;
            this_$iv[30] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$commonSettings$inlined.BRACE_STYLE, this.$commonSettings$inlined.SPACE_BEFORE_SWITCH_LBRACE, false, 4, null));
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("BLANK_LINES_AROUND_FUNCTION_DECLARATION");
            $i$f$radEntry2 = false;
            this_$iv[31] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.BLANK_LINES_AROUND_METHOD_IN_INTERFACE);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("BLANK_LINES_AROUND_FUNCTION_DEFINITION");
            $i$f$radEntry2 = false;
            this_$iv[32] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.BLANK_LINES_AROUND_METHOD);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("PLACE_WHILE_ON_NEW_LINE");
            $i$f$radEntry2 = false;
            this_$iv[33] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.WHILE_ON_NEW_LINE);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("PLACE_ELSE_ON_NEW_LINE");
            $i$f$radEntry2 = false;
            this_$iv[34] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.ELSE_ON_NEW_LINE);
                }
            });
            this_$iv2 = this;
            reSharperKey$iv2 = super.cppEntry("PLACE_CATCH_ON_NEW_LINE");
            $i$f$radEntry2 = false;
            this_$iv[35] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>(commonSettings){
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$commonSettings$inlined.CATCH_ON_NEW_LINE);
                }
            });
            CollectionsKt.addAll((Collection)$i$f$service22, (Iterable)CollectionsKt.listOf((Object[])this_$iv));
            CustomCodeStyleSettings customCodeStyleSettings2 = settings.getCustomSettings(CidrCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings2, (String)"getCustomSettings(...)");
            CidrCodeStyleSettings cidrCustomSettings = (CidrCodeStyleSettings)customCodeStyleSettings2;
            this_$iv = options;
            this_$iv2 = new Pair[54];
            reSharperKey$iv2 = this;
            Object[] reSharperKey$iv3 = super.cppEntry("NAMESPACE_INDENTATION");
            boolean $i$f$radEntry3 = false;
            this_$iv2[0] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)(this.$cidrCustomSettings$inlined.INDENT_NAMESPACE_MEMBERS > 0 ? (this.$cidrCustomSettings$inlined.KEEP_NESTED_NAMESPACES_IN_ONE_LINE ? "Inner" : "All") : "None"));
                }
            });
            Object[] this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("ALIGN_MULTILINE_ARGUMENT");
            $i$f$radEntry3 = false;
            this_$iv2[1] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("ALIGN_MULTILINE_EXTENDS_LIST");
            $i$f$radEntry3 = false;
            this_$iv2[2] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.CLASS_CONSTRUCTOR_INIT_LIST_ALIGN_MULTILINE);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("ALIGN_MULTILINE_PARAMETER");
            $i$f$radEntry3 = false;
            this_$iv2[3] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.FUNCTION_PARAMETERS_ALIGN_MULTILINE);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("ALIGN_MULTILINE_TYPE_ARGUMENT");
            $i$f$radEntry3 = false;
            this_$iv2[4] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("ALIGN_MULTILINE_TYPE_PARAMETER");
            $i$f$radEntry3 = false;
            this_$iv2[5] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.TEMPLATE_PARAMETERS_ALIGN_MULTILINE);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("BLANK_LINES_AROUND_DECLARATIONS");
            $i$f$radEntry3 = false;
            this_$iv2[6] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.BLANK_LINES_AROUND_PROPERTIES_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("INDENT_ACCESS_SPECIFIERS_FROM_CLASS");
            $i$f$radEntry3 = false;
            this_$iv2[7] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)(this.$cidrCustomSettings$inlined.INDENT_VISIBILITY_KEYWORDS > 0 ? 1 : 0));
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("INDENT_CLASS_MEMBERS_FROM_ACCESS_SPECIFIERS");
            $i$f$radEntry3 = false;
            this_$iv2[8] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)(this.$cidrCustomSettings$inlined.INDENT_VISIBILITY_KEYWORDS < this.$cidrCustomSettings$inlined.INDENT_CLASS_MEMBERS ? 1 : 0));
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("LINE_BREAK_AFTER_COLON_IN_MEMBER_INITIALIZER_LISTS");
            $i$f$radEntry3 = false;
            this_$iv2[9] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.access$getSimpleEmbeddedStatementStyle(RadMigrateCodeStyleAction.Companion, this.$cidrCustomSettings$inlined.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON));
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("MEMBER_INITIALIZER_LIST_STYLE");
            $i$f$radEntry3 = false;
            this_$iv2[10] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.access$getSimpleEmbeddedStatementStyle(RadMigrateCodeStyleAction.Companion, this.$cidrCustomSettings$inlined.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_BEFORE_COLON));
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("PLACE_NAMESPACE_DEFINITIONS_ON_SAME_LINE");
            $i$f$radEntry3 = false;
            this_$iv2[11] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.KEEP_NESTED_NAMESPACES_IN_ONE_LINE);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_AFTER_COLON_IN_BITFIELD_DECLARATOR");
            $i$f$radEntry3 = false;
            this_$iv2[12] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_AFTER_DICTIONARY_LITERAL_COLON);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_COLON_IN_BITFIELD_DECLARATOR");
            $i$f$radEntry3 = false;
            this_$iv2[13] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_DICTIONARY_LITERAL_COLON);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_AFTER_EXTENDS_COLON");
            $i$f$radEntry3 = false;
            this_$iv2[14] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_AFTER_SUPERCLASS_COLON);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_EXTENDS_COLON");
            $i$f$radEntry3 = false;
            this_$iv2[15] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_SUPERCLASS_COLON);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_AFTER_FOR_COLON");
            $i$f$radEntry3 = false;
            this_$iv2[16] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_AFTER_COLON_IN_FOREACH);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_FOR_COLON");
            $i$f$radEntry3 = false;
            this_$iv2[17] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_COLON_IN_FOREACH);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_AFTER_PTR_IN_DATA_MEMBER");
            $i$f$radEntry3 = false;
            this_$iv2[18] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_AFTER_POINTER_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_AFTER_PTR_IN_DATA_MEMBERS");
            $i$f$radEntry3 = false;
            this_$iv2[19] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_AFTER_POINTER_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_AFTER_PTR_IN_METHOD");
            $i$f$radEntry3 = false;
            this_$iv2[20] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_AFTER_POINTER_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_AFTER_PTR_IN_NESTED_DECLARATOR");
            $i$f$radEntry3 = false;
            this_$iv2[21] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_AFTER_POINTER_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_AFTER_REF_IN_DATA_MEMBER");
            $i$f$radEntry3 = false;
            this_$iv2[22] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_AFTER_REFERENCE_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_AFTER_REF_IN_DATA_MEMBERS");
            $i$f$radEntry3 = false;
            this_$iv2[23] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_AFTER_REFERENCE_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_AFTER_REF_IN_METHOD");
            $i$f$radEntry3 = false;
            this_$iv2[24] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_AFTER_REFERENCE_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_PTR_IN_ABSTRACT_DECL");
            $i$f$radEntry3 = false;
            this_$iv2[25] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_POINTER_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_PTR_IN_DATA_MEMBER");
            $i$f$radEntry3 = false;
            this_$iv2[26] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_POINTER_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_PTR_IN_DATA_MEMBERS");
            $i$f$radEntry3 = false;
            this_$iv2[27] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_POINTER_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_PTR_IN_METHOD");
            $i$f$radEntry3 = false;
            this_$iv2[28] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_POINTER_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_REF_IN_ABSTRACT_DECL");
            $i$f$radEntry3 = false;
            this_$iv2[29] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_REFERENCE_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_REF_IN_DATA_MEMBER");
            $i$f$radEntry3 = false;
            this_$iv2[30] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_REFERENCE_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_REF_IN_DATA_MEMBERS");
            $i$f$radEntry3 = false;
            this_$iv2[31] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_REFERENCE_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_REF_IN_METHOD");
            $i$f$radEntry3 = false;
            this_$iv2[32] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_REFERENCE_IN_DECLARATION);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_TEMPLATE_ARGS");
            $i$f$radEntry3 = false;
            this_$iv2[33] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_TEMPLATE_DECLARATION_LT);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BEFORE_TEMPLATE_PARAMS");
            $i$f$radEntry3 = false;
            this_$iv2[34] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_BEFORE_TEMPLATE_CALL_LT);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_BETWEEN_CLOSING_ANGLE_BRACKETS_IN_TEMPLATE_ARGS");
            $i$f$radEntry3 = false;
            this_$iv2[35] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_WITHIN_TEMPLATE_DOUBLE_GT);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_WITHIN_EMPTY_TEMPLATE_PARAMS");
            $i$f$radEntry3 = false;
            this_$iv2[36] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_WITHIN_EMPTY_TEMPLATE_DECLARATION_LTGT);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_WITHIN_TEMPLATE_ARGS");
            $i$f$radEntry3 = false;
            this_$iv2[37] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_WITHIN_TEMPLATE_CALL_LTGT);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_WITHIN_TEMPLATE_PARAMS");
            $i$f$radEntry3 = false;
            this_$iv2[38] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_WITHIN_TEMPLATE_DECLARATION_LTGT);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_WITHIN_DECLARATION_PARENTHESES");
            $i$f$radEntry3 = false;
            this_$iv2[39] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_WITHIN_FUNCTION_DECLARATION_PARENTHESES);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("SPACE_WITHIN_EMPTY_BLOCKS");
            $i$f$radEntry3 = false;
            this_$iv2[40] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.SPACE_WITHIN_EMPTY_BRACES);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("WRAP_BEFORE_INVOCATION_LPAR");
            $i$f$radEntry3 = false;
            this_$iv2[41] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(){

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)false);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("WRAP_AFTER_INVOCATION_LPAR");
            $i$f$radEntry3 = false;
            this_$iv2[42] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.FUNCTION_CALL_ARGUMENTS_NEW_LINE_AFTER_LPAR);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("WRAP_BEFORE_INVOCATION_RPAR");
            $i$f$radEntry3 = false;
            this_$iv2[43] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.FUNCTION_CALL_ARGUMENTS_NEW_LINE_BEFORE_RPAR);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("WRAP_BEFORE_DECLARATION_LPAR");
            $i$f$radEntry3 = false;
            this_$iv2[44] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(){

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)false);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("WRAP_AFTER_DECLARATION_LPAR");
            $i$f$radEntry3 = false;
            this_$iv2[45] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.FUNCTION_PARAMETERS_NEW_LINE_AFTER_LPAR);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("WRAP_BEFORE_DECLARATION_RPAR");
            $i$f$radEntry3 = false;
            this_$iv2[46] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$cidrCustomSettings$inlined.FUNCTION_PARAMETERS_NEW_LINE_BEFORE_RPAR);
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("WRAP_ARGUMENTS_STYLE");
            $i$f$radEntry3 = false;
            this_$iv2[47] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.access$getConvertedWrapStyle(RadMigrateCodeStyleAction.Companion, this.$cidrCustomSettings$inlined.FUNCTION_CALL_ARGUMENTS_WRAP));
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("WRAP_PARAMETERS_STYLE");
            $i$f$radEntry3 = false;
            this_$iv2[48] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.access$getConvertedWrapStyle(RadMigrateCodeStyleAction.Companion, this.$cidrCustomSettings$inlined.FUNCTION_PARAMETERS_WRAP));
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("BREAK_TEMPLATE_DECLARATION");
            $i$f$radEntry3 = false;
            this_$iv2[49] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.access$getConvertedWrapToSimpleEmbeddedStatementStyle(RadMigrateCodeStyleAction.Companion, this.$cidrCustomSettings$inlined.TEMPLATE_DECLARATION_FUNCTION_WRAP));
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("NAMESPACE_DECLARATION_BRACES");
            $i$f$radEntry3 = false;
            this_$iv2[50] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$cidrCustomSettings$inlined.NAMESPACE_BRACE_PLACEMENT, this.$cidrCustomSettings$inlined.SPACE_BEFORE_NAMESPACE_LBRACE, false, 4, null));
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("INVOCABLE_DECLARATION_BRACES");
            $i$f$radEntry3 = false;
            this_$iv2[51] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings, commonSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$cidrCustomSettings$inlined.FUNCTION_BRACE_PLACEMENT, this.$commonSettings$inlined.SPACE_BEFORE_METHOD_LBRACE, false, 4, null));
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("ANONYMOUS_METHOD_DECLARATION_BRACES");
            $i$f$radEntry3 = false;
            this_$iv2[52] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings, commonSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$cidrCustomSettings$inlined.BLOCK_BRACE_PLACEMENT, this.$commonSettings$inlined.SPACE_BEFORE_METHOD_LBRACE, false, 4, null));
                }
            });
            this_$iv3 = this;
            reSharperKey$iv3 = super.cppEntry("INITIALIZER_BRACES");
            $i$f$radEntry3 = false;
            this_$iv2[53] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(cidrCustomSettings){
                final /* synthetic */ CidrCodeStyleSettings $cidrCustomSettings$inlined;
                {
                    this.$cidrCustomSettings$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType((Object)com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$cidrCustomSettings$inlined.BLOCK_BRACE_PLACEMENT, this.$cidrCustomSettings$inlined.SPACE_BEFORE_INIT_LIST, false, 4, null));
                }
            });
            CollectionsKt.addAll((Collection)this_$iv, (Iterable)CollectionsKt.listOf((Object[])this_$iv2));
            CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
            if (indentOptions != null) {
                this_$iv2 = options;
                this_$iv3 = new Pair[4];
                reSharperKey$iv3 = this;
                String reSharperKey$iv4 = super.cppEntry("INDENT_STYLE");
                boolean $i$f$radEntry4 = false;
                this_$iv3[0] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv4), (Object)new Function0<PredefinedValue>(indentOptions){
                    final /* synthetic */ CommonCodeStyleSettings.IndentOptions $indentOptions$inlined;
                    {
                        this.$indentOptions$inlined = indentOptions;
                    }

                    public final PredefinedValue invoke() {
                        boolean bl = false;
                        return SettingsSynchronizerKt.asPredefinedType((Object)(this.$indentOptions$inlined.USE_TAB_CHARACTER ? "Tab" : "Space"));
                    }
                });
                Object[] this_$iv4 = this;
                reSharperKey$iv4 = super.cppEntry("INDENT_SIZE");
                $i$f$radEntry4 = false;
                this_$iv3[1] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv4), (Object)new Function0<PredefinedValue>(indentOptions){
                    final /* synthetic */ CommonCodeStyleSettings.IndentOptions $indentOptions$inlined;
                    {
                        this.$indentOptions$inlined = indentOptions;
                    }

                    public final PredefinedValue invoke() {
                        boolean bl = false;
                        return SettingsSynchronizerKt.asPredefinedType((Object)this.$indentOptions$inlined.INDENT_SIZE);
                    }
                });
                this_$iv4 = this;
                reSharperKey$iv4 = super.cppEntry("CONTINUOUS_LINE_INDENT");
                $i$f$radEntry4 = false;
                this_$iv3[2] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv4), (Object)new Function0<PredefinedValue>(indentOptions){
                    final /* synthetic */ CommonCodeStyleSettings.IndentOptions $indentOptions$inlined;
                    {
                        this.$indentOptions$inlined = indentOptions;
                    }

                    public final PredefinedValue invoke() {
                        boolean bl = false;
                        return SettingsSynchronizerKt.asPredefinedType((Object)(this.$indentOptions$inlined.CONTINUATION_INDENT_SIZE == 0 ? "None" : (this.$indentOptions$inlined.CONTINUATION_INDENT_SIZE <= this.$indentOptions$inlined.INDENT_SIZE ? "Single" : "Double")));
                    }
                });
                this_$iv4 = this;
                reSharperKey$iv4 = super.cppEntry("TAB_WIDTH");
                $i$f$radEntry4 = false;
                this_$iv3[3] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv4), (Object)new Function0<PredefinedValue>(indentOptions){
                    final /* synthetic */ CommonCodeStyleSettings.IndentOptions $indentOptions$inlined;
                    {
                        this.$indentOptions$inlined = indentOptions;
                    }

                    public final PredefinedValue invoke() {
                        boolean bl = false;
                        return SettingsSynchronizerKt.asPredefinedType((Object)this.$indentOptions$inlined.TAB_SIZE);
                    }
                });
                CollectionsKt.addAll((Collection)this_$iv2, (Iterable)CollectionsKt.listOf((Object[])this_$iv3));
            }
            super.log("{migration");
            Iterable $this$forEach$iv2 = options;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                PredefinedValue value = (PredefinedValue)((Function0)it.getSecond()).invoke();
                riderCustomSettings.getData().put(it.getFirst(), value);
                Companion.log("  " + it.getFirst() + " -> " + value);
            }
            super.log("}migration");
            super.fireCodeStyleSettingChanged(project);
        }

        static /* synthetic */ void performMigration$default(Companion companion, Project project, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.performMigration(project, bl);
        }

        private final void fireCodeStyleSettingChanged(Project project) {
            if (project != null) {
                ApplicationManager.getApplication().invokeLater(() -> Companion.fireCodeStyleSettingChanged$lambda$0(project), project.getDisposed());
            } else {
                ApplicationManager.getApplication().invokeLater(Companion::fireCodeStyleSettingChanged$lambda$1);
            }
        }

        private final String cppEntry(@NonNls String optionName) {
            return "CodeStyle/CodeFormatting/CppFormatting/" + optionName;
        }

        private final String getTernaryOperatorAlignStyle(boolean option) {
            String string;
            boolean bl = option;
            if (bl) {
                string = "ALIGN_ALL";
            } else if (!bl) {
                string = "NONE";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private final String getSimpleEmbeddedStatementStyle(@CidrCodeStyleSettings.NewLineConstant int option) {
            return switch (option) {
                case 0 -> "ON_SINGLE_LINE";
                case 1 -> "LINE_BREAK";
                default -> "DO_NOT_CHANGE";
            };
        }

        private final String getConvertedWrapStyle(int option) {
            return switch (option) {
                case 1 -> "WRAP_IF_LONG";
                case 2 -> "CHOP_ALWAYS";
                case 5 -> "CHOP_IF_LONG";
                default -> "";
            };
        }

        private final String getConvertedWrapToSimpleEmbeddedStatementStyle(int option) {
            return switch (option) {
                case 1 -> "ON_SINGLE_LINE";
                case 2 -> "LINE_BREAK";
                case 5 -> "DO_NOT_CHANGE";
                default -> "";
            };
        }

        private final String getBraceFormatStyleStyle(@CommonCodeStyleSettings.BraceStyleConstant int option, boolean withSpace, boolean withCompactOption) {
            return switch (option) {
                case 1 -> {
                    if (withSpace) {
                        yield "END_OF_LINE";
                    }
                    yield "END_OF_LINE_NO_SPACE";
                }
                case 2 -> "NEXT_LINE";
                case 3 -> "NEXT_LINE_SHIFTED";
                case 4 -> "NEXT_LINE_SHIFTED_2";
                case 5 -> {
                    if (withCompactOption) {
                        yield "PICO";
                    }
                    yield "";
                }
                default -> "";
            };
        }

        static /* synthetic */ String getBraceFormatStyleStyle$default(Companion companion, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = true;
            }
            if ((n2 & 4) != 0) {
                bl2 = false;
            }
            return companion.getBraceFormatStyleStyle(n, bl, bl2);
        }

        public final void migrateCodeStyleFromCidrToRad(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.log("Check migration Classic->Nova");
                boolean perProjectSettings = CodeStyle.usesOwnSettings((Project)project);
                RunOnceUtil.runOnceForApp((String)RadMigrateCodeStyleAction.ID_MIGRATION_ACTION, () -> Companion.migrateCodeStyleFromCidrToRad$lambda$0(perProjectSettings, project));
                RunOnceUtil.runOnceForProject((Project)project, (String)RadMigrateCodeStyleAction.ID_MIGRATION_ACTION, () -> Companion.migrateCodeStyleFromCidrToRad$lambda$1(perProjectSettings, project));
            }
        }

        private final /* synthetic */ <T> Pair<KeyPathComponents, Function0<PredefinedValue>> radEntry(String reSharperKey, Function0<? extends T> accessor) {
            boolean $i$f$radEntry = false;
            return TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey), (Object)new Function0<PredefinedValue>(accessor){
                final /* synthetic */ Function0<T> $accessor;
                {
                    this.$accessor = $accessor;
                }

                public final PredefinedValue invoke() {
                    return SettingsSynchronizerKt.asPredefinedType((Object)this.$accessor.invoke());
                }
            });
        }

        private final void log(String message) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RadMigrateCodeStyleAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info(message);
        }

        private static final void fireCodeStyleSettingChanged$lambda$0(Project $project) {
            CodeStyleSettingsManager.getInstance((Project)$project).fireCodeStyleSettingsChanged();
        }

        private static final void fireCodeStyleSettingChanged$lambda$1() {
            CodeStyleSettingsManager.getInstance().fireCodeStyleSettingsChanged();
        }

        private static final void migrateCodeStyleFromCidrToRad$lambda$0(boolean $perProjectSettings, Project $project) {
            Companion.log("{Migration procedure Classic->Nova for Default CS");
            com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.performMigration$default(Companion, null, false, 2, null);
            if (!$perProjectSettings) {
                Companion.log("  Notify project backend that project-from-default CS were changed");
                Companion.fireCodeStyleSettingChanged($project);
            }
            Companion.log("}Migration procedure Classic->Nova for Default CS");
        }

        private static final void migrateCodeStyleFromCidrToRad$lambda$1(boolean $perProjectSettings, Project $project) {
            Companion.log("{Migration procedure Classic->Nova for project CS");
            if ($perProjectSettings) {
                com.intellij.clion.radler.core.settings.migration.RadMigrateCodeStyleAction$Companion.performMigration$default(Companion, $project, false, 2, null);
            } else {
                Companion.log("  Skip project-from-default CS migration, they need to be actual at this point");
            }
            Companion.log("}Migration procedure Classic->Nova for project CS");
        }

        public static final /* synthetic */ String access$getTernaryOperatorAlignStyle(Companion $this, boolean option) {
            return $this.getTernaryOperatorAlignStyle(option);
        }

        public static final /* synthetic */ String access$getBraceFormatStyleStyle(Companion $this, int option, boolean withSpace, boolean withCompactOption) {
            return $this.getBraceFormatStyleStyle(option, withSpace, withCompactOption);
        }

        public static final /* synthetic */ String access$getSimpleEmbeddedStatementStyle(Companion $this, int option) {
            return $this.getSimpleEmbeddedStatementStyle(option);
        }

        public static final /* synthetic */ String access$getConvertedWrapStyle(Companion $this, int option) {
            return $this.getConvertedWrapStyle(option);
        }

        public static final /* synthetic */ String access$getConvertedWrapToSimpleEmbeddedStatementStyle(Companion $this, int option) {
            return $this.getConvertedWrapToSimpleEmbeddedStatementStyle(option);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

