/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.radler.core.settings;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import com.jetbrains.rider.model.OptionsDialog;
import com.jetbrains.rider.settings.ReSharperConfigurableUtilKt;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B;\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB=\b\u0016\u0012\b\b\u0001\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0011B?\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\tH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lcom/intellij/clion/radler/core/settings/RadSettingsDialog;", "Lcom/intellij/openapi/options/newEditor/SettingsDialog;", "project", "Lcom/intellij/openapi/project/Project;", "key", "", "configurable", "Lcom/intellij/openapi/options/Configurable;", "showApplyButton", "", "showResetButton", "settingsViewModelHost", "Lcom/jetbrains/rider/settings/SettingsViewModelHost;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/options/Configurable;ZZLcom/jetbrains/rider/settings/SettingsViewModelHost;)V", "parent", "Ljava/awt/Component;", "(Ljava/awt/Component;Ljava/lang/String;Lcom/intellij/openapi/options/Configurable;ZZLcom/jetbrains/rider/settings/SettingsViewModelHost;)V", "groups", "", "Lcom/intellij/openapi/options/ConfigurableGroup;", "filter", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/options/Configurable;Ljava/lang/String;Lcom/jetbrains/rider/settings/SettingsViewModelHost;)V", "mySingleConfigurable", "areReSharperSettingsEnabled", "getAreReSharperSettingsEnabled", "()Z", "initialize", "", "doOKAction", "doCancelAction", "isClosed", "Companion", "intellij.clion.radler.core"})
@SourceDebugExtension(value={"SMAP\nRadSettingsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadSettingsDialog.kt\ncom/intellij/clion/radler/core/settings/RadSettingsDialog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,135:1\n13#2:136\n*S KotlinDebug\n*F\n+ 1 RadSettingsDialog.kt\ncom/intellij/clion/radler/core/settings/RadSettingsDialog\n*L\n37#1:136\n*E\n"})
public final class RadSettingsDialog
extends SettingsDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsViewModelHost settingsViewModelHost;
    @Nullable
    private final Project project;
    @Nullable
    private final Configurable mySingleConfigurable;
    @NotNull
    private static final Logger logger;

    private final boolean getAreReSharperSettingsEnabled() {
        return this.mySingleConfigurable == null || ReSharperConfigurableUtilKt.checkIsConfigurableFromReSharper((Configurable)this.mySingleConfigurable);
    }

    public RadSettingsDialog(@Nullable Project project, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton, @NotNull SettingsViewModelHost settingsViewModelHost) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter((Object)settingsViewModelHost, (String)"settingsViewModelHost");
        super(project, key, configurable, showApplyButton, showResetButton);
        this.project = project;
        this.settingsViewModelHost = settingsViewModelHost;
        this.mySingleConfigurable = configurable;
        this.initialize();
    }

    public RadSettingsDialog(@NotNull Component parent, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton, @NotNull SettingsViewModelHost settingsViewModelHost) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter((Object)settingsViewModelHost, (String)"settingsViewModelHost");
        super(parent, key, configurable, showApplyButton, showResetButton);
        this.project = null;
        this.settingsViewModelHost = settingsViewModelHost;
        this.mySingleConfigurable = configurable;
        this.initialize();
    }

    public RadSettingsDialog(@NotNull Project project, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable, @Nullable String filter, @NotNull SettingsViewModelHost settingsViewModelHost) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)settingsViewModelHost, (String)"settingsViewModelHost");
        super(project, groups, configurable, filter);
        this.project = project;
        this.settingsViewModelHost = settingsViewModelHost;
        this.mySingleConfigurable = null;
        this.initialize();
    }

    private final void initialize() {
        if (!this.getAreReSharperSettingsEnabled()) {
            logger.info("Entered frontend-only settings dialog with mySingleConfigurable = " + this.mySingleConfigurable);
            return;
        }
        PermittedModalitiesImpl permittedModalitiesImpl = IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null);
        Window window = this.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
        Component component = window;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        permittedModalitiesImpl.allowPumpProtocolForComponent(component, disposable);
        Lifetime currentDialogLifetime = this.settingsViewModelHost.getCurrentDialogLifetime();
        currentDialogLifetime.onTermination(() -> RadSettingsDialog.initialize$lambda$0(this));
        this.settingsViewModelHost.getCurrentDialog().view(currentDialogLifetime, (arg_0, arg_1) -> RadSettingsDialog.initialize$lambda$1(this, arg_0, arg_1));
    }

    public void doOKAction() {
        TableCellEditor editor;
        Container parent;
        Component focusOwner = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JFormattedTextField) {
            ((JFormattedTextField)focusOwner).commitEdit();
        }
        Component component = focusOwner;
        Container container = parent = component != null ? component.getParent() : null;
        if (parent instanceof JTable && (editor = ((JTable)parent).getCellEditor()) != null && !editor.stopCellEditing()) {
            throw new ConfigurationException(RiderSettingsBundle.Companion.message("RiderSettingsDialog.dialog.message.editing.cannot.be.stopped", new Object[0]));
        }
        super.doOKAction();
        if (this.getAreReSharperSettingsEnabled() && this.isClosed()) {
            SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
            if (settingsViewModelHost == null) {
                throw new IllegalStateException("host".toString());
            }
            SettingsViewModelHost settingsHost = settingsViewModelHost;
            settingsHost.saveTo("Radler Settings");
            this.settingsViewModelHost.cancel();
        }
    }

    public void doCancelAction() {
        super.doCancelAction();
        if (this.getAreReSharperSettingsEnabled() && this.isClosed()) {
            this.settingsViewModelHost.cancel();
        }
    }

    private final boolean isClosed() {
        return this.isDisposed();
    }

    private static final Unit initialize$lambda$0(RadSettingsDialog this$0) {
        super.doCancelAction();
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$1(RadSettingsDialog this$0, Lifetime dialogLifetime, OptionsDialog dialog) {
        Intrinsics.checkNotNullParameter((Object)dialogLifetime, (String)"dialogLifetime");
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        dialog.getSelectPage().advise(dialogLifetime, arg_0 -> RadSettingsDialog.initialize$lambda$1$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$1$0(RadSettingsDialog this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this$0.getEditor());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        Settings settings = (Settings)Settings.KEY.getData(dataContext2);
        if (settings == null) {
            return Unit.INSTANCE;
        }
        Settings settings2 = settings;
        settings2.select(settings2.find(it));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RadSettingsDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RadSettingsDialog.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/clion/radler/core/settings/RadSettingsDialog$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clion.radler.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

