/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.radler.core.psi;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.jetbrains.rider.cpp.fileType.lexer.CppElementType;
import com.jetbrains.rider.cpp.fileType.psi.CppElement;
import com.jetbrains.rider.cpp.fileType.psi.CppElementsTypes;
import com.jetbrains.rider.cpp.fileType.psi.impl.CppPsiElementBase;
import java.io.File;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0016B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/clion/radler/core/psi/RadNavigatablePsiElement;", "Lcom/jetbrains/rider/cpp/fileType/psi/impl/CppPsiElementBase;", "Lcom/jetbrains/rider/cpp/fileType/psi/CppElement;", "Lcom/intellij/psi/NavigatablePsiElement;", "functionName", "", "myOffset", "", "myFilePath", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getFunctionName", "()Ljava/lang/String;", "getMyOffset", "()I", "getMyFilePath", "navigate", "", "requestFocus", "", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "Companion", "intellij.clion.radler.core"})
public final class RadNavigatablePsiElement
extends CppPsiElementBase
implements CppElement,
NavigatablePsiElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String functionName;
    private final int myOffset;
    @NotNull
    private final String myFilePath;

    public RadNavigatablePsiElement(@NotNull String functionName, int myOffset, @NotNull String myFilePath) {
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        Intrinsics.checkNotNullParameter((Object)myFilePath, (String)"myFilePath");
        super((CppElementType)CppElementsTypes.Companion.getDUMMY_NODE());
        this.functionName = functionName;
        this.myOffset = myOffset;
        this.myFilePath = myFilePath;
    }

    @NotNull
    public final String getFunctionName() {
        return this.functionName;
    }

    public final int getMyOffset() {
        return this.myOffset;
    }

    @NotNull
    public final String getMyFilePath() {
        return this.myFilePath;
    }

    public void navigate(boolean requestFocus) {
        VirtualFile virtualFile = VfsUtil.findFile((Path)Path.of(this.myFilePath, new String[0]), (boolean)false);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiNavigationSupport.getInstance().createNavigatable(this.getProject(), virtualFile2, this.myOffset).navigate(requestFocus);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        String string = new File(this.myFilePath).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new Companion.RadItemPresentation(this.functionName, string);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/clion/radler/core/psi/RadNavigatablePsiElement$Companion;", "", "<init>", "()V", "RadItemPresentation", "intellij.clion.radler.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/clion/radler/core/psi/RadNavigatablePsiElement$Companion$RadItemPresentation;", "Lcom/intellij/navigation/ItemPresentation;", "functionName", "", "location", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPresentableText", "getLocationString", "getIcon", "Ljavax/swing/Icon;", "unused", "", "intellij.clion.radler.core"})
        public static final class RadItemPresentation
        implements ItemPresentation {
            @NotNull
            private final String functionName;
            @NotNull
            private final String location;

            public RadItemPresentation(@NotNull String functionName, @NotNull String location) {
                Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
                Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                this.functionName = functionName;
                this.location = location;
            }

            @NotNull
            public String getPresentableText() {
                return this.functionName;
            }

            @NotNull
            public String getLocationString() {
                return this.location;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }
        }
    }
}

