/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.radler.core.projectmodel;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.cidr.execution.CidrResolveConfigurationProvider;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.RdTaskUtilKt;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.model.CppIncludeGraph_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/clion/radler/core/projectmodel/RadResolveConfigurationProvider;", "Lcom/jetbrains/cidr/execution/CidrResolveConfigurationProvider;", "<init>", "()V", "getAllResolveConfigurationsForFile", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "file", "Lcom/intellij/psi/PsiFile;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "findRoots", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "Util", "intellij.clion.radler.core"})
@SourceDebugExtension(value={"SMAP\nRadResolveConfigurationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadResolveConfigurationProvider.kt\ncom/intellij/clion/radler/core/projectmodel/RadResolveConfigurationProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,81:1\n23#2:82\n23#2:83\n*S KotlinDebug\n*F\n+ 1 RadResolveConfigurationProvider.kt\ncom/intellij/clion/radler/core/projectmodel/RadResolveConfigurationProvider\n*L\n50#1:82\n65#1:83\n*E\n"})
public final class RadResolveConfigurationProvider
implements CidrResolveConfigurationProvider {
    @NotNull
    public Collection<OCResolveConfiguration> getAllResolveConfigurationsForFile(@NotNull PsiFile file, @Nullable ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Collection<VirtualFile> roots = this.findRoots(project2, virtualFile);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        HashSet configurations = new HashSet();
        for (VirtualFile root : roots) {
            configurations.addAll(OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile((VirtualFile)root, (Project)project2));
        }
        return configurations;
    }

    @NotNull
    public Collection<VirtualFile> findRoots(@NotNull Project project, @NotNull VirtualFile file) {
        List rootIds;
        Object[] $this$thisLogger$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        if (!languageUtils.isSupportedFileType(fileType)) {
            Object[] objectArray = new VirtualFile[]{file};
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
        Object object = (ProjectModelEntity)CollectionsKt.singleOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)file, (Project)project));
        if (object == null || (object = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)object, (Project)project)) == null) {
            Object[] objectArray = new VirtualFile[]{file};
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }
        int fileId = (Integer)object;
        RdCall collectHeaderRoots = CppIncludeGraph_PregeneratedKt.getCppIncludeGraph((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getCollectHeaderRoots();
        if (ApplicationKt.getApplication().isDispatchThread()) {
            $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(RadResolveConfigurationProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warnWithDebug("Attention! Potential freeze: getting roots on EDT, using sync call", new Throwable("Stacktrace"));
            Object object2 = ExtensionsKt.callSynchronously$default((IRdCall)((IRdCall)collectHeaderRoots), (Object)fileId, (IProtocol)ApplicationProtocolKt.getProtocol((Project)project), null, null, null, (int)28, null);
            Intrinsics.checkNotNull((Object)object2);
            v5 = (List)object2;
        } else {
            v5 = rootIds = (List)RdTaskUtilKt.callWithCancellation$default((IRdCall)((IRdCall)collectHeaderRoots), (Object)fileId, (long)0L, (int)2, null);
        }
        if (rootIds.isEmpty()) {
            $this$thisLogger$iv = new VirtualFile[]{file};
            return CollectionsKt.mutableListOf((Object[])$this$thisLogger$iv);
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        Iterator iterator = rootIds.iterator();
        while (iterator.hasNext()) {
            VirtualFile f;
            int fileId2 = ((Number)iterator.next()).intValue();
            ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getProjectModelEntity((WorkspaceModel)workspaceModel, (int)fileId2);
            VirtualFile virtualFile = projectModelEntity != null && (projectModelEntity = projectModelEntity.getUrl()) != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)projectModelEntity) : (f = null);
            if (f == null) {
                Object[] $this$thisLogger$iv2 = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(RadResolveConfigurationProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("could not find file for id " + fileId2);
                continue;
            }
            roots.add(f);
        }
        return roots;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/clion/radler/core/projectmodel/RadResolveConfigurationProvider$Util;", "", "<init>", "()V", "getResolveConfigurationOrFallback", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.clion.radler.core"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @Nullable
        public final OCResolveConfiguration getResolveConfigurationOrFallback(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            List list = OCWorkspace.getInstance((Project)project).getConfigurationsForFile(file);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurationsForFile(...)");
            List configs = list;
            OCResolveConfiguration oCResolveConfiguration = (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, (Collection)((Collection)configs)).first;
            if (oCResolveConfiguration == null) {
                oCResolveConfiguration = OCResolveConfigurations.getPreselectedConfiguration((VirtualFile)file, (Project)project);
            }
            return oCResolveConfiguration;
        }
    }
}

