/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.radler.core.format;

import com.intellij.clion.radler.core.clangFormat.RadClangFormatHelper;
import com.intellij.clion.radler.core.format.RadProjectWizardFormatterKt;
import com.intellij.clion.radler.core.projectmodel.RadProjectModelHost;
import com.intellij.lang.Language;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.BackgroundProgressCoroutineUtilKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.formatting.CidrProjectWizardFilesFormatter;
import com.jetbrains.cidr.project.CidrProjectWizardUtil;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import com.jetbrains.rider.cpp.fileType.CppLanguage;
import com.jetbrains.rider.model.RadFormatterModel_PregeneratedKt;
import com.jetbrains.rider.model.RadStringRange;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016JZ\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2:\u0010\f\u001a6\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\rj\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f`\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0003JZ\u0010\u0015\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2:\u0010\f\u001a6\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\rj\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f`\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/clion/radler/core/format/RadProjectWizardFormatter;", "Lcom/jetbrains/cidr/lang/formatting/CidrProjectWizardFilesFormatter;", "<init>", "()V", "reformatProjectFiles", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "formatWhenReady", "sourceFilesToReformat", "Ljava/util/LinkedHashMap;", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/editor/Document;", "", "Lkotlin/collections/LinkedHashMap;", "otherFiles", "", "formatAction", "sendRequestToFormatSourceFile", "document", "filePath", "intellij.clion.radler.core"})
@SourceDebugExtension(value={"SMAP\nRadProjectWizardFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadProjectWizardFormatter.kt\ncom/intellij/clion/radler/core/format/RadProjectWizardFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n774#2:152\n865#2,2:153\n*S KotlinDebug\n*F\n+ 1 RadProjectWizardFormatter.kt\ncom/intellij/clion/radler/core/format/RadProjectWizardFormatter\n*L\n39#1:152\n39#1:153,2\n*E\n"})
public final class RadProjectWizardFormatter
extends CidrProjectWizardFilesFormatter {
    /*
     * WARNING - void declaration
     */
    public void reformatProjectFiles(@NotNull List<? extends VirtualFile> files, @NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RadProjectWizardFormatterKt.access$log("{ reformatProjectFiles");
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!CidrProjectWizardFilesFormatter.isSourceFile((VirtualFile)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sourceFiles = (List)destination$iv$iv;
        Set otherFiles = CollectionsKt.subtract((Iterable)files, (Iterable)CollectionsKt.toSet((Iterable)sourceFiles));
        LinkedHashMap<String, Pair<Document, Long>> sourceFilesToReformat = new LinkedHashMap<String, Pair<Document, Long>>();
        for (VirtualFile file : sourceFiles) {
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) {
                RadProjectWizardFormatterKt.access$log("Cannot format project file: document is null");
                continue;
            }
            ((Map)sourceFilesToReformat).put(file.getPath(), new Pair((Object)document, (Object)document.getModificationStamp()));
        }
        this.formatWhenReady(project, sourceFilesToReformat, otherFiles);
        RadProjectWizardFormatterKt.access$log("} reformatProjectFiles");
    }

    @RequiresReadLock
    private final void formatWhenReady(Project project, LinkedHashMap<String, Pair<Document, Long>> sourceFilesToReformat, Set<? extends VirtualFile> otherFiles) {
        RadProjectModelHost projectModelHost = RadProjectModelHost.Companion.getInstance(project);
        if (projectModelHost.isProjectSyncedAtLeastOnce()) {
            RadProjectWizardFormatterKt.access$log("- reformatProjectFiles - synced");
            this.formatAction(project, sourceFilesToReformat, otherFiles);
            return;
        }
        RadProjectWizardFormatterKt.access$log("- reformatProjectFiles - not synced yet, postpone");
        LifetimeCoroutineUtilKt.launch$default((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(projectModelHost, this, project, sourceFilesToReformat, otherFiles, null){
            int label;
            final /* synthetic */ RadProjectModelHost $projectModelHost;
            final /* synthetic */ RadProjectWizardFormatter this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ LinkedHashMap<String, Pair<Document, Long>> $sourceFilesToReformat;
            final /* synthetic */ Set<VirtualFile> $otherFiles;
            {
                this.$projectModelHost = $projectModelHost;
                this.this$0 = $receiver;
                this.$project = $project;
                this.$sourceFilesToReformat = $sourceFilesToReformat;
                this.$otherFiles = $otherFiles;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        RadProjectWizardFormatterKt.access$log("- (postponed) reformatProjectFiles - waiting for sync");
lbl6:
                        // 3 sources

                        while (!this.$projectModelHost.isProjectSyncedAtLeastOnce()) {
                            this.label = 1;
                            v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                            if (v0 != var2_2) continue;
                            return var2_2;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                RadProjectWizardFormatterKt.access$log("- (postponed) reformatProjectFiles - synced");
                RadProjectWizardFormatter.access$formatAction(this.this$0, this.$project, this.$sourceFilesToReformat, this.$otherFiles);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void formatAction(Project project, LinkedHashMap<String, Pair<Document, Long>> sourceFilesToReformat, Set<? extends VirtualFile> otherFiles) {
        Lifetime lifetime = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project));
        String string = CidrLangBundle.message((String)"project.wizard.format.source.files", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        BackgroundProgressCoroutineUtilKt.launchWithModalProgress((Lifetime)lifetime, (Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, sourceFilesToReformat, this, otherFiles, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ LinkedHashMap<String, Pair<Document, Long>> $sourceFilesToReformat;
            final /* synthetic */ RadProjectWizardFormatter this$0;
            final /* synthetic */ Set<VirtualFile> $otherFiles;
            {
                this.$project = $project;
                this.$sourceFilesToReformat = $sourceFilesToReformat;
                this.this$0 = $receiver;
                this.$otherFiles = $otherFiles;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        RadProjectWizardFormatterKt.access$log("{ wizard format");
                        CidrProjectWizardUtil.NEW_PROJECT_GENERATION_IN_PROGRESS.set((UserDataHolder)this.$project, (Object)Boxing.boxBoolean((boolean)true));
                        this.label = 1;
                        v0 = CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.project.Project ), ()Lkotlin/Unit;)((Project)this.$project), (Continuation)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl13
lbl12:
                        // 1 sources

                        return var3_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        this.label = 2;
                        v1 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                        ** if (v1 != var3_2) goto lbl23
lbl22:
                        // 1 sources

                        return var3_2;
lbl23:
                        // 1 sources

                        ** GOTO lbl29
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        RadProjectWizardFormatterKt.access$log("{ format files");
                        this.label = 3;
                        v2 = CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(java.util.LinkedHashMap com.intellij.clion.radler.core.format.RadProjectWizardFormatter com.intellij.openapi.project.Project ), ()Lkotlin/Unit;)(this.$sourceFilesToReformat, (RadProjectWizardFormatter)this.this$0, (Project)this.$project), (Continuation)((Continuation)this));
                        ** if (v2 != var3_2) goto lbl34
lbl33:
                        // 1 sources

                        return var3_2;
lbl34:
                        // 1 sources

                        ** GOTO lbl40
                    }
                    case 3: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl40:
                            // 2 sources

                            RadProjectWizardFormatter.access$runFormatAction$s-1749229853(this.$project, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$2(java.util.Set com.intellij.openapi.project.Project ), ()V)(this.$otherFiles, (Project)this.$project));
                            RadProjectWizardFormatterKt.access$log("} format files");
                        }
                        catch (Throwable var2_3) {
                            throw var2_3;
                        }
                        finally {
                            CidrProjectWizardUtil.NEW_PROJECT_GENERATION_IN_PROGRESS.set((UserDataHolder)this.$project, null);
                            RadProjectWizardFormatterKt.access$log("} wizard format");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Project $project) {
                RadProjectWizardFormatterKt.access$log("{ prepare CS settings");
                CodeStyleSettingsManager.getInstance((Project)$project).fireCodeStyleSettingsChanged();
                ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
                boolean $i$f$service = false;
                Class<RadClangFormatHelper> serviceClass$iv = RadClangFormatHelper.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((RadClangFormatHelper)object).createClangFormatConfigurationIfNeeded($project);
                RadProjectWizardFormatterKt.access$log("} prepare CS settings");
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$1(LinkedHashMap $sourceFilesToReformat, RadProjectWizardFormatter this$0, Project $project) {
                for (Map.Entry<K, V> entry2 : ((Map)$sourceFilesToReformat).entrySet()) {
                    String filePath = (String)entry2.getKey();
                    Pair documentToModificationStamp = (Pair)entry2.getValue();
                    Document document = (Document)documentToModificationStamp.getFirst();
                    long modificationStamp = ((Number)documentToModificationStamp.getSecond()).longValue();
                    if (document.getModificationStamp() != modificationStamp) {
                        RadProjectWizardFormatterKt.access$log("Cannot format project file " + filePath + ": already changed");
                        continue;
                    }
                    RadProjectWizardFormatterKt.access$log("- formatting " + filePath);
                    RadProjectWizardFormatter.access$sendRequestToFormatSourceFile(this$0, document, filePath, $project);
                }
                return Unit.INSTANCE;
            }

            private static final void invokeSuspend$lambda$2(Set $otherFiles, Project $project) {
                RadProjectWizardFormatter.access$reformatTextFiles$s-1749229853($otherFiles, RadProjectWizardFormatterKt.access$getLogger$p(), $project);
            }
        }));
    }

    private final void sendRequestToFormatSourceFile(Document document, String filePath, Project project) {
        IdeBackend backend = IdeBackend.Companion.getInstance(project);
        RdLanguage language = ProtocolLanguageManagerKt.toRdLanguageOrThrow((Language)((Language)CppLanguage.INSTANCE));
        TextRange textRange = TextRange.create((int)0, (int)document.getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        TextRange range = textRange;
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        RadStringRange request = new RadStringRange(string, filePath, RangeUtilKt.toRdTextRange((TextRange)range), language);
        SourceExKt.adviseOnce((ISource)((ISource)RadFormatterModel_PregeneratedKt.getRadFormatterModel((Solution)backend.getSolution()).getDoFormatText().start(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), (Object)request).getResult()), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), arg_0 -> RadProjectWizardFormatter.sendRequestToFormatSourceFile$lambda$0(document, arg_0));
    }

    private static final Unit sendRequestToFormatSourceFile$lambda$0(Document $document, RdTaskResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RdTaskResult rdTaskResult = it;
        if (rdTaskResult instanceof RdTaskResult.Success) {
            WriteAction.run(() -> RadProjectWizardFormatter.sendRequestToFormatSourceFile$lambda$0$0($document, it));
        } else if (rdTaskResult instanceof RdTaskResult.Fault) {
            RadProjectWizardFormatterKt.access$log("Cannot format project file " + ((RdTaskResult.Fault)it).getError().getCause());
        } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
            RadProjectWizardFormatterKt.access$log("Cannot format project file: Task cancelled");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final void sendRequestToFormatSourceFile$lambda$0$0(Document $document, RdTaskResult $it) {
        $document.setText((CharSequence)((RdTaskResult.Success)$it).getValue());
    }

    public static final /* synthetic */ void access$formatAction(RadProjectWizardFormatter $this, Project project, LinkedHashMap sourceFilesToReformat, Set otherFiles) {
        $this.formatAction(project, sourceFilesToReformat, otherFiles);
    }

    public static final /* synthetic */ void access$runFormatAction$s-1749229853(Project p0, Runnable p1) {
        CidrProjectWizardFilesFormatter.runFormatAction((Project)p0, (Runnable)p1);
    }

    public static final /* synthetic */ void access$sendRequestToFormatSourceFile(RadProjectWizardFormatter $this, Document document, String filePath, Project project) {
        $this.sendRequestToFormatSourceFile(document, filePath, project);
    }

    public static final /* synthetic */ void access$reformatTextFiles$s-1749229853(Collection p0, Logger p1, Project p2) {
        CidrProjectWizardFilesFormatter.reformatTextFiles((Collection)p0, (Logger)p1, (Project)p2);
    }
}

