/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.radler.core.diagnostics;

import com.intellij.clion.radler.core.util.RadPluginUtilsKt;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.jetbrains.cidr.execution.debugger.NativeSelfProfilerPathProvider;
import com.jetbrains.cidr.execution.debugger.NativeSelfProfilerPaths;
import com.jetbrains.rider.RiderEnvironment;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/clion/radler/core/diagnostics/RadNativeSelfProfilerPathProvider;", "Lcom/jetbrains/cidr/execution/debugger/NativeSelfProfilerPathProvider;", "<init>", "()V", "getProfilerPaths", "Lcom/jetbrains/cidr/execution/debugger/NativeSelfProfilerPaths;", "getProfilerPath", "Ljava/nio/file/Path;", "getAdditionalProbingPaths", "", "intellij.clion.radler.core"})
public final class RadNativeSelfProfilerPathProvider
extends NativeSelfProfilerPathProvider {
    @Nullable
    public NativeSelfProfilerPaths getProfilerPaths() {
        Path radlerPluginPath = RadPluginUtilsKt.getRadlerPluginPath();
        if (radlerPluginPath == null) {
            return null;
        }
        return new NativeSelfProfilerPaths(this.getProfilerPath(), this.getAdditionalProbingPaths());
    }

    private final Path getProfilerPath() {
        if (PluginManagerCore.isRunningFromSources() || AppMode.isRunningFromDevBuild()) {
            Path path = RiderEnvironment.INSTANCE.getBundledBinDir().toPath().resolve("JetBrains.ReSharperCpp.NativeSelfProfiler.exe");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }
        Path path = RadPluginUtilsKt.getRadlerPluginPath();
        Intrinsics.checkNotNull((Object)path);
        Path path2 = path.resolve("DotFiles").resolve("JetBrains.ReSharperCpp.NativeSelfProfiler.exe");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    private final List<Path> getAdditionalProbingPaths() {
        if (PluginManagerCore.isRunningFromSources() || AppMode.isRunningFromDevBuild()) {
            return CollectionsKt.emptyList();
        }
        Path path = RadPluginUtilsKt.getRadlerPluginPath();
        Intrinsics.checkNotNull((Object)path);
        Path backendLocation = path.resolve("DotFiles");
        Path path2 = RadPluginUtilsKt.getRadlerPluginPath();
        Intrinsics.checkNotNull((Object)path2);
        Path dotCommon = path2.resolve("dotCommon").resolve("DotFiles");
        Object[] objectArray = new Path[]{backendLocation, dotCommon};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

