/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.external.system.model.impl;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.external.system.model.ExternalLanguageConfiguration;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u0003H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c2\u0003J\u0011\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c2\u0003J=\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\nH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/cidr/external/system/model/impl/ExternalLanguageConfigurationImpl;", "Lcom/jetbrains/cidr/external/system/model/ExternalLanguageConfiguration;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "compilerKind", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "compilerExecutable", "Ljava/io/File;", "compilerSwitches", "", "", "<init>", "(Lcom/jetbrains/cidr/lang/OCLanguageKind;Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;Ljava/io/File;Ljava/util/List;)V", "getLanguageKind", "getCompilerKind", "getCompilerExecutable", "getCompilerSwitches", "resolveCompiler", "project", "Lcom/intellij/openapi/project/Project;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.cidr.externalSystem"})
public final class ExternalLanguageConfigurationImpl
implements ExternalLanguageConfiguration {
    @NotNull
    private final OCLanguageKind languageKind;
    @Nullable
    private final OCCompilerKind compilerKind;
    @Nullable
    private final File compilerExecutable;
    @Nullable
    private final List<String> compilerSwitches;

    public ExternalLanguageConfigurationImpl(@NotNull OCLanguageKind languageKind, @Nullable OCCompilerKind compilerKind, @Nullable File compilerExecutable, @Nullable List<String> compilerSwitches) {
        Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
        this.languageKind = languageKind;
        this.compilerKind = compilerKind;
        this.compilerExecutable = compilerExecutable;
        this.compilerSwitches = compilerSwitches;
    }

    @Override
    @NotNull
    public OCLanguageKind getLanguageKind() {
        return this.languageKind;
    }

    @Override
    @Nullable
    public OCCompilerKind getCompilerKind() {
        return this.compilerKind;
    }

    @Override
    @Nullable
    public File getCompilerExecutable() {
        return this.compilerExecutable;
    }

    @Override
    @Nullable
    public List<String> getCompilerSwitches() {
        return this.compilerSwitches;
    }

    @NotNull
    public final OCCompilerKind resolveCompiler(@NotNull Project project, @NotNull CidrToolEnvironment environment) {
        OCCompilerKind oCCompilerKind;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (this.compilerKind != null && !Intrinsics.areEqual((Object)this.compilerKind, (Object)UnknownCompilerKind.INSTANCE)) {
            oCCompilerKind = this.compilerKind;
        } else if (this.compilerExecutable == null) {
            oCCompilerKind = (OCCompilerKind)UnknownCompilerKind.INSTANCE;
        } else {
            Path path = environment.getHostMachine().getPath(this.compilerExecutable.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
            oCCompilerKind = OCCompilerResolver.Companion.resolve(project, path, environment);
        }
        return oCCompilerKind;
    }

    private final OCLanguageKind component1() {
        return this.languageKind;
    }

    private final OCCompilerKind component2() {
        return this.compilerKind;
    }

    private final File component3() {
        return this.compilerExecutable;
    }

    private final List<String> component4() {
        return this.compilerSwitches;
    }

    @NotNull
    public final ExternalLanguageConfigurationImpl copy(@NotNull OCLanguageKind languageKind, @Nullable OCCompilerKind compilerKind, @Nullable File compilerExecutable, @Nullable List<String> compilerSwitches) {
        Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
        return new ExternalLanguageConfigurationImpl(languageKind, compilerKind, compilerExecutable, compilerSwitches);
    }

    public static /* synthetic */ ExternalLanguageConfigurationImpl copy$default(ExternalLanguageConfigurationImpl externalLanguageConfigurationImpl, OCLanguageKind oCLanguageKind, OCCompilerKind oCCompilerKind, File file, List list, int n, Object object) {
        if ((n & 1) != 0) {
            oCLanguageKind = externalLanguageConfigurationImpl.languageKind;
        }
        if ((n & 2) != 0) {
            oCCompilerKind = externalLanguageConfigurationImpl.compilerKind;
        }
        if ((n & 4) != 0) {
            file = externalLanguageConfigurationImpl.compilerExecutable;
        }
        if ((n & 8) != 0) {
            list = externalLanguageConfigurationImpl.compilerSwitches;
        }
        return externalLanguageConfigurationImpl.copy(oCLanguageKind, oCCompilerKind, file, list);
    }

    @NotNull
    public String toString() {
        return "ExternalLanguageConfigurationImpl(languageKind=" + this.languageKind + ", compilerKind=" + this.compilerKind + ", compilerExecutable=" + this.compilerExecutable + ", compilerSwitches=" + this.compilerSwitches + ")";
    }

    public int hashCode() {
        int result = this.languageKind.hashCode();
        result = result * 31 + (this.compilerKind == null ? 0 : this.compilerKind.hashCode());
        result = result * 31 + (this.compilerExecutable == null ? 0 : this.compilerExecutable.hashCode());
        result = result * 31 + (this.compilerSwitches == null ? 0 : ((Object)this.compilerSwitches).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExternalLanguageConfigurationImpl)) {
            return false;
        }
        ExternalLanguageConfigurationImpl externalLanguageConfigurationImpl = (ExternalLanguageConfigurationImpl)other;
        if (!Intrinsics.areEqual((Object)this.languageKind, (Object)externalLanguageConfigurationImpl.languageKind)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.compilerKind, (Object)externalLanguageConfigurationImpl.compilerKind)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.compilerExecutable, (Object)externalLanguageConfigurationImpl.compilerExecutable)) {
            return false;
        }
        return Intrinsics.areEqual(this.compilerSwitches, externalLanguageConfigurationImpl.compilerSwitches);
    }
}

