/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.jetbrains.cmake.CMakeLanguage;
import com.jetbrains.cmake.CMakePsiBundle;
import com.jetbrains.cmake.settings.CMakeCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        CMakeLanguage cMakeLanguage = CMakeLanguage.INSTANCE;
        if (cMakeLanguage == null) {
            CMakeLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return cMakeLanguage;
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            CMakeLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return switch (settingsType) {
            case LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS -> CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"Spaces.cmake");
            case LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS -> CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"Indent.cmake");
            case LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS -> CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"Wrapping.cmake");
            case LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS -> CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"Blank_lines.cmake");
            default -> "";
        };
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            CMakeLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            CMakeLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            consumer.showStandardOptions(new String[]{"INDENT_SIZE"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_BEFORE_IF_PARENTHESES", "SPACE_WITHIN_IF_PARENTHESES", "SPACE_BEFORE_WHILE_PARENTHESES", "SPACE_WITHIN_WHILE_PARENTHESES", "SPACE_BEFORE_FOR_PARENTHESES", "SPACE_WITHIN_FOR_PARENTHESES"});
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_CALL_PARENTHESES", CMakePsiBundle.message("cmake.settings.formatter.spaceBeforeMethodCallParentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_PARENTHESES", CMakePsiBundle.message("cmake.settings.formatter.spaceBeforeMethodParentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_CALL_PARENTHESES", CMakePsiBundle.message("cmake.settings.formatter.spaceWithinMethodCallParentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_PARENTHESES", CMakePsiBundle.message("cmake.settings.formatter.spaceWithinMethodParentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_BEFORE_FOR_PARENTHESES", CMakePsiBundle.message("cmake.settings.formatter.spaceBeforeForParentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_FOR_PARENTHESES", CMakePsiBundle.message("cmake.settings.formatter.spaceWithinForParentheses", new Object[0]));
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"ALIGN_MULTILINE_PARAMETERS_IN_CALLS"});
            consumer.showCustomOption(CMakeCodeStyleSettings.class, "ALIGN_COMMAND_CALL_R_PAR", CMakePsiBundle.message("cmake.settings.formatter.alignMultilineParentheses", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_METHOD_ARGUMENTS_WRAPPING, new Object[0]);
            consumer.showCustomOption(CMakeCodeStyleSettings.class, "ALIGN_CONTROL_FLOW_R_PAR", CMakePsiBundle.message("cmake.settings.formatter.alignMultilineParentheses", new Object[0]), CMakePsiBundle.message("cmake.settings.formatter.controlFlowCommands", new Object[0]), new Object[0]);
            consumer.renameStandardOption("ALIGN_MULTILINE_PARAMETERS_IN_CALLS", CMakePsiBundle.message("cmake.settings.formatter.alignWhenMultiline", new Object[0]));
            consumer.renameStandardOption(CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_METHOD_ARGUMENTS_WRAPPING, CMakePsiBundle.message("cmake.settings.formatter.commandCallArguments", new Object[0]));
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_CODE"});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/settings/CMakeLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/settings/CMakeLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

