/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.refactoring;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.completion.contributors.providers.CMakeCommandProvider;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeLiteral;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeSafeDeleteProcessorDelegate
implements SafeDeleteProcessorDelegate {
    public boolean handlesElement(PsiElement element) {
        return element instanceof PsiFile;
    }

    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete, @NotNull List<? super UsageInfo> result) {
        if (element == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(1);
        }
        if (allElementsToDelete == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(2);
        }
        ArrayList usages = new ArrayList();
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element, usages, (PsiElement[])allElementsToDelete);
        result.addAll(ContainerUtil.map(usages, info -> {
            final PsiElement usageElement = info.getElement();
            boolean isSafeDelete = CMakeSafeDeleteProcessorDelegate.isSafeToDelete(usageElement, allElementsToDelete);
            return new SafeDeleteReferenceSimpleDeleteUsageInfo(this, usageElement, ((SafeDeleteUsageInfo)info).getReferencedElement(), isSafeDelete){

                public void deleteElement() throws IncorrectOperationException {
                    CMakeSafeDeleteProcessorDelegate.deleteElement(usageElement);
                }
            };
        }));
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element);
    }

    private static void deleteElement(PsiElement usageElement) {
        CMakeArgument cMakeArgument;
        CMakeCommandArguments cMakeCommandArguments;
        CMakeCommand command;
        if ((usageElement = CMakeSafeDeleteProcessorDelegate.tryGetArgument(usageElement)) instanceof CMakeArgument && (command = (cMakeCommandArguments = (cMakeArgument = (CMakeArgument)usageElement).getParentCommandArguments()).getCommand()).getCMakeCommandName() != null && CMakeSafeDeleteProcessorDelegate.isReferencingFilesCommand(command.getCMakeCommandName(), cMakeArgument)) {
            CMakeSafeDeleteProcessorDelegate.deleteElementInUndoAction(cMakeArgument);
        }
    }

    private static PsiElement tryGetArgument(PsiElement usageElement) {
        if (usageElement instanceof CMakeLiteral) {
            usageElement = ((CMakeLiteral)usageElement).getArgument();
        }
        return usageElement;
    }

    private static void deleteElementInUndoAction(PsiElement command) {
        CommandProcessor processor = CommandProcessor.getInstance();
        processor.executeCommand(processor.getCurrentCommandProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> ((PsiElement)command).delete()), processor.getCurrentCommandName(), processor.getCurrentCommandGroupId());
    }

    private static boolean isSafeToDelete(PsiElement usageElement, PsiElement[] allElementsToDelete) {
        CMakeArgument cMakeArgument;
        CMakeCommandArguments cMakeCommandArguments;
        CMakeCommandName cMakeCommandName;
        if (usageElement != null && (usageElement = CMakeSafeDeleteProcessorDelegate.tryGetArgument(usageElement)) instanceof CMakeArgument && (cMakeCommandName = (cMakeCommandArguments = (cMakeArgument = (CMakeArgument)usageElement).getParentCommandArguments()).getCommandName()) != null && CMakeSafeDeleteProcessorDelegate.isReferencingFilesCommand(cMakeCommandName, cMakeArgument)) {
            List<CMakeArgument> groupOfArguments = CMakeSafeDeleteProcessorDelegate.getGroupOfArguments(cMakeArgument);
            PsiReference originalReference = CMakeSafeDeleteProcessorDelegate.findFileReference(cMakeArgument);
            if (originalReference != null) {
                PsiFile originalFile;
                PsiElement resolvedElement = originalReference.resolve();
                if (resolvedElement instanceof PsiFile && CMakeSafeDeleteProcessorDelegate.groupOfArgumentsReferencesAnotherFiles(groupOfArguments, originalFile = (PsiFile)resolvedElement)) {
                    Iterator<CMakeArgument> iterator = groupOfArguments.iterator();
                    while (iterator.hasNext()) {
                        PsiElement resolvedFile;
                        CMakeArgument argument = iterator.next();
                        PsiReference fileReference = CMakeSafeDeleteProcessorDelegate.findFileReference(argument);
                        if (fileReference == null || !((resolvedFile = fileReference.resolve()) instanceof PsiFile)) continue;
                        for (PsiElement elementToDelete : allElementsToDelete) {
                            if (elementToDelete != resolvedFile) continue;
                            iterator.remove();
                        }
                    }
                    return !groupOfArguments.isEmpty();
                }
                return false;
            }
            return CMakeSafeDeleteProcessorDelegate.isFileReference(cMakeArgument.getNextArgument());
        }
        return false;
    }

    @Nullable
    private static List<CMakeArgument> getGroupOfArguments(@NotNull CMakeArgument argument) {
        PsiElement resolvedElement;
        PsiReference originalReference;
        if (argument == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(3);
        }
        if ((originalReference = CMakeSafeDeleteProcessorDelegate.findFileReference(argument)) != null && (resolvedElement = originalReference.resolve()) instanceof PsiFile) {
            ArrayList<CMakeArgument> groupFileArguments = new ArrayList<CMakeArgument>();
            groupFileArguments.add(argument);
            groupFileArguments.addAll(CMakeSafeDeleteProcessorDelegate.getAllFileArguments(argument, (Function<CMakeArgument, CMakeArgument>)((Function)cMakeArgument -> cMakeArgument.getPreviousArgument())));
            groupFileArguments.addAll(CMakeSafeDeleteProcessorDelegate.getAllFileArguments(argument, (Function<CMakeArgument, CMakeArgument>)((Function)cMakeArgument -> cMakeArgument.getNextArgument())));
            return groupFileArguments;
        }
        return null;
    }

    private static boolean groupOfArgumentsReferencesAnotherFiles(@Nullable List<CMakeArgument> group, @NotNull PsiFile originalFile) {
        if (originalFile == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(4);
        }
        if (group != null) {
            for (CMakeArgument fileArgument : group) {
                if (CMakeSafeDeleteProcessorDelegate.isFileReferenceToCurrentFile(originalFile, fileArgument)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<CMakeArgument> getAllFileArguments(CMakeArgument argument, Function<CMakeArgument, CMakeArgument> nextArgumentFunction) {
        CMakeArgument nextArgument;
        ArrayList<CMakeArgument> arguments = new ArrayList<CMakeArgument>();
        while ((nextArgument = (CMakeArgument)nextArgumentFunction.fun((Object)argument)) != null && CMakeSafeDeleteProcessorDelegate.findFileReference(nextArgument) != null) {
            arguments.add(nextArgument);
            argument = nextArgument;
        }
        return arguments;
    }

    private static boolean isFileReferenceToCurrentFile(PsiFile originalFile, CMakeArgument argument) {
        PsiElement resolvedFile;
        PsiReference fileReference = CMakeSafeDeleteProcessorDelegate.findFileReference(argument);
        return fileReference != null && (resolvedFile = fileReference.resolve()) instanceof PsiFile && resolvedFile.equals((Object)originalFile);
    }

    private static boolean isReferencingFilesCommand(@NotNull CMakeCommandName cMakeCommandName, CMakeArgument cMakeArgument) {
        boolean isCommandWithSetOfFiles;
        if (cMakeCommandName == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(5);
        }
        boolean bl = isCommandWithSetOfFiles = CMakeCommandProvider.isAddExecutableCommand(cMakeCommandName) || CMakeCommandProvider.isAddLibraryCommand(cMakeCommandName) || CMakeCommandProvider.isSetCommand(cMakeCommandName) || CMakeCommandProvider.isAddCustomTargetCommand(cMakeCommandName) || CMakeCommandProvider.isFltkWrapUiCommand(cMakeCommandName) || CMakeCommandProvider.isQtWrapCppCommand(cMakeCommandName) || CMakeCommandProvider.isQtWrapUiCommand(cMakeCommandName) || CMakeCommandProvider.isSetPropertyCommand(cMakeCommandName) || CMakeCommandProvider.isSetSourceFilesPropertiesCommand(cMakeCommandName) || CMakeCommandProvider.isTryCompileCommand(cMakeCommandName);
        if (isCommandWithSetOfFiles) {
            CMakeArgument nextArgument = cMakeArgument.getNextArgument();
            CMakeArgument previousArgument = cMakeArgument.getPreviousArgument();
            if (CMakeSafeDeleteProcessorDelegate.isFileReference(nextArgument) || CMakeSafeDeleteProcessorDelegate.isFileReference(previousArgument)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isFileReference(@Nullable CMakeArgument argument) {
        return CMakeSafeDeleteProcessorDelegate.findFileReference(argument) != null;
    }

    @Nullable
    private static PsiReference findFileReference(@Nullable CMakeArgument argument) {
        PsiReference[] references;
        if (argument == null) {
            return null;
        }
        CMakeLiteral argumentLiteral = argument.getCMakeLiteral();
        if (argumentLiteral == null) {
            return null;
        }
        for (PsiReference reference : references = argumentLiteral.getReferences()) {
            if (!(reference.resolve() instanceof PsiFile)) continue;
            return reference;
        }
        return null;
    }

    @Nullable
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete) {
        if (element == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(6);
        }
        if (allElementsToDelete == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(7);
        }
        return Collections.singletonList(element);
    }

    @Nullable
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(8);
        }
        if (allElementsToDelete == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Nullable
    public Collection<String> findConflicts(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete) {
        if (element == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(10);
        }
        if (allElementsToDelete == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(11);
        }
        return null;
    }

    public UsageInfo @Nullable [] preprocessUsages(@NotNull Project project, UsageInfo @NotNull [] usages) {
        if (project == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(12);
        }
        if (usages == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(13);
        }
        return usages;
    }

    public void prepareForDeletion(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CMakeSafeDeleteProcessorDelegate.$$$reportNull$$$0(14);
        }
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cMakeCommandName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cmake/refactoring/CMakeSafeDeleteProcessorDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupOfArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "groupOfArgumentsReferencesAnotherFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferencingFilesCommand";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementsToSearch";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findConflicts";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessUsages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareForDeletion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

