/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.project.command;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.io.CPPLocalPathFactory;
import com.jetbrains.cidr.cpp.io.CPPPathFactory;
import com.jetbrains.cidr.cpp.project.command.CPPCommandDataContext;
import com.jetbrains.cidr.cpp.project.command.CPPCommandObject;
import com.jetbrains.cidr.cpp.project.command.CPPCommandParserResult;
import com.jetbrains.cidr.cpp.project.command.CPPCompilationCommand;
import com.jetbrains.cidr.cpp.project.command.CPPCompilationCommandDataContextKt;
import com.jetbrains.cidr.cpp.project.command.CantFindCompilerExecutable;
import com.jetbrains.cidr.cpp.project.command.FileDoesNotExist;
import com.jetbrains.cidr.cpp.project.command.IncorrectDirectory;
import com.jetbrains.cidr.cpp.project.command.IncorrectFile;
import com.jetbrains.cidr.cpp.project.command.NoCommand;
import com.jetbrains.cidr.cpp.project.command.NoCompilerExecutable;
import com.jetbrains.cidr.cpp.toolchains.CPPCompilerSwitchesUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u001b\u001a\u0004\u0018\u00010\u0016*\u00020\u00032\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u0016*\u00020\u00032\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u0014H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R.\u0010\u0011\u001a\"\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u00140\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/cpp/project/command/CPPCompilationCommandParser;", "Lkotlinx/coroutines/CoroutineScope;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "dataContext", "Lcom/jetbrains/cidr/cpp/project/command/CPPCommandDataContext;", "context", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;Lcom/jetbrains/cidr/cpp/project/command/CPPCommandDataContext;Lkotlin/coroutines/CoroutineContext;)V", "getEnvironment", "()Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "getDataContext", "()Lcom/jetbrains/cidr/cpp/project/command/CPPCommandDataContext;", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "compilerExecutableCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "", "Ljava/util/Optional;", "Ljava/nio/file/Path;", "parse", "Lcom/jetbrains/cidr/cpp/project/command/CPPCommandParserResult;", "command", "Lcom/jetbrains/cidr/cpp/project/command/CPPCompilationCommand;", "toLocalExecutable", "localBaseDir", "absoluteOrRelativeEnvPath", "toLocalExecutable0", "Companion", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nCPPCompilationCommandParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CPPCompilationCommandParser.kt\ncom/jetbrains/cidr/cpp/project/command/CPPCompilationCommandParser\n+ 2 CPPPathFactory.kt\ncom/jetbrains/cidr/cpp/io/CPPPathFactoryKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,277:1\n41#2,7:278\n41#2,7:285\n41#2,7:292\n41#2,7:299\n13#3:306\n*S KotlinDebug\n*F\n+ 1 CPPCompilationCommandParser.kt\ncom/jetbrains/cidr/cpp/project/command/CPPCompilationCommandParser\n*L\n72#1:278,7\n103#1:285,7\n168#1:292,7\n218#1:299,7\n273#1:306\n*E\n"})
public final class CPPCompilationCommandParser
implements CoroutineScope {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final CPPEnvironment environment;
    @TestOnly
    @Nullable
    private final CPPCommandDataContext dataContext;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final ConcurrentHashMap<Pair<String, String>, Optional<Path>> compilerExecutableCache;
    @NotNull
    private static final Logger LOG;

    public CPPCompilationCommandParser(@Nullable CPPEnvironment environment, @Nullable CPPCommandDataContext dataContext, @NotNull CoroutineContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.environment = environment;
        this.dataContext = dataContext;
        ExecutorService executorService = ConcurrencyUtil.newSameThreadExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSameThreadExecutorService(...)");
        this.coroutineContext = ExecutorsKt.from((ExecutorService)executorService).plus(context);
        this.compilerExecutableCache = new ConcurrentHashMap();
    }

    public /* synthetic */ CPPCompilationCommandParser(CPPEnvironment cPPEnvironment, CPPCommandDataContext cPPCommandDataContext, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cPPCommandDataContext = null;
        }
        if ((n & 4) != 0) {
            coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        this(cPPEnvironment, cPPCommandDataContext, coroutineContext);
    }

    @Nullable
    public final CPPEnvironment getEnvironment() {
        return this.environment;
    }

    @Nullable
    public final CPPCommandDataContext getDataContext() {
        return this.dataContext;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CPPCommandParserResult parse(@NotNull CPPCompilationCommand command) {
        Path path;
        String[] argv0;
        List args;
        String compilerPath;
        Path localFile;
        Object ipe$iv2;
        Path localDirectory;
        CPPCompilationCommand myCommand;
        block30: {
            String[] stringArray;
            block32: {
                block31: {
                    block29: {
                        Path path2;
                        String more$iv;
                        Object first$iv;
                        String[] onError$iv;
                        Path path3;
                        CPPCompilationCommand cPPCompilationCommand;
                        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                        if (this.dataContext != null) {
                            CPPLog.LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
                            cPPCompilationCommand = CPPCompilationCommandParser.Companion.expandMacros(command, this.dataContext);
                        } else {
                            cPPCompilationCommand = command;
                        }
                        myCommand = cPPCompilationCommand;
                        if (((CharSequence)myCommand.getDirectory$intellij_clion_execution()).length() == 0) {
                            return CPPCompilationCommandParser.Companion.toIncorrectDirectory(myCommand);
                        }
                        if (this.environment != null) {
                            path3 = com.jetbrains.cidr.cpp.project.command.CPPCompilationCommandParser$Companion.toLocalPath$default(Companion, this.environment, null, myCommand.getDirectory$intellij_clion_execution(), 1, null);
                        } else {
                            Path path4;
                            CPPPathFactory cPPPathFactory = CPPLocalPathFactory.INSTANCE;
                            String string = myCommand.getDirectory$intellij_clion_execution();
                            String[] stringArray2 = new String[]{};
                            onError$iv = CPPCompilationCommandParser.Companion.onError(myCommand.getDirectory$intellij_clion_execution(), new String[0]);
                            boolean $i$f$getPathOrNull = false;
                            try {
                                void $this$getPathOrNull$iv;
                                path4 = $this$getPathOrNull$iv.getPath((String)first$iv, (String[])Arrays.copyOf(more$iv, ((void)more$iv).length));
                            }
                            catch (InvalidPathException ipe$iv2) {
                                String string2 = ipe$iv2.getMessage();
                                if (string2 == null) {
                                    string2 = ipe$iv2.toString();
                                }
                                onError$iv.invoke((Object)string2);
                                path4 = null;
                            }
                            path3 = path4;
                        }
                        localDirectory = path3;
                        if (localDirectory == null || this.environment != null && !this.environment.getHostMachine().isRemote() && !CPPCompilationCommandParser.Companion.isDirectory(localDirectory)) {
                            return CPPCompilationCommandParser.Companion.toIncorrectDirectory(myCommand);
                        }
                        CoroutineScopeKt.ensureActive((CoroutineScope)this);
                        if (((CharSequence)myCommand.getFile$intellij_clion_execution()).length() == 0) {
                            return CPPCompilationCommandParser.Companion.toIncorrectFile(myCommand);
                        }
                        if (this.environment != null) {
                            first$iv = CPPCompilationCommandParser.Companion.toLocalPath(this.environment, localDirectory, myCommand.getFile$intellij_clion_execution());
                            path2 = first$iv != null ? first$iv.normalize() : null;
                        } else {
                            first$iv = CPPLocalPathFactory.INSTANCE;
                            more$iv = myCommand.getFile$intellij_clion_execution();
                            onError$iv = new String[]{};
                            Function1 onError$iv2 = CPPCompilationCommandParser.Companion.onError(myCommand.getFile$intellij_clion_execution(), new String[0]);
                            boolean $i$f$getPathOrNull = false;
                            try {
                                void more$iv2;
                                void first$iv2;
                                void $this$getPathOrNull$iv;
                                ipe$iv2 = $this$getPathOrNull$iv.getPath((String)first$iv2, (String[])Arrays.copyOf(more$iv2, ((void)more$iv2).length));
                            }
                            catch (InvalidPathException ipe$iv3) {
                                String string = ipe$iv3.getMessage();
                                if (string == null) {
                                    string = ipe$iv3.toString();
                                }
                                onError$iv2.invoke((Object)string);
                                ipe$iv2 = null;
                            }
                            path2 = ipe$iv2;
                        }
                        localFile = path2;
                        if (localFile == null || ((CharSequence)((Object)localFile).toString()).length() == 0) {
                            return CPPCompilationCommandParser.Companion.toIncorrectFile(myCommand);
                        }
                        if (this.environment != null && !CPPCompilationCommandParser.Companion.isRegularFile(localFile)) {
                            return new FileDoesNotExist(localFile);
                        }
                        CoroutineScopeKt.ensureActive((CoroutineScope)this);
                        compilerPath = null;
                        CPPEnvironment cPPEnvironment = this.environment;
                        if (cPPEnvironment == null || (cPPEnvironment = CPPCompilationCommandParser.Companion.getArgsFormat(cPPEnvironment)) == null) {
                            cPPEnvironment = CPPCompilationCommandParser.Companion.getDefaultArgsFormat();
                        }
                        CPPEnvironment argsFormat = cPPEnvironment;
                        args = null;
                        if (myCommand.getCommand$intellij_clion_execution() == null) break block29;
                        List list2 = CidrSwitchBuilder.parseArgs((String)myCommand.getCommand$intellij_clion_execution(), (CidrCompilerSwitches.Format)argsFormat);
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parseArgs(...)");
                        args = list2;
                        if (args.isEmpty()) {
                            return new NoCommand(myCommand.getFile$intellij_clion_execution(), myCommand.getDirectory$intellij_clion_execution(), myCommand.toUserString());
                        }
                        Object object = CollectionsKt.first((List)args);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                        compilerPath = (String)object;
                        break block30;
                    }
                    args = myCommand.getArguments$intellij_clion_execution();
                    stringArray = (String[])CollectionsKt.firstOrNull(args);
                    if (stringArray == null) break block31;
                    argv0 = stringArray;
                    boolean bl = false;
                    String[] stringArray3 = ((CharSequence)argv0).length() == 0 ? null : argv0;
                    stringArray = stringArray3;
                    if (stringArray3 != null) break block32;
                }
                return new NoCompilerExecutable(myCommand.getFile$intellij_clion_execution(), myCommand.getDirectory$intellij_clion_execution(), myCommand.toUserString());
            }
            compilerPath = stringArray;
        }
        if (this.environment != null) {
            path = this.toLocalExecutable(this.environment, localDirectory, compilerPath);
        } else {
            Path path5;
            CPPPathFactory $i$f$getPathOrNull = CPPLocalPathFactory.INSTANCE;
            ipe$iv2 = compilerPath;
            argv0 = new String[]{};
            Function1 onError$iv = CPPCompilationCommandParser.Companion.onError(compilerPath, new String[0]);
            boolean $i$f$getPathOrNull2 = false;
            try {
                void more$iv;
                void first$iv;
                void $this$getPathOrNull$iv;
                path5 = $this$getPathOrNull$iv.getPath((String)first$iv, (String[])Arrays.copyOf(more$iv, ((void)more$iv).length));
            }
            catch (InvalidPathException ipe$iv4) {
                String string = ipe$iv4.getMessage();
                if (string == null) {
                    string = ipe$iv4.toString();
                }
                onError$iv.invoke((Object)string);
                path5 = null;
            }
            path = path5;
        }
        Path compilerExecutable = path;
        List<String> arguments = args.subList(1, args.size());
        CoroutineScopeKt.ensureActive((CoroutineScope)this);
        if (compilerExecutable == null || ((CharSequence)((Object)compilerExecutable).toString()).length() == 0) {
            return new CantFindCompilerExecutable(compilerPath, myCommand.toUserString());
        }
        File file = localDirectory.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File file2 = localFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        String string = myCommand.getFile$intellij_clion_execution();
        File file3 = compilerExecutable.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
        return new CPPCommandParserResult.SuccessCommandObject(new CPPCommandObject(file, file2, string, file3, arguments));
    }

    private final Path toLocalExecutable(CPPEnvironment $this$toLocalExecutable, Path localBaseDir, String absoluteOrRelativeEnvPath) {
        Path path = localBaseDir;
        Pair key = TuplesKt.to((Object)(path != null ? ((Object)path).toString() : null), (Object)absoluteOrRelativeEnvPath);
        Optional optional = this.compilerExecutableCache.computeIfAbsent((Pair<String, String>)key, arg_0 -> CPPCompilationCommandParser.toLocalExecutable$lambda$1(arg_0 -> CPPCompilationCommandParser.toLocalExecutable$lambda$0(this, $this$toLocalExecutable, localBaseDir, absoluteOrRelativeEnvPath, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"computeIfAbsent(...)");
        Optional optional2 = optional;
        return optional2.orElse(null);
    }

    static /* synthetic */ Path toLocalExecutable$default(CPPCompilationCommandParser cPPCompilationCommandParser, CPPEnvironment cPPEnvironment, Path path, String string, int n, Object object) {
        if ((n & 1) != 0) {
            path = null;
        }
        return cPPCompilationCommandParser.toLocalExecutable(cPPEnvironment, path, string);
    }

    /*
     * WARNING - void declaration
     */
    private final Path toLocalExecutable0(CPPEnvironment $this$toLocalExecutable0, Path localBaseDir, String absoluteOrRelativeEnvPath) {
        Path path;
        CPPEnvironment.ExecutablePathResult executablePathResult = $this$toLocalExecutable0.resolveEnvPathToLocalExecutable(localBaseDir, absoluteOrRelativeEnvPath);
        Intrinsics.checkNotNullExpressionValue((Object)executablePathResult, (String)"resolveEnvPathToLocalExecutable(...)");
        CPPEnvironment.ExecutablePathResult result2 = executablePathResult;
        if (result2.isResolvedToExecutable) {
            String string = result2.path;
            if (string != null) {
                Path path2;
                String localExecutable = string;
                boolean bl = false;
                CPPPathFactory cPPPathFactory = CPPLocalPathFactory.INSTANCE;
                String string2 = localExecutable;
                String[] stringArray = new String[]{};
                Function1 function1 = CPPCompilationCommandParser.Companion.onError(localExecutable, new String[0]);
                boolean $i$f$getPathOrNull = false;
                try {
                    void more$iv;
                    void first$iv;
                    void $this$getPathOrNull$iv;
                    path2 = $this$getPathOrNull$iv.getPath((String)first$iv, (String[])Arrays.copyOf(more$iv, ((void)more$iv).length));
                }
                catch (InvalidPathException ipe$iv) {
                    void onError$iv;
                    String string3 = ipe$iv.getMessage();
                    if (string3 == null) {
                        string3 = ipe$iv.toString();
                    }
                    onError$iv.invoke((Object)string3);
                    path2 = null;
                }
                path = path2;
            } else {
                path = null;
            }
        } else {
            path = null;
        }
        return path;
    }

    static /* synthetic */ Path toLocalExecutable0$default(CPPCompilationCommandParser cPPCompilationCommandParser, CPPEnvironment cPPEnvironment, Path path, String string, int n, Object object) {
        if ((n & 1) != 0) {
            path = null;
        }
        return cPPCompilationCommandParser.toLocalExecutable0(cPPEnvironment, path, string);
    }

    private static final Optional toLocalExecutable$lambda$0(CPPCompilationCommandParser this$0, CPPEnvironment $this_toLocalExecutable, Path $localBaseDir, String $absoluteOrRelativeEnvPath, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path localExecutable = this$0.toLocalExecutable0($this_toLocalExecutable, $localBaseDir, $absoluteOrRelativeEnvPath);
        boolean bl = false;
        return Optional.ofNullable(localExecutable);
    }

    private static final Optional toLocalExecutable$lambda$1(Function1 $tmp0, Object p0) {
        return (Optional)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CPPCompilationCommandParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\u0007\u001a\u00020\b*\u00020\u0006H\u0002J\u0014\u0010\t\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0003J\"\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00112\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JI\u0010\u001d\u001a\u0013\u0012\t\u0012\u00070\u0018\u00a2\u0006\u0002\b\u001f\u0012\u0004\u0012\u00020 0\u001e2\u000b\u0010!\u001a\u00070\u0018\u00a2\u0006\u0002\b\u001f2\u001c\u0010\"\u001a\u000f\u0012\u000b\b\u0001\u0012\u00070\u0018\u00a2\u0006\u0002\b\u001f0#\"\u00070\u0018\u00a2\u0006\u0002\b\u001fH\u0002\u00a2\u0006\u0002\u0010$R\u0014\u0010\f\u001a\u00020\r8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\r*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u001a*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/cidr/cpp/project/command/CPPCompilationCommandParser$Companion;", "", "<init>", "()V", "toIncorrectDirectory", "Lcom/jetbrains/cidr/cpp/project/command/IncorrectDirectory;", "Lcom/jetbrains/cidr/cpp/project/command/CPPCompilationCommand;", "toIncorrectFile", "Lcom/jetbrains/cidr/cpp/project/command/IncorrectFile;", "expandMacros", "context", "Lcom/jetbrains/cidr/cpp/project/command/CPPCommandDataContext;", "defaultArgsFormat", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches$Format;", "getDefaultArgsFormat", "()Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches$Format;", "argsFormat", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "getArgsFormat", "(Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;)Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches$Format;", "toLocalPath", "Ljava/nio/file/Path;", "localBaseDir", "absoluteOrRelativeEnvPath", "", "isDirectory", "", "(Ljava/nio/file/Path;)Z", "isRegularFile", "onError", "Lkotlin/Function1;", "Lorg/jetbrains/annotations/NonNls;", "", "first", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Lkotlin/jvm/functions/Function1;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clion.execution"})
    @SourceDebugExtension(value={"SMAP\nCPPCompilationCommandParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CPPCompilationCommandParser.kt\ncom/jetbrains/cidr/cpp/project/command/CPPCompilationCommandParser$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CPPPathFactory.kt\ncom/jetbrains/cidr/cpp/io/CPPPathFactoryKt\n*L\n1#1,277:1\n1617#2,9:278\n1869#2:287\n1870#2:289\n1626#2:290\n1#3:288\n41#4,7:291\n*S KotlinDebug\n*F\n+ 1 CPPCompilationCommandParser.kt\ncom/jetbrains/cidr/cpp/project/command/CPPCompilationCommandParser$Companion\n*L\n237#1:278,9\n237#1:287\n237#1:289\n237#1:290\n237#1:288\n255#1:291,7\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final IncorrectDirectory toIncorrectDirectory(CPPCompilationCommand $this$toIncorrectDirectory) {
            return new IncorrectDirectory($this$toIncorrectDirectory.getDirectory$intellij_clion_execution(), $this$toIncorrectDirectory.toUserString());
        }

        private final IncorrectFile toIncorrectFile(CPPCompilationCommand $this$toIncorrectFile) {
            return new IncorrectFile($this$toIncorrectFile.getFile$intellij_clion_execution(), $this$toIncorrectFile.toUserString());
        }

        /*
         * WARNING - void declaration
         */
        @TestOnly
        private final CPPCompilationCommand expandMacros(CPPCompilationCommand $this$expandMacros, CPPCommandDataContext context) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            String string = CPPCompilationCommandDataContextKt.expandInString(context, $this$expandMacros.getDirectory$intellij_clion_execution());
            Intrinsics.checkNotNull((Object)string);
            String string2 = CPPCompilationCommandDataContextKt.expandInString(context, $this$expandMacros.getFile$intellij_clion_execution());
            Intrinsics.checkNotNull((Object)string2);
            Iterable iterable = $this$expandMacros.getArguments$intellij_clion_execution();
            String string3 = CPPCompilationCommandDataContextKt.expandInString(context, $this$expandMacros.getCommand$intellij_clion_execution());
            String string4 = string2;
            String string5 = string;
            CPPCompilationCommand cPPCompilationCommand = $this$expandMacros;
            boolean $i$f$mapNotNull = false;
            void var5_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (CPPCompilationCommandDataContextKt.expandInString(context, it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            return CPPCompilationCommand.copy$default(cPPCompilationCommand, string5, string4, string3, list2, null, 16, null);
        }

        @TestOnly
        private final CidrCompilerSwitches.Format getDefaultArgsFormat() {
            return SystemInfo.isWindows ? CidrCompilerSwitches.Format.WINDOWS_SHELL : CidrCompilerSwitches.Format.BASH_SHELL;
        }

        private final CidrCompilerSwitches.Format getArgsFormat(CPPEnvironment $this$argsFormat) {
            CidrCompilerSwitches.Format format = CPPCompilerSwitchesUtil.getFlagsFormat($this$argsFormat);
            Intrinsics.checkNotNullExpressionValue((Object)format, (String)"getFlagsFormat(...)");
            return format;
        }

        /*
         * WARNING - void declaration
         */
        private final Path toLocalPath(CPPEnvironment $this$toLocalPath, Path localBaseDir, String absoluteOrRelativeEnvPath) {
            Path path;
            Path path2 = localBaseDir;
            String localPath = $this$toLocalPath.toLocalPath(path2 != null ? path2.toFile() : null, absoluteOrRelativeEnvPath);
            CPPPathFactory cPPPathFactory = CPPLocalPathFactory.INSTANCE;
            Intrinsics.checkNotNull((Object)localPath);
            String string = localPath;
            String[] stringArray = new String[]{};
            Function1<String, Unit> function1 = this.onError(localPath, new String[0]);
            boolean $i$f$getPathOrNull = false;
            try {
                void more$iv;
                void first$iv;
                void $this$getPathOrNull$iv;
                path = $this$getPathOrNull$iv.getPath((String)first$iv, (String[])Arrays.copyOf(more$iv, ((void)more$iv).length));
            }
            catch (InvalidPathException ipe$iv) {
                void onError$iv;
                String string2 = ipe$iv.getMessage();
                if (string2 == null) {
                    string2 = ipe$iv.toString();
                }
                onError$iv.invoke((Object)string2);
                path = null;
            }
            return path;
        }

        static /* synthetic */ Path toLocalPath$default(Companion companion, CPPEnvironment cPPEnvironment, Path path, String string, int n, Object object) {
            if ((n & 1) != 0) {
                path = null;
            }
            return companion.toLocalPath(cPPEnvironment, path, string);
        }

        private final boolean isDirectory(Path $this$isDirectory) {
            return Files.isDirectory($this$isDirectory, new LinkOption[0]);
        }

        private final boolean isRegularFile(Path $this$isRegularFile) {
            return Files.isRegularFile($this$isRegularFile, new LinkOption[0]);
        }

        private final Function1<String, Unit> onError(String first, String ... more) {
            return arg_0 -> Companion.onError$lambda$0(first, more, arg_0);
        }

        private static final Unit onError$lambda$0(String $first, String[] $more, String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            LOG.warn("Failed to convert \"" + $first + "\" " + SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])$more), Companion::onError$lambda$0$0), null, null, null, (int)0, null, null, (int)63, null) + " to a path: " + message);
            return Unit.INSTANCE;
        }

        private static final String onError$lambda$0$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "\"" + it + "\"";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

