/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.project.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.project.command.CPPCommandObject;
import com.jetbrains.cidr.cpp.project.command.CPPCompilationCommandConverterKt;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.external.system.model.ExternalFileConfiguration;
import com.jetbrains.cidr.external.system.model.ExternalLanguageConfiguration;
import com.jetbrains.cidr.external.system.model.ExternalResolveConfiguration;
import com.jetbrains.cidr.external.system.model.impl.ExternalFileConfigurationImpl;
import com.jetbrains.cidr.external.system.model.impl.ExternalLanguageConfigurationImpl;
import com.jetbrains.cidr.external.system.model.impl.ExternalResolveConfigurationImpl;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.lang.workspace.compiler.OCOptionsFilteringCapable;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/project/command/CPPCompilationCommandConverter;", "Lkotlinx/coroutines/CoroutineScope;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/CoroutineContext;)V", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "convert", "Lcom/jetbrains/cidr/external/system/model/ExternalResolveConfiguration;", "command", "Lcom/jetbrains/cidr/cpp/project/command/CPPCommandObject;", "UnresolvedCompilerException", "intellij.clion.execution"})
public final class CPPCompilationCommandConverter
implements CoroutineScope {
    @NotNull
    private final CPPEnvironment environment;
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineContext coroutineContext;

    public CPPCompilationCommandConverter(@NotNull CPPEnvironment environment, @NotNull Project project, @NotNull CoroutineContext context) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.environment = environment;
        this.project = project;
        ExecutorService executorService = ConcurrencyUtil.newSameThreadExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSameThreadExecutorService(...)");
        this.coroutineContext = ExecutorsKt.from((ExecutorService)executorService).plus(context);
    }

    public /* synthetic */ CPPCompilationCommandConverter(CPPEnvironment cPPEnvironment, Project project, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        this(cPPEnvironment, project, coroutineContext);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public final ExternalResolveConfiguration convert(@NotNull CPPCommandObject command) throws UnresolvedCompilerException {
        List list2;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        CoroutineScopeKt.ensureActive((CoroutineScope)this);
        File compilerExecutable = command.getCompilerExecutable();
        Path path = this.environment.getHostMachine().getPath(compilerExecutable.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        OCCompilerKind compilerKind = OCCompilerResolver.Companion.resolve(this.project, path, (CidrToolEnvironment)this.environment);
        if (Intrinsics.areEqual((Object)compilerKind, (Object)UnknownCompilerKind.INSTANCE)) {
            throw new UnresolvedCompilerException(compilerExecutable);
        }
        CidrCompilerSwitches cidrCompilerSwitches = new CidrSwitchBuilder().addAllRaw(command.getArguments()).build();
        Intrinsics.checkNotNullExpressionValue((Object)cidrCompilerSwitches, (String)"build(...)");
        CidrCompilerSwitches switches = cidrCompilerSwitches;
        CPPCompilationCommandConverter $this$convert_u24lambda_u240 = this;
        boolean bl = false;
        OCCompiler oCCompiler = OCCompilerBase.getCompilerInstance((Project)$this$convert_u24lambda_u240.project, (OCCompilerKind)compilerKind, (File)compilerExecutable, (File)command.getDirectory(), (CidrToolEnvironment)((CidrToolEnvironment)$this$convert_u24lambda_u240.environment), (TempFilesPool)((TempFilesPool)TempFilesPool.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)oCCompiler, (String)"getCompilerInstance(...)");
        OCCompiler compiler = oCCompiler;
        if (!(compiler instanceof OCOptionsFilteringCapable)) {
            list2 = switches.getList(CidrCompilerSwitches.Format.RAW);
        } else {
            HashSet<String> skipNames = new HashSet<String>();
            CoroutineScopeKt.ensureActive((CoroutineScope)$this$convert_u24lambda_u240);
            String envFilePath = $this$convert_u24lambda_u240.environment.toEnvPath(command.getFile().getPath());
            String envDirectoryPath = $this$convert_u24lambda_u240.environment.toEnvPath(command.getDirectory().getPath());
            Iterator iterator = $this$convert_u24lambda_u240.environment.getSupportedFileSeparators().iterator();
            while (iterator.hasNext()) {
                String separatorFileName;
                String separatorDirectoryName;
                char separator = ((Character)iterator.next()).charValue();
                skipNames.add(FileUtilRt.toSystemDependentName((String)command.getOriginalFilePath(), (char)separator));
                Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.toSystemDependentName((String)envFilePath, (char)separator), (String)"toSystemDependentName(...)");
                Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.toSystemDependentName((String)envDirectoryPath, (char)separator), (String)"toSystemDependentName(...)");
                String relativeEnvPath = FileUtilRt.getRelativePath((String)separatorDirectoryName, (String)separatorFileName, (char)separator);
                skipNames.add(separatorFileName);
                if (relativeEnvPath == null) continue;
                skipNames.add(relativeEnvPath);
            }
            CoroutineScopeKt.ensureActive((CoroutineScope)$this$convert_u24lambda_u240);
            list2 = ((OCOptionsFilteringCapable)compiler).filterOptions(switches, (Set)skipNames).getList(CidrCompilerSwitches.Format.RAW);
        }
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"run(...)");
        List filteredSwitches = list2;
        CPPLog.LOG.debug("Filtered options for file '" + command.getFile() + "': " + CollectionsKt.joinToString$default((Iterable)filteredSwitches, null, null, null, (int)0, null, null, (int)63, null));
        OCLanguageKind oCLanguageKind = OCCompilerBase.resolveLanguage((OCCompilerKind)compilerKind, (List)filteredSwitches);
        if (oCLanguageKind == null && (oCLanguageKind = OCFileTypeHelpers.getLanguageKind((String)command.getFile().getName())) == null) {
            oCLanguageKind = (OCLanguageKind)CLanguageKind.CPP;
        }
        OCLanguageKind languageKind = oCLanguageKind;
        CPPLog.LOG.debug("Language kind for file '" + command.getFile() + "': " + languageKind.getDisplayName());
        List ccbinSwitch = languageKind.isCuda() ? CollectionsKt.toMutableList((Collection)CollectionsKt.listOfNotNull((Object)NVCCCompiler.Companion.getCCBinOption(filteredSwitches))) : (List)new ArrayList();
        ExternalLanguageConfigurationImpl languageConfiguration = new ExternalLanguageConfigurationImpl(languageKind, compilerKind, compilerExecutable, ccbinSwitch);
        ExternalFileConfigurationImpl fileConfiguration = new ExternalFileConfigurationImpl(command.getFile(), languageKind, filteredSwitches);
        Object[] objectArray = new ExternalLanguageConfiguration[]{languageConfiguration};
        Set set = SetsKt.mutableSetOf((Object[])objectArray);
        objectArray = new ExternalFileConfiguration[]{fileConfiguration};
        return (ExternalResolveConfiguration)new ExternalResolveConfigurationImpl(CPPCompilationCommandConverterKt.access$configurationId(command), CPPCompilationCommandConverterKt.access$configurationName(command), null, command.getDirectory(), this.environment.getToolchain().getName(), set, SetsKt.mutableSetOf((Object[])objectArray));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/cpp/project/command/CPPCompilationCommandConverter$UnresolvedCompilerException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "compilerExecutable", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getCompilerExecutable", "()Ljava/io/File;", "intellij.clion.execution"})
    public static final class UnresolvedCompilerException
    extends Exception {
        @NotNull
        private final File compilerExecutable;

        public UnresolvedCompilerException(@NotNull File compilerExecutable) {
            Intrinsics.checkNotNullParameter((Object)compilerExecutable, (String)"compilerExecutable");
            Object[] objectArray = new Object[]{compilerExecutable.toString()};
            super(CLionExecutionBundle.message("command.unknown.compiler.executable.message", objectArray));
            this.compilerExecutable = compilerExecutable;
        }

        @NotNull
        public final File getCompilerExecutable() {
            return this.compilerExecutable;
        }
    }
}

