/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaScrollPaneBorder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsYKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetsCounterUsagesCollector;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.HelpComponentKt;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.RunParametersHelper;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.TextAreaLookalikeDarculaScrollPaneBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u001cJ\b\u00103\u001a\u000204H\u0003J\b\u00105\u001a\u000204H\u0007J\u0006\u00106\u001a\u000204R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&Rd\u0010'\u001aX\u0012\f\u0012\n )*\u0004\u0018\u00010\r0\r\u0012\u0017\u0012\u0015\u0012\u0004\u0012\u00020+\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e\u0018\u00010* )*+\u0012\f\u0012\n )*\u0004\u0018\u00010\r0\r\u0012\u0017\u0012\u0015\u0012\u0004\u0012\u00020+\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e\u0018\u00010*\u0018\u00010,0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0/0.8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/HelpComponent;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/Disposable;)V", "MAX_HELP_RUN_TIMEOUT", "", "initialText", "", "Lorg/jetbrains/annotations/Nls;", "getInitialText", "()Ljava/lang/String;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "editor", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/HelpComponent$HelpEditorPane;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "workDir", "exePath", "env", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "notifyExecutableChanged", "newExe", "newWorkDir", "newEnv", "argumentsEditor", "Ljavax/swing/text/JTextComponent;", "getArgumentsEditor", "()Ljavax/swing/text/JTextComponent;", "setArgumentsEditor", "(Ljavax/swing/text/JTextComponent;)V", "gdbServersHelpLRU", "", "kotlin.jvm.PlatformType", "Lkotlin/Pair;", "", "", "historyProvider", "Lkotlin/Function0;", "", "getHistoryProvider", "()Lkotlin/jvm/functions/Function0;", "helpLoaded", "loadHelp", "", "gatherHelpIfNeeded", "gatherHelp", "HelpEditorPane", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nHelpComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelpComponent.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/HelpComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,391:1\n1869#2,2:392\n*S KotlinDebug\n*F\n+ 1 HelpComponent.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/HelpComponent\n*L\n268#1:392,2\n*E\n"})
public final class HelpComponent {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private final int MAX_HELP_RUN_TIMEOUT;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    @NotNull
    private final HelpEditorPane editor;
    @NotNull
    private final JComponent component;
    @Nullable
    private volatile String workDir;
    @Nullable
    private volatile String exePath;
    @Nullable
    private volatile EnvironmentVariablesData env;
    @Nullable
    private JTextComponent argumentsEditor;
    private final Map<String, Pair<Boolean, String>> gdbServersHelpLRU;
    private boolean helpLoaded;

    /*
     * WARNING - void declaration
     */
    public HelpComponent(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.MAX_HELP_RUN_TIMEOUT = 15000;
        Object object = new BorderLayout();
        this.loadingPanel = new JBLoadingPanel(disposable, this, (BorderLayout)object){
            final /* synthetic */ HelpComponent this$0;
            {
                this.this$0 = $receiver;
                super((LayoutManager)$super_call_param$1, $disposable, 300);
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                HelpComponent.access$getEditor$p(this.this$0).setEnabled(enabled);
            }
        };
        this.editor = new HelpEditorPane();
        this.component = (JComponent)BuilderKt.panel(arg_0 -> HelpComponent.component$lambda$0(this, disposable, arg_0));
        this.gdbServersHelpLRU = Collections.synchronizedMap(new LinkedHashMap<String, Pair<? extends Boolean, ? extends String>>(){

            protected boolean removeEldestEntry(Map.Entry<String, Pair<Boolean, String>> eldest) {
                Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
                return this.size() > 10;
            }
        });
        object = PropertiesComponent.getInstance().getList(HelpComponentKt.access$getGDBSERVERS_PERSISTENCE_KEY$p());
        if (object != null) {
            void $this$forEach$iv;
            Iterable iterable = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Object object2 = it;
                if (object2 == null || object2.length() == 0) continue;
                Map<String, Pair<Boolean, String>> map = this.gdbServersHelpLRU;
                Intrinsics.checkNotNullExpressionValue(map, (String)"gdbServersHelpLRU");
                object2 = map;
                String string = it;
                Object v = null;
                object2.put(string, v);
            }
        }
    }

    private final String getInitialText() {
        String string = CLionExecutionBundle.message("helpcomponent.initial.html", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final String notifyExecutableChanged(@NotNull String newExe, @NotNull String newWorkDir, @NotNull EnvironmentVariablesData newEnv) {
        Intrinsics.checkNotNullParameter((Object)newExe, (String)"newExe");
        Intrinsics.checkNotNullParameter((Object)newWorkDir, (String)"newWorkDir");
        Intrinsics.checkNotNullParameter((Object)newEnv, (String)"newEnv");
        this.workDir = newWorkDir;
        if (!StringsKt.isBlank((CharSequence)newExe)) {
            this.gdbServersHelpLRU.putIfAbsent(newExe, null);
            PropertiesComponent.getInstance().setList(HelpComponentKt.access$getGDBSERVERS_PERSISTENCE_KEY$p(), (Collection)this.gdbServersHelpLRU.keySet());
        }
        this.exePath = newExe;
        this.env = newEnv;
        this.loadHelp();
        return newExe;
    }

    @Nullable
    public final JTextComponent getArgumentsEditor() {
        return this.argumentsEditor;
    }

    public final void setArgumentsEditor(@Nullable JTextComponent jTextComponent) {
        this.argumentsEditor = jTextComponent;
    }

    @NotNull
    public final Function0<List<String>> getHistoryProvider() {
        return () -> HelpComponent._get_historyProvider_$lambda$0(this);
    }

    @RequiresEdt
    private final void loadHelp() {
        Pair<Boolean, String> helpData = this.gdbServersHelpLRU.get(this.exePath);
        CharSequence charSequence = this.exePath;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || this.loadingPanel.isLoading()) {
            this.editor.setText("");
            this.helpLoaded = false;
        } else if (helpData == null) {
            this.editor.setText(this.getInitialText());
            this.helpLoaded = false;
        } else {
            this.editor.setText((String)helpData.getSecond());
            this.helpLoaded = (Boolean)helpData.getFirst();
        }
        this.editor.setCaretPosition(0);
    }

    @RequiresEdt
    public final void gatherHelpIfNeeded() {
        if (!this.helpLoaded) {
            this.gatherHelp();
        }
    }

    public final void gatherHelp() {
        String currentExePath = StringKt.nullize((String)this.exePath, (boolean)true);
        if (currentExePath != null && !this.loadingPanel.isLoading()) {
            this.editor.setText("");
            this.loadingPanel.startLoading();
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, currentExePath, null){
                Object L$0;
                int label;
                final /* synthetic */ HelpComponent this$0;
                final /* synthetic */ String $currentExePath;
                {
                    this.this$0 = $receiver;
                    this.$currentExePath = $currentExePath;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            GeneralCommandLine commandLine = new RunParametersHelper(HelpComponent.access$getProject$p(this.this$0), this.$currentExePath, "--help", HelpComponent.access$getWorkDir$p(this.this$0), HelpComponent.access$getEnv$p(this.this$0)).expandedCommandLine();
                            DebugTargetsCounterUsagesCollector.INSTANCE.runHelpGdbServer(HelpComponent.access$getProject$p(this.this$0), commandLine);
                            try {
                                ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)HelpComponent.access$getMAX_HELP_RUN_TIMEOUT$p(this.this$0));
                                Map map = HelpComponent.access$getGdbServersHelpLRU$p(this.this$0);
                                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"access$getGdbServersHelpLRU$p(...)");
                                Map map2 = map;
                                String string = this.$currentExePath;
                                Pair pair = TuplesKt.to((Object)Boxing.boxBoolean((boolean)true), (Object)HelpComponentKt.helpToHtml(output.getStdout() + output.getStderr()));
                                map2.put(string, pair);
                            }
                            catch (Throwable e) {
                                Object[] objectArray = new Object[]{e.getLocalizedMessage()};
                                String string = CLionExecutionBundle.message("helpcomponent.error.html", objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                String errorText = string;
                                Map map = HelpComponent.access$getGdbServersHelpLRU$p(this.this$0);
                                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"access$getGdbServersHelpLRU$p(...)");
                                Map map3 = map;
                                String string2 = this.$currentExePath;
                                Pair pair = TuplesKt.to((Object)Boxing.boxBoolean((boolean)false), (Object)errorText);
                                map3.put(string2, pair);
                            }
                            CoroutineContext coroutineContext = CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE);
                            ModalityState modalityState = ModalityState.stateForComponent((Component)this.this$0.getComponent());
                            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)commandLine);
                            this.label = 1;
                            Object object2 = BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ HelpComponent this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            HelpComponent.access$getLoadingPanel$p(this.this$0).stopLoading();
                                            HelpComponent.access$loadHelp(this.this$0);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            GeneralCommandLine commandLine = (GeneralCommandLine)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private static final Unit component$lambda$0(HelpComponent this$0, Disposable $disposable, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> HelpComponent.component$lambda$0$0(this$0, $disposable, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$0$0(HelpComponent this$0, Disposable $disposable, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.customize(UnscaledGapsYKt.UnscaledGapsY$default((int)6, (int)0, (int)2, null));
        $this$row.cell((JComponent)this$0.loadingPanel).align(Align.FILL).resizableColumn().applyToComponent(arg_0 -> HelpComponent.component$lambda$0$0$0(this$0, $disposable, arg_0));
        $this$row.resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$0$0$0(HelpComponent this$0, Disposable $disposable, JBLoadingPanel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setMinimumSize(new Dimension(10, 10));
        JBScrollPane scrollPane = new JBScrollPane((Component)((Object)this$0.editor));
        scrollPane.setPreferredSize(new Dimension(100, 100));
        if (scrollPane.getBorder() instanceof DarculaScrollPaneBorder) {
            TextAreaLookalikeDarculaScrollPaneBorder border = new TextAreaLookalikeDarculaScrollPaneBorder();
            scrollPane.setBorder((Border)border);
            $this$applyToComponent.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, (Object)UnscaledGapsKt.UnscaledGaps((int)border.getUnscaledVisualPadding()));
        }
        RevertOnDisposeUtilKt.addFocusListener((Component)((Component)((Object)this$0.editor)), (Disposable)$disposable, (FocusListener)new FocusListener(scrollPane){
            final /* synthetic */ JBScrollPane $scrollPane;
            {
                this.$scrollPane = $scrollPane;
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$scrollPane.repaint();
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$scrollPane.repaint();
            }
        });
        $this$applyToComponent.add((Component)scrollPane, (Object)"Center");
        return Unit.INSTANCE;
    }

    private static final List _get_historyProvider_$lambda$0(HelpComponent this$0) {
        return CollectionsKt.toList((Iterable)this$0.gdbServersHelpLRU.keySet());
    }

    public static final /* synthetic */ Project access$getProject$p(HelpComponent $this) {
        return $this.project;
    }

    public static final /* synthetic */ String access$getWorkDir$p(HelpComponent $this) {
        return $this.workDir;
    }

    public static final /* synthetic */ EnvironmentVariablesData access$getEnv$p(HelpComponent $this) {
        return $this.env;
    }

    public static final /* synthetic */ int access$getMAX_HELP_RUN_TIMEOUT$p(HelpComponent $this) {
        return $this.MAX_HELP_RUN_TIMEOUT;
    }

    public static final /* synthetic */ Map access$getGdbServersHelpLRU$p(HelpComponent $this) {
        return $this.gdbServersHelpLRU;
    }

    public static final /* synthetic */ JBLoadingPanel access$getLoadingPanel$p(HelpComponent $this) {
        return $this.loadingPanel;
    }

    public static final /* synthetic */ void access$loadHelp(HelpComponent $this) {
        $this.loadHelp();
    }

    public static final /* synthetic */ HelpEditorPane access$getEditor$p(HelpComponent $this) {
        return $this.editor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0017\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/HelpComponent$HelpEditorPane;", "Lcom/intellij/ui/components/JBHtmlPane;", "<init>", "(Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/HelpComponent;)V", "gatherHelp", "", "shouldAddSpace", "", "char", "", "(Ljava/lang/Character;)Z", "insertToGdbServerArgumentsLine", "text", "", "intellij.clion.execution"})
    public final class HelpEditorPane
    extends JBHtmlPane {
        public HelpEditorPane() {
            CustomizationUtil.installPopupHandler((JComponent)((JComponent)((Object)this)), (String)"CLionDebugTargetHelpPopup", (String)"popup");
            this.setEditable(false);
            this.setBorder((Border)JBUI.Borders.empty((int)3, (int)5));
            this.setBackground((Color)JBColor.namedColor((String)"TextArea.background"));
            this.setText(HelpComponent.this.getInitialText());
            this.addHyperlinkListener(arg_0 -> HelpEditorPane._init_$lambda$0(HelpComponent.this, this, arg_0));
        }

        public final void gatherHelp() {
            HelpComponent.this.gatherHelp();
        }

        private final boolean shouldAddSpace(Character c) {
            return c == null ? false : !CharsKt.isWhitespace((char)c.charValue());
        }

        public final void insertToGdbServerArgumentsLine(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            JTextComponent jTextComponent = HelpComponent.this.getArgumentsEditor();
            if (jTextComponent == null) {
                return;
            }
            JTextComponent editor = jTextComponent;
            String string = editor.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Character charBeforeSelection = StringsKt.getOrNull((CharSequence)string, (int)(editor.getSelectionStart() - 1));
            boolean spaceBefore = this.shouldAddSpace(charBeforeSelection);
            String string2 = editor.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            Character charAfterSelection = StringsKt.getOrNull((CharSequence)string2, (int)editor.getSelectionEnd());
            boolean spaceAfter = this.shouldAddSpace(charAfterSelection);
            Object textToInsert = spaceBefore && spaceAfter ? " " + text + " " : (spaceBefore ? " " + text : (spaceAfter ? text + " " : text));
            editor.replaceSelection((String)textToInsert);
            if (spaceAfter) {
                editor.setCaretPosition(editor.getSelectionEnd() - 1);
            }
            editor.requestFocus();
        }

        private static final void _init_$lambda$0(HelpComponent this$0, HelpEditorPane this$1, HyperlinkEvent e) {
            if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                if (this$0.helpLoaded) {
                    String string = e.getDescription();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
                    this$1.insertToGdbServerArgumentsLine(string);
                } else {
                    this$1.gatherHelp();
                }
            }
        }
    }
}

