/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets;

import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.BrokenDebugTargetService;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetParameters;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetServiceViewContributorKt;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.GdbServerService;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.GenericDebugTarget;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.NamedDebugTargetConfigurable;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0015\u0010\u0013\u001a\u00020\u00122\u000b\u0010\u0014\u001a\u00070\n\u00a2\u0006\u0002\b\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetViewDescriptor;", "Lcom/intellij/execution/services/ServiceViewDescriptor;", "Lcom/intellij/navigation/ItemPresentation;", "project", "Lcom/intellij/openapi/project/Project;", "debugTargetParameters", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetParameters;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetParameters;)V", "getId", "", "getPresentation", "getPresentableText", "getIcon", "Ljavax/swing/Icon;", "unused", "", "getContentComponent", "Ljavax/swing/JComponent;", "getErrorComponent", "errorMessage", "Lorg/jetbrains/annotations/Nls;", "getPopupActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getToolbarActions", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nDebugTargetServiceViewContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTargetServiceViewContributor.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetViewDescriptor\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,97:1\n30#2,2:98\n*S KotlinDebug\n*F\n+ 1 DebugTargetServiceViewContributor.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetViewDescriptor\n*L\n49#1:98,2\n*E\n"})
public final class DebugTargetViewDescriptor
implements ServiceViewDescriptor,
ItemPresentation {
    @NotNull
    private final Project project;
    @NotNull
    private final DebugTargetParameters debugTargetParameters;

    public DebugTargetViewDescriptor(@NotNull Project project, @NotNull DebugTargetParameters debugTargetParameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)debugTargetParameters, (String)"debugTargetParameters");
        this.project = project;
        this.debugTargetParameters = debugTargetParameters;
    }

    @NotNull
    public String getId() {
        return this.debugTargetParameters.getName();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this;
    }

    @NotNull
    public String getPresentableText() {
        return this.debugTargetParameters.getName();
    }

    @NotNull
    public Icon getIcon(boolean unused) {
        return GenericDebugTarget.Companion.getIcon(this.project, this.debugTargetParameters.getUniqueID());
    }

    @NotNull
    public JComponent getContentComponent() {
        JComponent jComponent;
        String errorMessage = BrokenDebugTargetService.Companion.getInstance(this.project).getBrokenMessage(this.debugTargetParameters.getUniqueID());
        if (errorMessage != null) {
            jComponent = this.getErrorComponent(errorMessage);
        } else {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<GdbServerService> serviceClass$iv = GdbServerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            jComponent = ((GdbServerService)object).component(this.debugTargetParameters);
        }
        return jComponent;
    }

    private final JComponent getErrorComponent(String errorMessage) {
        return (JComponent)DebugTargetServiceViewContributorKt.access$centeredPanel(arg_0 -> DebugTargetViewDescriptor.getErrorComponent$lambda$0(errorMessage, this, arg_0));
    }

    @NotNull
    public ActionGroup getPopupActions() {
        AnAction anAction = ActionManager.getInstance().getAction("DebugTargets.Gdbserver");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        return (ActionGroup)anAction;
    }

    @NotNull
    public ActionGroup getToolbarActions() {
        return this.getPopupActions();
    }

    private static final Unit getErrorComponent$lambda$0(String $errorMessage, DebugTargetViewDescriptor this$0, Panel $this$centeredPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$centeredPanel, (String)"$this$centeredPanel");
        Panel.row$default((Panel)$this$centeredPanel, null, arg_0 -> DebugTargetViewDescriptor.getErrorComponent$lambda$0$0($errorMessage, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getErrorComponent$lambda$0$0(String $errorMessage, DebugTargetViewDescriptor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.General.Error;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Error");
        $this$row.icon(icon).gap(RightGap.SMALL);
        Object messageWithPeriod = StringsKt.endsWith$default((String)$errorMessage, (String)".", (boolean)false, (int)2, null) ? $errorMessage : $errorMessage + ".";
        $this$row.label((String)messageWithPeriod).gap(RightGap.SMALL);
        String string = CLionExecutionBundle.message("debug.targets.settings.link", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.link(string, arg_0 -> DebugTargetViewDescriptor.getErrorComponent$lambda$0$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit getErrorComponent$lambda$0$0$0(DebugTargetViewDescriptor this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ShowSettingsUtil.getInstance().showSettingsDialog(this$0.project, NamedDebugTargetConfigurable.class, arg_0 -> DebugTargetViewDescriptor.getErrorComponent$lambda$0$0$0$1(arg_0 -> DebugTargetViewDescriptor.getErrorComponent$lambda$0$0$0$0(this$0, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit getErrorComponent$lambda$0$0$0$0(DebugTargetViewDescriptor this$0, NamedDebugTargetConfigurable it) {
        it.selectDebugTarget(this$0.debugTargetParameters.getUniqueID());
        return Unit.INSTANCE;
    }

    private static final void getErrorComponent$lambda$0$0$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

