/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Placeholder;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ValueComponentPredicate;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetMacroSupportKt;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.HelpComponent;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.RunParametersHelper;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.TryRunComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 82\u00020\u0001:\u00018B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010)\u001a\u00020\u000bH\u0014J\b\u0010*\u001a\u00020\u000bH\u0014J\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020\nH\u0014J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020,H\u0016J\u0014\u00101\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n02H\u0002J\b\u00103\u001a\u00020\u000bH\u0002J\b\u00104\u001a\u00020\u000bH\u0002J\b\u00105\u001a\u00020\u000bH\u0002J\b\u00106\u001a\u00020\u000bH\u0007J\b\u00107\u001a\u00020\u000bH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&\u00a8\u00069"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/ArgumentEditorDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "helpComponent", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/HelpComponent;", "tryRunComponent", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/TryRunComponent;", "runParametersHelper", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/RunParametersHelper;", "okCallback", "Lkotlin/Function2;", "", "", "<init>", "(Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/HelpComponent;Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/TryRunComponent;Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/RunParametersHelper;Lkotlin/jvm/functions/Function2;)V", "getHelpComponent", "()Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/HelpComponent;", "getTryRunComponent", "()Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/TryRunComponent;", "getRunParametersHelper", "()Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/RunParametersHelper;", "getOkCallback", "()Lkotlin/jvm/functions/Function2;", "helpShowing", "Lcom/intellij/ui/layout/ValueComponentPredicate;", "outputPlaceholder", "Lcom/intellij/ui/dsl/builder/Placeholder;", "outputLabel", "Ljavax/swing/JLabel;", "commandLineTextComponent", "Lcom/intellij/ui/components/JBTextArea;", "workDir", "env", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "kotlin.jvm.PlatformType", "originalCommandLine", "centerComponent", "Lcom/intellij/ui/OnePixelSplitter;", "getCenterComponent", "()Lcom/intellij/ui/OnePixelSplitter;", "centerComponent$delegate", "Lkotlin/Lazy;", "createDefaultActions", "doOKAction", "createCenterPanel", "Ljavax/swing/JComponent;", "getDimensionServiceKey", "getInitialSize", "Ljava/awt/Dimension;", "getPreferredFocusedComponent", "getExeAndParams", "Lkotlin/Pair;", "executeTestRun", "switchToHelp", "switchToTest", "showHelp", "showTestRun", "Companion", "intellij.clion.execution"})
public final class ArgumentEditorDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HelpComponent helpComponent;
    @NotNull
    private final TryRunComponent tryRunComponent;
    @NotNull
    private final RunParametersHelper runParametersHelper;
    @NotNull
    private final Function2<String, String, Unit> okCallback;
    @NotNull
    private final ValueComponentPredicate helpShowing;
    private Placeholder outputPlaceholder;
    private JLabel outputLabel;
    private JBTextArea commandLineTextComponent;
    @NotNull
    private final String workDir;
    private final EnvironmentVariablesData env;
    @NlsSafe
    @NotNull
    private final String originalCommandLine;
    @NotNull
    private final Lazy centerComponent$delegate;
    @NotNull
    private static final String DIMENSION_KEY = "DebugServers.ArgumentEditorDialog.DimensionKey";
    @NotNull
    private static final String PROPORTION_KEY = "DebugServers.ArgumentEditorDialog.ProportionKey";

    public ArgumentEditorDialog(@NotNull HelpComponent helpComponent, @NotNull TryRunComponent tryRunComponent, @NotNull RunParametersHelper runParametersHelper, @NotNull Function2<? super String, ? super String, Unit> okCallback) {
        EnvironmentVariablesData environmentVariablesData;
        Intrinsics.checkNotNullParameter((Object)helpComponent, (String)"helpComponent");
        Intrinsics.checkNotNullParameter((Object)tryRunComponent, (String)"tryRunComponent");
        Intrinsics.checkNotNullParameter((Object)runParametersHelper, (String)"runParametersHelper");
        Intrinsics.checkNotNullParameter(okCallback, (String)"okCallback");
        super(true);
        this.helpComponent = helpComponent;
        this.tryRunComponent = tryRunComponent;
        this.runParametersHelper = runParametersHelper;
        this.okCallback = okCallback;
        this.helpShowing = new ValueComponentPredicate(true);
        String string = this.runParametersHelper.getWorkingDirectory();
        if (string == null) {
            Path path = this.runParametersHelper.expandedCommandLine().getWorkingDirectory();
            string = path != null ? ((Object)path).toString() : null;
            if (string == null) {
                string = this.workDir = "";
            }
        }
        if ((environmentVariablesData = this.runParametersHelper.getEnv()) == null) {
            environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        }
        this.env = environmentVariablesData;
        this.originalCommandLine = this.runParametersHelper.commandLineText();
        this.centerComponent$delegate = LazyKt.lazy(() -> ArgumentEditorDialog.centerComponent_delegate$lambda$0(this));
        this.init();
    }

    @NotNull
    public final HelpComponent getHelpComponent() {
        return this.helpComponent;
    }

    @NotNull
    public final TryRunComponent getTryRunComponent() {
        return this.tryRunComponent;
    }

    @NotNull
    public final RunParametersHelper getRunParametersHelper() {
        return this.runParametersHelper;
    }

    @NotNull
    public final Function2<String, String, Unit> getOkCallback() {
        return this.okCallback;
    }

    private final OnePixelSplitter getCenterComponent() {
        Lazy lazy = this.centerComponent$delegate;
        return (OnePixelSplitter)lazy.getValue();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.putValue("Name", CLionExecutionBundle.message("debug.targets.edit.save.changes", new Object[0]));
        this.myOKAction.setEnabled(false);
    }

    protected void doOKAction() {
        Pair<String, String> pair = this.getExeAndParams();
        String exePath = (String)pair.component1();
        String parameters = (String)pair.component2();
        this.okCallback.invoke((Object)exePath, (Object)parameters);
        this.close(0);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)this.getCenterComponent();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    @NotNull
    public Dimension getInitialSize() {
        Dimension dimension = super.getInitialSize();
        if (dimension == null) {
            dimension = new Dimension(644, 660);
        }
        return dimension;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JBTextArea jBTextArea = this.commandLineTextComponent;
        if (jBTextArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandLineTextComponent");
            jBTextArea = null;
        }
        return (JComponent)jBTextArea;
    }

    private final Pair<String, String> getExeAndParams() {
        JBTextArea jBTextArea = this.commandLineTextComponent;
        if (jBTextArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandLineTextComponent");
            jBTextArea = null;
        }
        List list2 = ParametersListUtil.parse((String)jBTextArea.getText());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parse(...)");
        List commandLine = list2;
        String string = (String)CollectionsKt.firstOrNull((List)commandLine);
        if (string == null) {
            string = "";
        }
        String exePath = string;
        String string2 = ParametersListUtil.join((List)CollectionsKt.drop((Iterable)commandLine, (int)1));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
        String parameters = string2;
        return TuplesKt.to((Object)exePath, (Object)parameters);
    }

    private final void executeTestRun() {
        Pair<String, String> pair = this.getExeAndParams();
        String exePath = (String)pair.component1();
        String parameters = (String)pair.component2();
        RunParametersHelper paramsHelper = RunParametersHelper.clone$default(this.runParametersHelper, null, exePath, parameters, null, null, 25, null);
        this.tryRunComponent.testRun(paramsHelper);
    }

    private final void switchToHelp() {
        this.setTitle(CLionExecutionBundle.message("debug.targets.edit.title.gdbserver.help", new Object[0]));
        JLabel jLabel = this.outputLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputLabel");
            jLabel = null;
        }
        jLabel.setText(CLionExecutionBundle.message("debug.targets.edit.group.help", new Object[0]));
        Placeholder placeholder = this.outputPlaceholder;
        if (placeholder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputPlaceholder");
            placeholder = null;
        }
        placeholder.setComponent(this.helpComponent.getComponent());
        this.helpShowing.set(true);
    }

    private final void switchToTest() {
        this.setTitle(CLionExecutionBundle.message("debug.targets.edit.title.validate.gdbserver", new Object[0]));
        JLabel jLabel = this.outputLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputLabel");
            jLabel = null;
        }
        jLabel.setText(CLionExecutionBundle.message("debug.targets.edit.output.label", new Object[0]));
        Placeholder placeholder = this.outputPlaceholder;
        if (placeholder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputPlaceholder");
            placeholder = null;
        }
        placeholder.setComponent(this.tryRunComponent.getComponent());
        this.helpShowing.set(false);
    }

    @RequiresEdt
    public final void showHelp() {
        this.helpComponent.gatherHelpIfNeeded();
        this.switchToHelp();
        this.show();
    }

    @RequiresEdt
    public final void showTestRun() {
        this.executeTestRun();
        this.switchToTest();
        this.show();
    }

    private static final OnePixelSplitter centerComponent_delegate$lambda$0(ArgumentEditorDialog this$0) {
        OnePixelSplitter onePixelSplitter;
        OnePixelSplitter $this$centerComponent_delegate_u24lambda_u240_u240 = onePixelSplitter = new OnePixelSplitter(true, PROPORTION_KEY, 0.25f);
        boolean bl = false;
        $this$centerComponent_delegate_u24lambda_u240_u240.getDivider().setBackground(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
        $this$centerComponent_delegate_u24lambda_u240_u240.setFirstComponent((JComponent)BuilderKt.panel(arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0(this$0, arg_0)));
        $this$centerComponent_delegate_u24lambda_u240_u240.setSecondComponent((JComponent)BuilderKt.panel(arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$1(this$0, arg_0)));
        return onePixelSplitter;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$0(ArgumentEditorDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Ref.ObjectRef commandLineLabel = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$0(commandLineLabel, this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$1(this$0, commandLineLabel, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$0$0(Ref.ObjectRef $commandLineLabel, ArgumentEditorDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CLionExecutionBundle.message("debug.targets.edit.label.command.line", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $commandLineLabel.element = $this$row.label(string).getComponent();
        String string2 = CLionExecutionBundle.message("debug.targets.edit.insert.macro", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String macroText = string2;
        String string3 = CLionExecutionBundle.message("debug.targets.edit.insert.file.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String filePathText = string3;
        Object[] objectArray = new String[]{macroText, filePathText};
        DropDownLink dropDownLink = new DropDownLink((Object)CLionExecutionBundle.message("debug.targets.edit.insert.link.text", new Object[0]), CollectionsKt.listOf((Object[])objectArray), arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$0$0(macroText, this$0, filePathText, arg_0));
        $this$row.cell((JComponent)dropDownLink).align((Align)AlignX.RIGHT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final void centerComponent_delegate$lambda$0$0$0$0$0(String $macroText, ArgumentEditorDialog this$0, String $filePathText, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it;
        if (Intrinsics.areEqual((Object)string, (Object)$macroText)) {
            JBTextArea jBTextArea = this$0.commandLineTextComponent;
            if (jBTextArea == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commandLineTextComponent");
                jBTextArea = null;
            }
            MacrosDialog.show((JTextComponent)((JTextComponent)jBTextArea), arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$0$0$0(DebugTargetMacroSupportKt.getDEBUG_TARGET_MACRO_FILTER(), arg_0), null);
        } else if (Intrinsics.areEqual((Object)string, (Object)$filePathText)) {
            FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.singleFileOrDir();
            Project project = this$0.runParametersHelper.getProject();
            JBTextArea jBTextArea = this$0.commandLineTextComponent;
            if (jBTextArea == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commandLineTextComponent");
                jBTextArea = null;
            }
            FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)project, (Component)((Component)jBTextArea), null, arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$0$0$2(arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$0$0$1(this$0, arg_0), arg_0));
        }
    }

    private static final boolean centerComponent_delegate$lambda$0$0$0$0$0$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit centerComponent_delegate$lambda$0$0$0$0$0$1(ArgumentEditorDialog this$0, VirtualFile file) {
        JBTextArea jBTextArea = this$0.commandLineTextComponent;
        if (jBTextArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandLineTextComponent");
            jBTextArea = null;
        }
        jBTextArea.replaceSelection(ParametersListUtil.escape((CharSequence)file.getPath()));
        return Unit.INSTANCE;
    }

    private static final void centerComponent_delegate$lambda$0$0$0$0$0$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit centerComponent_delegate$lambda$0$0$0$1(ArgumentEditorDialog this$0, Ref.ObjectRef $commandLineLabel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.textArea().align(Align.FILL).resizableColumn().applyToComponent(arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$1$0(this$0, $commandLineLabel, arg_0));
        $this$row.resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$0$1$0(ArgumentEditorDialog this$0, Ref.ObjectRef $commandLineLabel, JBTextArea $this$applyToComponent) {
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.commandLineTextComponent = $this$applyToComponent;
        this$0.helpComponent.setArgumentsEditor((JTextComponent)$this$applyToComponent);
        if ($commandLineLabel.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandLineLabel");
            jLabel = null;
        } else {
            jLabel = (JLabel)$commandLineLabel.element;
        }
        jLabel.setLabelFor((Component)$this$applyToComponent);
        $this$applyToComponent.setText(this$0.originalCommandLine);
        $this$applyToComponent.setLineWrap(true);
        $this$applyToComponent.setFocusTraversalKeys(0, null);
        $this$applyToComponent.setFocusTraversalKeys(1, null);
        ListenerUiUtil.whenTextChangedFromUi((JTextComponent)((JTextComponent)$this$applyToComponent), (Disposable)this$0.getDisposable(), arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$1$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$0$1$0$0(ArgumentEditorDialog this$0, String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Pair<String, String> pair = this$0.getExeAndParams();
        String newExe = (String)pair.component1();
        String newArgs = (String)pair.component2();
        HelpComponent helpComponent = this$0.helpComponent;
        String string = this$0.workDir;
        EnvironmentVariablesData environmentVariablesData = this$0.env;
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"env");
        helpComponent.notifyExecutableChanged(newExe, string, environmentVariablesData);
        this$0.getOKAction().setEnabled(!Intrinsics.areEqual((Object)newText, (Object)this$0.originalCommandLine));
        return Unit.INSTANCE;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$0$2(ArgumentEditorDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$2$0(this$0, arg_0));
        $this$row.bottomGap(BottomGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$0$2$0(ArgumentEditorDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.align((Align)AlignX.RIGHT.INSTANCE);
        $this$panel.resizableColumn();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$2$0$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$0$2$0$0(ArgumentEditorDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CLionExecutionBundle.message("debug.targets.edit.get.help.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.button(string, arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$2$0$0$0(this$0, arg_0));
        String string2 = CLionExecutionBundle.message("debug.targets.edit.button.test.run", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.button(string2, arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$0$2$0$0$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$0$2$0$0$0(ArgumentEditorDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.helpComponent.gatherHelpIfNeeded();
        this$0.switchToHelp();
        return Unit.INSTANCE;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$0$2$0$0$1(ArgumentEditorDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.executeTestRun();
        this$0.switchToTest();
        return Unit.INSTANCE;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$1(ArgumentEditorDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$1$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ArgumentEditorDialog.centerComponent_delegate$lambda$0$0$1$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$1$0(ArgumentEditorDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.topGap(TopGap.SMALL);
        String string = CLionExecutionBundle.message("debug.targets.edit.group.help", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.outputLabel = (JLabel)$this$row.label(string).getComponent();
        String string2 = CLionExecutionBundle.message("debug.targets.edit.group.help.comment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string2, (int)0, null, (int)6, null).align((Align)AlignX.RIGHT.INSTANCE).visibleIf((ComponentPredicate)this$0.helpShowing);
        return Unit.INSTANCE;
    }

    private static final Unit centerComponent_delegate$lambda$0$0$1$1(ArgumentEditorDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.outputPlaceholder = $this$row.placeholder().align(Align.FILL).resizableColumn();
        $this$row.resizableRow();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/ArgumentEditorDialog$Companion;", "", "<init>", "()V", "DIMENSION_KEY", "", "PROPORTION_KEY", "intellij.clion.execution"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

