/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.HorizontalLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class RadioButtonPanel<T>
extends JBPanel {
    protected final T @NotNull [] myValues;
    protected final AbstractButton @NotNull [] myButtons;
    @NotNull
    protected final ButtonGroup myGroup;
    private int mySelectedIndex;
    @NotNull
    private final List<ChangeListener> myChangeListener;

    public RadioButtonPanel(T @NotNull [] values, LayoutManager layoutManager) {
        if (values == null) {
            RadioButtonPanel.$$$reportNull$$$0(0);
        }
        super(layoutManager);
        this.myChangeListener = new ArrayList<ChangeListener>();
        this.myValues = values;
        this.myGroup = new ButtonGroup();
        this.myButtons = new AbstractButton[values.length];
        int i = 0;
        while (i < values.length) {
            String text = StringUtil.capitalize((String)Objects.toString(values[i], "-"));
            JRadioButton button = new JRadioButton(text);
            button.setIconTextGap(6);
            this.myButtons[i] = button;
            this.add(button);
            this.myGroup.add(button);
            int index = i++;
            button.addChangeListener(e -> {
                if (button.isSelected()) {
                    this.mySelectedIndex = index;
                }
                this.myChangeListener.forEach(listener -> listener.stateChanged(e));
            });
        }
        this.myButtons[0].setSelected(true);
    }

    public RadioButtonPanel(T @NotNull [] values) {
        if (values == null) {
            RadioButtonPanel.$$$reportNull$$$0(1);
        }
        this(values, (LayoutManager)new HorizontalLayout(16));
    }

    @NotNull
    public T getSelectedValue() {
        T t = this.myValues[this.mySelectedIndex];
        if (t == null) {
            RadioButtonPanel.$$$reportNull$$$0(2);
        }
        return t;
    }

    public void setSelectedValue(@NotNull T value) {
        if (value == null) {
            RadioButtonPanel.$$$reportNull$$$0(3);
        }
        int index = -1;
        for (int i = 0; i < this.myValues.length && index < 0; ++i) {
            if (!Objects.equals(value, this.myValues[i])) continue;
            index = i;
        }
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (this.mySelectedIndex != index) {
            this.myButtons[index].setSelected(true);
            this.mySelectedIndex = index;
        }
    }

    public void addChangeListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            RadioButtonPanel.$$$reportNull$$$0(4);
        }
        this.myChangeListener.add(listener);
    }

    public void removeChangeListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            RadioButtonPanel.$$$reportNull$$$0(5);
        }
        this.myChangeListener.remove(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/gdbserver/RadioButtonPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/RadioButtonPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

