/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coredump;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.coredump.CidrCoreDumpDebugParameters;
import com.jetbrains.cidr.cpp.execution.coredump.CidrCoreDumpRunConfigurationEditor;
import com.jetbrains.cidr.cpp.execution.coredump.CidrCoreDumpRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.coredump.CoreDumpLauncher;
import com.jetbrains.cidr.cpp.execution.debugger.CLionDebuggerKind;
import com.jetbrains.cidr.cpp.execution.remote.DebuggerData;
import com.jetbrains.cidr.cpp.execution.remote.PathMappingsComponentKt;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.CidrRunProfile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coredump/CidrCoreDumpRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "Lcom/jetbrains/cidr/execution/CidrRunProfile;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "debuggerData", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerData;", "getDebuggerData", "()Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerData;", "setDebuggerData", "(Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerData;)V", "params", "Lcom/jetbrains/cidr/cpp/execution/coredump/CidrCoreDumpDebugParameters;", "getParams", "()Lcom/jetbrains/cidr/cpp/execution/coredump/CidrCoreDumpDebugParameters;", "setParams", "(Lcom/jetbrains/cidr/cpp/execution/coredump/CidrCoreDumpDebugParameters;)V", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "checkConfiguration", "", "getState", "Lcom/intellij/execution/configurations/CommandLineState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "writeExternal", "element", "Lorg/jdom/Element;", "readExternal", "suggestedName", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nCidrCoreDumpRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrCoreDumpRunConfiguration.kt\ncom/jetbrains/cidr/cpp/execution/coredump/CidrCoreDumpRunConfiguration\n+ 2 runConfigurationType.kt\ncom/intellij/execution/configurations/RunConfigurationTypeKt\n*L\n1#1,157:1\n26#2:158\n*S KotlinDebug\n*F\n+ 1 CidrCoreDumpRunConfiguration.kt\ncom/jetbrains/cidr/cpp/execution/coredump/CidrCoreDumpRunConfiguration\n*L\n64#1:158\n*E\n"})
public final class CidrCoreDumpRunConfiguration
extends LocatableConfigurationBase<CidrCoreDumpRunConfiguration>
implements RunConfigurationWithSuppressedDefaultRunAction,
CidrRunProfile {
    @NotNull
    private DebuggerData debuggerData;
    @NotNull
    private CidrCoreDumpDebugParameters params;

    public CidrCoreDumpRunConfiguration(@NotNull Project project, @Nullable String name, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(project, factory, name);
        this.debuggerData = new DebuggerData(SystemInfo.isWindows ? (CLionDebuggerKind.Bundled)CLionDebuggerKind.Bundled.LLDB.INSTANCE : CLionDebuggerKind.Bundled.Companion.defaultForOS$default(CLionDebuggerKind.Bundled.Companion, null, 1, null));
        this.params = new CidrCoreDumpDebugParameters(null, null, null, null, 15, null);
    }

    public /* synthetic */ CidrCoreDumpRunConfiguration(Project project, String string, ConfigurationFactory configurationFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            boolean $i$f$runConfigurationType = false;
            configurationFactory = (ConfigurationFactory)ConfigurationTypeUtil.findConfigurationType(CidrCoreDumpRunConfigurationType.class);
        }
        this(project, string, configurationFactory);
    }

    @NotNull
    public final DebuggerData getDebuggerData() {
        return this.debuggerData;
    }

    public final void setDebuggerData(@NotNull DebuggerData debuggerData) {
        Intrinsics.checkNotNullParameter((Object)debuggerData, (String)"<set-?>");
        this.debuggerData = debuggerData;
    }

    @NotNull
    public final CidrCoreDumpDebugParameters getParams() {
        return this.params;
    }

    public final void setParams(@NotNull CidrCoreDumpDebugParameters cidrCoreDumpDebugParameters) {
        Intrinsics.checkNotNullParameter((Object)cidrCoreDumpDebugParameters, (String)"<set-?>");
        this.params = cidrCoreDumpDebugParameters;
    }

    @NotNull
    public SettingsEditor<CidrCoreDumpRunConfiguration> getConfigurationEditor() {
        return new CidrCoreDumpRunConfigurationEditor();
    }

    public void checkConfiguration() {
        CLionDebuggerKind kind = this.debuggerData.getKind();
        if (kind instanceof CLionDebuggerKind.Custom.AdHocSpecified && StringsKt.isBlank((CharSequence)((CLionDebuggerKind.Custom.AdHocSpecified)kind).getPath())) {
            throw new RuntimeConfigurationError(CLionExecutionBundle.message("gdbRemote.debuggerNotSpecified", new Object[0]));
        }
        String coreDump = this.params.getCoreDump();
        if (StringsKt.isBlank((CharSequence)coreDump)) {
            throw new RuntimeConfigurationError(CLionExecutionBundle.message("coredump.coredump.missing", new Object[0]));
        }
        if (!new File(coreDump).exists()) {
            Object[] objectArray = new Object[]{coreDump};
            throw new RuntimeConfigurationError(CLionExecutionBundle.message("coredump.coredump.invalid", objectArray));
        }
        String symbolFile = this.params.getCoreDump();
        if (this.debuggerData.isGDB() && StringsKt.isBlank((CharSequence)symbolFile)) {
            throw new RuntimeConfigurationError(CLionExecutionBundle.message("coredump.symbolFile.missing", new Object[0]));
        }
        if (this.debuggerData.isGDB() && !new File(symbolFile).exists()) {
            Object[] objectArray = new Object[]{symbolFile};
            throw new RuntimeConfigurationWarning(CLionExecutionBundle.message("coredump.symbolFile.invalid", objectArray));
        }
    }

    @NotNull
    public CommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        CPPToolchains.Toolchain debuggerToolchain = this.debuggerData.getOrCreateDebuggerToolchain();
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CoreDumpLauncher launcher = new CoreDumpLauncher(project, this.params, debuggerToolchain);
        return (CommandLineState)new CidrCommandLineState(environment, (CidrLauncher)launcher);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        this.debuggerData.writeExternal(element);
        element.setAttribute("coreDump", FileUtil.toSystemIndependentName((String)this.params.getCoreDump()));
        element.setAttribute("symbolFile", FileUtil.toSystemIndependentName((String)this.params.getSymbolFile()));
        element.setAttribute("sysroot", FileUtil.toSystemIndependentName((String)this.params.getSysroot()));
        PathMappingsComponentKt.save((Element)element, this.params.getPathMappings());
    }

    public void readExternal(@NotNull Element element) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        this.debuggerData.readExternal(element);
        String string3 = element.getAttributeValue("coreDump");
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = element.getAttributeValue("symbolFile")) == null) {
            string2 = "";
        }
        if ((string = element.getAttributeValue("sysroot")) == null) {
            string = "";
        }
        this.params = new CidrCoreDumpDebugParameters(string3, string2, string, PathMappingsComponentKt.load((Element)element));
    }

    @NotNull
    public String suggestedName() {
        String string = FileUtil.toSystemIndependentName((String)this.params.getCoreDump());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String coreDumpFileName = StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null);
        return coreDumpFileName.length() < 30 ? coreDumpFileName : StringsKt.take((String)coreDumpFileName, (int)30) + "...";
    }
}

