/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.grazie.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spellchecker.DictionaryLayer;
import com.intellij.spellchecker.quickfixes.SaveTo;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.spellChecker.layers.BackendDictionaryLayer;
import icons.SpellcheckerIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J$\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/plugins/appender/grazie/quickfix/SaveToExactLayerIntentionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "typo", "", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "layer", "Lcom/jetbrains/rider/spellChecker/layers/BackendDictionaryLayer;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/rider/spellChecker/layers/BackendDictionaryLayer;)V", "startInWriteAction", "", "getFamilyName", "getText", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "intellij.rider.appender.grazie"})
public final class SaveToExactLayerIntentionAction
implements IntentionAction,
Iconable,
PriorityAction {
    @NotNull
    private final String typo;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> pointer;
    @NotNull
    private final TextRange range;
    @NotNull
    private final BackendDictionaryLayer layer;

    public SaveToExactLayerIntentionAction(@NotNull String typo, @NotNull SmartPsiElementPointer<PsiElement> pointer, @NotNull TextRange range, @NotNull BackendDictionaryLayer layer) {
        Intrinsics.checkNotNullParameter((Object)typo, (String)"typo");
        Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.typo = typo;
        this.pointer = pointer;
        this.range = range;
        this.layer = layer;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return RiderBundle.message((String)"spellchecker.save.to.dictionary", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.layer.getName();
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || psiFile == null) {
            return;
        }
        Segment segment = this.pointer.getRange();
        if (segment == null) {
            return;
        }
        Segment elementRange = segment;
        SaveTo.applyFix((Project)project, (PsiFile)psiFile, (TextRange)this.range.shiftRight(elementRange.getStartOffset()), (String)this.typo, (DictionaryLayer)((DictionaryLayer)this.layer));
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = SpellcheckerIcons.Spellcheck;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Spellcheck");
        return icon;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.TOP;
    }
}

