/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.MappedHost;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\r\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/system/RemoteFSCacheInvalidator;", "Lcom/intellij/ide/caches/CachesInvalidator;", "<init>", "()V", "invalidateCaches", "", "getDescription", "", "getComment", "optionalCheckboxDefaultValue", "", "()Ljava/lang/Boolean;", "intellij.clion.toolchains"})
public final class RemoteFSCacheInvalidator
extends CachesInvalidator {
    public void invalidateCaches() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project : projectArray) {
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            for (CidrWorkspace workspace : CidrWorkspace.Companion.getInitializedWorkspaces(project2)) {
                if (!(workspace instanceof WorkspaceWithEnvironment)) continue;
                for (CidrToolEnvironment environment : ((WorkspaceWithEnvironment)workspace).getEnvironment()) {
                    HostMachine host = environment.getHostMachine();
                    if (!(host instanceof MappedHost)) continue;
                    ((MappedHost)host).markCacheInvalid();
                }
            }
        }
    }

    @NotNull
    public String getDescription() {
        String string = ToolchainsBundle.message("remote.fs.cache.invalidator.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getComment() {
        String string = ToolchainsBundle.message("remote.fs.cache.invalidator.comment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Boolean optionalCheckboxDefaultValue() {
        return false;
    }
}

