/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.util.CidrFileUtilKt;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/system/CidrHasher;", "", "<init>", "()V", "myHashes", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "", "getHash", "path", "Companion", "intellij.clion.toolchains"})
@SourceDebugExtension(value={"SMAP\nCidrHasher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrHasher.kt\ncom/jetbrains/cidr/system/CidrHasher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n13#2:62\n*S KotlinDebug\n*F\n+ 1 CidrHasher.kt\ncom/jetbrains/cidr/system/CidrHasher\n*L\n23#1:62\n*E\n"})
public final class CidrHasher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<Path, String> myHashes = new ConcurrentHashMap();
    @JvmField
    @NotNull
    public static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final String getHash(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String computed = this.myHashes.get(path);
        if (computed != null) {
            return computed;
        }
        CidrHasher cidrHasher = this;
        synchronized (cidrHasher) {
            boolean bl = false;
            String string = this.myHashes.get(path);
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                return it;
            }
            try {
                long t0 = System.currentTimeMillis();
                String hash = CidrFileUtilKt.computeHash((Path)path);
                ((Map)this.myHashes).put(path, hash);
                LOG.debug("Computed hash for " + path + " in " + (System.currentTimeMillis() - t0) + " ms");
                return hash;
            }
            catch (IOException e) {
                LOG.warn("Failed to compute hash for " + path, (Throwable)e);
                return null;
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final CidrHasher getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CidrHasher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/system/CidrHasher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/cidr/system/CidrHasher;", "intellij.clion.toolchains"})
    @SourceDebugExtension(value={"SMAP\nCidrHasher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrHasher.kt\ncom/jetbrains/cidr/system/CidrHasher$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,61:1\n42#2,3:62\n*S KotlinDebug\n*F\n+ 1 CidrHasher.kt\ncom/jetbrains/cidr/system/CidrHasher$Companion\n*L\n26#1:62,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CidrHasher getInstance() {
            boolean $i$f$service = false;
            Class<CidrHasher> serviceClass$iv = CidrHasher.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CidrHasher)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

