/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.msvc;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.sun.jna.platform.win32.WinReg;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
public final class WinAPIConsoleCPReader {
    private static final Logger LOG = Logger.getInstance(WinAPIConsoleCPReader.class);
    private static final NotNullLazyValue<Charset> charset = NotNullLazyValue.atomicLazy(() -> WinAPIConsoleCPReader.retrieveConsoleCharset());
    private static final String CODEPAGE_REG_PATH = "SYSTEM\\CurrentControlSet\\Control\\Nls\\CodePage";
    private static final String OEMCP_REG_KEY = "OEMCP";
    @NotNull
    private static final @NotNull Map<@NotNull String, @NotNull Charset> OEM_TO_JAVA_CP = WinAPIConsoleCPReader.getEncodingsMap();

    @NotNull
    public Charset getConsoleCharset() {
        Charset charset = (Charset)WinAPIConsoleCPReader.charset.getValue();
        if (charset == null) {
            WinAPIConsoleCPReader.$$$reportNull$$$0(0);
        }
        return charset;
    }

    @NotNull
    private static Charset retrieveConsoleCharset() {
        String csCode = CPPToolchainsUtil.getRegistryValue(WinReg.HKEY_LOCAL_MACHINE, CODEPAGE_REG_PATH, OEMCP_REG_KEY);
        if (csCode == null) {
            LOG.warn("Failed to get OEMCP value from registry");
        }
        LOG.debug("Got charset " + csCode + " from jna");
        if (csCode != null) {
            if (OEM_TO_JAVA_CP.containsKey(csCode)) {
                Charset charset = OEM_TO_JAVA_CP.get(csCode);
                if (charset == null) {
                    WinAPIConsoleCPReader.$$$reportNull$$$0(1);
                }
                return charset;
            }
            Map.Entry cs = (Map.Entry)ContainerUtil.find(Charset.availableCharsets().entrySet(), entry -> ((String)entry.getKey()).endsWith(csCode));
            if (cs != null) {
                LOG.debug("Found charset " + ((Charset)cs.getValue()).name());
                Charset charset = (Charset)cs.getValue();
                if (charset == null) {
                    WinAPIConsoleCPReader.$$$reportNull$$$0(2);
                }
                return charset;
            }
            LOG.warn("Charset " + csCode + " is not found");
        }
        LOG.warn("Falling back to default charset");
        Charset charset = CharsetToolkit.getDefaultSystemCharset();
        if (charset == null) {
            WinAPIConsoleCPReader.$$$reportNull$$$0(3);
        }
        return charset;
    }

    @NotNull
    private static @NotNull Map<@NotNull String, @NotNull Charset> getEncodingsMap() {
        List<Pair> asianEncodings = List.of(Pair.pair((Object)"950", (Object)"Big5"), Pair.pair((Object)"936", (Object)"GB2312"), Pair.pair((Object)"949", (Object)"EUC-KR"), Pair.pair((Object)"932", (Object)"Shift_JIS"));
        HashMap<String, Charset> map = new HashMap<String, Charset>();
        map.put("65001", StandardCharsets.UTF_8);
        for (Pair item : asianEncodings) {
            try {
                map.put((String)item.first, Charset.forName((String)item.second));
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
                LOG.warn("Failed to find encoding for pair " + (String)item.first + ":" + (String)item.second, (Throwable)ex);
            }
        }
        HashMap<String, Charset> hashMap = map;
        if (hashMap == null) {
            WinAPIConsoleCPReader.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/cpp/toolchains/msvc/WinAPIConsoleCPReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleCharset";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveConsoleCharset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncodingsMap";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

