/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.msvc;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.cpp.toolchains.msvc.MSVCArch;
import com.jetbrains.cidr.cpp.toolchains.msvc.MSVCArchAndVersion;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSVCCompilerToVersionCacheService;", "", "<init>", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSVCArchAndVersion;", "getCompilerVersion", "exePath", "Companion", "intellij.clion.toolchains"})
@SourceDebugExtension(value={"SMAP\nMSVCCompilerToVersionCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MSVCCompilerToVersionCacheService.kt\ncom/jetbrains/cidr/cpp/toolchains/msvc/MSVCCompilerToVersionCacheService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,62:1\n13#2:63\n*S KotlinDebug\n*F\n+ 1 MSVCCompilerToVersionCacheService.kt\ncom/jetbrains/cidr/cpp/toolchains/msvc/MSVCCompilerToVersionCacheService\n*L\n51#1:63\n*E\n"})
public final class MSVCCompilerToVersionCacheService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<String, MSVCArchAndVersion> cache = new ConcurrentHashMap();
    private static final Pattern msvcToolsFolderPattern = Pattern.compile(".*vc\\\\tools\\\\msvc\\\\(?<version>.*)\\\\bin\\\\(?<host>.*?)(\\\\(?<target>.*))?\\\\cl.exe");
    private static final Pattern customInstallFolderPattern = Pattern.compile(".*bin\\\\(?<host>.*?)(\\\\(?<target>.*))?\\\\cl.exe");

    @Nullable
    public final MSVCArchAndVersion getCompilerVersion(@NotNull String exePath) {
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        MSVCArchAndVersion result = this.cache.computeIfAbsent(exePath, arg_0 -> MSVCCompilerToVersionCacheService.getCompilerVersion$lambda$1(arg_0 -> MSVCCompilerToVersionCacheService.getCompilerVersion$lambda$0(exePath, arg_0), arg_0));
        return result;
    }

    private static final MSVCArchAndVersion getCompilerVersion$lambda$0(String $exePath, String path) {
        String string = $exePath.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowercasePath = string;
        Matcher matcher = msvcToolsFolderPattern.matcher(lowercasePath);
        boolean hasVersion = matcher.find();
        if (!hasVersion) {
            matcher = customInstallFolderPattern.matcher(lowercasePath);
        }
        if (hasVersion || matcher.find()) {
            try {
                String host;
                String version = hasVersion ? matcher.group("version") : null;
                String string2 = matcher.group("host");
                String string3 = host = string2 != null ? StringsKt.replace$default((String)string2, (String)"host", (String)"", (boolean)false, (int)4, null) : null;
                if (host == null) {
                    throw new IllegalArgumentException();
                }
                String target = matcher.group("target");
                MSVCArch arch = MSVCArch.Companion.fromString((String)(Intrinsics.areEqual((Object)host, (Object)target) ? host : host + "_" + target));
                return new MSVCArchAndVersion(arch, version);
            }
            catch (IllegalArgumentException version) {
                // empty catch block
            }
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MSVCCompilerToVersionCacheService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Failed to detect compiler arch for " + path);
        return null;
    }

    private static final MSVCArchAndVersion getCompilerVersion$lambda$1(Function1 $tmp0, Object p0) {
        return (MSVCArchAndVersion)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSVCCompilerToVersionCacheService$Companion;", "", "<init>", "()V", "msvcToolsFolderPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "customInstallFolderPattern", "intellij.clion.toolchains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

