/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.msvc;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ShellEnvironmentReader;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.util.CPPPropertiesProvider;
import com.jetbrains.cidr.cpp.util.concurrent.CPPSharedLazyComputation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J@\u0010\u001f\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0014j\u0002`\u00150\u0013j\u0002`\u00162\u0006\u0010 \u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J@\u0010!\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0014j\u0002`\u00150\u0013j\u0002`\u00162\u0006\u0010 \u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J0\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H&0$\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010&*\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H&0'H\u0002J%\u0010(\u001a\f\u0012\u0004\u0012\u00020\u000b0\u0011j\u0002`\u0012*\u00020\u001b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0082\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r8\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eRB\u0010\u000f\u001a6\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\u0011j\u0002`\u0012\u0012\"\u0012 \u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0014j\u0002`\u0015\u0018\u00010\u0013j\u0004\u0018\u0001`\u00160\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/msvc/CLionMsvcEnvCache;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "DEFAULT_ENV_READER_TIMEOUT_MILLIS", "", "DEFAULT_FORGET_ENVIRONMENT_ON_FOCUS_LOSS", "", "VCVARSALL_BAT", "", "ERROR_PATTERNS", "", "[Ljava/lang/String;", "environmentCache", "", "", "Lcom/jetbrains/cidr/cpp/toolchains/msvc/VcvarsallWithArgs;", "Lkotlin/Function0;", "", "Lcom/jetbrains/cidr/cpp/toolchains/msvc/Environment;", "Lcom/jetbrains/cidr/cpp/toolchains/msvc/LazyEnvironment;", "isListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getEnvironment", "toolsetHome", "Ljava/nio/file/Path;", "args", "propertiesProvider", "Lcom/jetbrains/cidr/cpp/util/CPPPropertiesProvider;", "getCachedLazyEnvironment", "vcvarsall", "getLazyEnvironment", "getVcvarsall", "toPair", "Lkotlin/Pair;", "A", "B", "Lcom/intellij/openapi/util/Pair;", "plus", "elements", "intellij.clion.toolchains"})
@SourceDebugExtension(value={"SMAP\nCLionMsvcEnvCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionMsvcEnvCache.kt\ncom/jetbrains/cidr/cpp/toolchains/msvc/CLionMsvcEnvCache\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,202:1\n183#2,2:203\n1#3:205\n29#4,3:206\n12970#5,2:209\n1878#6,3:211\n13#7:214\n*S KotlinDebug\n*F\n+ 1 CLionMsvcEnvCache.kt\ncom/jetbrains/cidr/cpp/toolchains/msvc/CLionMsvcEnvCache\n*L\n179#1:203,2\n107#1:206,3\n152#1:209,2\n159#1:211,3\n23#1:214\n*E\n"})
public final class CLionMsvcEnvCache {
    @NotNull
    public static final CLionMsvcEnvCache INSTANCE = new CLionMsvcEnvCache();
    @NotNull
    private static final Logger LOGGER;
    private static final int DEFAULT_ENV_READER_TIMEOUT_MILLIS = 40000;
    private static final boolean DEFAULT_FORGET_ENVIRONMENT_ON_FOCUS_LOSS = true;
    @NonNls
    @NotNull
    private static final String VCVARSALL_BAT = "vcvarsall.bat";
    @NonNls
    @NotNull
    private static final String[] ERROR_PATTERNS;
    @NotNull
    private static final Map<List<String>, Function0<Map<String, String>>> environmentCache;
    @NotNull
    private static final AtomicBoolean isListenerAdded;

    private CLionMsvcEnvCache() {
    }

    @JvmStatic
    @RequiresBackgroundThread
    @NotNull
    public static final Map<String, String> getEnvironment(@NotNull Path toolsetHome, @NotNull List<String> args, @NotNull CPPPropertiesProvider propertiesProvider) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)toolsetHome, (String)"toolsetHome");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)propertiesProvider, (String)"propertiesProvider");
        Function0<Map<String, String>> cachedLazyEnvironment = INSTANCE.getCachedLazyEnvironment(INSTANCE.getVcvarsall(toolsetHome), args, propertiesProvider);
        return (Map)cachedLazyEnvironment.invoke();
    }

    private final Function0<Map<String, String>> getCachedLazyEnvironment(Path vcvarsall, List<String> args, CPPPropertiesProvider propertiesProvider) {
        Application application = ApplicationManager.getApplication();
        if (application != null && !isListenerAdded.getAndSet(true)) {
            MessageBusConnection messageBusConnection = application.getMessageBus().connect();
            Topic topic = ApplicationActivationListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new ApplicationActivationListener(propertiesProvider){
                final /* synthetic */ CPPPropertiesProvider $propertiesProvider;
                {
                    this.$propertiesProvider = $propertiesProvider;
                }

                public void applicationDeactivated(IdeFrame ideFrame) {
                    Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
                    boolean forgetEnvironmentOnFocusLoss = this.$propertiesProvider.is("clion.msvc.vcvarsall.forget.environment.on.focus.loss", true);
                    if (forgetEnvironmentOnFocusLoss) {
                        int environmentCacheSize = CLionMsvcEnvCache.access$getEnvironmentCache$p().size();
                        CLionMsvcEnvCache.access$getEnvironmentCache$p().clear();
                        if (environmentCacheSize != 0) {
                            CLionMsvcEnvCache.access$getLOGGER$p().info("Window focus lost; vcvarsall.bat environment cache (" + environmentCacheSize + " entries) cleared.");
                        }
                    }
                }
            });
        }
        Function0<Map<String, String>> lazyEnvironment = CPPSharedLazyComputation.shared(this.getLazyEnvironment(vcvarsall, args, propertiesProvider));
        List<String> vcvarsallWithArgs = this.plus(vcvarsall, args);
        Function0<Map<String, String>> function0 = environmentCache.computeIfAbsent(vcvarsallWithArgs, arg_0 -> CLionMsvcEnvCache.getCachedLazyEnvironment$lambda$1(arg_0 -> CLionMsvcEnvCache.getCachedLazyEnvironment$lambda$0(application, lazyEnvironment, arg_0), arg_0));
        if (function0 == null) {
            function0 = lazyEnvironment;
        }
        return function0;
    }

    private final Function0<Map<String, String>> getLazyEnvironment(Path vcvarsall, List<String> args, CPPPropertiesProvider propertiesProvider) {
        return () -> CLionMsvcEnvCache.getLazyEnvironment$lambda$0(vcvarsall, args, propertiesProvider);
    }

    private final Path getVcvarsall(Path toolsetHome) throws ExecutionException {
        Path path;
        block5: {
            block4: {
                Object v0;
                Object object;
                block3: {
                    object = new Path[]{toolsetHome.resolve("VC").resolve(VCVARSALL_BAT), toolsetHome.resolve("VC").resolve("Auxiliary").resolve("Build").resolve(VCVARSALL_BAT)};
                    Sequence $this$firstOrNull$iv = SequencesKt.sequenceOf((Object[])object);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Path p0 = (Path)element$iv;
                        boolean bl = false;
                        if (!Files.isRegularFile(p0, new LinkOption[0])) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                Path path2 = v0;
                if (path2 == null) break block4;
                Path p0 = path2;
                boolean bl = false;
                object = p0.toAbsolutePath();
                if (object == null) break block4;
                Object p02 = object;
                boolean bl2 = false;
                path = p02.normalize();
                if (path != null) break block5;
            }
            Object[] objectArray = new Object[]{toolsetHome};
            throw new ExecutionException(ToolchainsBundle.message("msvc.error.cannot.locate.vcvarsall.bat", objectArray));
        }
        return path;
    }

    private final <A, B> kotlin.Pair<A, B> toPair(Pair<A, B> $this$toPair) {
        return TuplesKt.to((Object)$this$toPair.first, (Object)$this$toPair.second);
    }

    private final List<String> plus(Path $this$plus, List<String> elements) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        if (elements.isEmpty()) {
            list = CollectionsKt.listOf((Object)((Object)$this$plus).toString());
        } else {
            ArrayList arrayList;
            ArrayList $this$plus_u24lambda_u240 = arrayList = new ArrayList(elements.size() + 1);
            boolean bl = false;
            ((Collection)$this$plus_u24lambda_u240).add(((Object)$this$plus).toString());
            CollectionsKt.addAll((Collection)$this$plus_u24lambda_u240, (Iterable)elements);
            list = arrayList;
        }
        return list;
    }

    private static final Function0 getCachedLazyEnvironment$lambda$0(Application $application, Function0 $lazyEnvironment, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $application != null ? $lazyEnvironment : null;
    }

    private static final Function0 getCachedLazyEnvironment$lambda$1(Function1 $tmp0, Object p0) {
        return (Function0)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getLazyEnvironment$lambda$0(Path $vcvarsall, List $args, CPPPropertiesProvider $propertiesProvider) {
        Map map;
        List<String> vcvarsallWithArgs = INSTANCE.plus($vcvarsall, $args);
        try {
            boolean bl;
            String output;
            Map environment;
            long envReadTimeMillis;
            String vcvarsallWithArgsStringified;
            block6: {
                long timeoutMillis = $propertiesProvider.intValue("clion.msvc.vcvarsall.timeout", 40000);
                vcvarsallWithArgsStringified = CollectionsKt.joinToString$default((Iterable)vcvarsallWithArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                LOGGER.info("About to run \"" + vcvarsallWithArgsStringified + "\" with a time-out of " + timeoutMillis + " ms...");
                kotlin.Pair outputAndEnv = null;
                boolean $i$f$measureTimeMillis = false;
                long start$iv = System.currentTimeMillis();
                boolean bl2 = false;
                ProcessBuilder processBuilder = ShellEnvironmentReader.winShellCommand((Path)$vcvarsall, (List)$args);
                Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"winShellCommand(...)");
                ProcessBuilder command = processBuilder;
                Map<String, String> processEnvironment2 = command.environment();
                int n = 0;
                processEnvironment2.remove("_JAVA_OPTIONS");
                Intrinsics.checkNotNull(processEnvironment2);
                processEnvironment2.put("VSCMD_SKIP_SENDTELEMETRY", "1");
                processEnvironment2.put("VSCMD_DEBUG", LOGGER.isTraceEnabled() ? "3" : (LOGGER.isDebugEnabled() ? "2" : ""));
                processEnvironment2.put("__VSCMD_ARG_NO_LOGO", LOGGER.isDebugEnabled() ? "" : "1");
                Pair pair = ShellEnvironmentReader.readEnvironment((ProcessBuilder)command, (long)timeoutMillis);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"readEnvironment(...)");
                outputAndEnv = INSTANCE.toPair(pair);
                envReadTimeMillis = System.currentTimeMillis() - start$iv;
                kotlin.Pair pair2 = outputAndEnv;
                environment = (Map)pair2.component1();
                output = (String)pair2.component2();
                String[] $this$any$iv = ERROR_PATTERNS;
                boolean $i$f$any = false;
                n = $this$any$iv.length;
                for (int processEnvironment2 = 0; processEnvironment2 < n; ++processEnvironment2) {
                    String element$iv;
                    String errorPattern = element$iv = $this$any$iv[processEnvironment2];
                    boolean bl3 = false;
                    if (!StringsKt.contains$default((CharSequence)output, (CharSequence)errorPattern, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                throw new IOException(output);
            }
            LOGGER.info("\"" + vcvarsallWithArgsStringified + "\" completed in " + envReadTimeMillis + " ms.");
            List outputLines = StringsKt.lines((CharSequence)output);
            int outputLinesSize = outputLines.size();
            Iterable $this$forEachIndexed$iv = outputLines;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void line;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n;
                boolean bl4 = false;
                LOGGER.info("[" + (index + 1) + "/" + outputLinesSize + "] " + (String)line);
            }
            map = environment;
        }
        catch (IOException ioe) {
            Object[] objectArray = new Object[]{$vcvarsall, ioe.getMessage()};
            throw new ExecutionException(ToolchainsBundle.message("msvc.error.cannot.load.visual.c.environment", objectArray), (Throwable)ioe);
        }
        return map;
    }

    public static final /* synthetic */ Map access$getEnvironmentCache$p() {
        return environmentCache;
    }

    public static final /* synthetic */ Logger access$getLOGGER$p() {
        return LOGGER;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CLionMsvcEnvCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
        String[] stringArray = new String[]{"Error in script usage", "Invalid argument"};
        ERROR_PATTERNS = stringArray;
        environmentCache = new ConcurrentHashMap();
        isListenerAdded = new AtomicBoolean(false);
    }
}

