/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.text.StringKt;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUIUtils;
import com.jetbrains.cidr.cpp.toolchains.CheckedVersion;
import com.jetbrains.cidr.cpp.ui.UIUtilKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/VersionChecker;", "ItemT", "", "requireNonEmpty", "", "name", "", "<init>", "(ZLjava/lang/String;)V", "getName$intellij_clion_toolchains", "()Ljava/lang/String;", "selectedItem", "getSelectedItem", "()Ljava/lang/Object;", "readAndCheckVersion", "Lcom/jetbrains/cidr/cpp/toolchains/CheckedVersion;", "selectedToolSet", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet;", "(Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet;Ljava/lang/Object;)Lcom/jetbrains/cidr/cpp/toolchains/CheckedVersion;", "check", "render", "", "version", "label", "Lcom/intellij/ui/components/JBLabel;", "intellij.clion.toolchains"})
public abstract class VersionChecker<ItemT> {
    private final boolean requireNonEmpty;
    @NotNull
    private final String name;

    public VersionChecker(boolean requireNonEmpty, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.requireNonEmpty = requireNonEmpty;
        this.name = name;
    }

    @NotNull
    public final String getName$intellij_clion_toolchains() {
        return this.name;
    }

    public abstract ItemT getSelectedItem();

    @Nullable
    public abstract CheckedVersion readAndCheckVersion(@NotNull CPPToolSet var1, ItemT var2);

    @Nullable
    public final CheckedVersion check(@NotNull CPPToolSet selectedToolSet, ItemT selectedItem) {
        Intrinsics.checkNotNullParameter((Object)selectedToolSet, (String)"selectedToolSet");
        if (selectedItem == null && this.requireNonEmpty) {
            return null;
        }
        return this.readAndCheckVersion(selectedToolSet, selectedItem);
    }

    public final void render(@Nullable CheckedVersion version, @NotNull JBLabel label) {
        String string;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"ERROR_ATTRIBUTES");
        SimpleTextAttributes errorAttributes = CPPToolchainsUIUtils.access$smallerTextAttributes(simpleTextAttributes);
        SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"REGULAR_ATTRIBUTES");
        SimpleTextAttributes regularAttributes = CPPToolchainsUIUtils.access$smallerTextAttributes(simpleTextAttributes2);
        HtmlBuilder builder = new HtmlBuilder();
        CheckedVersion checkedVersion = version;
        String rawVersion = StringKt.nullize$default((String)(checkedVersion != null ? checkedVersion.getRawVersion() : null), (boolean)false, (int)1, null);
        if (version == null) {
            label.setIcon(UIUtilKt.getERROR_ICON());
            String string2 = ToolchainsBundle.message("cpp.toolchains.not.specified", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            CPPToolchainsUIUtils.access$append(builder, string2, errorAttributes);
        } else if (version.isDisabled()) {
            label.setIcon(UIUtilKt.getNO_ICON());
        } else if (version.getVersion() == null) {
            label.setIcon(UIUtilKt.getERROR_ICON());
            CPPToolchainsUIUtils.access$append(builder, CPPToolchainsUIUtils.getNotFoundMessage(version.isBundled(), version.isFromToolSet()), errorAttributes);
        } else if (version.isUnknown()) {
            if (version.getShowUnknownVersionWarning()) {
                VersionChecker.render$setVersion(label, builder, regularAttributes, version.getVersion(), UIUtilKt.getWARNING_ICON());
            }
            if (version.getWarning() != null) {
                label.setIcon(UIUtilKt.getWARNING_ICON());
                String warningPrefix = version.getShowUnknownVersionWarning() ? "; " : "";
                CPPToolchainsUIUtils.access$append(builder, warningPrefix + version.getWarning(), regularAttributes);
            }
            label.setToolTipText(rawVersion);
        } else if (version.getWarning() != null) {
            VersionChecker.render$setVersion(label, builder, regularAttributes, version.getVersion(), UIUtilKt.getWARNING_ICON());
            CPPToolchainsUIUtils.access$append(builder, "; " + version.getWarning(), regularAttributes);
            label.setToolTipText(rawVersion);
        } else {
            VersionChecker.render$setVersion(label, builder, regularAttributes, version.getVersion(), (Icon)UIUtilKt.getOK_ICON());
            label.setToolTipText(rawVersion);
        }
        if (builder.isEmpty()) {
            string = "";
        } else {
            String string3 = builder.wrapWith(HtmlChunk.html()).toString();
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        label.setText(string);
    }

    private static final void render$setVersion(JBLabel $label, HtmlBuilder builder, SimpleTextAttributes regularAttributes, String version, Icon icon) {
        $label.setIcon(icon);
        Object[] objectArray = new Object[]{version};
        String string = ToolchainsBundle.message("cpp.toolchains.version", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        CPPToolchainsUIUtils.access$append(builder, string, regularAttributes);
    }
}

