/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.EnvironmentReader;
import com.jetbrains.cidr.cpp.toolchains.HostMachineAwareEnvironmentReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\bH\u0002R>\u0010\u0004\u001a2\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\n0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CachingEnvironmentReaderService;", "", "<init>", "()V", "cache", "", "Lkotlin/Pair;", "Lcom/jetbrains/cidr/cpp/toolchains/EnvironmentReader;", "", "Ljava/nio/file/attribute/FileTime;", "", "readEnvironment", "file", "reader", "parentEnvironment", "invalidate", "", "getModifiedTime", "Companion", "intellij.clion.toolchains"})
public final class CachingEnvironmentReaderService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Pair<EnvironmentReader, String>, Pair<FileTime, Map<String, String>>> cache = new ConcurrentHashMap();
    private static final FileTime INVALID_TS = FileTime.fromMillis(0L);

    @NotNull
    public final Map<String, String> readEnvironment(@NotNull String file, @NotNull EnvironmentReader reader, @NotNull Map<String, String> parentEnvironment) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(parentEnvironment, (String)"parentEnvironment");
        Pair readerToPath = TuplesKt.to((Object)reader, (Object)file);
        FileTime timestamp = this.getModifiedTime(reader, file);
        Pair pair = this.cache.compute((Pair<EnvironmentReader, String>)readerToPath, (arg_0, arg_1) -> CachingEnvironmentReaderService.readEnvironment$lambda$1((arg_0, arg_1) -> CachingEnvironmentReaderService.readEnvironment$lambda$0(timestamp, reader, file, parentEnvironment, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNull((Object)pair);
        return (Map)pair.getSecond();
    }

    public final void invalidate(@NotNull String file, @NotNull EnvironmentReader reader) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.cache.remove(TuplesKt.to((Object)reader, (Object)file));
    }

    private final FileTime getModifiedTime(EnvironmentReader reader, String file) {
        FileTime fileTime;
        if (!AdvancedSettings.Companion.getBoolean("clion.toolchains.enable.environment.file.cache")) {
            FileTime fileTime2 = INVALID_TS;
            Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"INVALID_TS");
            return fileTime2;
        }
        if (reader instanceof HostMachineAwareEnvironmentReader) {
            Path path = ((HostMachineAwareEnvironmentReader)reader).getHostMachine().getPath(file, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
            Path path2 = path;
            FileTime fileTime3 = Files.exists(path2, new LinkOption[0]) ? Files.getLastModifiedTime(path2, new LinkOption[0]) : INVALID_TS;
            Intrinsics.checkNotNull((Object)fileTime3);
            fileTime = fileTime3;
        } else {
            FileTime fileTime4 = INVALID_TS;
            fileTime = fileTime4;
            Intrinsics.checkNotNullExpressionValue((Object)fileTime4, (String)"INVALID_TS");
        }
        return fileTime;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Pair readEnvironment$lambda$0(FileTime $timestamp, EnvironmentReader $reader, String $file, Map $parentEnvironment, Pair pair, Pair value) {
        Pair pair2;
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<unused var>");
        if (!Intrinsics.areEqual((Object)$timestamp, (Object)INVALID_TS)) {
            Pair pair3 = value;
            if (Intrinsics.areEqual((Object)(pair3 != null ? (FileTime)pair3.getFirst() : null), (Object)$timestamp)) {
                pair2 = value;
                return pair2;
            }
        }
        pair2 = TuplesKt.to((Object)$timestamp, $reader.readEnvironmentFile($file, $parentEnvironment));
        return pair2;
    }

    private static final Pair readEnvironment$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Pair)$tmp0.invoke(p0, p1);
    }

    @JvmStatic
    public static final void invalidate(@Nullable String toolchainName) {
        Companion.invalidate(toolchainName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CachingEnvironmentReaderService$Companion;", "", "<init>", "()V", "INVALID_TS", "Ljava/nio/file/attribute/FileTime;", "kotlin.jvm.PlatformType", "invalidate", "", "toolchainName", "", "intellij.clion.toolchains"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void invalidate(@Nullable String toolchainName) {
            CPPToolchains.Toolchain toolchain;
            CPPToolchains.Toolchain toolchain2 = toolchain = CPPToolchains.getInstance().getToolchainByNameOrDefault(toolchainName);
            if ((toolchain2 != null ? toolchain2.getEnvironment() : null) != null) {
                new CPPEnvironment(toolchain).invalidateEnvironmentCache();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

