/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPBuildUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 *2\u00020\u0001:\u0003()*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u0012\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u0013H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ%\u0010 \u001a\u00020\u00192\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#\u00a2\u0006\u0002\b$J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0006\u0010'\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006+"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool;", "Lcom/jetbrains/cidr/toolchains/CidrExecutableTool;", "executable", "Ljava/io/File;", "env", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "<init>", "(Ljava/io/File;Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;)V", "getEnv", "()Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "myVersionLines", "Lcom/intellij/openapi/util/NullableLazyValue;", "", "", "readVersionLines", "()[Ljava/lang/String;", "versionLines", "getVersionLines", "readVersion", "Lcom/intellij/openapi/util/NlsSafe;", "debugProtocol", "Lcom/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$CMakeDebugProtocol;", "getDebugProtocol", "()Lcom/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$CMakeDebugProtocol;", "executeWithOutput", "Lcom/intellij/execution/process/ProcessOutput;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeout", "", "executeWithParameters", "Lkotlin/time/Duration;", "params", "", "executeWithParameters-dnQKTGw", "readToolVersion", "Lcom/jetbrains/cidr/ToolVersion;", "calcCMakeHash", "ToolKind", "CMakeDebugProtocol", "Companion", "intellij.clion.toolchains"})
public class CMakeExecutableTool
extends CidrExecutableTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CPPEnvironment env;
    @NotNull
    private final NullableLazyValue<String[]> myVersionLines;
    @NotNull
    private static final Pattern VERSION_PATTERN;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String SKIP_MAX_VERSION_CHECK_REGISTRY_KEY = "clion.cmake.skip.max.version.check";
    @JvmField
    @NotNull
    public static final Version MIN_VERSION;
    @NotNull
    private static final Version BUNDLED_VERSION;
    @JvmField
    @VisibleForTesting
    @NotNull
    public static final Version MAX_VERSION;
    @Nullable
    private static Supplier<String> ourHashCalculatorInTests;

    public CMakeExecutableTool(@NotNull File executable, @NotNull CPPEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        super(executable);
        this.env = env;
        NullableLazyValue nullableLazyValue = NullableLazyValue.atomicLazyNullable(() -> CMakeExecutableTool._init_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)nullableLazyValue, (String)"atomicLazyNullable(...)");
        this.myVersionLines = nullableLazyValue;
    }

    @NotNull
    public final CPPEnvironment getEnv() {
        return this.env;
    }

    private final String[] readVersionLines() throws ExecutionException {
        ProgressIndicator indicator = CidrRunProcessUtil.getProgressIndicator();
        java.time.Duration timeout = CidrRunProcessUtil.getReadVersionTimeout((OS)this.env.getHostMachine().getOS());
        String[] stringArray = new String[]{"-version"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withParameters(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProcessOutput output = this.executeWithOutput(generalCommandLine, progressIndicator, (int)timeout.toMillis());
        return StringUtil.splitByLines((String)output.getStdout());
    }

    private final String[] getVersionLines() throws ExecutionException {
        try {
            return (String[])this.myVersionLines.getValue();
        }
        catch (RuntimeException rex) {
            Throwable eex = rex.getCause();
            if (eex instanceof ExecutionException) {
                throw eex;
            }
            throw rex;
        }
    }

    @Override
    @Nullable
    public String readVersion() throws ExecutionException {
        String[] versionLines = this.getVersionLines();
        if (LOG.isDebugEnabled() && versionLines != null) {
            CPPLog.logReadVersion("CMake tool", this.myExecutable, versionLines[0]);
        }
        return Companion.parseVersionLines(versionLines);
    }

    @NotNull
    public final CMakeDebugProtocol getDebugProtocol() {
        try {
            Object version;
            String[] versionLines = this.getVersionLines();
            if (versionLines == null) {
                return CMakeDebugProtocol.NONE;
            }
            if (AdvancedSettings.Companion.getBoolean("cmake.dbg.use.dap.protocol") && !this.env.isCygwin()) {
                ToolVersion toolVersion;
                version = Companion.parseVersionLines(versionLines);
                ToolVersion toolVersion2 = toolVersion = version != null ? Companion.parseToolVersion((String)version) : null;
                if (toolVersion != null && toolVersion.versionNumber.isOrGreaterThan(Integer.valueOf(3), Integer.valueOf(27))) {
                    return CMakeDebugProtocol.DAP;
                }
            }
            if (ArrayUtil.contains((String)"debugging support enabled", (String[])Arrays.copyOf(version = versionLines, ((String[])version).length))) {
                return CMakeDebugProtocol.SYSPROGS;
            }
            return CMakeDebugProtocol.NONE;
        }
        catch (ExecutionException executionException) {
            return CMakeDebugProtocol.NONE;
        }
    }

    @NotNull
    public final ProcessOutput executeWithOutput(@NotNull GeneralCommandLine commandLine, @Nullable ProgressIndicator indicator, int timeout) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        commandLine.setExePath(this.myExecutable.getPath());
        this.env.prepare(commandLine, CidrToolEnvironment.PrepareFor.BUILD);
        ProcessOutput processOutput = this.env.getHostMachine().runProcess(commandLine, indicator, timeout);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput output = processOutput;
        CidrToolsUtil.checkSuccess((GeneralCommandLine)commandLine, (ProcessOutput)output, (Logger)LOG);
        if (LOG.isDebugEnabled()) {
            LOG.debug(CidrToolsUtil.logInfo((GeneralCommandLine)commandLine, (ProcessOutput)output));
        }
        if (output.isTimeout()) {
            throw new ExecutionException(ToolchainsBundle.message("dialog.message.cmake.execution.timed.out", new Object[0]));
        }
        return output;
    }

    @NotNull
    public final ProcessOutput executeWithParameters-dnQKTGw(@Nullable Duration timeout, @NotNull List<String> params) throws ExecutionException {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        GeneralCommandLine generalCommandLine = CPPBuildUtil.buildCommandLine(this.env, this.myExecutable.getPath(), null, params, true, MapsKt.emptyMap(), false);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"buildCommandLine(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        this.env.prepare(commandLine, CidrToolEnvironment.PrepareFor.BUILD);
        CPPBuildUtil.setAdditionalBuildEnvironment(commandLine);
        Duration duration = timeout;
        return this.executeWithOutput(commandLine, null, duration != null ? (int)Duration.getInWholeMilliseconds-impl((long)duration.unbox-impl()) : 0);
    }

    public static /* synthetic */ ProcessOutput executeWithParameters-dnQKTGw$default(CMakeExecutableTool cMakeExecutableTool, Duration duration, List list, int n, Object object) throws ExecutionException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeWithParameters-dnQKTGw");
        }
        if ((n & 1) != 0) {
            duration = null;
        }
        return cMakeExecutableTool.executeWithParameters-dnQKTGw(duration, list);
    }

    @Override
    @Nullable
    public ToolVersion readToolVersion() {
        try {
            String version;
            String string = version = this.readVersion();
            return string == null ? null : Companion.parseToolVersion(string);
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    @NotNull
    public final String calcCMakeHash() {
        if (ourHashCalculatorInTests != null) {
            Supplier<String> supplier = ourHashCalculatorInTests;
            Intrinsics.checkNotNull(supplier);
            String string = supplier.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            return string;
        }
        return "CMake: " + this.readToolVersion() + "@" + this.getExecutable() + "\n";
    }

    private static final String[] _init_$lambda$0(CMakeExecutableTool this$0) {
        try {
            return this$0.readVersionLines();
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    @JvmStatic
    @NotNull
    public static final File getBundledCMakeToolBinary(boolean cygwin, @NotNull ToolKind execTool) {
        return Companion.getBundledCMakeToolBinary(cygwin, execTool);
    }

    @JvmStatic
    @VisibleForTesting
    @Nullable
    public static final String parseVersionLines(@Nullable String[] versionLines) throws ExecutionException {
        return Companion.parseVersionLines(versionLines);
    }

    @JvmStatic
    @Nullable
    public static final String checkVersion(@NotNull String version) {
        return Companion.checkVersion(version);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final ToolVersion parseToolVersion(@NotNull String version) {
        return Companion.parseToolVersion(version);
    }

    @JvmStatic
    @TestOnly
    public static final void setHashCalculatorInTests(@Nullable Supplier<String> hashCalculatorInTests) {
        Companion.setHashCalculatorInTests(hashCalculatorInTests);
    }

    @JvmStatic
    @NotNull
    public static final File getBundledCMakeBinary(boolean cygwin) {
        return Companion.getBundledCMakeBinary(cygwin);
    }

    @JvmStatic
    public static final boolean hasBundledCMake(boolean cygwin) {
        return Companion.hasBundledCMake(cygwin);
    }

    @JvmStatic
    @NotNull
    public static final CMakeExecutableTool getBundledCMake(@NotNull CPPEnvironment env) {
        return Companion.getBundledCMake(env);
    }

    @JvmStatic
    @Nullable
    public static final String readCMakeVersion(@Nullable CPPToolchains.Toolchain toolchain) throws ExecutionException {
        return Companion.readCMakeVersion(toolchain);
    }

    @JvmStatic
    @Nullable
    public static final ToolVersion readCMakeToolVersion(@Nullable CPPToolchains.Toolchain toolchain) {
        return Companion.readCMakeToolVersion(toolchain);
    }

    @JvmStatic
    @Nullable
    public static final ToolVersion readCMakeToolVersion(@NotNull CPPEnvironment environment) {
        return Companion.readCMakeToolVersion(environment);
    }

    static {
        Pattern pattern = Pattern.compile("(cmake|ctest)\\w*\\s+version ([\\d.]+)( \\(CMake; JetBrains IDE bundle; build [\\d.]+\\))?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        VERSION_PATTERN = pattern;
        Logger logger = Logger.getInstance(CMakeExecutableTool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        MIN_VERSION = new Version(2, 8, 11);
        BUNDLED_VERSION = new Version(4, 1, -1);
        MAX_VERSION = Registry.Companion.is(SKIP_MAX_VERSION_CHECK_REGISTRY_KEY) ? new Version(-1, -1, -1) : BUNDLED_VERSION;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$CMakeDebugProtocol;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "SYSPROGS", "DAP", "intellij.clion.toolchains"})
    public static final class CMakeDebugProtocol
    extends Enum<CMakeDebugProtocol> {
        public static final /* enum */ CMakeDebugProtocol NONE = new CMakeDebugProtocol();
        public static final /* enum */ CMakeDebugProtocol SYSPROGS = new CMakeDebugProtocol();
        public static final /* enum */ CMakeDebugProtocol DAP = new CMakeDebugProtocol();
        private static final /* synthetic */ CMakeDebugProtocol[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CMakeDebugProtocol[] values() {
            return (CMakeDebugProtocol[])$VALUES.clone();
        }

        public static CMakeDebugProtocol valueOf(String value) {
            return Enum.valueOf(CMakeDebugProtocol.class, value);
        }

        @NotNull
        public static EnumEntries<CMakeDebugProtocol> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cMakeDebugProtocolArray = new CMakeDebugProtocol[]{CMakeDebugProtocol.NONE, CMakeDebugProtocol.SYSPROGS, CMakeDebugProtocol.DAP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0011\u001a\u00020\n*\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0016\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J&\u0010\u001f\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b 2\u0010\u0010!\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\"H\u0007\u00a2\u0006\u0002\u0010#J\u0017\u0010$\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b 2\u0006\u0010%\u001a\u00020\nH\u0007J\u0010\u0010&\u001a\u00020'2\u0006\u0010%\u001a\u00020\nH\u0007J\u0018\u0010*\u001a\u00020+2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010)H\u0007J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0007J\u0019\u00103\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b 2\b\u00104\u001a\u0004\u0018\u000105H\u0007J\u0014\u00106\u001a\u0004\u0018\u00010'2\b\u00104\u001a\u0004\u0018\u000105H\u0007J\u0012\u00106\u001a\u0004\u0018\u00010'2\u0006\u00107\u001a\u000202H\u0007J7\u00108\u001a\u0004\u0018\u0001H9\"\u0004\b\u0000\u001092\b\u00104\u001a\u0004\u0018\u0001052\u0016\u0010:\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0006\u0012\u0004\u0018\u0001H90;H\u0002\u00a2\u0006\u0002\u0010<J5\u00108\u001a\u0004\u0018\u0001H9\"\u0004\b\u0000\u001092\u0006\u00107\u001a\u0002022\u0016\u0010=\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0006\u0012\u0004\u0018\u0001H90;H\u0002\u00a2\u0006\u0002\u0010>R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010(\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$Companion;", "", "<init>", "()V", "VERSION_PATTERN", "Ljava/util/regex/Pattern;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SKIP_MAX_VERSION_CHECK_REGISTRY_KEY", "", "MIN_VERSION", "Lcom/intellij/openapi/util/Version;", "BUNDLED_VERSION", "getBUNDLED_VERSION", "()Lcom/intellij/openapi/util/Version;", "MAX_VERSION", "systemCMakeExeName", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind;", "systemCMakeExeName$intellij_clion_toolchains", "getBundledCMakeToolBinary", "Ljava/io/File;", "cygwin", "", "execTool", "Lcom/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$ToolKind;", "bundledCMakeDocumentation", "Ljava/nio/file/Path;", "getBundledCMakeDocumentation", "()Ljava/nio/file/Path;", "hasBundledTool", "parseVersionLines", "Lcom/intellij/openapi/util/NlsSafe;", "versionLines", "", "([Ljava/lang/String;)Ljava/lang/String;", "checkVersion", "version", "parseToolVersion", "Lcom/jetbrains/cidr/ToolVersion;", "ourHashCalculatorInTests", "Ljava/util/function/Supplier;", "setHashCalculatorInTests", "", "hashCalculatorInTests", "getBundledCMakeBinary", "hasBundledCMake", "getBundledCMake", "Lcom/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool;", "env", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "readCMakeVersion", "toolchain", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "readCMakeToolVersion", "environment", "doWithToolchainCMake", "T", "function", "Ljava/util/function/Function;", "(Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;Ljava/util/function/Function;)Ljava/lang/Object;", "fun", "(Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;Ljava/util/function/Function;)Ljava/lang/Object;", "intellij.clion.toolchains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getBUNDLED_VERSION() {
            return BUNDLED_VERSION;
        }

        @NotNull
        public final String systemCMakeExeName$intellij_clion_toolchains(@NotNull CPPToolSet.Kind $this$systemCMakeExeName) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$systemCMakeExeName), (String)"<this>");
            return "cmake" + $this$systemCMakeExeName.getDefaultExecutableExtension();
        }

        @JvmStatic
        @NotNull
        public final File getBundledCMakeToolBinary(boolean cygwin, @NotNull ToolKind execTool) {
            Intrinsics.checkNotNullParameter((Object)((Object)execTool), (String)"execTool");
            String platformBinPath = "cmake/" + CidrPathManager.getPlatformRelativePath((String)"bin", (boolean)true, (boolean)cygwin);
            File file = CidrPathManager.getBinPath$default(CMakeExecutableTool.class, (String)"clion/bin", (String)(platformBinPath + "/" + execTool.getOSExecutableName()), (String)platformBinPath, (boolean)false, (boolean)false, (int)48, null).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        @NotNull
        public final Path getBundledCMakeDocumentation() {
            return CidrPathManager.getBinPath$default(CMakeExecutableTool.class, (String)"clion/bin", (String)"cmake/quickdoc", null, (boolean)false, (boolean)false, (int)32, null);
        }

        public final boolean hasBundledTool(boolean cygwin, @NotNull ToolKind execTool) {
            Intrinsics.checkNotNullParameter((Object)((Object)execTool), (String)"execTool");
            return this.getBundledCMakeToolBinary(cygwin, execTool).exists();
        }

        @JvmStatic
        @VisibleForTesting
        @Nullable
        public final String parseVersionLines(@Nullable String[] versionLines) throws ExecutionException {
            String result = null;
            if (versionLines != null) {
                result = StringUtil.nullize((String)versionLines[0], (boolean)true);
            }
            if (result == null) {
                return null;
            }
            Matcher matcher = VERSION_PATTERN.matcher(result);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
            Matcher matcher2 = matcher;
            boolean matched = matcher2.find();
            if (!matched) {
                LOG.warn("Couldn't find CMake version in header \"" + result + "\"");
                return null;
            }
            return matcher2.group(2);
        }

        @JvmStatic
        @Nullable
        public final String checkVersion(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return CPPToolchainsUtil.checkVersion(MIN_VERSION, MAX_VERSION, this.parseToolVersion(version));
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final ToolVersion parseToolVersion(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Pattern[] patternArray = new Pattern[]{CPPToolchainsUtil.VERSION_PATTERN};
            ToolVersion toolVersion = ToolVersion.parse((String)version, (Pattern[])patternArray);
            Intrinsics.checkNotNullExpressionValue((Object)toolVersion, (String)"parse(...)");
            return toolVersion;
        }

        @JvmStatic
        @TestOnly
        public final void setHashCalculatorInTests(@Nullable Supplier<String> hashCalculatorInTests) {
            ourHashCalculatorInTests = hashCalculatorInTests;
        }

        @JvmStatic
        @NotNull
        public final File getBundledCMakeBinary(boolean cygwin) {
            return this.getBundledCMakeToolBinary(cygwin, ToolKind.CMAKE);
        }

        @JvmStatic
        public final boolean hasBundledCMake(boolean cygwin) {
            return this.hasBundledTool(cygwin, ToolKind.CMAKE);
        }

        @JvmStatic
        @NotNull
        public final CMakeExecutableTool getBundledCMake(@NotNull CPPEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            return new CMakeExecutableTool(this.getBundledCMakeToolBinary(env.isCygwin(), ToolKind.CMAKE), env);
        }

        @JvmStatic
        @Nullable
        public final String readCMakeVersion(@Nullable CPPToolchains.Toolchain toolchain) throws ExecutionException {
            CMakeExecutableTool cmake;
            CMakeExecutableTool cMakeExecutableTool = cmake = toolchain == null ? null : new CPPEnvironment(toolchain).getCMake();
            return cMakeExecutableTool != null ? cMakeExecutableTool.readVersion() : null;
        }

        @JvmStatic
        @Nullable
        public final ToolVersion readCMakeToolVersion(@Nullable CPPToolchains.Toolchain toolchain) {
            return this.doWithToolchainCMake(toolchain, Companion::readCMakeToolVersion$lambda$0);
        }

        @JvmStatic
        @Nullable
        public final ToolVersion readCMakeToolVersion(@NotNull CPPEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            return this.doWithToolchainCMake(environment, Companion::readCMakeToolVersion$lambda$1);
        }

        private final <T> T doWithToolchainCMake(CPPToolchains.Toolchain toolchain, Function<CMakeExecutableTool, T> function) {
            CMakeExecutableTool cmake;
            CMakeExecutableTool cMakeExecutableTool = cmake = toolchain == null ? null : new CPPEnvironment(toolchain).getCMake();
            return cMakeExecutableTool == null ? null : (T)function.apply(cMakeExecutableTool);
        }

        private final <T> T doWithToolchainCMake(CPPEnvironment environment, Function<CMakeExecutableTool, T> fun) {
            CMakeExecutableTool cmake;
            CMakeExecutableTool cMakeExecutableTool = cmake = environment.getCMake();
            return cMakeExecutableTool == null ? null : (T)fun.apply(cMakeExecutableTool);
        }

        private static final ToolVersion readCMakeToolVersion$lambda$0(CMakeExecutableTool obj) {
            CMakeExecutableTool cMakeExecutableTool = obj;
            Intrinsics.checkNotNull((Object)cMakeExecutableTool);
            return cMakeExecutableTool.readToolVersion();
        }

        private static final ToolVersion readCMakeToolVersion$lambda$1(CMakeExecutableTool obj) {
            CMakeExecutableTool cMakeExecutableTool = obj;
            Intrinsics.checkNotNull((Object)cMakeExecutableTool);
            return cMakeExecutableTool.readToolVersion();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$ToolKind;", "", "executableName", "", "macroName", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getExecutableName", "()Ljava/lang/String;", "getMacroName", "CMAKE", "CTEST", "oSExecutableName", "getOSExecutableName", "toolset", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet;", "macro", "getMacro", "Companion", "intellij.clion.toolchains"})
    public static final class ToolKind
    extends Enum<ToolKind> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String executableName;
        @NotNull
        private final String macroName;
        public static final /* enum */ ToolKind CMAKE;
        public static final /* enum */ ToolKind CTEST;
        private static final /* synthetic */ ToolKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ToolKind(String executableName, String macroName) {
            this.executableName = executableName;
            this.macroName = macroName;
        }

        @NotNull
        public final String getExecutableName() {
            return this.executableName;
        }

        @NotNull
        public final String getMacroName() {
            return this.macroName;
        }

        @NotNull
        public final String getOSExecutableName() {
            return this.executableName + (SystemInfo.isWindows ? ".exe" : "");
        }

        @NotNull
        public final String getExecutableName(@NotNull CPPToolSet toolset) {
            Intrinsics.checkNotNullParameter((Object)toolset, (String)"toolset");
            if (toolset.isMinGW() || toolset.isMSVC()) {
                return this.executableName + ".exe";
            }
            return this.executableName;
        }

        @NotNull
        public final String getMacro() {
            return "$" + this.macroName + "$";
        }

        public static ToolKind[] values() {
            return (ToolKind[])$VALUES.clone();
        }

        public static ToolKind valueOf(String value) {
            return Enum.valueOf(ToolKind.class, value);
        }

        @NotNull
        public static EnumEntries<ToolKind> getEntries() {
            return $ENTRIES;
        }

        static {
            CMAKE = new ToolKind("cmake", "CMakeCurrentExecutableName");
            CTEST = new ToolKind("ctest", "CTestCurrentExecutableName");
            $VALUES = toolKindArray = new ToolKind[]{ToolKind.CMAKE, ToolKind.CTEST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$ToolKind$Companion;", "", "<init>", "()V", "findMacro", "Lcom/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$ToolKind;", "maybeMacro", "", "intellij.clion.toolchains"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final ToolKind findMacro(@NotNull String maybeMacro) {
                Intrinsics.checkNotNullParameter((Object)maybeMacro, (String)"maybeMacro");
                for (ToolKind e : ToolKind.getEntries()) {
                    if (!Intrinsics.areEqual((Object)e.getMacro(), (Object)maybeMacro)) continue;
                    return e;
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

