/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.testing.ctest;

import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfigurationSettingsEditor;
import com.jetbrains.cidr.cpp.execution.CMakeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CTestAvailableTestsDialog;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestBundle;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectState;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectTestInfo;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.ui.CidrProgramParametersPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class CTestConfigurationSettingsEditor
extends CMakeAppRunConfigurationSettingsEditor {
    private LabeledComponent<ComponentWithBrowseButton<TextFieldWithAutoCompletion<String>>> myPatternTextField;
    private final List<CidrCTestProjectTestInfo> myTests;
    private @Unmodifiable List<CidrCTestProjectTestInfo> mySelectedTests;

    public CTestConfigurationSettingsEditor(@NotNull Project project, @NotNull CMakeBuildConfigurationHelper configHelper) {
        if (project == null) {
            CTestConfigurationSettingsEditor.$$$reportNull$$$0(0);
        }
        if (configHelper == null) {
            CTestConfigurationSettingsEditor.$$$reportNull$$$0(1);
        }
        super(project, configHelper, false);
        this.myTests = ((CidrCTestProjectState)project.getService(CidrCTestProjectState.class)).getTests();
        this.mySelectedTests = new ArrayList<CidrCTestProjectTestInfo>(this.myTests);
        this.orderTestsByTestNumber();
    }

    protected void createEditorInner(JPanel panel, GridBag g) {
        this.createTestPatternComponent(panel, g);
        super.createEditorInner(panel, g);
        this.setupAnchor();
    }

    protected void applyEditorTo(@NotNull CMakeAppRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            CTestConfigurationSettingsEditor.$$$reportNull$$$0(2);
        }
        super.applyEditorTo(runConfiguration);
        if (!(runConfiguration instanceof CidrTestRunConfiguration)) {
            return;
        }
        CidrTestRunConfigurationData testData = ((CidrTestRunConfiguration)runConfiguration).getTestData();
        this.updateSelectedTests(((TextFieldWithAutoCompletion)((ComponentWithBrowseButton)this.myPatternTextField.getComponent()).getChildComponent()).getText());
        if (this.mySelectedTests.isEmpty() || this.mySelectedTests.size() == this.myTests.size()) {
            testData.setTestName(null);
            testData.setTestPattern(null);
            testData.setTestMode(CidrTestRunConfigurationData.Mode.PATTERN);
        } else if (this.mySelectedTests.size() == 1) {
            testData.setTestName(this.mySelectedTests.get(0).getTestName());
            testData.setTestPattern(null);
            testData.setTestMode(CidrTestRunConfigurationData.Mode.SUITE_TEST);
        } else {
            testData.setTestName(null);
            testData.setTestPattern(StringUtil.join((Collection)ContainerUtil.map(this.mySelectedTests, CidrCTestProjectTestInfo::getTestName), (String)","));
            testData.setTestMode(CidrTestRunConfigurationData.Mode.PATTERN);
        }
    }

    protected void resetEditorFrom(@NotNull CMakeAppRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            CTestConfigurationSettingsEditor.$$$reportNull$$$0(3);
        }
        super.resetEditorFrom(runConfiguration);
        if (!(runConfiguration instanceof CidrTestRunConfiguration)) {
            return;
        }
        CidrTestRunConfigurationData testData = ((CidrTestRunConfiguration)runConfiguration).getTestData();
        if (testData.getTestName() != null) {
            ((TextFieldWithAutoCompletion)((ComponentWithBrowseButton)this.myPatternTextField.getComponent()).getChildComponent()).setText(testData.getTestName());
            this.updateSelectedTests(testData.getTestName());
        } else if (testData.getTestPattern() != null) {
            ((TextFieldWithAutoCompletion)((ComponentWithBrowseButton)this.myPatternTextField.getComponent()).getChildComponent()).setText(testData.getTestPattern());
            this.updateSelectedTests(testData.getTestPattern());
        }
    }

    @NotNull
    protected CommonProgramParametersPanel createProgramParametersPanel() {
        return new CidrProgramParametersPanel(){

            protected void initComponents() {
                super.initComponents();
                this.myProgramParametersComponent.setText(CidrCTestBundle.message("ctest.arguments.label", new Object[0]));
                this.myProgramInputRedirectPanel.setVisible(false);
                this.myConsoleOptionsPanel.setVisible(false);
            }

            @NotNull
            protected Predicate<? super Macro> getCommonMacroFilter() {
                Predicate predicate = MacrosDialog.Filters.ALL;
                if (predicate == null) {
                    1.$$$reportNull$$$0(0);
                }
                return predicate;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestConfigurationSettingsEditor$1", "getCommonMacroFilter"));
            }
        };
    }

    private void setupAnchor() {
        JComponent anchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myCommonProgramParameters, this.myPatternTextField});
        this.myPatternTextField.setAnchor(anchor);
    }

    private void createTestPatternComponent(@NotNull JPanel panel, @NotNull GridBag g) {
        if (panel == null) {
            CTestConfigurationSettingsEditor.$$$reportNull$$$0(4);
        }
        if (g == null) {
            CTestConfigurationSettingsEditor.$$$reportNull$$$0(5);
        }
        TextFieldWithAutoCompletion.StringsCompletionProvider completionProvider = new TextFieldWithAutoCompletion.StringsCompletionProvider(this, this.getTestNames(), null){

            @NotNull
            public String getPrefix(@NotNull String text, int offset) {
                int i;
                if (text == null) {
                    2.$$$reportNull$$$0(0);
                }
                String string = (i = text.lastIndexOf(44)) >= 0 ? text.substring(i + 1) : text;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestConfigurationSettingsEditor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestConfigurationSettingsEditor$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPrefix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getPrefix";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        final TextFieldWithAutoCompletion textField = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)completionProvider, true, null);
        textField.setPlaceholder((CharSequence)CidrExecutionBundle.message((String)"test.defaultName.allTests", (Object[])new Object[0]));
        textField.setToolTipText(CidrCTestBundle.message("ctest.test.list.to.run.tooltip", new Object[0]));
        ComponentWithBrowseButton textFieldWithBrowseButton = new ComponentWithBrowseButton((JComponent)textField, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CTestConfigurationSettingsEditor.this.updateSelectedTests(textField.getText());
                CTestAvailableTestsDialog dialog = new CTestAvailableTestsDialog(CTestConfigurationSettingsEditor.this.myProject, CTestConfigurationSettingsEditor.this.myTests, CTestConfigurationSettingsEditor.this.mySelectedTests, false);
                if (!dialog.showAndGet()) {
                    return;
                }
                CTestConfigurationSettingsEditor.this.mySelectedTests = dialog.getEnabledTests();
                CTestConfigurationSettingsEditor.this.updatePatternTextField();
            }
        });
        textFieldWithBrowseButton.setButtonIcon(AllIcons.Actions.Edit);
        textFieldWithBrowseButton.getButton().setToolTipText(CidrCTestBundle.message("ctest.select.tests.from.table", new Object[0]) + " (" + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 64)) + ")");
        this.myPatternTextField = LabeledComponent.create((JComponent)textFieldWithBrowseButton, (String)CidrCTestBundle.message("ctest.test.list.to.run.label", new Object[0]));
        this.myPatternTextField.setLabelLocation("West");
        this.updatePatternTextField();
        panel.add((Component)this.myPatternTextField, g.nextLine().insets(0, -1, 4, -1).coverLine());
    }

    private void orderTestsByTestNumber() {
        ContainerUtil.sort(this.myTests, (o1, o2) -> {
            if (o1.getTestNumber() == o2.getTestNumber()) {
                return 0;
            }
            return o1.getTestNumber() < o2.getTestNumber() ? -1 : 1;
        });
    }

    @NotNull
    private List<String> getTestNames() {
        List list = ContainerUtil.map(this.myTests, t -> t.getTestName());
        if (list == null) {
            CTestConfigurationSettingsEditor.$$$reportNull$$$0(6);
        }
        return list;
    }

    private void updateSelectedTests(@NotNull String pattern) {
        if (pattern == null) {
            CTestConfigurationSettingsEditor.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)pattern)) {
            this.mySelectedTests = new ArrayList<CidrCTestProjectTestInfo>(this.myTests);
            return;
        }
        HashSet testNames = new HashSet(StringUtil.split((String)pattern, (String)","));
        this.mySelectedTests = ContainerUtil.filter(this.myTests, test -> testNames.contains(test.getTestName()));
    }

    private void updatePatternTextField() {
        TextFieldWithAutoCompletion textField = (TextFieldWithAutoCompletion)((ComponentWithBrowseButton)this.myPatternTextField.getComponent()).getChildComponent();
        if (this.mySelectedTests.isEmpty() || this.mySelectedTests.size() == this.myTests.size()) {
            textField.setText(null);
            return;
        }
        textField.setText(StringUtil.join((Collection)ContainerUtil.map(this.mySelectedTests, CidrCTestProjectTestInfo::getTestName), (String)","));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestConfigurationSettingsEditor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CTestConfigurationSettingsEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTestPatternComponent";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

