/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectWithOwner;
import com.intellij.database.dialects.postgresbase.model.PgBaseOperator;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.properties.PgOperatorKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgRoutineKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgVolatilityKind;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateCatalogStatement;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.sql.psi.stubs.elementStubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.elementStubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.elementTypes.SqlNamedStubElementType;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J$\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J \u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J \u0010!\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\f\u001a\u0004\u0018\u00010&H\u0004J\u0019\u0010'\u001a\u0004\u0018\u00010(2\b\u0010\f\u001a\u0004\u0018\u00010&H\u0004\u00a2\u0006\u0002\u0010)JB\u0010*\u001a\b\u0012\u0004\u0012\u00020%0+2\b\u0010\f\u001a\u0004\u0018\u00010&2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0006\u0012\u0004\u0018\u00010&0-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0-H\u0004J \u0010/\u001a\u00020\t2\u0006\u0010\n\u001a\u0002002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0014\u00101\u001a\u0004\u0018\u00010%2\b\u0010\f\u001a\u0004\u0018\u000102H\u0002J\u0014\u00103\u001a\u0004\u0018\u00010%2\b\u0010\f\u001a\u0004\u0018\u000102H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010%2\u0006\u0010\f\u001a\u000202H\u0014J \u00105\u001a\u00020\t2\u0006\u0010\n\u001a\u0002062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006;"}, d2={"Lcom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "lazyCodeBlock", "Lcom/intellij/psi/tree/IElementType;", "getLazyCodeBlock", "()Lcom/intellij/psi/tree/IElementType;", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "buildStatement", "Lcom/intellij/sql/psi/SqlElement;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "retrieveOwner", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseObjectWithOwner;", "Lcom/intellij/sql/psi/SqlAlterStatement;", "buildDatabase", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "buildRoutine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "buildRoutineKind", "findSchemaInSiblings", "", "Lcom/intellij/psi/PsiElement;", "findNumberInSiblings", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Float;", "findOptions", "", "nextElement", "Lkotlin/Function1;", "optionFormatter", "buildRoutineSources", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "getRoutineArgumentsDefinition", "Lcom/intellij/sql/psi/SqlCreateProcedureStatement;", "getRoutineResultDefinition", "getRoutineSourceText", "buildOperator", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseOperator;", "getPgOperatorKind", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgOperatorKind;", "n", "Lcom/intellij/database/model/DasOperator$OperatorNotation;", "intellij.database.dialects.postgresbase"})
@SourceDebugExtension(value={"SMAP\nPgBaseObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseObjectBuilder.kt\ncom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,232:1\n1869#2:233\n1869#2,2:234\n1870#2:236\n625#3,5:237\n614#3,10:242\n637#3:252\n625#3,5:253\n614#3,10:258\n660#3,6:269\n644#3:275\n660#3,6:276\n648#3:282\n660#3,6:283\n625#3,5:289\n648#3:294\n660#3,6:295\n644#3:301\n660#3,6:302\n1#4:268\n19#5:308\n*S KotlinDebug\n*F\n+ 1 PgBaseObjectBuilder.kt\ncom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder\n*L\n65#1:233\n68#1:234,2\n65#1:236\n96#1:237,5\n102#1:242,10\n119#1:252\n119#1:253,5\n120#1:258,10\n167#1:269,6\n192#1:275\n192#1:276,6\n193#1:282\n193#1:283,6\n206#1:289,5\n218#1:294\n218#1:295,6\n220#1:301\n220#1:302,6\n223#1:308\n*E\n"})
public abstract class PgBaseObjectBuilder
extends SqlObjectBuilderImpl {
    @Nullable
    protected abstract IElementType getLazyCodeBlock();

    public void build(@NotNull BasicModElement obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof PgBaseOperator) {
            this.buildOperator((PgBaseOperator)obj, source, context);
        } else if (basicModElement instanceof PgBaseLikeDatabase) {
            this.buildDatabase((PgBaseLikeDatabase)obj, source, context);
        } else {
            super.build(obj, source, context);
        }
    }

    protected void buildStatement(@NotNull BasicModElement obj, @NotNull SqlElement source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (obj instanceof PgBaseObjectWithOwner && source instanceof SqlAlterStatement) {
            this.retrieveOwner((PgBaseObjectWithOwner)obj, (SqlAlterStatement)source);
        }
        super.buildStatement(obj, source, context);
    }

    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)path.kind, (Object)ObjectKind.RULE) ? this.getTriggerBodyRange(def) : super.getCompactDefinition(path, text, def);
    }

    private final void retrieveOwner(PgBaseObjectWithOwner obj, SqlAlterStatement source) {
        String ownerName = null;
        boolean faceless = false;
        JBIterable jBIterable = SqlImplUtil.childrenIt((PsiElement)((PsiElement)source));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"childrenIt(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)SqlElementTypes.SQL_ALTER_INSTRUCTION)) continue;
            JBIterable jBIterable2 = SqlImplUtil.childrenIt((PsiElement)it);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"childrenIt(...)");
            Iterable $this$forEach$iv2 = (Iterable)jBIterable2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PsiElement ownerPsi;
                PsiElement psiElement;
                StubElement stub;
                PsiElement alterChild = (PsiElement)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)alterChild), (Object)SqlElementTypes.SQL_OWNER_TO_CLAUSE)) continue;
                SqlStubbedElement sqlStubbedElement = alterChild instanceof SqlStubbedElement ? (SqlStubbedElement)alterChild : null;
                Object object = stub = sqlStubbedElement != null ? sqlStubbedElement.getStub() : null;
                if (stub != null) {
                    SqlReferenceExpression sqlReferenceExpression;
                    StubElement stubElement = stub;
                    SqlNamedElementStub sqlNamedElementStub = stubElement instanceof SqlNamedElementStub ? (SqlNamedElementStub)stubElement : null;
                    if (sqlNamedElementStub != null) {
                        IElementType iElementType = ((SqlNamedElementStub)stub).getElementType();
                        Intrinsics.checkNotNull((Object)iElementType, (String)"null cannot be cast to non-null type com.intellij.sql.psi.stubs.elementTypes.SqlNamedStubElementType<*, *>");
                        sqlReferenceExpression = sqlNamedElementStub.getNameReference(((SqlNamedStubElementType)iElementType).getTargetReferenceType());
                    } else {
                        sqlReferenceExpression = null;
                    }
                    psiElement = (PsiElement)sqlReferenceExpression;
                } else {
                    IElementType iElementType = PgTypes.PG_TO;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PG_TO");
                    PsiElement to = this.findChild(alterChild, iElementType);
                    SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_USER_REFERENCE;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_USER_REFERENCE");
                    psiElement = this.findSibling(to, (IElementType)sqlReferenceElementType);
                    if (psiElement == null) {
                        IElementType iElementType2 = PgTypes.PG_SESSION_USER;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"PG_SESSION_USER");
                        psiElement = this.findSibling(to, iElementType2);
                        if (psiElement == null) {
                            IElementType iElementType3 = PgTypes.PG_CURRENT_USER;
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"PG_CURRENT_USER");
                            psiElement = this.findSibling(to, iElementType3);
                        }
                    }
                }
                PsiElement psiElement2 = ownerPsi = psiElement;
                ownerName = psiElement2 != null ? this.extractName(psiElement2) : null;
                faceless = ownerPsi != null && !(ownerPsi instanceof SqlReferenceExpression);
            }
        }
        if (ownerName != null) {
            obj.setOwnerRef((BasicReference)BasicNameReference.create(ownerName, (boolean)faceless));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void buildDatabase(@NotNull PgBaseLikeDatabase obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        PgBaseLikeDatabase stubbed;
        StubElement stubElement;
        BasicElement basicElement;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.buildNamespace((BasicModNamespace)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof PgBaseLikeDatabase) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof PgBaseLikeDatabase)) {
                object = null;
            }
            basicElement = (BasicElement)((PgBaseLikeDatabase)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (PgBaseLikeDatabase)basicElement) != null) {
            obj.setOwnerRef(stubbed.getOwnerRef());
        } else {
            void this_$iv;
            String ownerName = null;
            $this$stubbed$iv = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateCatalogStatement ? (SqlCreateCatalogStatement)source : null);
            boolean $i$f$forEachChild = false;
            stubElement = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)PgTypes.PG_OWNER)) continue;
                SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_USER_REFERENCE;
                Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_USER_REFERENCE");
                PsiElement psiElement2 = this.findSibling(it, (IElementType)sqlReferenceElementType);
                ownerName = psiElement2 != null ? this.extractName(psiElement2) : null;
            }
            obj.setOwnerRef((BasicReference)BasicNameReference.create(ownerName));
        }
    }

    protected void buildViewSource(@NotNull BasicModView obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources((BasicModSourceAware)obj, context, () -> PgBaseObjectBuilder.buildViewSource$lambda$0(this, source));
    }

    /*
     * WARNING - void declaration
     */
    protected void buildRoutine(@NotNull BasicModRoutine obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        void $this$stubbedOrBuild$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PgBaseRoutine cfr_ignored_0 = (PgBaseRoutine)obj;
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject dasObject = source;
        BasicElement tgt$iv = (BasicElement)obj;
        boolean $i$f$stubbedOrBuild = false;
        BasicElement basicElement2 = this_$iv;
        void $this$stubbed$iv$iv = $this$stubbedOrBuild$iv;
        boolean $i$f$stubbed = false;
        void var12_11 = $this$stubbed$iv$iv;
        if (var12_11 instanceof PgBaseRoutine) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (var12_11 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof PgBaseRoutine)) {
                object = null;
            }
            basicElement = (BasicElement)((PgBaseRoutine)object);
        } else {
            basicElement = null;
        }
        BasicElement basicElement3 = basicElement;
        if (basicElement == null) {
            boolean bl;
            void this_$iv2;
            BasicElement basicElement4 = ((BasicObjectNode)tgt$iv).getMetaObject().newDataObject();
            if (basicElement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseRoutine");
            }
            basicElement2 = (BasicElement)((PgBaseRoutine)basicElement4);
            PgBaseRoutine $this$buildRoutine_u24lambda_u240 = (PgBaseRoutine)basicElement2;
            boolean bl2 = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)source : null);
            boolean $i$f$forEachChild2 = false;
            void var19_19 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement s;
                PsiElement it = tmp$iv$iv;
                boolean bl3 = false;
                PsiElement psiElement2 = s = it.getFirstChild();
                Object object = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_IMMUTABLE)) {
                    $this$buildRoutine_u24lambda_u240.setVolatilityKind(PgVolatilityKind.IMMUTABLE);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_STABLE)) {
                    $this$buildRoutine_u24lambda_u240.setVolatilityKind(PgVolatilityKind.STABLE);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VOLATILE)) continue;
                $this$buildRoutine_u24lambda_u240.setVolatilityKind(PgVolatilityKind.VOLATILE);
            }
            $this$buildRoutine_u24lambda_u240.setArgumentsDefinition(this.getRoutineArgumentsDefinition(source instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)source : null));
            $this$buildRoutine_u24lambda_u240.setResultsDefinition(this.getRoutineResultDefinition(source instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)source : null));
            PgBaseRoutine pgBaseRoutine = $this$buildRoutine_u24lambda_u240;
            String string = $this$buildRoutine_u24lambda_u240.getResultsDefinition();
            if (string != null) {
                void $this$buildRoutine_u24lambda_u240_u241;
                String $i$f$forEachChild2 = string;
                PgBaseRoutine pgBaseRoutine2 = pgBaseRoutine;
                boolean bl4 = false;
                pgBaseRoutine = pgBaseRoutine2;
                bl = Boolean.valueOf(StringsKt.contains((CharSequence)((CharSequence)$this$buildRoutine_u24lambda_u240_u241), (CharSequence)"setof ", (boolean)true) || StringsKt.startsWith((String)$this$buildRoutine_u24lambda_u240_u241, (String)"table", (boolean)true)).booleanValue();
            } else {
                bl = false;
            }
            pgBaseRoutine.setReturnsSet(bl);
            basicElement3 = basicElement2;
        }
        PgBaseRoutine stubbed = (PgBaseRoutine)basicElement3;
        ((PgBaseRoutine)obj).setArgumentsDefinition(stubbed.getArgumentsDefinition());
        ((PgBaseRoutine)obj).setResultsDefinition(stubbed.getResultsDefinition());
        ((PgBaseRoutine)obj).setVolatilityKind(stubbed.getVolatilityKind());
        ((PgBaseRoutine)obj).setReturnsSet(stubbed.isReturnsSet());
        super.buildRoutine(obj, source, context);
    }

    public void buildRoutineKind(@NotNull BasicModRoutine obj, @NotNull DasObject source) {
        PgRoutineKind pgRoutineKind;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DasRoutine.Kind rk = this.extractRoutineKind(source);
        PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)obj;
        String string = ((PgBaseRoutine)obj).getResultsDefinition();
        boolean bl = string != null ? StringsKt.equals((String)string, (String)"trigger", (boolean)true) : false;
        if (bl) {
            pgRoutineKind = PgRoutineKind.PG_TRIGGER;
        } else {
            String string2 = ((PgBaseRoutine)obj).getResultsDefinition();
            pgRoutineKind = (string2 != null ? StringsKt.equals((String)string2, (String)"event_trigger", (boolean)true) : false) ? PgRoutineKind.PG_EVENT_TRIGGER : (rk == DasRoutine.Kind.PROCEDURE ? PgRoutineKind.PG_PROCEDURE : PgRoutineKind.PG_FUNCTION);
        }
        pgBaseRoutine.setPgRoutineKind(pgRoutineKind);
    }

    @Nullable
    protected final String findSchemaInSiblings(@Nullable PsiElement source) {
        SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_SCHEMA_REFERENCE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_SCHEMA_REFERENCE");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlReferenceElementType);
        SqlReferenceExpressionImpl sqlReferenceExpressionImpl = psiElement instanceof SqlReferenceExpressionImpl ? (SqlReferenceExpressionImpl)psiElement : null;
        return sqlReferenceExpressionImpl != null ? sqlReferenceExpressionImpl.getName() : null;
    }

    @Nullable
    protected final Float findNumberInSiblings(@Nullable PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_NUMERIC_LITERAL");
        PsiElement num = this.findSibling(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toFloatOrNull((String)object) : null;
    }

    @NotNull
    protected final List<String> findOptions(@Nullable PsiElement source, @NotNull Function1<? super PsiElement, ? extends PsiElement> nextElement, @NotNull Function1<? super String, String> optionFormatter) {
        PsiElement leftParen;
        Intrinsics.checkNotNullParameter(nextElement, (String)"nextElement");
        Intrinsics.checkNotNullParameter(optionFormatter, (String)"optionFormatter");
        List result = new ArrayList();
        SqlTokenType sqlTokenType = SqlElementTypes.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlTokenType);
        if (psiElement == null) {
            return result;
        }
        PsiElement current = leftParen = psiElement;
        while (true) {
            PsiElement psiElement2;
            block6: {
                PsiElement literal;
                PsiElement option;
                PsiElement psiElement3 = current;
                if ((psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null) == null || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)current), (Object)SqlElementTypes.SQL_RIGHT_PAREN)) break;
                if ((PsiElement)nextElement.invoke((Object)current) == null) {
                    return result;
                }
                PsiElement psiElement4 = option.getNextSibling();
                SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
                Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_STRING_LITERAL");
                if (this.findSibling(psiElement4, (IElementType)sqlCompositeElementType) == null) {
                    return result;
                }
                String literalValue = ((SqlStringLiteralExpressionImpl)literal).getValue();
                if (literalValue != null) {
                    result.add(option.getText() + "=" + optionFormatter.invoke((Object)literalValue));
                }
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
                PsiElement element$iv = literal;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv = element$iv; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                    PsiElement it = tmp$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)literal) && !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)SqlElementTypes.WHITE_SPACE))) continue;
                    psiElement2 = tmp$iv;
                    break block6;
                }
                psiElement2 = null;
            }
            current = psiElement2;
        }
        return result;
    }

    protected void buildRoutineSources(@NotNull BasicModSourceAware obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources(obj, context, () -> PgBaseObjectBuilder.buildRoutineSources$lambda$0(source, this));
    }

    private final String getRoutineArgumentsDefinition(SqlCreateProcedureStatement source) {
        PsiElement rParen;
        PsiElement lParen;
        PsiElement params;
        block5: {
            block4: {
                PsiElement psiElement = (PsiElement)source;
                IElementType iElementType = PgTypes.PG_PARAMETER_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PG_PARAMETER_LIST");
                PsiElement psiElement2 = this.findChild(psiElement, iElementType);
                if (psiElement2 == null) {
                    return null;
                }
                params = psiElement2;
                lParen = params.getFirstChild();
                rParen = params.getLastChild();
                PsiElement psiElement3 = lParen;
                if (!Intrinsics.areEqual((Object)(psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null), (Object)PgTypes.PG_LEFT_PAREN)) break block4;
                PsiElement psiElement4 = rParen;
                if (Intrinsics.areEqual((Object)(psiElement4 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement4) : null), (Object)PgTypes.PG_RIGHT_PAREN)) break block5;
            }
            return null;
        }
        String string = params.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = lParen.getStartOffsetInParent() + lParen.getTextLength();
        int n2 = rParen.getStartOffsetInParent();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (boolean)false, (int)1, null);
    }

    private final String getRoutineResultDefinition(SqlCreateProcedureStatement source) {
        PsiElement returns;
        PsiElement psiElement = (PsiElement)source;
        IElementType iElementType = PgTypes.PG_RETURNS_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PG_RETURNS_CLAUSE");
        PsiElement psiElement2 = this.findChild(psiElement, iElementType);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement params = psiElement2;
        PsiElement psiElement3 = returns = params.getFirstChild();
        if (!Intrinsics.areEqual((Object)(psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null), (Object)PgTypes.PG_RETURNS)) {
            return null;
        }
        String string = params.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = returns.getStartOffsetInParent() + returns.getTextLength();
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (boolean)false, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected String getRoutineSourceText(@NotNull SqlCreateProcedureStatement source) {
        String string;
        PsiElement code;
        PsiElement psiElement;
        SqlObjectBuilderImpl sqlObjectBuilderImpl;
        block8: {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            PsiElement psiElement2 = (PsiElement)source;
            IElementType iElementType = PgElementTypes.Misc.PG_LAZY_CODE_BLOCK_PARENT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PG_LAZY_CODE_BLOCK_PARENT");
            PsiElement psiElement3 = this.findChild(psiElement2, iElementType);
            if (psiElement3 == null) {
                PsiElement psiElement4;
                block7: {
                    void this_$iv2;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
                    PsiElement el$iv = (PsiElement)source;
                    boolean $i$f$findChild2 = false;
                    void var8_8 = this_$iv2;
                    PsiElement element$iv$iv = el$iv.getFirstChild();
                    boolean $i$f$findSibling = false;
                    for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        PsiElement it$iv = tmp$iv$iv;
                        boolean bl = false;
                        if (!(it$iv instanceof SqlStringLiteralExpression)) continue;
                        psiElement4 = tmp$iv$iv;
                        break block7;
                    }
                    psiElement4 = null;
                }
                SqlStringLiteralExpression sqlStringLiteralExpression = (SqlStringLiteralExpression)psiElement4;
                return sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
            }
            PsiElement block = psiElement3;
            sqlObjectBuilderImpl = this;
            PsiElement el$iv = block;
            boolean $i$f$findChild = false;
            void $i$f$findChild2 = this_$iv;
            PsiElement element$iv$iv = el$iv.getFirstChild();
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                IElementType type = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (!(Intrinsics.areEqual((Object)type, (Object)this.getLazyCodeBlock()) || Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_STRING_LITERAL))) continue;
                psiElement = tmp$iv$iv;
                break block8;
            }
            psiElement = null;
        }
        PsiElement psiElement5 = code = psiElement;
        Object object = sqlObjectBuilderImpl = psiElement5 != null ? PsiTreeUtilKt.getElementType(psiElement5) : null;
        if (Intrinsics.areEqual((Object)sqlObjectBuilderImpl, (Object)this.getLazyCodeBlock())) {
            PsiElement psiElement6 = code;
            string = psiElement6 != null ? psiElement6.getText() : null;
        } else if (Intrinsics.areEqual((Object)sqlObjectBuilderImpl, (Object)SqlElementTypes.SQL_STRING_LITERAL)) {
            PsiElement psiElement7 = code;
            Intrinsics.checkNotNull((Object)psiElement7, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlStringLiteralExpression");
            string = ((SqlStringLiteralExpression)psiElement7).getValue();
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void buildOperator(PgBaseOperator obj, DasObject source, SqlObjectBuilder.Context context) {
        block20: {
            block18: {
                block17: {
                    block19: {
                        this.buildBasicElement((BasicModElement)obj, source, context);
                        var5_4 = this;
                        $this$stubbed$iv = source;
                        $i$f$stubbed = false;
                        var8_8 = $this$stubbed$iv;
                        if (var8_8 instanceof PgBaseOperator) {
                            v0 = (BasicElement)$this$stubbed$iv;
                        } else if (var8_8 instanceof SqlStubbedElement) {
                            var9_9 = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                            v1 = var9_9 instanceof SqlDefinitionStub != false ? (SqlDefinitionStub)var9_9 : null;
                            v2 /* !! */  = v1 != null ? v1.getElement() : null;
                            if (!(v2 /* !! */  instanceof PgBaseOperator)) {
                                v2 /* !! */  = null;
                            }
                            v0 = (BasicElement)((PgBaseOperator)v2 /* !! */ );
                        } else {
                            v0 = null;
                        }
                        if ((stubbed = (PgBaseOperator)v0) == null) break block19;
                        obj.setLeftStoredType(stubbed.getLeftType());
                        obj.setRightStoredType(stubbed.getRightType());
                        obj.setOperatorKind(stubbed.getOperatorKind());
                        obj.setCallRoutineRef(stubbed.getCallRoutineRef());
                        break block20;
                    }
                    op = source instanceof DasOperator != false ? (DasOperator)source : null;
                    v3 /* !! */  = op;
                    if (v3 /* !! */  == null || (v3 /* !! */  = v3 /* !! */ .getArgumentTypes()) == null || (v3 /* !! */  = (DasType)CollectionsKt.getOrNull((List)v3 /* !! */ , (int)0)) == null) {
                        v3 /* !! */  = (DasType)DasTypeSystemBase.UNKNOWN;
                    }
                    obj.setLeftStoredType((DasType)v3 /* !! */ );
                    v4 /* !! */  = op;
                    if (v4 /* !! */  == null || (v4 /* !! */  = v4 /* !! */ .getArgumentTypes()) == null || (v4 /* !! */  = (DasType)CollectionsKt.getOrNull((List)v4 /* !! */ , (int)1)) == null) {
                        v4 /* !! */  = (DasType)DasTypeSystemBase.UNKNOWN;
                    }
                    obj.setRightStoredType((DasType)v4 /* !! */ );
                    v5 = op;
                    if (v5 == null || (v5 = v5.getOperatorNotation()) == null) {
                        v5 = DasOperator.OperatorNotation.INFIX;
                    }
                    obj.setOperatorKind(this.getPgOperatorKind((DasOperator.OperatorNotation)v5));
                    $i$f$stubbed = this;
                    var8_8 = source instanceof PsiElement != false ? (PsiElement)source : null;
                    var20_13 = obj;
                    $i$f$findChild = false;
                    var10_14 = this_$iv;
                    v6 = el$iv;
                    element$iv$iv = v6 != null ? v6.getFirstChild() : null;
                    $i$f$findSibling = false;
                    for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        it = tmp$iv$iv;
                        $i$a$-findChild-PgBaseObjectBuilder$buildOperator$1 = false;
                        if (!(it instanceof SqlClause)) ** GOTO lbl-1000
                        v7 = ((SqlClause)it).getFirstChild();
                        if (Intrinsics.areEqual((Object)(v7 != null ? PsiTreeUtilKt.getElementType((PsiElement)v7) : null), (Object)PgTypes.PG_PROCEDURE)) {
                            v8 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v8 = false;
                        }
                        if (!v8) continue;
                        v9 = tmp$iv$iv;
                        break block17;
                    }
                    v9 = null;
                }
                v10 = var20_13;
                $this$stubbed$iv = v9;
                if ($this$stubbed$iv == null) ** GOTO lbl-1000
                $i$f$findChild = $this$stubbed$iv;
                var20_13 = v10;
                $i$a$-let-PgBaseObjectBuilder$buildOperator$2 = false;
                element$iv$iv = this;
                el$iv = it;
                $i$f$findChild = false;
                it = this_$iv;
                element$iv$iv = el$iv.getFirstChild();
                $i$f$findSibling = false;
                for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    it$iv = tmp$iv$iv;
                    $i$a$-findSibling-SqlObjectBuilderImpl$findChild$2$iv = false;
                    if (!(it$iv instanceof SqlReferenceExpression)) continue;
                    v11 = tmp$iv$iv;
                    break block18;
                }
                v11 = null;
            }
            v10 = var20_13;
            this_$iv = (SqlReferenceExpression)v11;
            if (this_$iv != null) {
                it = this_$iv;
                var20_13 = v10;
                $i$a$-let-PgBaseObjectBuilder$buildOperator$3 = false;
                v12 = BasicNameReference.create((String)it.getName(), (boolean)it.isPlainIdentifier());
                v10 = var20_13;
            } else lbl-1000:
            // 2 sources

            {
                v12 = null;
            }
            v10.setCallRoutineRef((BasicReference)v12);
        }
        if (!context.isStubBuilder()) {
            $this$asSafely$iv = source;
            $i$f$asSafely = false;
            v13 = $this$asSafely$iv;
            if (!(v13 instanceof DasOperator)) {
                v13 = null;
            }
            if ((v14 = (DasOperator)v13) == null || (v14 = v14.getResultType()) == null) {
                v14 = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            obj.setResultStoredType((DasType)v14);
        }
    }

    private final PgOperatorKind getPgOperatorKind(DasOperator.OperatorNotation n) {
        if (n == DasOperator.OperatorNotation.INFIX) {
            return PgOperatorKind.BINARY;
        }
        if (n == DasOperator.OperatorNotation.POSTFIX) {
            return PgOperatorKind.POSTFIX;
        }
        return n == DasOperator.OperatorNotation.PREFIX ? PgOperatorKind.PREFIX : PgOperatorKind.UNKNOWN;
    }

    private static final CompositeText buildViewSource$lambda$0(PgBaseObjectBuilder this$0, DasObject $source) {
        return (CompositeText)super.getViewQuery($source, CompositeText.Kind.DECOMPILED_TEXT);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final CompositeText buildRoutineSources$lambda$0(DasObject $source, PgBaseObjectBuilder this$0) {
        SimpleCompositeText simpleCompositeText;
        SqlCreateProcedureStatement sqlCreateProcedureStatement;
        SqlCreateProcedureStatement sqlCreateProcedureStatement2 = sqlCreateProcedureStatement = $source instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)$source : null;
        if (sqlCreateProcedureStatement != null) {
            SqlCreateProcedureStatement it = sqlCreateProcedureStatement;
            boolean bl = false;
            String string = this$0.getRoutineSourceText(it);
            if (string != null) {
                simpleCompositeText = SqlObjectBuilderImpl.asComposite$default((SqlObjectBuilderImpl)this$0, (String)string, null, (int)1, null);
                return (CompositeText)simpleCompositeText;
            }
        }
        simpleCompositeText = null;
        return (CompositeText)simpleCompositeText;
    }
}

