/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.cidr.cpp.cmake.CMakeCLionBundle;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.CMakeProjectGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeSettingsPanel
extends JPanel {
    protected ComboBox<String> myLanguageVersionComboBox;
    private ComboBox<String> myLibraryTypeComboBox;

    public CMakeSettingsPanel(@NotNull CMakeProjectGenerator cMakeProjectGenerator) {
        if (cMakeProjectGenerator == null) {
            CMakeSettingsPanel.$$$reportNull$$$0(0);
        }
        this.init(cMakeProjectGenerator);
    }

    public void init(final @NotNull CMakeProjectGenerator cMakeProjectGenerator) {
        if (cMakeProjectGenerator == null) {
            CMakeSettingsPanel.$$$reportNull$$$0(1);
        }
        this.setLayout(new BorderLayout());
        boolean addLibraryPanel = cMakeProjectGenerator.addLibrarySettingsPanel();
        boolean addOnboardingTips = cMakeProjectGenerator.addOnboardingTipsCheckbox();
        int rowCount = this.getRowCount(addLibraryPanel, addOnboardingTips);
        GridLayoutManager gridLayoutManager = new GridLayoutManager(rowCount, 2);
        JPanel wrapper = new JPanel((LayoutManager)gridLayoutManager);
        GridConstraints constraints = CMakeSettingsPanel.createConstraints(0, 0);
        JLabel languageStandardLabel = new JLabel(CMakeCLionBundle.message("cmake.settings.language.standard", new Object[0]));
        wrapper.add((Component)languageStandardLabel, constraints);
        this.createLanguageVersionCombobox(cMakeProjectGenerator);
        constraints = CMakeSettingsPanel.createConstraints(0, 1);
        wrapper.add((Component)this.myLanguageVersionComboBox, constraints);
        languageStandardLabel.setDisplayedMnemonic(83);
        languageStandardLabel.setLabelFor((Component)this.myLanguageVersionComboBox);
        if (addLibraryPanel) {
            constraints = CMakeSettingsPanel.createConstraints(1, 0);
            JLabel libraryTypeLabel = new JLabel(CMakeCLionBundle.message("cmake.settings.library.type", new Object[0]));
            wrapper.add((Component)libraryTypeLabel, constraints);
            this.myLibraryTypeComboBox = new ComboBox((Object[])new String[]{"static", "shared"});
            String libraryType = cMakeProjectGenerator.getLibraryType();
            if (libraryType != null) {
                this.myLibraryTypeComboBox.setSelectedItem((Object)libraryType);
            }
            this.myLibraryTypeComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        cMakeProjectGenerator.setLibraryType((String)e.getItem());
                    }
                }
            });
            constraints = CMakeSettingsPanel.createConstraints(1, 1);
            wrapper.add((Component)this.myLibraryTypeComboBox, constraints);
            libraryTypeLabel.setDisplayedMnemonic(73);
            libraryTypeLabel.setLabelFor((Component)this.myLibraryTypeComboBox);
        }
        if (addOnboardingTips) {
            constraints = CMakeSettingsPanel.createConstraints(1, 0);
            JCheckBox onboardingTipsCheckBox = new JCheckBox(CMakeCLionBundle.message("cmake.settings.onboarding.tips", new Object[0]), (boolean)cMakeProjectGenerator.getAreTipsEnabled());
            onboardingTipsCheckBox.addActionListener(e -> cMakeProjectGenerator.setAreTipsEnabled(onboardingTipsCheckBox.isSelected()));
            wrapper.add((Component)onboardingTipsCheckBox, constraints);
        }
        this.add((Component)wrapper, "West");
    }

    public void initFields(@Nullable @NlsSafe String languageVersion, @Nullable @NlsSafe String libraryType) {
        if (languageVersion != null) {
            this.myLanguageVersionComboBox.setSelectedItem((Object)languageVersion);
        }
        if (this.myLibraryTypeComboBox != null) {
            this.myLibraryTypeComboBox.setSelectedItem((Object)libraryType);
        }
    }

    protected void createLanguageVersionCombobox(final @NotNull CMakeProjectGenerator cMakeProjectGenerator) {
        if (cMakeProjectGenerator == null) {
            CMakeSettingsPanel.$$$reportNull$$$0(2);
        }
        this.myLanguageVersionComboBox = new ComboBox((Object[])cMakeProjectGenerator.getLanguageVersions());
        String languageVersion = cMakeProjectGenerator.getLanguageVersion();
        if (languageVersion != null) {
            this.myLanguageVersionComboBox.setSelectedItem((Object)languageVersion);
        }
        this.myLanguageVersionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    cMakeProjectGenerator.setLanguageVersion((String)e.getItem());
                }
            }
        });
    }

    @NotNull
    protected static GridConstraints createConstraints(int row, int column) {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(row);
        constraints.setColumn(column);
        constraints.setAnchor(8);
        GridConstraints gridConstraints = constraints;
        if (gridConstraints == null) {
            CMakeSettingsPanel.$$$reportNull$$$0(3);
        }
        return gridConstraints;
    }

    protected int getRowCount(boolean addLibraryPanel, boolean addOnboardingPanel) {
        int rowCount = 1;
        if (addLibraryPanel) {
            ++rowCount;
        }
        if (addOnboardingPanel) {
            ++rowCount;
        }
        return rowCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cMakeProjectGenerator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/generators/settings/ui/CMakeSettingsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/generators/settings/ui/CMakeSettingsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstraints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLanguageVersionCombobox";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

