/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPass;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCProblemRegister;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.Unmodifiable;

public class OCUnusedIncludeDirectiveInspection
extends OCInspection
implements OCInspectionBase.CppMarker {
    private static final Logger LOG = Logger.getInstance((String)OCUnusedIncludeDirectiveInspection.class.getName());
    @NotNull
    public EliminateStrategy strategy = EliminateStrategy.RemoveNotDirectlyUsed;
    public boolean showInHeaders = false;

    public boolean isEnabledByDefault() {
        return PluginUtils.hasCLion();
    }

    public String getMainToolId() {
        return null;
    }

    public boolean worksWithClangd() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.unused.directive.display.name", (Object[])new Object[0]);
        if (string == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = CidrLangBundle.message((String)"inspection.unused.code", (Object[])new Object[0]);
        if (string == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String @NotNull [] getGroupPath() {
        String[] stringArray = new String[]{CidrLangBundle.message((String)"c.cpp", (Object[])new Object[0]), this.getGroupDisplayName()};
        if (stringArray == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Nullable
    public String getStaticDescription() {
        return OCInspectionUtil.getStaticDescription((OCInspectionBase)this);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(3);
        }
        final Class inspectionClass = this.getInspectionClass();
        if (!OCInspectionUtil.isInspectionEnabled((Project)holder.getFile().getProject(), (Class)inspectionClass)) {
            return new PsiElementVisitor(this){};
        }
        return new PsiElementVisitor(this){

            public void visitFile(@NotNull PsiFile psiFile) {
                if (psiFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (isOnTheFly) {
                    return;
                }
                if (!ClangUtils.isClangdOn((Project)psiFile.getProject())) {
                    return;
                }
                if (!ClangdBridge.isSupported((Project)psiFile.getProject(), (VirtualFile)psiFile.getVirtualFile())) {
                    return;
                }
                ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)psiFile.getProject());
                if (service == null) {
                    return;
                }
                List<ClangDiagnostic> unusedDiagnostics = OCUnusedIncludeDirectiveInspection.getUnusedDiagnostics(service, psiFile);
                if (!unusedDiagnostics.isEmpty()) {
                    Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
                    if (document == null) {
                        return;
                    }
                    HighlightInfoHolder highlightInfos = new HighlightInfoHolder(psiFile, new HighlightInfoFilter[0]);
                    for (ClangDiagnostic diag : unusedDiagnostics) {
                        HighlightInfo info = ClangErrorsAnnotatorPass.makeAnnotation(service.getClangIdeFacade(), diag, psiFile, document, highlightInfos, service.getUrlConverter());
                        ProblemDescriptor descriptor = info == null ? null : ProblemDescriptorUtil.toProblemDescriptor((PsiFile)psiFile, (HighlightInfo)info);
                        if (descriptor == null) continue;
                        OCProblemRegister.ProblemConsumer consumer = new OCProblemRegister.ProblemConsumer(holder, null, null, isOnTheFly);
                        OCProblemRegister.registerProblem((OCProblemRegister.ProblemConsumer)consumer, (PsiElement)descriptor.getStartElement(), (PsiElement)descriptor.getEndElement(), (String)info.getDescription(), (String)"CIDR", (ProblemHighlightType)ProblemHighlightType.LIKE_UNUSED_SYMBOL, (TextRange)new TextRange(info.startOffset, info.endOffset), (Class)inspectionClass, (IntentionAction[])IntentionAction.EMPTY_ARRAY);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/cidr/lang/inspections/OCUnusedIncludeDirectiveInspection$2", "visitFile"));
            }
        };
    }

    @NotNull
    private static @Unmodifiable List<ClangDiagnostic> getUnusedDiagnostics(@NotNull ClangLanguageService service, @NotNull PsiFile file) {
        if (service == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(4);
        }
        if (file == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(5);
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        List list = (List)service.computeWithOpenedAndParsed(virtualFile, response -> {
            if (response != null) {
                try {
                    Supplier diagsSupplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)response.getDiagnostics(), (long)Long.MAX_VALUE, (String)"unused include diagnostics");
                    if (diagsSupplier != null) {
                        List diagnostics = (List)diagsSupplier.get();
                        return diagnostics != null ? ContainerUtil.filter((Collection)diagnostics, diag -> "clion_unused_include".equals(diag.getCode())) : Collections.emptyList();
                    }
                }
                catch (ExecutionException | TimeoutException e) {
                    LOG.error((Throwable)e);
                }
            }
            return Collections.emptyList();
        });
        if (list == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public OptPane getOptionsPane() {
        if (!PluginUtils.hasCLion()) {
            OptPane optPane = OptPane.EMPTY;
            if (optPane == null) {
                OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(7);
            }
            return optPane;
        }
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.dropdown((String)"strategy", (String)"", EliminateStrategy.class, opt -> opt.getOption()), OptPane.checkbox((String)"showInHeaders", (String)OCInspectionsBundle.message((String)"unused.inspection.run.in.headers", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(8);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCUnusedIncludeDirectiveInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCUnusedIncludeDirectiveInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedDiagnostics";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedDiagnostics";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    public static enum EliminateStrategy {
        RemoveCompletelyUnused("inspection.unused.include.directive.completely.unused"),
        RemoveNotDirectlyUsed("inspection.unused.include.directive.completely.not.directly"),
        RemoveNotRequired("inspection.unused.include.directive.completely.not.required");

        @NotNull
        @PropertyKey(resourceBundle="messages.OCInspectionsBundle")
        private final @NotNull @PropertyKey(resourceBundle="messages.OCInspectionsBundle") String option;

        private EliminateStrategy(String option) {
            if (option == null) {
                EliminateStrategy.$$$reportNull$$$0(0);
            }
            this.option = option;
        }

        @NlsContexts.Label
        String getOption() {
            return OCInspectionsBundle.message((String)this.option, (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/jetbrains/cidr/lang/inspections/OCUnusedIncludeDirectiveInspection$EliminateStrategy", "<init>"));
        }
    }
}

