/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarkerKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigation.ClangNaiveGotoActionSync;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClangLineMarkerInfo
extends LineMarkerInfo<PsiElement> {
    public ClangLineMarkerInfo(@NotNull PsiElement element, @NotNull ClionLineMarker marker) {
        if (element == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(0);
        }
        if (marker == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(1);
        }
        super(element, OCElementUtil.getTextRangeWithoutComments((PsiElement)element), ClangLineMarkerInfo.getIcon(marker.getKind()), psiElement -> ClangLineMarkerInfo.getActionName(marker), ClangLineMarkerInfo.createNavigationHandler(element, marker), GutterIconRenderer.Alignment.RIGHT, () -> ClangLineMarkerInfo.getActionName(marker));
    }

    @NotNull
    private static Icon getIcon(@NotNull ClionLineMarkerKind kind) {
        if (kind == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(2);
        }
        Icon icon = switch (kind) {
            default -> throw new MatchException(null, null);
            case ClionLineMarkerKind.DECL_DEF -> CidrLangIcons.AssocFile;
            case ClionLineMarkerKind.DIRECT_CHILDREN, ClionLineMarkerKind.ALL_CHILDREN -> AllIcons.Gutter.OverridenMethod;
            case ClionLineMarkerKind.DIRECT_PARENTS, ClionLineMarkerKind.ALL_PARENTS -> AllIcons.Gutter.OverridingMethod;
        };
        if (icon == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @Nls
    @NotNull
    private static String getActionName(@NotNull ClionLineMarker marker) {
        if (marker == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(4);
        }
        CLionSymbolInformation sourceSymbol = marker.getSource();
        CLionSymbolInformation targetSymbol = (CLionSymbolInformation)marker.getTargets().get(0);
        return switch (marker.getKind()) {
            case ClionLineMarkerKind.DIRECT_PARENTS, ClionLineMarkerKind.ALL_PARENTS -> {
                switch (sourceSymbol.getKind()) {
                    case Method: {
                        yield OCBundle.message((String)"goto.super.type.name1", (Object[])new Object[]{StringUtil.decapitalize((String)sourceSymbol.getKind().toString()), "`" + targetSymbol.getContainerName() + "`"});
                    }
                    case Constructor: 
                    case Function: {
                        yield OCBundle.message((String)"goto.super.type.name2", (Object[])new Object[]{targetSymbol.getContainerName()});
                    }
                }
                yield OCBundle.message((String)"goto.super.type.name3", (Object[])new Object[0]);
            }
            case ClionLineMarkerKind.DIRECT_CHILDREN, ClionLineMarkerKind.ALL_CHILDREN -> {
                switch (sourceSymbol.getKind()) {
                    case Class: 
                    case Struct: {
                        yield OCBundle.message((String)"goto.subclass", (Object[])new Object[0]);
                    }
                    case Method: {
                        yield OCBundle.message((String)"goto.overridden.methods", (Object[])new Object[0]);
                    }
                }
                yield OCBundle.message((String)"goto.overridden.functions", (Object[])new Object[0]);
            }
            default -> "";
        };
    }

    @NotNull
    private static GutterIconNavigationHandler<PsiElement> createNavigationHandler(@NotNull PsiElement element, @NotNull ClionLineMarker marker) {
        if (element == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(5);
        }
        if (marker == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(6);
        }
        String actionName = ClangLineMarkerInfo.getActionName(marker);
        ClangNaiveGotoActionSync action = new ClangNaiveGotoActionSync(actionName, ClangLineMarkerInfo.getIcon(marker.getKind()), element.getProject(), element, marker.getTargets());
        GutterIconNavigationHandler gutterIconNavigationHandler = (e, elt) -> action.navigate(e, null);
        if (gutterIconNavigationHandler == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(7);
        }
        return gutterIconNavigationHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/navigation/ClangLineMarkerInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/navigation/ClangLineMarkerInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }
}

