/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.AdvancedClangFileFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.AdvancedClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/AdvancedClangIdeFacadeImpl;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacadeImpl;", "descriptor", "", "<init>", "(Ljava/lang/String;)V", "getFileFacade", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangFileFacade;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "getResolveInfoForFile", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/cidr/lang/daemon/clang/ClangUtils$ResolveInfo;", "project", "Lcom/intellij/openapi/project/Project;", "vf", "getUnusedIncludesInspectionMode", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/UnusedIncludesInspectionMode;", "getOCPsiFile", "Lcom/jetbrains/cidr/lang/psi/OCPsiFile;", "ocFile", "intellij.cidr.clangd.legacyBridge"})
public class AdvancedClangIdeFacadeImpl
extends ClangIdeFacadeImpl {
    public AdvancedClangIdeFacadeImpl(@NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super(descriptor);
    }

    @NotNull
    public ClangFileFacade getFileFacade(@NotNull VirtualFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return new AdvancedClangFileFacadeImpl(file, document);
    }

    @NotNull
    public CompletableFuture<ClangUtils.ResolveInfo> getResolveInfoForFile(@NotNull Project project, @NotNull VirtualFile vf) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
        OCPsiFile ocFile = this.getOCPsiFile(project, vf);
        if (ocFile != null) {
            Application app = ApplicationManager.getApplication();
            if (app.isReadAccessAllowed()) {
                CompletableFuture<ClangUtils.ResolveInfo> completableFuture = CompletableFuture.completedFuture(ClangIdeFacadeUtil.Companion.getInstance().getResolveInfoForFile(project, ocFile, vf));
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }
            ClangUtils.ResolveInfo resolveInfo2 = (ClangUtils.ResolveInfo)com.intellij.openapi.progress.CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ClangUtils.ResolveInfo>, Object>(project, ocFile, vf, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ OCPsiFile $ocFile;
                final /* synthetic */ VirtualFile $vf;
                {
                    this.$project = $project;
                    this.$ocFile = $ocFile;
                    this.$vf = $vf;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = CoroutinesKt.readAction(() -> getResolveInfoForFile.resolveInfo.1.invokeSuspend$lambda$0(this.$project, this.$ocFile, this.$vf), (Continuation)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super ClangUtils.ResolveInfo> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final ClangUtils.ResolveInfo invokeSuspend$lambda$0(Project $project, OCPsiFile $ocFile, VirtualFile $vf) {
                    return ClangIdeFacadeUtil.Companion.getInstance().getResolveInfoForFile($project, $ocFile, $vf);
                }
            }));
            CompletableFuture<ClangUtils.ResolveInfo> completableFuture = CompletableFuture.completedFuture(resolveInfo2);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CompletableFuture completableFuture = super.getResolveInfoForFile(project, vf);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"getResolveInfoForFile(...)");
        return completableFuture;
    }

    @Nullable
    public UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OCPsiFile ocFile = this.getOCPsiFile(project, file);
        if (ocFile == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)("Failed to get OCPsiFile for file " + file.getPath()));
            return null;
        }
        return this.getUnusedIncludesInspectionMode(ocFile);
    }

    private final OCPsiFile getOCPsiFile(Project project, VirtualFile file) {
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> AdvancedClangIdeFacadeImpl.getOCPsiFile$lambda$0(file, project));
        if (psiFile == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)("Failed to get PSI file for file: " + file.getPath()));
            return null;
        }
        OCPsiFile ocFile = OCLanguageUtils.asOCPsiFile((PsiFile)psiFile);
        if (ocFile == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)("PSI file is not OCPsiFile: " + file.getPath()));
            return null;
        }
        return ocFile;
    }

    private final UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(OCPsiFile ocFile) {
        Class<OCUnusedIncludeDirectiveInspection> inspectionClass = OCUnusedIncludeDirectiveInspection.class;
        if (!OCInspectionUtil.isInspectionEnabled((Project)ocFile.getProject(), inspectionClass)) {
            return UnusedIncludesInspectionMode.Off;
        }
        if (Intrinsics.areEqual(inspectionClass, OCUnusedIncludeDirectiveInspection.class)) {
            HighlightDisplayKey key;
            String shortName;
            String string = shortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
            Object object = key = string != null ? HighlightDisplayKey.find((String)string) : null;
            if (key != null) {
                InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)ocFile.getProject()).getCurrentProfile();
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
                InspectionProfile inspectionProfile = (InspectionProfile)inspectionProfileImpl;
                InspectionToolWrapper tool = inspectionProfile.getInspectionTool(key.getShortName(), ocFile.getProject());
                if (tool != null && tool.getTool() instanceof OCUnusedIncludeDirectiveInspection) {
                    UnusedIncludesInspectionMode unusedIncludesInspectionMode;
                    InspectionProfileEntry inspectionProfileEntry = tool.getTool();
                    Intrinsics.checkNotNull((Object)inspectionProfileEntry, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection");
                    OCUnusedIncludeDirectiveInspection inspection = (OCUnusedIncludeDirectiveInspection)inspectionProfileEntry;
                    if (!inspection.showInHeaders && ocFile.isHeader()) {
                        unusedIncludesInspectionMode = UnusedIncludesInspectionMode.Off;
                    } else {
                        switch (WhenMappings.$EnumSwitchMapping$0[inspection.strategy.ordinal()]) {
                            case 1: {
                                unusedIncludesInspectionMode = UnusedIncludesInspectionMode.RemoveCompletelyUnused;
                                break;
                            }
                            case 2: {
                                unusedIncludesInspectionMode = UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
                                break;
                            }
                            case 3: {
                                unusedIncludesInspectionMode = UnusedIncludesInspectionMode.RemoveNotRequired;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    return unusedIncludesInspectionMode;
                }
            }
        }
        return UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
    }

    private static final PsiFile getOCPsiFile$lambda$0(VirtualFile $file, Project $project) {
        return $file.isValid() ? PsiManager.getInstance((Project)$project).findFile($file) : null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OCUnusedIncludeDirectiveInspection.EliminateStrategy.values().length];
            try {
                nArray[OCUnusedIncludeDirectiveInspection.EliminateStrategy.RemoveCompletelyUnused.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCUnusedIncludeDirectiveInspection.EliminateStrategy.RemoveNotDirectlyUsed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCUnusedIncludeDirectiveInspection.EliminateStrategy.RemoveNotRequired.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

